/*
 * Decompiled with CFR 0.152.
 */
package com.github.tbekolay.jnumeric;

import com.github.tbekolay.jnumeric.BinaryFunction;
import com.github.tbekolay.jnumeric.PyMultiarray;
import org.python.core.Py;
import org.python.core.PyObject;

final class LogicalXor
extends BinaryFunction {
    boolean returnsInt = true;

    LogicalXor() {
    }

    @Override
    final PyMultiarray identity() {
        return BinaryFunction.one;
    }

    @Override
    final void accumulate(Object aData, int sa, int dim, int dsa, Object rData, int sr, int rDim, int dsr, char type) {
        int maxSa = sa + dim * dsa;
        int last = 1;
        int[] rDatai = (int[])rData;
        switch (type) {
            case '1': {
                byte[] aData1 = (byte[])aData;
                while (sa != maxSa) {
                    last = last != 0 ^ aData1[sa] != 0 ? 1 : 0;
                    rDatai[sr] = last;
                    sa += dsa;
                    sr += dsr;
                }
                break;
            }
            case 's': {
                short[] aDatas = (short[])aData;
                while (sa != maxSa) {
                    last = last != 0 ^ aDatas[sa] != 0 ? 1 : 0;
                    rDatai[sr] = last;
                    sa += dsa;
                    sr += dsr;
                }
                break;
            }
            case 'i': {
                int[] aDatai = (int[])aData;
                while (sa != maxSa) {
                    last = last != 0 ^ aDatai[sa] != 0 ? 1 : 0;
                    rDatai[sr] = last;
                    sa += dsa;
                    sr += dsr;
                }
                break;
            }
            case 'l': {
                long[] aDatal = (long[])aData;
                while (sa != maxSa) {
                    last = last != 0 ^ aDatal[sa] != 0L ? 1 : 0;
                    rDatai[sr] = last;
                    sa += dsa;
                    sr += dsr;
                }
                break;
            }
            case 'f': {
                float[] aDataf = (float[])aData;
                while (sa != maxSa) {
                    last = last != 0 ^ aDataf[sa] != 0.0f ? 1 : 0;
                    rDatai[sr] = last;
                    sa += dsa;
                    sr += dsr;
                }
                break;
            }
            case 'd': {
                double[] aDatad = (double[])aData;
                while (sa != maxSa) {
                    last = last != 0 ^ aDatad[sa] != 0.0 ? 1 : 0;
                    rDatai[sr] = last;
                    sa += dsa;
                    sr += dsr;
                }
                break;
            }
            case 'F': {
                float[] aDataF = (float[])aData;
                while (sa != maxSa) {
                    last = last != 0 ^ (aDataF[sa] != 0.0f || aDataF[sa + 1] != 0.0f) ? 1 : 0;
                    rDatai[sr] = last;
                    sa += dsa;
                    sr += dsr;
                }
                break;
            }
            case 'D': {
                double[] aDataD = (double[])aData;
                while (sa != maxSa) {
                    last = last != 0 ^ (aDataD[sa] != 0.0 || aDataD[sa + 1] != 0.0) ? 1 : 0;
                    rDatai[sr] = last;
                    sa += dsa;
                    sr += dsr;
                }
                break;
            }
            case 'O': {
                super.accumulate(aData, sa, dim, dsa, rData, sr, rDim, dsr, type);
                break;
            }
            default: {
                throw Py.ValueError((String)"typecd must be in [zcbhilfdO]");
            }
        }
    }

    @Override
    public final PyObject call(PyObject po1, PyObject po2) {
        return PyMultiarray.asarray(po1).__lxor((PyObject)PyMultiarray.asarray(po2));
    }

    @Override
    final PyObject call(PyMultiarray a, PyMultiarray b, PyMultiarray result) {
        return a.__lxor((PyObject)b, result);
    }
}

