/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wcs.io.downloader;

import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.RemoteServiceException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.raster.cache.tile.TileCacheLibrary;
import org.gvsig.raster.cache.tile.TileCacheLocator;
import org.gvsig.raster.cache.tile.TileCacheManager;
import org.gvsig.raster.cache.tile.provider.CacheStruct;
import org.gvsig.raster.cache.tile.provider.Downloader;
import org.gvsig.raster.cache.tile.provider.TileServer;
import org.gvsig.raster.impl.provider.RasterProvider;
import org.gvsig.raster.wcs.io.WCSProvider;
import org.gvsig.raster.wcs.io.downloader.TileDownloaderForWCS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WCSTileServer
implements TileServer {
    private static Logger logger = LoggerFactory.getLogger(WCSTileServer.class);
    private CacheStruct struct = null;
    private Downloader downloader = null;
    private RasterDataStore store = null;
    private String suffix = ".tif";

    public WCSTileServer(RasterDataStore store) {
        this.store = store;
        this.suffix = ((RasterProvider)store.getProvider()).getFileSuffix();
    }

    public Downloader getDownloader() {
        if (this.downloader == null || ((TileDownloaderForWCS)this.downloader).getTileSize()[0] != TileCacheLibrary.ALTERNATIVE_TILESIZE || ((TileDownloaderForWCS)this.downloader).getTileSize()[1] != TileCacheLibrary.ALTERNATIVE_TILESIZE) {
            try {
                this.downloader = new TileDownloaderForWCS(this.store, TileCacheLibrary.ALTERNATIVE_TILESIZE, TileCacheLibrary.ALTERNATIVE_TILESIZE, ((WCSProvider)this.store.getProvider()).getConnector());
            }
            catch (RemoteServiceException e) {
                return null;
            }
        }
        return this.downloader;
    }

    public CacheStruct getStruct() {
        if (this.struct == null) {
            TileCacheManager manager = TileCacheLocator.getManager();
            int coordinates = 1;
            if (this.store.getProjection() != null) {
                coordinates = this.store.getProjection() != null && this.store.getProjection().isProjected() ? 1 : 0;
            } else {
                Extent e = this.store.getExtent();
                if (e.getULX() >= -180.0 && e.getULX() <= 180.0 && e.getLRX() >= -180.0 && e.getLRX() <= 180.0 && e.getULY() >= -90.0 && e.getULY() <= 90.0 && e.getLRY() >= -90.0 && e.getLRY() <= 90.0) {
                    coordinates = 0;
                }
            }
            String epsg = null;
            IProjection proj = this.store.getProjection();
            if (proj != null) {
                epsg = proj.getAbrev();
            }
            WCSProvider wcsProvider = (WCSProvider)this.store.getProvider();
            this.struct = manager.createCacheStructure(coordinates, TileCacheLibrary.DEFAULT_LEVELS, this.store.getExtent().toRectangle2D(), this.store.getCellSize(), TileCacheLibrary.ALTERNATIVE_TILESIZE, TileCacheLibrary.ALTERNATIVE_TILESIZE, wcsProvider.getURIOfFirstProvider().getPath(), wcsProvider.getParameters().getCoverageName(), TileCacheLibrary.DEFAULT_STRUCTURE, RasterLibrary.pathTileCache, this.getFileSuffix(), epsg, 0L);
        }
        return this.struct;
    }

    public void setStruct(CacheStruct struct) {
        if (struct != null) {
            this.struct = struct;
            if (struct.getTileSizeByLevel(0) != null) {
                try {
                    this.downloader = new TileDownloaderForWCS(this.store, struct.getTileSizeByLevel(0)[0], struct.getTileSizeByLevel(0)[1], ((WCSProvider)this.store.getProvider()).getConnector());
                }
                catch (RemoteServiceException ex) {
                    logger.error("Constructing TileDownloaderForWCS: " + ex.getMessage());
                }
            }
        }
    }

    public String getFileSuffix() {
        return this.suffix;
    }

    public void setFileSuffix(String extension) {
        this.suffix = extension;
    }
}

