/*
 * Decompiled with CFR 0.152.
 */
package com.ermapper.ecw;

import com.ermapper.ecw.JNCSException;
import com.ermapper.ecw.JNCSFile;
import com.ermapper.ecw.JNCSFileNotOpenException;
import com.ermapper.ecw.JNCSFileOpenFailedException;
import com.ermapper.ecw.JNCSInvalidSetViewException;
import com.ermapper.util.JNCSDatasetPoint;
import com.ermapper.util.JNCSWorldPoint;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.util.StringTokenizer;

public class JNCSRenderer
extends JNCSFile {
    private double dRendererSetViewWorldTLX;
    private double dRendererSetViewWorldTLY;
    private double dRendererSetViewWorldBRX;
    private double dRendererSetViewWorldBRY;
    private int dRendererSetViewDatasetTLX;
    private int dRendererSetViewDatasetTLY;
    private int dRendererSetViewDatasetBRX;
    private int dRendererSetViewDatasetBRY;
    private int dRendererSetViewWidth;
    private int dRendererSetViewHeight;
    private int[] pRGBArray = null;
    private double[] outputDeviceCoords = new double[4];
    private double dRendererWorldTLX;
    private double dRendererWorldTLY;
    private double dRendererWorldBRX;
    private double dRendererWorldBRY;
    private Image ecwImage = null;
    private int prevImageSizeX = -1;
    private int prevImageSizeY = -1;
    private boolean bHaveValidSetView = false;
    private float transparencyValue = 1.0f;
    private AlphaComposite alphaComposite = null;
    private static boolean bHave1_2VM = false;
    private MemoryImageSource memImSource = null;
    private static DirectColorModel ecwColorModel = null;
    private static final boolean bOptimizeImageStretch = true;

    public JNCSRenderer() throws JNCSException {
    }

    public JNCSRenderer(String s, boolean flag) throws JNCSFileOpenFailedException, JNCSException {
        this.open(s, flag);
    }

    public void setTransparency(float f) {
        this.transparencyValue = f;
        if (bHave1_2VM) {
            this.alphaComposite = AlphaComposite.getInstance(3, this.transparencyValue);
        }
    }

    public int setView(int i, int[] ai, int j, int k, int l, int i1, int j1, int k1) throws JNCSFileNotOpenException, JNCSInvalidSetViewException {
        int l1 = j;
        int i2 = k;
        int j2 = l;
        int k2 = i1;
        if (j < 0) {
            l1 = 0;
        }
        if (k < 0) {
            i2 = 0;
        }
        if (l > this.width - 1) {
            j2 = this.width - 1;
        }
        if (i1 > this.height - 1) {
            k2 = this.height - 1;
        }
        int l2 = (int)Math.round((double)(l1 - j) / (double)(l - j) * (double)j1);
        int i3 = (int)Math.round((double)(i2 - k) / (double)(i1 - k) * (double)k1);
        int j3 = (int)Math.round((double)(j2 - j) / (double)(l - j) * (double)j1);
        int k3 = (int)Math.round((double)(k2 - k) / (double)(i1 - k) * (double)k1);
        super.setView(i, ai, l1, i2, j2, k2, j3 - l2, k3 - i3);
        this.bHaveValidSetView = true;
        if (!this.progressive) {
            this.dRendererSetViewDatasetTLX = l1;
            this.dRendererSetViewDatasetTLY = l1;
            this.dRendererSetViewDatasetBRX = j2;
            this.dRendererSetViewDatasetBRY = k2;
            this.dRendererSetViewWidth = j3 - l2;
            this.dRendererSetViewHeight = k3 - i3;
        }
        return 0;
    }

    public int setView(int i, int[] ai, double d, double d1, double d2, double d3, int j, int k) throws JNCSFileNotOpenException, JNCSInvalidSetViewException {
        JNCSDatasetPoint jncsdatasetpoint = this.convertWorldToDataset(d, d1);
        JNCSDatasetPoint jncsdatasetpoint1 = this.convertWorldToDataset(d2, d3);
        double d4 = d;
        double d5 = d1;
        double d6 = d2;
        double d7 = d3;
        jncsdatasetpoint.x = (int)Math.floor((d4 - this.originX) / this.cellIncrementX);
        jncsdatasetpoint.y = (int)Math.floor((d5 - this.originY) / this.cellIncrementY);
        jncsdatasetpoint1.x = (int)Math.ceil((d6 - this.originX) / this.cellIncrementX);
        jncsdatasetpoint1.y = (int)Math.ceil((d7 - this.originY) / this.cellIncrementY);
        JNCSWorldPoint jncsworldpoint = this.convertDatasetToWorld(jncsdatasetpoint.x, jncsdatasetpoint.y);
        JNCSWorldPoint jncsworldpoint1 = this.convertDatasetToWorld(jncsdatasetpoint1.x, jncsdatasetpoint1.y);
        d4 = jncsworldpoint.x;
        d5 = jncsworldpoint.y;
        d6 = jncsworldpoint1.x;
        d7 = jncsworldpoint1.y;
        if (jncsdatasetpoint.x < 0) {
            d4 = this.originX;
        }
        if (jncsdatasetpoint.y < 0) {
            d5 = this.originY;
        }
        if (jncsdatasetpoint1.x > this.width - 1) {
            d6 = this.originX + (double)(this.width - 1) * this.cellIncrementX;
        }
        if (jncsdatasetpoint1.y > this.height - 1) {
            d7 = this.originY + (double)(this.height - 1) * this.cellIncrementY;
        }
        if (jncsdatasetpoint.x < 0 && jncsdatasetpoint1.x < 0 || jncsdatasetpoint.x > this.width - 1 && jncsdatasetpoint1.x > this.width - 1) {
            this.bHaveValidSetView = false;
            return 1;
        }
        if (jncsdatasetpoint.y < 0 && jncsdatasetpoint1.y < 0 || jncsdatasetpoint.y > this.height - 1 && jncsdatasetpoint1.y > this.height - 1) {
            this.bHaveValidSetView = false;
            return 1;
        }
        int l = (int)Math.round((d4 - d) / (d2 - d) * (double)j);
        int i1 = (int)Math.round((d5 - d1) / (d3 - d1) * (double)k);
        int j1 = (int)Math.round((d6 - d) / (d2 - d) * (double)j);
        int k1 = (int)Math.round((d7 - d1) / (d3 - d1) * (double)k);
        if (j1 - l > jncsdatasetpoint1.x - jncsdatasetpoint.x) {
            j1 = jncsdatasetpoint1.x;
            l = jncsdatasetpoint.x;
        }
        if (k1 - i1 > jncsdatasetpoint1.y - jncsdatasetpoint.y) {
            k1 = jncsdatasetpoint1.y;
            i1 = jncsdatasetpoint.y;
        }
        if (j1 - l < 1 || k1 - i1 < 1) {
            this.bHaveValidSetView = false;
            return 1;
        }
        super.setView(i, ai, d4, d5, d6, d7, j1 - l, k1 - i1);
        this.bHaveValidSetView = true;
        if (!this.progressive) {
            this.dRendererSetViewWorldTLX = d4;
            this.dRendererSetViewWorldTLY = d5;
            this.dRendererSetViewWorldBRX = d6;
            this.dRendererSetViewWorldBRY = d7;
            this.dRendererSetViewWidth = j1 - l;
            this.dRendererSetViewHeight = k1 - i1;
        }
        return 0;
    }

    public void refreshUpdate(int i, int j, double d, double d1, double d2, double d3) {
        this.ecwReadImage(i, j, d, d1, d2, d3);
        if (this.progImageClient != null) {
            this.progImageClient.refreshUpdate(i, j, d, d1, d2, d3);
        }
    }

    public void refreshUpdate(int i, int j, int k, int l, double d, int i1) {
        this.ecwReadImage(i, j, k, l, d, i1);
        if (this.progImageClient != null) {
            this.progImageClient.refreshUpdate(i, j, (double)k, (double)l, d, (double)i1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ecwReadImage(int i, int j, double d, double d1, double d2, double d3) {
        Image image = null;
        boolean flag = false;
        if (this.prevImageSizeX != i || this.prevImageSizeY != j) {
            this.pRGBArray = new int[i * j];
            this.prevImageSizeX = i;
            this.prevImageSizeY = j;
            flag = true;
        }
        try {
            this.readImageRGBA(this.pRGBArray, i, j);
            if (flag) {
                this.memImSource = null;
                this.memImSource = new MemoryImageSource(i, j, (ColorModel)ecwColorModel, this.pRGBArray, 0, i);
            } else {
                this.memImSource.newPixels(this.pRGBArray, (ColorModel)ecwColorModel, 0, i);
            }
        }
        catch (JNCSException jncsexception) {
            System.out.print(String.valueOf(String.valueOf(new StringBuffer("readImageRGBA failed :").append(jncsexception.toString()).append("\n"))));
            this.bHaveValidSetView = false;
            boolean flag1 = false;
            return flag1;
        }
        image = Toolkit.getDefaultToolkit().createImage(this.memImSource);
        if (this.ecwImage == null) {
            this.ecwImage = image;
            this.dRendererWorldTLX = d;
            this.dRendererWorldTLY = d1;
            this.dRendererWorldBRX = d2;
            this.dRendererWorldBRY = d3;
        } else {
            Image image2 = this.ecwImage;
            synchronized (image2) {
                this.ecwImage = image;
                this.dRendererWorldTLX = d;
                this.dRendererWorldTLY = d1;
                this.dRendererWorldBRX = d2;
                this.dRendererWorldBRY = d3;
            }
        }
        this.bHaveValidSetView = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawImage(Graphics g, int i, int j, int k, int l, double d, double d1, double d2, double d3, ImageObserver imageobserver) {
        if (!this.progressive && this.bHaveValidSetView) {
            this.ecwReadImage(this.dRendererSetViewWidth, this.dRendererSetViewHeight, this.dRendererSetViewWorldTLX, this.dRendererSetViewWorldTLY, this.dRendererSetViewWorldBRX, this.dRendererSetViewWorldBRY);
        }
        if (this.progressive && this.ecwImage == null) {
            return;
        }
        Image image = this.ecwImage;
        synchronized (image) {
            if (!bHave1_2VM || (double)this.transparencyValue == 1.0) {
                // empty if block
            }
            this.calculateDeviceCoords(i, j, i + k, j + l, d, d1, d2, d3, this.outputDeviceCoords);
            int i1 = (int)Math.round(this.outputDeviceCoords[2] - this.outputDeviceCoords[0]);
            int j1 = (int)Math.round(this.outputDeviceCoords[3] - this.outputDeviceCoords[1]);
            int k1 = this.ecwImage.getWidth(imageobserver);
            int l1 = this.ecwImage.getHeight(imageobserver);
            if (i1 != k1 || j1 != l1) {
                if (i1 > k1 && j1 > l1) {
                    double d4 = this.outputDeviceCoords[0] >= (double)i ? this.outputDeviceCoords[0] : (double)i;
                    double d5 = this.outputDeviceCoords[1] >= (double)j ? this.outputDeviceCoords[1] : (double)j;
                    double d6 = this.outputDeviceCoords[2] <= (double)(i + k) ? this.outputDeviceCoords[2] : (double)(i + k);
                    double d7 = this.outputDeviceCoords[3] <= (double)(j + l) ? this.outputDeviceCoords[3] : (double)(j + l);
                    double[] ad = JNCSRenderer.calculateImageCoords(this.outputDeviceCoords[0], this.outputDeviceCoords[1], this.outputDeviceCoords[2], this.outputDeviceCoords[3], k1, l1, d4, d5, d6, d7);
                    ad[0] = Math.floor(ad[0]);
                    ad[1] = Math.floor(ad[1]);
                    ad[2] = Math.ceil(ad[2]);
                    ad[3] = Math.ceil(ad[3]);
                    double d8 = this.dRendererWorldTLX + (this.dRendererWorldBRX - this.dRendererWorldTLX) / (double)k1 * ad[0];
                    double d9 = this.dRendererWorldTLY + (this.dRendererWorldBRY - this.dRendererWorldTLY) / (double)l1 * ad[1];
                    double d10 = this.dRendererWorldTLX + (this.dRendererWorldBRX - this.dRendererWorldTLX) / (double)k1 * ad[2];
                    double d11 = this.dRendererWorldTLY + (this.dRendererWorldBRY - this.dRendererWorldTLY) / (double)l1 * ad[3];
                    double d12 = (this.outputDeviceCoords[2] - this.outputDeviceCoords[0]) * (d8 - this.dRendererWorldTLX) / (this.dRendererWorldBRX - this.dRendererWorldTLX) + this.outputDeviceCoords[0];
                    double d13 = (this.outputDeviceCoords[3] - this.outputDeviceCoords[1]) * (d9 - this.dRendererWorldTLY) / (this.dRendererWorldBRY - this.dRendererWorldTLY) + this.outputDeviceCoords[1];
                    double d14 = (this.outputDeviceCoords[2] - this.outputDeviceCoords[0]) * (d10 - this.dRendererWorldTLX) / (this.dRendererWorldBRX - this.dRendererWorldTLX) + this.outputDeviceCoords[0];
                    double d15 = (this.outputDeviceCoords[3] - this.outputDeviceCoords[1]) * (d11 - this.dRendererWorldTLY) / (this.dRendererWorldBRY - this.dRendererWorldTLY) + this.outputDeviceCoords[1];
                    g.drawImage(this.ecwImage, (int)Math.round(d12), (int)Math.round(d13), (int)Math.round(d14), (int)Math.round(d15), (int)Math.floor(ad[0]), (int)Math.floor(ad[1]), (int)Math.ceil(ad[2]), (int)Math.ceil(ad[3]), imageobserver);
                } else {
                    g.drawImage(this.ecwImage, (int)Math.round(this.outputDeviceCoords[0]), (int)Math.round(this.outputDeviceCoords[1]), (int)Math.round(this.outputDeviceCoords[2]), (int)Math.round(this.outputDeviceCoords[3]), 0, 0, k1, l1, imageobserver);
                }
            } else {
                g.drawImage(this.ecwImage, (int)Math.round(this.outputDeviceCoords[0]), (int)Math.round(this.outputDeviceCoords[1]), imageobserver);
            }
            if (!bHave1_2VM || (double)this.transparencyValue == 1.0) {
                // empty if block
            }
        }
    }

    private static final double[] calculateImageCoords(double d, double d1, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double[] ad = new double[4];
        double d10 = (d8 - d6) * d4 / (d2 - d);
        double d11 = (d9 - d7) * d5 / (d3 - d1);
        ad[0] = (d6 - d) * d10 / (d8 - d6);
        ad[1] = (d7 - d1) * d11 / (d9 - d7);
        ad[2] = ad[0] + d10;
        ad[3] = ad[1] + d11;
        return ad;
    }

    private final void calculateDeviceCoords(int i, int j, int k, int l, double d, double d1, double d2, double d3, double[] ad) {
        ad[0] = (this.dRendererWorldTLX - d) / (d2 - d) * (double)(k - i);
        ad[1] = (this.dRendererWorldTLY - d1) / (d3 - d1) * (double)(l - j);
        ad[2] = (this.dRendererWorldBRX - d) / (d2 - d) * (double)(k - i);
        ad[3] = (this.dRendererWorldBRY - d1) / (d3 - d1) * (double)(l - j);
    }

    private final void convertImageToWorld(int i, int j, double d, double d1, double[] ad) {
        ad[0] = this.dRendererWorldTLX + (this.dRendererWorldBRX - this.dRendererWorldTLX) / (double)i * d;
        ad[1] = this.dRendererWorldTLY + (this.dRendererWorldBRY - this.dRendererWorldTLY) / (double)j * d1;
    }

    static {
        String s = System.getProperty("java.version");
        StringTokenizer stringtokenizer = new StringTokenizer(s, ".");
        int i = Integer.parseInt(stringtokenizer.nextToken());
        int j = Integer.parseInt(stringtokenizer.nextToken());
        if (i >= 1 && j >= 2) {
            bHave1_2VM = true;
        }
        ecwColorModel = new DirectColorModel(32, 0xFF0000, 65280, 255);
    }
}

