/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.dbf;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.WriteException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.store.dbf.DBFStoreParameters;
import org.gvsig.fmap.dal.store.dbf.utils.DbaseCodepage;
import org.gvsig.fmap.dal.store.dbf.utils.DbaseFileHeader;
import org.gvsig.fmap.dal.store.dbf.utils.DbaseFileWriter;
import org.gvsig.fmap.dal.store.dbf.utils.LogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBFFeatureWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBFFeatureWriter.class);
    protected FeatureType featuretype;
    private DbaseFileWriter dbfWriter = null;
    protected String name;
    private File dbfFile;
    private DbaseFileHeader myHeader;
    private FileChannel dbfChannel;

    protected DBFFeatureWriter(String name) {
        this.name = name;
    }

    public void begin(DBFStoreParameters storeParameters, FeatureType featureType, long numRows) throws DataException {
        String charset = storeParameters.getEffectiveEncodingName();
        if (charset == null) {
            charset = "UTF-8";
        }
        try {
            this.myHeader = DbaseFileHeader.fromFeatureType(featureType, charset);
        }
        catch (DataException e1) {
            throw new WriteException(this.name, (Throwable)e1);
        }
        this.dbfFile = storeParameters.getDBFFile();
        DbaseCodepage cpWriter = new DbaseCodepage(this.dbfFile);
        cpWriter.write(charset);
        this.dbfChannel = null;
        try {
            this.dbfChannel = (FileChannel)DBFFeatureWriter.getWriteChannel(this.dbfFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new WriteException(this.name, (Throwable)e);
        }
        try {
            this.dbfWriter = new DbaseFileWriter(this.myHeader, this.dbfChannel, true);
        }
        catch (InitializeException e) {
            throw new WriteException(this.name, (Throwable)e);
        }
        this.featuretype = featureType;
        this.dbfFile = storeParameters.getDBFFile();
    }

    public void append(Feature feature) throws DataException {
        if (feature.isBroken()) {
            throw new IllegalStateException("The feature '" + Objects.toString(feature.getReference()) + "' is broken.");
        }
        this.dbfWriter.append(feature);
    }

    public void end() throws DataException {
        this.dbfWriter.close();
    }

    public void dispose() {
        this.dbfWriter = null;
    }

    protected static WritableByteChannel getWriteChannel(String path) throws IOException {
        File f = new File(path);
        LogUtils.log(DBFFeatureWriter.class, "begin getWriteChannel");
        LogUtils.log(DBFFeatureWriter.class, "exists(" + f.getAbsolutePath() + ")");
        if (!f.exists()) {
            LogUtils.log(DBFFeatureWriter.class, "createNewFile(" + f.getAbsolutePath() + ")");
            if (!f.createNewFile()) {
                LOGGER.warn("Error al crear el fichero " + f.getAbsolutePath());
                throw new IOException("Cannot create file " + f);
            }
        }
        LogUtils.log(DBFFeatureWriter.class, "RandomAccessFile('" + f.getAbsolutePath() + "', \"rw\")");
        RandomAccessFile raf = new RandomAccessFile(f, "rw");
        LogUtils.log(DBFFeatureWriter.class, "getChanel()");
        FileChannel channel = raf.getChannel();
        LogUtils.log(DBFFeatureWriter.class, "end getWriteChannel");
        return channel;
    }

    protected int getRowCount() {
        return this.myHeader.getNumRecords();
    }
}

