/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.dbf;

import java.io.File;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.basicformats.CPGFile;
import org.gvsig.basicformats.FormatsFile;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.FileHelper;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.feature.OpenFeatureStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.dal.spi.AbstractDataStoreParameters;
import org.gvsig.fmap.dal.store.dbf.utils.DbaseCodepage;
import org.gvsig.tools.dynobject.DelegatedDynObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBFStoreParameters
extends AbstractDataStoreParameters
implements OpenFeatureStoreParameters,
FilesystemStoreParameters {
    private static final Logger logger = LoggerFactory.getLogger(DBFStoreParameters.class);
    public static final String PARAMETERS_DEFINITION_NAME = "DBFStoreParameters";
    public static final String DBFFILE_PARAMTER_NAME = "dbfFile";
    public static final String ENCODING_PARAMTER_NAME = "encoding";
    public static final String HANDLE_DATES_AS_STRINGS = "handleDatesAsStrings";
    public static final String DATE_FORMAT = "dateFormat";
    public static final String LOCALE = "locale";
    public static final String ALLOW_DECIMAL_INCONSISTENCIES_PARAMTER_NAME = "allowInconsistenciesInDecimals";
    public static final String ALLOW_DUPLICATED_FIELD_NAMES = "allowDuplicatedFieldNames";
    private String effectiveEncoding = null;
    private DelegatedDynObject parameters;

    public DBFStoreParameters() {
        this(PARAMETERS_DEFINITION_NAME);
    }

    protected DBFStoreParameters(String parametersDefinitionName) {
        this(parametersDefinitionName, "DBF");
    }

    public DBFStoreParameters(String parametersDefinitionName, String name) {
        this.parameters = (DelegatedDynObject)FileHelper.newParameters((String)parametersDefinitionName);
        this.setDynValue("ProviderName", name);
    }

    public String getDataStoreName() {
        return (String)this.getDynValue("ProviderName");
    }

    public String getDescription() {
        return this.getDynClass().getDescription();
    }

    public boolean isValid() {
        return this.getDBFFileName() != null;
    }

    public File getFile() {
        return (File)this.getDynValue(DBFFILE_PARAMTER_NAME);
    }

    public void setFile(File file) {
        this.setDynValue(DBFFILE_PARAMTER_NAME, file);
    }

    public void setFile(String fileName) {
        this.setDynValue(DBFFILE_PARAMTER_NAME, fileName);
    }

    public String getDBFFileName() {
        if (this.getDBFFile() == null) {
            return null;
        }
        return this.getDBFFile().getAbsolutePath();
    }

    public File getDBFFile() {
        return (File)this.getDynValue(DBFFILE_PARAMTER_NAME);
    }

    public void setDBFFile(File file) {
        this.setDynValue(DBFFILE_PARAMTER_NAME, file);
    }

    public void setDBFFile(String fileName) {
        this.setDynValue(DBFFILE_PARAMTER_NAME, fileName);
    }

    public String getCPGFileName() {
        return DbaseCodepage.getCpgFileName(this.getDBFFileName());
    }

    public File getCPGFile() {
        return new File(DbaseCodepage.getCpgFileName(this.getDBFFileName()));
    }

    public String getEncodingName() {
        String s = (String)this.getDynValue(ENCODING_PARAMTER_NAME);
        return s;
    }

    public Charset getEncoding() {
        String name = this.getEncodingName();
        if (StringUtils.isBlank((CharSequence)name)) {
            File f = this.getCPGFile();
            if (!f.exists()) {
                return null;
            }
            CPGFile cpgFile = FormatsFile.getCPGFile((File)f);
            name = cpgFile.getCharsetName();
        }
        return Charset.forName(name);
    }

    public String getEffectiveEncodingName() {
        if (this.effectiveEncoding == null) {
            return this.getEncodingName();
        }
        return this.effectiveEncoding.trim();
    }

    public Charset getEffectiveEncoding() {
        String name = this.getEffectiveEncodingName();
        if (name == null) {
            return null;
        }
        return Charset.forName(name);
    }

    public void setEncoding(String encoding) {
        this.setEncoding(Charset.forName(encoding));
    }

    public void setEffectiveEncoding(String encoding) {
        this.effectiveEncoding = encoding;
    }

    public boolean handleDatesAsStrings() {
        Boolean x = (Boolean)this.getDynValue(HANDLE_DATES_AS_STRINGS);
        return BooleanUtils.isTrue((Boolean)x);
    }

    public boolean allowDuplicatedFieldNames() {
        Boolean x = (Boolean)this.getDynValue(ALLOW_DUPLICATED_FIELD_NAMES);
        return BooleanUtils.isTrue((Boolean)x);
    }

    public void setEncoding(Charset charset) {
        this.setDynValue(ENCODING_PARAMTER_NAME, charset.name());
    }

    public void setEffectiveEncoding(Charset charset) {
        this.effectiveEncoding = charset.name();
    }

    public DataParameters getCopy() {
        DataParameters copy = super.getCopy();
        if (copy instanceof DBFStoreParameters) {
            DBFStoreParameters dbfParams = (DBFStoreParameters)copy;
            dbfParams.setEffectiveEncoding(this.effectiveEncoding);
        }
        return copy;
    }

    protected DelegatedDynObject getDelegatedDynObject() {
        return this.parameters;
    }

    public Locale getLocale() {
        try {
            String s = (String)this.getDynValue(LOCALE);
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            Locale locale = null;
            locale = Locale.forLanguageTag(s);
            return locale;
        }
        catch (Exception ex) {
            logger.warn("Can't get locale from DBF parameters.", (Throwable)ex);
            return Locale.getDefault();
        }
    }

    public String getDateFormat() {
        return (String)this.getDynValue(DATE_FORMAT);
    }

    public void validate() throws ValidateDataParametersException {
        super.validate();
        String sfmt = this.getDateFormat();
        if (!StringUtils.isBlank((CharSequence)sfmt)) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(sfmt, this.getLocale());
            }
            catch (Exception ex) {
                throw new InvalidDateFormatException(sfmt, ex);
            }
        }
    }

    public boolean allowInconsistenciesInDecimals() {
        Boolean x = (Boolean)this.getDynValue(ALLOW_DECIMAL_INCONSISTENCIES_PARAMTER_NAME);
        if (x == null) {
            return false;
        }
        return x;
    }

    public boolean isTheSameExplorer(DataStoreParameters parameters) {
        return FilesystemStoreParameters.isTheSameExplorer((DataStoreParameters)this, (DataStoreParameters)parameters);
    }

    public Object getDynValue(String name) {
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)ENCODING_PARAMTER_NAME)) {
            String s = (String)super.getDynValue(name);
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            if ("DEFAULT".equalsIgnoreCase(s.trim())) {
                return null;
            }
            return s.trim();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)LOCALE)) {
            try {
                String s = (String)super.getDynValue(LOCALE);
                if (StringUtils.isBlank((CharSequence)s)) {
                    return null;
                }
                if ("DEFAULT".equalsIgnoreCase(s.trim())) {
                    return Locale.getDefault().toLanguageTag();
                }
                return s;
            }
            catch (Exception ex) {
                logger.warn("Can't get locale from DBF parameters.", (Throwable)ex);
                return Locale.getDefault().toLanguageTag();
            }
        }
        return super.getDynValue(name);
    }

    private static class InvalidDateFormatException
    extends ValidateDataParametersException {
        public InvalidDateFormatException(String sfmt, Throwable cause) {
            super("Date format specified '%(dataformat)' is not valid.", cause, "Date_format_specified_XdataformatX_is_not_valid", 0);
            this.setValue("dataformat", sfmt);
        }
    }
}

