/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.dbf.utils;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Date;
import org.gvsig.fmap.dal.exception.FileNotFoundException;
import org.gvsig.fmap.dal.exception.UnsupportedVersionException;
import org.gvsig.fmap.dal.exception.WriteException;
import org.gvsig.fmap.dal.feature.exception.AttributeFeatureTypeNotSuportedException;
import org.gvsig.fmap.dal.store.dbf.utils.DbaseCodepage;
import org.gvsig.fmap.dal.store.dbf.utils.DbaseFieldDescriptor;
import org.gvsig.fmap.dal.store.dbf.utils.DbaseFileHeader;
import org.gvsig.fmap.dal.store.dbf.utils.FieldFormatter;
import org.gvsig.utils.bigfile.BigByteBuffer2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbaseFile
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(DbaseFile.class);
    public static final int MAX_FIELD_NAME_LENGTH = 10;
    private DbaseFileHeader myHeader;
    private File file;
    private RandomAccessFile raf;
    private FileChannel channel;
    private BigByteBuffer2 buffer;
    private FileChannel.MapMode mode;
    private FieldFormatter formatter = new FieldFormatter();
    private long posActual = -1L;
    private long recordOffset;
    private ByteBuffer cachedRecord = null;
    private byte[] bytesCachedRecord = null;
    private final Number NULL_NUMBER = 0;
    private final String NULL_STRING = "";
    private final String NULL_DATE = "        ";
    private Charset chars = null;
    private Charset charsOriginal;
    private boolean isOpen = false;
    private boolean allowDuplicatedFieldNames;

    public DbaseFile(File afile) {
        this(afile, null);
    }

    public DbaseFile(File afile, Charset chars) {
        this(afile, chars, false);
    }

    public DbaseFile(File afile, Charset chars, boolean allowDuplicatedFieldNames) {
        this.file = afile;
        this.chars = chars;
        this.allowDuplicatedFieldNames = allowDuplicatedFieldNames;
    }

    public DbaseFileHeader getHeader() {
        return this.myHeader;
    }

    public int getCodePageInt() {
        return this.myHeader.getLanguageID();
    }

    public String getCharsetName() {
        return this.chars.name();
    }

    public String getOriginalCharsetName() {
        return this.myHeader.getOriginalCharset();
    }

    public int getRecordCount() {
        return this.myHeader.getNumRecords();
    }

    public int getFieldCount() {
        return this.myHeader.getNumFields();
    }

    public boolean getBooleanFieldValue(long rowIndex, int fieldId) {
        DbaseFieldDescriptor descriptor = this.myHeader.getFieldDescription(fieldId);
        long recordOffset = (long)this.myHeader.getRecordLength() * rowIndex + (long)this.myHeader.getHeaderLength() + 1L;
        int fieldOffset = 0;
        for (int i = 0; i < fieldId - 1; ++i) {
            fieldOffset += descriptor.getSize();
        }
        this.buffer.position(recordOffset + (long)fieldOffset);
        char bool = (char)this.buffer.get();
        return bool == 't' || bool == 'T' || bool == 'Y' || bool == 'y';
    }

    public byte[] getBytesFieldValue(long rowIndex, int fieldId) throws org.gvsig.fmap.dal.exception.UnsupportedEncodingException {
        DbaseFieldDescriptor descriptor = this.myHeader.getFieldDescription(fieldId);
        int fieldOffset = descriptor.getOffsetInRecord();
        byte[] data = new byte[descriptor.getSize()];
        if (rowIndex != this.posActual) {
            this.recordOffset = (long)this.myHeader.getRecordLength() * rowIndex + (long)this.myHeader.getHeaderLength() + 1L;
            this.buffer.position(this.recordOffset);
            this.buffer.get(this.bytesCachedRecord);
            this.cachedRecord = ByteBuffer.wrap(this.bytesCachedRecord);
            this.posActual = rowIndex;
        }
        ((Buffer)this.cachedRecord).position(fieldOffset);
        this.cachedRecord.get(data);
        return data;
    }

    public String getStringFieldValue(long rowIndex, int fieldId) throws org.gvsig.fmap.dal.exception.UnsupportedEncodingException {
        byte[] data = this.getBytesFieldValue(rowIndex, fieldId);
        return new String(data, this.chars);
    }

    public void setFieldValue(long rowIndex, int fieldId, Object obj) throws org.gvsig.fmap.dal.exception.UnsupportedEncodingException, WriteException {
        try {
            DbaseFieldDescriptor descriptor = this.myHeader.getFieldDescription(fieldId);
            this.formatter.setRowIndex(rowIndex);
            this.formatter.setName(descriptor.getName());
            int fieldOffset = descriptor.getOffsetInRecord();
            String str = this.fieldString(obj, fieldId);
            byte[] data = new byte[descriptor.getSize()];
            this.recordOffset = (long)this.myHeader.getRecordLength() * rowIndex + (long)this.myHeader.getHeaderLength() + 1L;
            ByteBuffer aux = ByteBuffer.wrap(data);
            aux.put(str.getBytes(this.chars));
            aux.flip();
            this.channel.write(aux, this.recordOffset + (long)fieldOffset);
        }
        catch (UnsupportedEncodingException e) {
            throw new org.gvsig.fmap.dal.exception.UnsupportedEncodingException((Throwable)e);
        }
        catch (IOException e) {
            throw new WriteException("DBF", (Throwable)e);
        }
    }

    public void open() throws FileNotFoundException, UnsupportedVersionException, IOException, AttributeFeatureTypeNotSuportedException {
        if (!this.file.exists()) {
            throw new FileNotFoundException(this.file);
        }
        this.raf = new RandomAccessFile(this.file, "r");
        this.mode = FileChannel.MapMode.READ_ONLY;
        this.channel = this.raf.getChannel();
        this.buffer = new BigByteBuffer2(this.channel, this.mode);
        this.myHeader = new DbaseFileHeader();
        if (this.chars == null) {
            this.myHeader.read(this.buffer, null, this.allowDuplicatedFieldNames);
        } else {
            this.myHeader.read(this.buffer, this.chars.name(), this.allowDuplicatedFieldNames);
        }
        if (this.myHeader.getLanguageID() == 0) {
            DbaseCodepage cpReader = new DbaseCodepage(this.file);
            String charsetName = cpReader.read();
            if (charsetName == null) {
                charsetName = "ISO-8859-1";
            }
            this.charsOriginal = Charset.forName(this.myHeader.mappingEncoding(charsetName));
        } else {
            this.charsOriginal = Charset.forName(this.myHeader.mappingEncoding(this.myHeader.getOriginalCharset()));
        }
        if (this.chars == null) {
            this.chars = this.charsOriginal;
        }
        this.bytesCachedRecord = new byte[this.myHeader.getRecordLength()];
        this.isOpen = true;
    }

    @Override
    public void close() throws IOException {
        logger.debug("Closing dbf file '" + this.file.getAbsolutePath() + "'");
        try {
            this.raf.close();
            this.channel.close();
            this.buffer = null;
            this.posActual = -1L;
            this.myHeader = null;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("DBF", e);
        }
        this.isOpen = false;
    }

    public FileChannel getWriteChannel() {
        return this.channel;
    }

    private String fieldString(Object obj, int col) {
        String o;
        DbaseFieldDescriptor descriptor = this.myHeader.getFieldDescription(col);
        int fieldLen = descriptor.getSize();
        switch (descriptor.getType()) {
            case 'C': 
            case 'c': {
                o = this.formatter.format(obj == null ? this.NULL_STRING : (String)obj, fieldLen);
                break;
            }
            case 'L': 
            case 'l': {
                o = obj == null ? "F" : ((Boolean)obj == true ? "T" : "F");
                break;
            }
            case 'G': 
            case 'M': {
                o = this.formatter.format(obj == null ? this.NULL_STRING : (String)obj, fieldLen);
                break;
            }
            case 'F': 
            case 'N': 
            case 'f': 
            case 'n': {
                Number number;
                if (obj == null) {
                    number = this.NULL_NUMBER;
                } else {
                    Number gVal = (Number)obj;
                    number = gVal.doubleValue();
                }
                o = this.formatter.format((Double)number, fieldLen, descriptor.getScale());
                break;
            }
            case 'D': 
            case 'd': {
                if (obj == null) {
                    o = "        ";
                    break;
                }
                o = this.formatter.formatDate((Date)obj);
                break;
            }
            default: {
                throw new RuntimeException("Unknown type " + descriptor.getType());
            }
        }
        return o;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public int getFieldIndex(String name) {
        return this.myHeader.getFieldIndex(name);
    }

    public Charset getCurrenCharset() {
        return this.chars;
    }

    public Charset getOriginalCharset() {
        return this.charsOriginal;
    }

    public void setCharset(Charset chars) {
        this.chars = chars;
    }

    public boolean isWritable() {
        return this.file.canWrite();
    }
}

