/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.dbf.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.exception.CloseException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.WriteException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.store.dbf.utils.DbaseFieldDescriptor;
import org.gvsig.fmap.dal.store.dbf.utils.DbaseFileHeader;
import org.gvsig.fmap.dal.store.dbf.utils.FieldFormatter;
import org.gvsig.fmap.dal.store.dbf.utils.FieldNameTooLongException;
import org.gvsig.fmap.dal.store.dbf.utils.LogUtils;
import org.gvsig.tools.logger.FilteredLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbaseFileWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbaseFileWriter.class);
    private final DbaseFileHeader header;
    private FieldFormatter formatter = new FieldFormatter();
    private FileChannel channel;
    private ByteBuffer buffer;
    private boolean headDrity = false;
    private ByteBuffer blank;
    private int blankSize;
    private Charset charset;
    private FilteredLogger logger;

    public DbaseFileWriter(DbaseFileHeader header, FileChannel out, boolean isNew) throws InitializeException {
        this.header = header;
        this.channel = out;
        this.headDrity = isNew;
        this.setCharset(Charset.forName(header.mappingEncoding(header.getCharsetName())));
        this.init();
    }

    private void init() throws InitializeException {
        try {
            LogUtils.log(this, "begin init");
            LogUtils.log(this, "channel.size");
            if (this.channel.size() < (long)this.header.getHeaderLength()) {
                this.writeHeader();
            }
            this.buffer = ByteBuffer.allocateDirect(this.header.getRecordLength());
        }
        catch (Exception e) {
            throw new InitializeException("DBF Writer", (Throwable)e);
        }
        finally {
            LogUtils.log(this, "end init");
        }
    }

    private void write() throws WriteException {
        ((Buffer)this.buffer).position(0);
        int r = this.buffer.remaining();
        LogUtils.log(this, "write begin");
        try {
            LogUtils.log(this, "channel.write(buffer)");
            while ((r -= this.channel.write(this.buffer)) > 0) {
            }
        }
        catch (IOException e) {
            throw new WriteException("DBF Writer", (Throwable)e);
        }
        finally {
            LogUtils.log(this, "write end");
        }
    }

    private void writeHeader() throws WriteException {
        LogUtils.log(this, "writeHeader begin");
        try {
            LogUtils.log(this, "channel.position(0)");
            this.channel.position(0L);
            LogUtils.log(this, "write(header)");
            this.header.write(this.channel);
        }
        catch (IOException e) {
            throw new WriteException("DBF Writer", (Throwable)e);
        }
        finally {
            LogUtils.log(this, "writeHeader end");
        }
    }

    public void append(Feature feature) throws WriteException, org.gvsig.fmap.dal.exception.UnsupportedEncodingException {
        this.fillBuffer(feature);
        try {
            this.moveToEOF();
        }
        catch (IOException e) {
            throw new WriteException("DbaseFileWriter", (Throwable)e);
        }
        this.header.setNumRecords(this.header.getNumRecords() + 1);
        this.write();
        this.headDrity = true;
    }

    private void fillBuffer(Feature feature) throws org.gvsig.fmap.dal.exception.UnsupportedEncodingException, WriteException {
        FeatureType featureType = feature.getType();
        try {
            ((Buffer)this.buffer).position(0);
            this.buffer.put((byte)32);
            for (FeatureAttributeDescriptor fad : featureType) {
                if (fad.isComputed()) continue;
                if (fad.getName().length() > 10) {
                    throw new FieldNameTooLongException("DBF file", fad.getName());
                }
                int type = fad.getType();
                if (type == 66) continue;
                this.encodeField(fad, feature);
            }
        }
        catch (Exception e) {
            throw new WriteException("DbaseFileWriter", (Throwable)e);
        }
    }

    private void moveToEOF() throws IOException {
        this.moveTo(this.header.getNumRecords());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveTo(long numReg) throws IOException {
        LogUtils.log(this, "moveTo begin");
        try {
            long newPos = (long)this.header.getHeaderLength() + numReg * (long)this.header.getRecordLength();
            LogUtils.log(this, "channel.position()");
            if (this.channel.position() != newPos) {
                LogUtils.log(this, "channel.position(" + newPos + ")");
                this.channel.position(newPos);
            }
        }
        finally {
            LogUtils.log(this, "moveTo end");
        }
    }

    public void update(Feature feature, long numReg) throws WriteException, org.gvsig.fmap.dal.exception.UnsupportedEncodingException {
        this.fillBuffer(feature);
        try {
            this.moveTo(numReg);
        }
        catch (IOException e) {
            throw new WriteException("DbaseFileWriter", (Throwable)e);
        }
        this.write();
    }

    private void encodeField(FeatureAttributeDescriptor attr, Feature feature) throws UnsupportedEncodingException, org.gvsig.fmap.dal.exception.UnsupportedEncodingException {
        if (attr == null) {
            throw new NullPointerException("attr is NULL");
        }
        if (feature == null) {
            throw new NullPointerException("feature is NULL");
        }
        int fieldLen = -1;
        try {
            DbaseFieldDescriptor descriptor = this.header.getFieldDescription(attr.getName());
            int type = attr.getType();
            fieldLen = descriptor.getSize();
            String fieldName = attr.getName();
            if (feature.isNull(attr.getIndex())) {
                this.safeEncode(fieldName, " ", fieldLen, false);
                return;
            }
            this.formatter.setName(fieldName);
            this.formatter.setRowIndex(-1L);
            if (1 == type) {
                boolean b = feature.getBoolean(attr.getIndex());
                this.safeEncode(fieldName, b ? "T" : "F", 1, true);
            } else if (10 == type) {
                Time date = feature.getTime(attr.getIndex());
                String fieldString = this.formatter.formatTime(date);
                this.safeEncode(fieldName, fieldString, fieldLen, false);
            } else if (11 == type) {
                Timestamp date = feature.getTimestamp(attr.getIndex());
                String fieldString = this.formatter.formatTimestamp((java.util.Date)date);
                this.safeEncode(fieldName, fieldString, fieldLen, false);
            } else if (9 == type) {
                Date date = feature.getDate(attr.getIndex());
                String fieldString = this.formatter.formatDate(date);
                this.safeEncode(fieldName, fieldString, fieldLen, false);
            } else if (19 == type) {
                BigDecimal n = feature.getDecimal(attr.getIndex());
                String fieldString = this.formatter.format(n, fieldLen);
                this.safeEncode(fieldName, fieldString, fieldLen, false);
            } else if (7 == type) {
                double n = feature.getDouble(attr.getIndex());
                String fieldString = this.formatter.format(n, fieldLen, descriptor.getScale());
                this.safeEncode(fieldName, fieldString, fieldLen, false);
            } else if (6 == type) {
                float n = feature.getFloat(attr.getIndex());
                String fieldString = this.formatter.format(n, fieldLen, descriptor.getScale());
                this.safeEncode(fieldName, fieldString, fieldLen, false);
            } else if (5 == type) {
                long l = feature.getLong(attr.getIndex());
                String fieldString = this.formatter.format(l, fieldLen);
                this.safeEncode(fieldName, fieldString, fieldLen, false);
            } else if (4 == type) {
                int n = feature.getInt(attr.getIndex());
                String fieldString = this.formatter.format(n, fieldLen);
                this.safeEncode(fieldName, fieldString, fieldLen, false);
            } else if (2 == type) {
                int n = feature.getInt(attr.getIndex());
                String fieldString = this.formatter.format(n, fieldLen);
                this.safeEncode(fieldName, fieldString, fieldLen, false);
            } else if (8 == type) {
                String s = feature.getString(attr.getIndex());
                this.safeEncode(fieldName, (String)StringUtils.defaultIfEmpty((CharSequence)s, (CharSequence)""), fieldLen, true);
            } else {
                String s = feature.getString(attr.getIndex());
                this.safeEncode(fieldName, (String)StringUtils.defaultIfEmpty((CharSequence)s, (CharSequence)""), fieldLen, true);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't encode field '" + attr.getName() + "' with size " + fieldLen, ex);
        }
    }

    private void safeEncode(String fieldName, String in, int limit, boolean rightPadding) throws org.gvsig.fmap.dal.exception.UnsupportedEncodingException {
        try {
            byte[] encodedString = in.getBytes(this.charset);
            if (encodedString.length > limit) {
                byte[] encodedChar;
                this.getLogger().error("'" + fieldName + "' field size [" + encodedString.length + "] exceeds limit " + limit);
                String str = in;
                int truncatePos = 0;
                int deviation = encodedString.length - limit;
                int deviationPrev = deviation - 1;
                while (Math.abs(deviation) > Math.abs(deviationPrev) && str.length() > 0) {
                    double ratio = (double)encodedString.length / (double)str.length();
                    int estimatedDiff = Math.max((int)((double)deviation / ratio), (int)(Math.signum(deviation) * 1.0f));
                    if (rightPadding) {
                        truncatePos = Math.max(str.length() - estimatedDiff, 0);
                        str = in.substring(0, truncatePos);
                    } else {
                        truncatePos = Math.max(truncatePos + estimatedDiff, 0);
                        str = in.substring(truncatePos);
                    }
                    encodedString = str.getBytes(this.charset);
                    deviationPrev = deviation;
                    deviation = encodedString.length - limit;
                }
                while (encodedString.length > limit) {
                    str = rightPadding ? in.substring(0, str.length() - 1) : in.substring(++truncatePos);
                    encodedString = str.getBytes(this.charset);
                }
                while (encodedString.length < limit && str.length() < in.length() && encodedString.length + (encodedChar = rightPadding ? in.substring(str.length(), str.length() + 1).getBytes(this.charset) : in.substring(truncatePos - 1, truncatePos).getBytes(this.charset)).length <= limit) {
                    str = rightPadding ? in.substring(0, str.length() + 1) : in.substring(--truncatePos);
                    encodedString = str.getBytes(this.charset);
                }
            }
            if (rightPadding) {
                this.buffer.put(encodedString);
            }
            if (encodedString.length < limit) {
                int i;
                for (i = encodedString.length; i < limit; i += this.blankSize) {
                    ((Buffer)this.blank).position(0);
                    this.buffer.put(this.blank);
                }
                if (i > limit) {
                    throw new org.gvsig.fmap.dal.exception.UnsupportedEncodingException((Throwable)new Exception("Impossible to encode this DBF using the selected charset"));
                }
            }
            if (!rightPadding) {
                this.buffer.put(encodedString);
            }
        }
        catch (BufferOverflowException exc) {
            throw new org.gvsig.fmap.dal.exception.UnsupportedEncodingException((Throwable)exc);
        }
    }

    public void close() throws CloseException {
        LogUtils.log(this, "close begin");
        try {
            if (this.headDrity) {
                try {
                    this.writeHeader();
                }
                catch (WriteException e) {
                    throw new CloseException("DbaseFileWriter", (Throwable)e);
                }
            }
            try {
                LogUtils.log(this, "channel.close()");
                this.channel.close();
            }
            catch (IOException e) {
                throw new CloseException("DBF Writer", (Throwable)e);
            }
            if (this.buffer instanceof MappedByteBuffer) {
                // empty if block
            }
            this.buffer = null;
            this.channel = null;
            this.formatter = null;
        }
        finally {
            LogUtils.log(this, "close end");
        }
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
        this.blank = charset.encode(" ");
        this.blankSize = this.blank.limit();
    }

    protected FilteredLogger getLogger() {
        if (this.logger == null) {
            this.logger = new FilteredLogger(LOGGER, "DbaseFileWriter", 2000L);
        }
        return this.logger;
    }
}

