/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.algorithm.swing.impl.bean.inputlayer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.swing.listener.PanelChangeEvent;
import org.gvsig.raster.swing.listener.PanelChangeListener;
import org.gvsig.raster.tools.algorithm.swing.bean.LayerComboElement;

public class InputLayerImpl
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JComboBox inputLayerCombo = null;
    private JComboBox bandsSelectorCombo = null;
    private JLabel layerLabel = null;
    private JLabel bandsLabel = null;
    private String boxLabel = null;
    private boolean borderEnabled = false;
    private boolean labelsEnabled = false;
    private PanelChangeListener listener = null;

    public InputLayerImpl(String[] labels, boolean border, boolean labelEnabled) {
        if (labels != null) {
            this.layerLabel = new JLabel(labels[0]);
            this.bandsLabel = new JLabel(labels[1]);
            this.boxLabel = labels[2];
        } else {
            this.boxLabel = Messages.getText((String)"input");
        }
        this.borderEnabled = border;
        this.labelsEnabled = labelEnabled;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        if (this.borderEnabled) {
            this.setBorder(BorderFactory.createTitledBorder(this.boxLabel));
        }
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.insets = new Insets(0, 2, 0, 0);
        if (this.labelsEnabled) {
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            this.add((Component)this.getLayerLabel(), gridBagConstraints1);
        }
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        this.add((Component)this.getInputLayerCombo(), gridBagConstraints1);
        gridBagConstraints1.fill = 0;
        gridBagConstraints1.weightx = 0.0;
        if (this.labelsEnabled) {
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 0;
            this.add((Component)this.getBandsLabel(), gridBagConstraints1);
        }
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        this.add((Component)this.getBandsSelectorCombo(), gridBagConstraints1);
    }

    public JComboBox getInputLayerCombo() {
        if (this.inputLayerCombo == null) {
            this.inputLayerCombo = new JComboBox();
            this.inputLayerCombo.addActionListener(this);
        }
        return this.inputLayerCombo;
    }

    public JComboBox getBandsSelectorCombo() {
        if (this.bandsSelectorCombo == null) {
            this.bandsSelectorCombo = new JComboBox();
            this.bandsSelectorCombo.addActionListener(this);
        }
        return this.bandsSelectorCombo;
    }

    public JLabel getLayerLabel() {
        if (this.layerLabel == null) {
            this.layerLabel = new JLabel(Messages.getText((String)"layers"));
        }
        return this.layerLabel;
    }

    public JLabel getBandsLabel() {
        if (this.bandsLabel == null) {
            this.bandsLabel = new JLabel(Messages.getText((String)"bands"));
        }
        return this.bandsLabel;
    }

    @Override
    public void setEnabled(boolean enable) {
        this.getBandsSelectorCombo().setEnabled(enable);
        this.getInputLayerCombo().setEnabled(enable);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.listener != null) {
            this.listener.panelHasChanged(new PanelChangeEvent((Object)e));
        }
        if (e.getSource() == this.getInputLayerCombo() && this.getInputLayerCombo().getSelectedItem() instanceof LayerComboElement) {
            int nElements = ((LayerComboElement)this.getInputLayerCombo().getSelectedItem()).getNumOfElements();
            this.getBandsSelectorCombo().removeAllItems();
            this.getBandsSelectorCombo().addItem(Messages.getText((String)"all"));
            for (int i = 0; i < nElements; ++i) {
                this.getBandsSelectorCombo().addItem(i);
            }
        }
    }

    public void addPanelChangeEvent(PanelChangeListener listener) {
        this.listener = listener;
    }
}

