/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.algorithm.swing.impl.saveraster;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.gui.beans.datainput.DataInputContainer;
import org.gvsig.gui.beans.datainput.DataInputContainerListener;
import org.gvsig.raster.tools.algorithm.swing.impl.saveraster.CoordinatesSelectionPanel;
import org.gvsig.raster.tools.algorithm.swing.impl.saveraster.OutputSelectionPanel;
import org.gvsig.raster.tools.algorithm.swing.impl.saveraster.PrintAndPxSelectionPanel;
import org.gvsig.raster.tools.algorithm.swing.impl.util.InputFieldPanel;
import org.gvsig.raster.tools.algorithm.swing.saveraster.SaveRasterPanel;

public class SaveRasterMainPanel
extends JPanel
implements SaveRasterPanel {
    private static final long serialVersionUID = 1L;
    private CoordinatesSelectionPanel coordinatesPanel = null;
    private PrintAndPxSelectionPanel methodPanel = null;
    private OutputSelectionPanel outputPanel = null;

    public SaveRasterMainPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridy = 0;
        this.add((Component)this.getWCCoordsPanel(), gbc);
        gbc.gridy = 1;
        this.add((Component)this.getMethodPanel(), gbc);
        gbc.gridy = 2;
        this.add((Component)this.getMethodPanel(), gbc);
        gbc.gridy = 3;
        this.add((Component)this.getOutputPanel(), gbc);
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.gridy = 4;
        this.add((Component)new JPanel(), gbc);
    }

    public CoordinatesSelectionPanel getWCCoordsPanel() {
        if (this.coordinatesPanel == null) {
            this.coordinatesPanel = new CoordinatesSelectionPanel();
        }
        return this.coordinatesPanel;
    }

    public PrintAndPxSelectionPanel getMethodPanel() {
        if (this.methodPanel == null) {
            this.methodPanel = new PrintAndPxSelectionPanel();
        }
        return this.methodPanel;
    }

    public OutputSelectionPanel getOutputPanel() {
        if (this.outputPanel == null) {
            this.outputPanel = new OutputSelectionPanel();
        }
        return this.outputPanel;
    }

    public void addValueChangedListener(DataInputContainerListener listener) {
        this.getWCCoordsPanel().getCoordinatesPanel().getDataInputContainer11().addValueChangedListener(listener);
        this.getWCCoordsPanel().getCoordinatesPanel().getDataInputContainer21().addValueChangedListener(listener);
        this.getWCCoordsPanel().getCoordinatesPanel().getDataInputContainer12().addValueChangedListener(listener);
        this.getWCCoordsPanel().getCoordinatesPanel().getDataInputContainer22().addValueChangedListener(listener);
    }

    public void addPropertiesChangeListener(PropertyChangeListener listener) {
        this.getMethodPanel().getPixelSelectionPanel().getWidthInput().setListener(listener);
        this.getMethodPanel().getPixelSelectionPanel().getHeightInput().setListener(listener);
        this.getMethodPanel().getPixelSelectionPanel().getCellsize().setListener(listener);
        this.getMethodPanel().getPrintSelectionPanel().getWidthInput().setListener(listener);
        this.getMethodPanel().getPrintSelectionPanel().getHeightInput().setListener(listener);
        this.getMethodPanel().getPrintSelectionPanel().getScale().setListener(listener);
    }

    public void addActionListener(ActionListener listener) {
        this.getMethodPanel().getPixelSelectionPanel().getRadioPxSelection().addActionListener(listener);
        this.getMethodPanel().getPrintSelectionPanel().getRadioPrintSelection().addActionListener(listener);
        this.getMethodPanel().getPrintSelectionPanel().getComboDPI().addActionListener(listener);
        this.getOutputPanel().getBSelect().addActionListener(listener);
        this.getOutputPanel().getBProperties().addActionListener(listener);
    }

    public boolean isPixelMethodSelected() {
        return this.getMethodPanel().getPixelSelectionPanel().getRadioPxSelection().isSelected();
    }

    public JComponent getComponent() {
        return this;
    }

    public int getComponentID(Object obj) {
        if (obj == this.getMethodPanel().getPixelSelectionPanel().getWidthInput().getTextField()) {
            return 0;
        }
        if (obj == this.getMethodPanel().getPixelSelectionPanel().getHeightInput().getTextField()) {
            return 1;
        }
        if (obj == this.getMethodPanel().getPixelSelectionPanel().getCellsize().getTextField()) {
            return 2;
        }
        if (obj == this.getMethodPanel().getPrintSelectionPanel().getWidthInput().getTextField()) {
            return 3;
        }
        if (obj == this.getMethodPanel().getPrintSelectionPanel().getHeightInput().getTextField()) {
            return 4;
        }
        if (obj == this.getMethodPanel().getPrintSelectionPanel().getScale().getTextField()) {
            return 5;
        }
        if (obj == this.getMethodPanel().getPrintSelectionPanel().getComboDPI()) {
            return 6;
        }
        if (obj == this.getOutputPanel().getBSelect()) {
            return 7;
        }
        if (obj == this.getOutputPanel().getBProperties()) {
            return 8;
        }
        if (obj == this.getWCCoordsPanel().getCoordinatesPanel().getDataInputContainer11().getDataInputField()) {
            return 9;
        }
        if (obj == this.getWCCoordsPanel().getCoordinatesPanel().getDataInputContainer12().getDataInputField()) {
            return 10;
        }
        if (obj == this.getWCCoordsPanel().getCoordinatesPanel().getDataInputContainer21().getDataInputField()) {
            return 11;
        }
        if (obj == this.getWCCoordsPanel().getCoordinatesPanel().getDataInputContainer22().getDataInputField()) {
            return 12;
        }
        if (obj == this.getMethodPanel().getPixelSelectionPanel().getRadioPxSelection()) {
            return 13;
        }
        if (obj == this.getMethodPanel().getPrintSelectionPanel().getRadioPrintSelection()) {
            return 14;
        }
        return -1;
    }

    public void setSizeMB(double mb) {
        this.getMethodPanel().setSize(mb);
    }

    public String getCellSize() {
        return this.getMethodPanel().getPixelSelectionPanel().getCellsize().getValue();
    }

    public void setCellSize(String value) {
        this.getMethodPanel().getPixelSelectionPanel().getCellsize().setValue(value);
    }

    public String getWidthPxValue() {
        return this.getMethodPanel().getPixelSelectionPanel().getWidthInput().getValue();
    }

    public String getHeightPxValue() {
        return this.getMethodPanel().getPixelSelectionPanel().getHeightInput().getValue();
    }

    public int getWidthPxPrint() {
        return this.getMethodPanel().getPrintSelectionPanel().getWidthPx();
    }

    public int getHeightPxPrint() {
        return this.getMethodPanel().getPrintSelectionPanel().getHeightPx();
    }

    public void setWidthPxValue(String value) {
        this.getMethodPanel().getPixelSelectionPanel().getWidthInput().setValue(value);
    }

    public void setHeightPxValue(String value) {
        this.getMethodPanel().getPixelSelectionPanel().getHeightInput().setValue(value);
    }

    public JButton getBProperties() {
        return this.getOutputPanel().getBProperties();
    }

    public String getValueLRX() {
        return this.getWCCoordsPanel().getCoordinatesPanel().getDataInputContainer21().getValue();
    }

    public String getValueLRY() {
        return this.getWCCoordsPanel().getCoordinatesPanel().getDataInputContainer22().getValue();
    }

    public String getValueULX() {
        return this.getWCCoordsPanel().getCoordinatesPanel().getDataInputContainer11().getValue();
    }

    public String getValueULY() {
        return this.getWCCoordsPanel().getCoordinatesPanel().getDataInputContainer12().getValue();
    }

    public void setValueLRX(String value) {
        this.getWCCoordsPanel().getCoordinatesPanel().getDataInputContainer21().setValue(value);
    }

    public void setValueLRY(String value) {
        this.getWCCoordsPanel().getCoordinatesPanel().getDataInputContainer22().setValue(value);
    }

    public void setValueULX(String value) {
        this.getWCCoordsPanel().getCoordinatesPanel().getDataInputContainer11().setValue(value);
    }

    public void setValueULY(String value) {
        this.getWCCoordsPanel().getCoordinatesPanel().getDataInputContainer12().setValue(value);
    }

    public JLabel getLFileName() {
        return this.getOutputPanel().getLabelText();
    }

    public JButton getBSelect() {
        return this.getOutputPanel().getBSelect();
    }

    public void setValueXCms(String value) {
        this.getMethodPanel().getPrintSelectionPanel().getWidthInput().setValue(value);
    }

    public void setValueYCms(String value) {
        this.getMethodPanel().getPrintSelectionPanel().getHeightInput().setValue(value);
    }

    public String getValueXCms() {
        return this.getMethodPanel().getPrintSelectionPanel().getWidthInput().getValue();
    }

    public String getValueYCms() {
        return this.getMethodPanel().getPrintSelectionPanel().getHeightInput().getValue();
    }

    public JComboBox getCbResolution() {
        return this.getMethodPanel().getPrintSelectionPanel().getComboDPI();
    }

    public String getScaleValue() {
        return this.getMethodPanel().getPrintSelectionPanel().getScale().getValue();
    }

    public void setScaleValue(String value) {
        this.getMethodPanel().getPrintSelectionPanel().getScale().setValue(value);
    }

    public String getResolutionValue() {
        return (String)this.getMethodPanel().getPrintSelectionPanel().getComboDPI().getSelectedItem();
    }

    public void setSizePxPrintResult(int w, int h) {
        this.getMethodPanel().getPrintSelectionPanel().setSizePxResult(w, h);
    }

    public void validateFields() {
        this.validateField(this.getMethodPanel().getPixelSelectionPanel().getWidthInput());
        this.validateField(this.getMethodPanel().getPixelSelectionPanel().getHeightInput());
        this.validateField(this.getMethodPanel().getPixelSelectionPanel().getCellsize());
        this.validateField(this.getMethodPanel().getPrintSelectionPanel().getWidthInput());
        this.validateField(this.getMethodPanel().getPrintSelectionPanel().getHeightInput());
        this.validateField(this.getMethodPanel().getPrintSelectionPanel().getScale());
        this.validateField(this.getWCCoordsPanel().getCoordinatesPanel().getDataInputContainer11());
        this.validateField(this.getWCCoordsPanel().getCoordinatesPanel().getDataInputContainer21());
        this.validateField(this.getWCCoordsPanel().getCoordinatesPanel().getDataInputContainer12());
        this.validateField(this.getWCCoordsPanel().getCoordinatesPanel().getDataInputContainer22());
    }

    private void validateField(InputFieldPanel field) {
        String value = field.getValue();
        if (value == null || value.equals("")) {
            field.setValue("0");
        }
        try {
            Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            field.setValue("0");
        }
    }

    private void validateField(DataInputContainer field) {
        String value = field.getValue();
        if (value == null || value.equals("")) {
            field.setValue("0");
        }
        try {
            Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            field.setValue("0");
        }
    }
}

