/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.symmetry.lib.prov.symmetry;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.aggregate.Aggregate;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiSurface;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.EditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class SymmetryEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private final EditingServiceParameter selectionParameter;
    private final EditingServiceParameter firstPointParameter;
    private final EditingServiceParameter secondPointParameter;
    private final EditingServiceParameter deleteOriginalGeometriesParameter;
    private Map<EditingServiceParameter, Object> values;
    private final FeatureStore featureStore;
    private List<Feature> selectedFeatures;

    public SymmetryEditingProvider(ProviderServices providerServices, DynObject parameters) {
        super(providerServices);
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.selectionParameter = new DefaultEditingServiceParameter("selection", i18nManager.getTranslation("selection"), new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.SELECTION});
        this.firstPointParameter = new DefaultEditingServiceParameter("first_point_of_symmetry_axis", i18nManager.getTranslation("first_point_of_symmetry_axis"), new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.secondPointParameter = new DefaultEditingServiceParameter("second_point_of_symmetry_axis", i18nManager.getTranslation("second_point_of_symmetry_axis"), new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        EditingProviderServices editingProviderServices = this.getProviderServices();
        DefaultEditingServiceParameterOptions deleteOriginalGeometriesOptions2 = new DefaultEditingServiceParameterOptions().add("delete_original_geometries", (Object)true, i18nManager.getTranslation("_yes")).add("keep_original_geometries", (Object)false, i18nManager.getTranslation("_no"));
        String consoleMsg = editingProviderServices.makeConsoleMessage("delete_original_geometries_question", (EditingServiceParameterOptions)deleteOriginalGeometriesOptions2);
        this.deleteOriginalGeometriesParameter = new DefaultEditingServiceParameter(i18nManager.getTranslation("delete_original_geometries"), consoleMsg, (EditingServiceParameterOptions)deleteOriginalGeometriesOptions2, (Object)false, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.OPTION}).setDataType(1);
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        block13: {
            DefaultDrawingStatus drawingStatus = new DefaultDrawingStatus();
            EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
            ISymbol auxiliaryLineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
            ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
            ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
            ISymbol polygonSymbolEditing = editingProviderManager.getSymbol("polygon-symbol-editing");
            FeatureSelection selected = (FeatureSelection)this.values.get(this.selectionParameter);
            try {
                Object p2Value;
                Point p2;
                if (!CollectionUtils.isNotEmpty(this.selectedFeatures)) break block13;
                Point p1 = (Point)this.values.get(this.firstPointParameter);
                if (p1 != null && !Objects.equals(p1, p2 = (p2Value = this.values.get(this.secondPointParameter)) != null && p2Value instanceof Point ? (Point)p2Value : mousePosition)) {
                    AffineTransform at;
                    Line line = GeometryLocator.getGeometryManager().createLine(this.featureStore.getDefaultFeatureType().getDefaultGeometryAttribute().getGeomType().getSubType());
                    line.addVertex(p1);
                    line.addVertex(p2);
                    drawingStatus.addStatus((Geometry)line, auxiliaryLineSymbolEditing, "");
                    DisposableIterator it = selected.fastIterator();
                    try {
                        at = this.getSymmetryAffineTransform(p1, p2);
                    }
                    catch (Exception e) {
                        throw new DrawServiceException((Throwable)e);
                    }
                    for (Feature feat : this.selectedFeatures) {
                        ISymbol previewSymbol = this.getPreviewSymbol(feat);
                        Geometry transformedGeometry = feat.getDefaultGeometry().cloneGeometry();
                        transformedGeometry.transform(at);
                        ISymbol symbol = null;
                        if (transformedGeometry instanceof Curve || transformedGeometry instanceof MultiCurve) {
                            symbol = lineSymbolEditing;
                        } else if (transformedGeometry instanceof Surface || transformedGeometry instanceof MultiSurface) {
                            symbol = polygonSymbolEditing;
                        } else if (transformedGeometry instanceof Point || transformedGeometry instanceof MultiPoint) {
                            symbol = auxiliaryPointSymbolEditing;
                        }
                        if (transformedGeometry instanceof Aggregate) {
                            int primitivesNumber = ((Aggregate)transformedGeometry).getPrimitivesNumber();
                            for (int i = 0; i < primitivesNumber; ++i) {
                                Primitive primitive = ((Aggregate)transformedGeometry).getPrimitiveAt(i);
                                drawingStatus.addStatus((Geometry)primitive, symbol, "");
                                drawingStatus.addStatus((Geometry)primitive, previewSymbol, "");
                            }
                            continue;
                        }
                        drawingStatus.addStatus(transformedGeometry, symbol, "");
                        drawingStatus.addStatus(transformedGeometry, previewSymbol, "");
                    }
                }
                return drawingStatus;
            }
            catch (Exception e) {
                throw new DrawServiceException((Throwable)e);
            }
        }
        return null;
    }

    private AffineTransform getSymmetryAffineTransform(Point axisP1, Point axisP2) throws GeometryOperationNotSupportedException, GeometryOperationException {
        AffineTransform translate = AffineTransform.getTranslateInstance(-axisP1.getX(), -axisP1.getY());
        EditingProviderServices editingProviderServices = this.getProviderServices();
        Double angle = -editingProviderServices.getAngle(axisP1, axisP2);
        AffineTransform rotate = AffineTransform.getRotateInstance(angle);
        AffineTransform symmetry = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
        AffineTransform inverseRotate = AffineTransform.getRotateInstance(-angle.doubleValue());
        AffineTransform inverseTranslate = AffineTransform.getTranslateInstance(axisP1.getX(), axisP1.getY());
        AffineTransform at = new AffineTransform(translate);
        at.preConcatenate(rotate);
        at.preConcatenate(symmetry);
        at.preConcatenate(inverseRotate);
        at.preConcatenate(inverseTranslate);
        return at;
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.selectionParameter) == null) {
            return this.selectionParameter;
        }
        if (this.values.get(this.firstPointParameter) == null) {
            return this.firstPointParameter;
        }
        if (this.values.get(this.secondPointParameter) == null) {
            return this.secondPointParameter;
        }
        if (this.values.get(this.deleteOriginalGeometriesParameter) == null) {
            return this.deleteOriginalGeometriesParameter;
        }
        return null;
    }

    public void stop() {
        this.values.clear();
        this.selectedFeatures = Collections.EMPTY_LIST;
    }

    private void validateAndInsertValue(EditingServiceParameter param, Object value) throws InvalidEntryException {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        if (param == this.selectionParameter) {
            FeatureSelection featureSelection;
            if (value instanceof FeatureSelection && (featureSelection = (FeatureSelection)value).getSelectedCount() > 0L) {
                this.values.put(param, featureSelection);
                this.selectedFeatures = this.getSelectedFeaturesCopy(featureSelection);
            }
        } else if (param == this.firstPointParameter) {
            if (value instanceof Point) {
                this.values.put(param, value);
            }
        } else if (param == this.secondPointParameter) {
            if (value instanceof Point) {
                this.values.put(param, value);
            }
        } else if (param == this.deleteOriginalGeometriesParameter) {
            this.values.put(param, param.getOptions2().getValue(value, param.getDefaultValue()));
        }
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> list = new ArrayList<EditingServiceParameter>();
        list.add(this.selectionParameter);
        list.add(this.firstPointParameter);
        list.add(this.secondPointParameter);
        list.add(this.deleteOriginalGeometriesParameter);
        return list;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter param = this.next();
        this.validateAndInsertValue(param, value);
    }

    public void finishAndStore() throws FinishServiceException {
        block6: {
            Boolean deleteOriginalGeometriesValue = (Boolean)this.values.get(this.deleteOriginalGeometriesParameter);
            try {
                AffineTransform at;
                if (!CollectionUtils.isNotEmpty(this.selectedFeatures)) break block6;
                Point p1 = (Point)this.values.get(this.firstPointParameter);
                Point p2 = (Point)this.values.get(this.secondPointParameter);
                if (p1 == null || p2 == null) break block6;
                try {
                    at = this.getSymmetryAffineTransform(p1, p2);
                }
                catch (GeometryOperationException | GeometryOperationNotSupportedException e) {
                    throw new FinishServiceException(e);
                }
                for (Feature feature : this.selectedFeatures) {
                    Geometry geom = feature.getDefaultGeometry().cloneGeometry();
                    geom.transform(at);
                    if (deleteOriginalGeometriesValue.booleanValue()) {
                        EditableFeature editableFeature = feature.getEditable();
                        editableFeature.setDefaultGeometry(geom);
                        this.getProviderServices().updateFeatureInFeatureStore((Feature)editableFeature, this.featureStore);
                        continue;
                    }
                    EditingProviderServices editingProviderServices = this.getProviderServices();
                    EditableFeature editableFeature = editingProviderServices.getFeatureCopyWithoutUniqueIndex(this.featureStore, feature);
                    editableFeature.setDefaultGeometry(geom);
                    editingProviderServices.insertFeatureIntoFeatureStore((Feature)editableFeature, this.featureStore);
                }
                this.featureStore.getFeatureSelection().deselectAll();
            }
            catch (DataException e) {
                throw new FinishServiceException((Throwable)e);
            }
        }
    }

    public Geometry finish() throws FinishServiceException {
        return null;
    }

    public void start() throws StartServiceException {
        this.values = new HashMap<EditingServiceParameter, Object>();
        this.selectedFeatures = Collections.EMPTY_LIST;
        FeatureSelection selected = null;
        if (this.featureStore != null) {
            try {
                selected = (FeatureSelection)this.featureStore.getFeatureSelection().clone();
            }
            catch (DataException e) {
                throw new StartServiceException((Throwable)e);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            if (selected != null && selected.getSelectedCount() > 0L) {
                this.values.put(this.selectionParameter, selected);
                this.selectedFeatures = this.getSelectedFeaturesCopy(selected);
            }
        }
    }

    public String getName() {
        return "modify-symmetry";
    }
}

