/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.scripting.ScriptingExternalFile;
import org.gvsig.scripting.ScriptingFolder;
import org.gvsig.scripting.ScriptingManager;
import org.gvsig.scripting.ScriptingUnit;
import org.gvsig.scripting.impl.AbstractUnit;
import org.gvsig.scripting.impl.FileUtils;
import org.gvsig.scripting.impl.Unit;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.util.FileTools;
import org.gvsig.tools.visitor.Visitor;
import org.ini4j.Ini;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultScriptingFolder
extends AbstractUnit
implements ScriptingFolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultScriptingFolder.class);
    protected File folder;
    private File configFile;
    private File linkTarget;
    private Ini config;
    private String[] iconNames = null;

    protected DefaultScriptingFolder(ScriptingManager manager) {
        super(null, "Folder", manager, null);
    }

    public DefaultScriptingFolder(ScriptingFolder parent, ScriptingManager manager, File folder) {
        super(parent, "Folder", manager, null);
        this.folder = new File(FilenameUtils.normalizeNoEndSeparator((String)folder.getAbsolutePath(), (boolean)true));
        if (this.folder.isFile() && !FilenameUtils.isExtension((String)this.folder.getName(), (String)"inf")) {
            throw new IllegalArgumentException("folder argument can be a folder.");
        }
        this.load(parent, folder.getName());
    }

    @Override
    public void create(ScriptingFolder folder, String id) {
        File f = new File(folder.getFile(), id);
        this.load(folder, id);
        if (!this.isLink()) {
            f.mkdir();
        }
    }

    @Override
    public void create(ScriptingFolder folder, String id, String language) {
        this.create(folder, id);
    }

    @Override
    public File getFile() {
        if (this.linkTarget == null) {
            return this.folder;
        }
        return this.linkTarget;
    }

    public List<File> getFiles() {
        ArrayList<File> l = new ArrayList<File>();
        l.add(this.folder);
        if (this.configFile != null) {
            l.add(this.configFile);
        }
        return l;
    }

    @Override
    public ScriptingFolder getParent() {
        ScriptingFolder theParent = super.getParent();
        if (theParent != null) {
            return theParent;
        }
        File f = this.folder;
        if (this.isLink()) {
            f = this.configFile.getParentFile();
        }
        if (FileUtils.isSameFile(this.manager.getRootUserFolder(), f)) {
            return null;
        }
        if (FileUtils.isRootFile(f)) {
            return null;
        }
        return this.manager.getFolder(f.getParentFile());
    }

    private String getTypenameFromInf(File file) {
        if (file == null) {
            LOGGER.warn("Can't load 'inf' file, file is null.");
            return null;
        }
        try {
            Ini inf = new Ini(file);
            String theTypename = inf.get((Object)"Unit", (Object)"type");
            if (theTypename == null) {
                return "Script";
            }
            return theTypename;
        }
        catch (Exception e) {
            LOGGER.warn("Can't load 'inf' file '" + file.getAbsolutePath() + "'.", (Throwable)e);
            return null;
        }
    }

    public Unit getUnit(String path) {
        path = FilenameUtils.normalizeNoEndSeparator((String)path, (boolean)true);
        if (StringUtils.isBlank((CharSequence)(path = StringUtils.removeStart((String)path, (String)"/")))) {
            return null;
        }
        int n = path.indexOf(47);
        if (n < 0) {
            List<ScriptingUnit> units = this.getUnits();
            for (ScriptingUnit unit1 : units) {
                if (!unit1.getId().equalsIgnoreCase(path)) continue;
                return (Unit)unit1;
            }
            return null;
        }
        String folderName = path.substring(0, n);
        List<ScriptingFolder> folders = this.getUnitFolders();
        for (ScriptingFolder theFolder : folders) {
            if (!theFolder.getId().equalsIgnoreCase(folderName)) continue;
            return (Unit)theFolder.getUnit(path.substring(n + 1));
        }
        return null;
    }

    public Unit getUnit(File afile) {
        Unit unit = null;
        File file = afile.isAbsolute() ? afile.getAbsoluteFile() : new File(this.getFile(), afile.getPath());
        String TheId = FilenameUtils.getBaseName((String)afile.getAbsolutePath());
        if (StringUtils.isBlank((CharSequence)TheId)) {
            TheId = afile.getName();
        }
        DefaultScriptingFolder theParent = FilenameUtils.equalsNormalizedOnSystem((String)this.getFile().getAbsolutePath(), (String)file.getParentFile().getAbsolutePath()) ? this : new DefaultScriptingFolder(null, this.manager, file.getParentFile());
        if (file.isDirectory()) {
            unit = (Unit)this.manager.createUnit("Folder", theParent, file.getName());
        } else if (file.isFile()) {
            if (!file.getName().endsWith(".inf")) {
                file = new File(file.getParentFile(), TheId + ".inf");
            }
            if (!file.exists()) {
                LOGGER.warn("Can't get Unit, file '" + file.getAbsolutePath() + "' not exists.");
                return null;
            }
            unit = (Unit)this.manager.createUnit(this.getTypenameFromInf(file), theParent, TheId);
        }
        return unit;
    }

    private boolean containsAny(Set<File> files, Collection<File> other) {
        for (File file : other) {
            if (!files.contains(file)) continue;
            return true;
        }
        return false;
    }

    public List<ScriptingUnit> getUnits() {
        ArrayList<ScriptingUnit> ol = new ArrayList<ScriptingUnit>();
        File[] files = this.getFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                File f = new File(arg0, arg1);
                if (!f.canRead() || f.isHidden()) {
                    return false;
                }
                if (f.isDirectory()) {
                    return true;
                }
                if ("#folder.inf".equals(f.getName())) {
                    return false;
                }
                String ext = FilenameUtils.getExtension((String)f.getName());
                return "inf".equalsIgnoreCase(ext);
            }
        });
        HashSet<File> filesAdded = new HashSet<File>();
        if (files != null) {
            for (File f : files) {
                try {
                    Unit unit = this.getUnit(f);
                    if (this.containsAny(filesAdded, unit.getFiles())) continue;
                    filesAdded.addAll(unit.getFiles());
                    ol.add(unit);
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't create unit from file '" + f.getAbsolutePath() + "'.", (Throwable)ex);
                }
            }
        }
        if ((files = this.getFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                File f = new File(arg0, arg1);
                if (!f.canRead() || f.isHidden()) {
                    return false;
                }
                if (f.isDirectory()) {
                    return false;
                }
                return !"#folder.inf".equals(f.getName());
            }
        })) != null) {
            for (File f : files) {
                try {
                    String extension = FilenameUtils.getExtension((String)f.getName());
                    if ("inf".equalsIgnoreCase(extension) || "class".equalsIgnoreCase(extension) || filesAdded.contains(f)) continue;
                    ScriptingExternalFile unit = this.manager.createExternalFile(this, f.getName());
                    filesAdded.addAll(unit.getFiles());
                    ol.add((ScriptingUnit)unit);
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't create unit from file '" + f.getAbsolutePath() + "'.", (Throwable)ex);
                }
            }
        }
        Collections.sort(ol, new Comparator<ScriptingUnit>(){

            @Override
            public int compare(ScriptingUnit o1, ScriptingUnit o2) {
                if (o1 instanceof ScriptingFolder) {
                    if (!(o2 instanceof ScriptingFolder)) {
                        return -1;
                    }
                } else if (o2 instanceof ScriptingFolder) {
                    return 1;
                }
                return o1.getId().compareToIgnoreCase(o2.getId());
            }
        });
        return ol;
    }

    public List<ScriptingFolder> getUnitFolders() {
        ArrayList<ScriptingFolder> ol = new ArrayList<ScriptingFolder>();
        File[] files = this.getFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                File f = new File(arg0, arg1);
                if (!f.canRead() || f.isHidden()) {
                    return false;
                }
                if (f.isDirectory()) {
                    return true;
                }
                String ext = FilenameUtils.getExtension((String)f.getName());
                return "inf".equalsIgnoreCase(ext);
            }
        });
        if (files != null) {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    if (f1.isDirectory() && !f2.isDirectory()) {
                        return -1;
                    }
                    if (!f1.isDirectory() && f2.isDirectory()) {
                        return 1;
                    }
                    return f1.getName().toLowerCase().compareTo(f2.getName().toLowerCase());
                }
            });
            for (File f : files) {
                try {
                    Unit unit = this.getUnit(f);
                    if (!(unit instanceof ScriptingFolder)) continue;
                    ol.add((ScriptingFolder)unit);
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't create unit from file '" + f.getAbsolutePath() + "'.");
                }
            }
        }
        return ol;
    }

    public void add(ScriptingUnit unit) {
        unit.move((ScriptingFolder)this);
    }

    public void remove(ScriptingUnit unit) {
        unit.remove();
    }

    @Override
    public File getFileResource(String extension) {
        if (this.isLink()) {
            return new File(this.configFile.getParentFile(), FilenameUtils.getBaseName((String)this.configFile.getName()) + extension).getAbsoluteFile();
        }
        return new File(this.getFile().getParentFile(), this.getFile().getName() + extension).getAbsoluteFile();
    }

    public File getConfigFile() {
        if (this.configFile == null) {
            this.configFile = this.getFileResource(".inf");
            if (!this.configFile.isFile()) {
                this.configFile = new File(this.folder, "#folder.inf");
            }
        }
        return this.configFile;
    }

    public Ini getConfig() {
        File f = this.getConfigFile();
        return this.getConfig(f);
    }

    public Ini getConfig(File f) {
        if (this.config == null) {
            Ini theConfig = new Ini();
            theConfig.setFile(f);
            if (f.exists()) {
                try {
                    theConfig.load();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            this.config = theConfig;
        }
        return this.config;
    }

    public String getProperty(String group, String name) {
        Ini theConfig = this.getConfig();
        String value = theConfig.get((Object)group, (Object)name);
        return value;
    }

    public void setProperty(String group, String name, String value) {
        Ini theConfig = this.getConfig();
        theConfig.put(group, name, (Object)value);
    }

    public void save() {
        File theConfigFile = this.getConfigFile();
        try {
            Ini theConfig = this.getConfig(theConfigFile);
            if (this.linkTarget != null) {
                theConfig.put("Folder", "path", (Object)FileTools.relativizeFile((File)this.configFile.getParentFile(), (File)this.linkTarget));
            }
            if (this.iconNames != null) {
                theConfig.put("Folder", "iconName", (Object)this.iconNames[0]);
                theConfig.put("Folder", "iconNameOpen", (Object)this.iconNames[1]);
            }
            this.save(theConfig);
        }
        catch (Throwable e) {
            String msg = "Can't save 'inf' file '" + theConfigFile.getAbsolutePath() + "'.";
            LOGGER.warn(msg, e);
            throw new RuntimeException(msg, e);
        }
    }

    @Override
    public void load(ScriptingFolder parent, String id) {
        this.configFile = null;
        this.config = null;
        this.linkTarget = null;
        this.iconNames = new String[]{"scripting-icon-folder", "scripting-icon-folder-open"};
        this.setId(id);
        this.setParent(parent);
        File theConfigFile = this.getConfigFile();
        try {
            String targetPath;
            Ini theConfig = this.getConfig(theConfigFile);
            this.loadInf(theConfig);
            String iconName = this.getInfString(theConfig, "Folder", "iconName", null);
            String iconNameOpen = this.getInfString(theConfig, "Folder", "iconNameOpen", null);
            if (iconName != null) {
                this.iconNames = new String[]{iconName, iconNameOpen == null ? iconName : iconNameOpen};
            }
            if (!StringUtils.isEmpty((CharSequence)(targetPath = this.getInfString(theConfig, "Folder", "path", null)))) {
                File target = new File(targetPath);
                this.linkTarget = target.isAbsolute() ? target : new File(FilenameUtils.concat((String)theConfigFile.getParent(), (String)targetPath));
                this.manager.addLink(this.configFile, this.linkTarget);
            }
            this.configFile = FileUtils.getAbsoluteFile(theConfigFile);
        }
        catch (Exception e) {
            LOGGER.warn("Can't load 'inf' file '" + theConfigFile.getAbsolutePath() + "'.", (Throwable)e);
        }
    }

    public String[] getIconNames() {
        return this.iconNames;
    }

    public void setIconNames(String iconName, String iconNameOpen) {
        this.iconNames = new String[]{iconName, StringUtils.isEmpty((CharSequence)iconNameOpen) ? iconName : iconNameOpen};
    }

    public boolean remove() {
        File f = this.getFile();
        try {
            File infofile = this.getFileResource(".inf");
            if (infofile.exists()) {
                FileUtils.forceDelete(infofile);
            }
            if (!this.isLink() && f != null) {
                FileUtils.forceDelete(this.getFile());
            }
            return true;
        }
        catch (Throwable e) {
            LOGGER.warn("Can't remove folder '" + (f == null ? "unknown" : f.getAbsolutePath()) + "'.", e);
            return false;
        }
    }

    public boolean move(ScriptingFolder target) {
        if (!this.manager.validateUnitId(target, this.getId())) {
            LOGGER.info("Can't move folder '" + this.getId() + "' to '" + target.getFile().getAbsolutePath() + "', is not valid.");
            return false;
        }
        try {
            File infofile = this.getFileResource(".inf");
            if (infofile.exists()) {
                FileUtils.moveFileToDirectory(infofile, target.getFile(), true);
            }
            if (!this.isLink()) {
                FileUtils.moveDirectoryToDirectory(this.getFile(), target.getFile(), true);
            }
            this.parent = target;
            this.load(target, this.id);
        }
        catch (IOException ex) {
            LOGGER.info("Can't move folder '" + this.getId() + "' to '" + target.getFile().getAbsolutePath() + "', " + ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }

    public boolean rename(String newId) {
        if (!this.manager.validateUnitId(this.getParent(), newId)) {
            LOGGER.info("Can't rename folder '" + this.getId() + "', target id '" + newId + "' is not valid.");
            return false;
        }
        try {
            File target = this.getParent().getFile();
            File infofile = this.getFileResource(".inf");
            if (this.isLink()) {
                FileUtils.moveFile(infofile, new File(target, newId));
            } else {
                FileUtils.moveDirectory(this.getFile(), new File(target, newId));
                if (infofile.exists()) {
                    FileUtils.moveFile(infofile, new File(target, newId));
                }
            }
            this.setId(newId);
            this.load(this.getParent(), this.id);
        }
        catch (IOException ex) {
            LOGGER.info("Can't rename folder '" + this.getId() + "' to '" + newId + "', " + ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }

    public void accept(Visitor visitor) throws BaseException {
        List<ScriptingUnit> units = this.getUnits();
        for (ScriptingUnit unit : units) {
            if (unit instanceof ScriptingFolder) {
                ScriptingFolder theFolder = (ScriptingFolder)unit;
                theFolder.accept(visitor);
                continue;
            }
            visitor.visit((Object)unit);
        }
    }

    public boolean isLink() {
        return this.linkTarget != null;
    }

    public void accept(Visitor visitor, Predicate<ScriptingUnit> includeFilter) throws BaseException {
        List<ScriptingUnit> units = this.getUnits();
        for (ScriptingUnit unit : units) {
            if (!includeFilter.test(unit)) continue;
            if (unit instanceof ScriptingFolder) {
                ScriptingFolder theFolder = (ScriptingFolder)unit;
                theFolder.accept(visitor);
                continue;
            }
            visitor.visit((Object)unit);
        }
    }

    public String getRawInf() {
        try {
            String rawInf = org.apache.commons.io.FileUtils.readFileToString((File)this.getConfigFile());
            return rawInf;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setRawInf(String rawInf) {
        if (this.configFile == null) {
            this.configFile = new File(this.folder, "#folder.inf");
        }
        try {
            org.apache.commons.io.FileUtils.write((File)this.getConfigFile(), (CharSequence)rawInf);
            this.reload();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void setId(String id) {
        this.firePropertyChangeListener("id", id, this.id);
        this.id = id;
    }
}

