/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class EncodingUtils {
    private static final Pattern RE_ENCODING = Pattern.compile(".*encoding[:]\\s*\"?([a-zA-Z_][a-zA-Z0-9_-]*)\"?.*");

    public static String getEncoding(File f) {
        String line = EncodingUtils.getFirstLine(f);
        String encoding = EncodingUtils.getEncoding(line);
        return encoding;
    }

    public static String getEncoding(InputStream is) {
        String line = EncodingUtils.getFirstLine(is);
        String encoding = EncodingUtils.getEncoding(line);
        return encoding;
    }

    public static String getEncoding(String line) {
        String s;
        if (StringUtils.isBlank((CharSequence)line)) {
            return null;
        }
        String encoding = null;
        Matcher m = RE_ENCODING.matcher(line);
        if (m != null && m.matches() && m.groupCount() == 1 && !StringUtils.isBlank((CharSequence)(s = m.group(1)))) {
            encoding = s;
        }
        return encoding;
    }

    public static String getFirstLine(File f) {
        String line;
        try (FileInputStream is = new FileInputStream(f);){
            line = EncodingUtils.getFirstLine(is);
        }
        catch (Exception ex) {
            return null;
        }
        return line;
    }

    public static String getFirstLine(InputStream is) {
        String line;
        try (InputStreamReader isr = new InputStreamReader(is);
             BufferedReader br = new BufferedReader(isr);){
            line = br.readLine();
            while (line != null) {
                if (!StringUtils.isBlank((CharSequence)line)) {
                    break;
                }
                line = br.readLine();
            }
        }
        catch (IOException ex) {
            return null;
        }
        return line;
    }
}

