/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.gui.layerproperties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.Collection;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.gvsig.app.gui.labeling.LabelClassEditor;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelClass;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelClassFactory;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelingMethod;
import org.gvsig.gui.beans.swing.celleditors.BooleanTableCellEditor;
import org.gvsig.gui.beans.swing.cellrenderers.BooleanTableCellRenderer;
import org.gvsig.i18n.Messages;
import org.gvsig.labeling.gui.layerproperties.AbstractLabelingMethodPanel;
import org.gvsig.labeling.gui.layerproperties.LabelClassPreview;
import org.gvsig.labeling.label.FeatureDependentLabeled;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.SymbologyManager;
import org.gvsig.symbology.swing.SymbologySwingLocator;
import org.gvsig.symbology.swing.SymbologySwingManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureDependent
extends AbstractLabelingMethodPanel
implements ActionListener {
    private static final Logger logger = LoggerFactory.getLogger(FeatureDependent.class);
    private static final long serialVersionUID = 5493451803343695650L;
    private static int NAME_FIELD_INDEX = 0;
    private static int PREVIEW_FIELD_INDEX = 1;
    private static int FILTER_FIELD_INDEX = 2;
    private static int LABEL_EXPRESSION_FIELD_INDEX = 3;
    private static int VISIBLE_FIELD_INDEX = 4;
    JTable tblClasses = null;
    private JButton btnMoveUpClass;
    private JButton btnAddClass;
    private JCheckBox chkLabel;
    private JCheckBox chkDefinePriorities;
    private JScrollPane scrlPan;
    private boolean openEditor = false;
    private JButton btnMoveDownClass;
    private JButton btnDelClass;
    private JPanel panel;
    private JPanel buttonPanel;
    private JComboBox comboLabelClassFactoryToUse;

    @Override
    public String getName() {
        return Messages.getText((String)"define_classes_of_features_and_label_each_differently") + ".";
    }

    @Override
    public Class<? extends ILabelingMethod> getLabelingMethodClass() {
        return FeatureDependentLabeled.class;
    }

    private JCheckBox getChkDefinePriorities() {
        if (this.chkDefinePriorities == null) {
            this.chkDefinePriorities = new JCheckBox(Messages.getText((String)"label_priority"));
            this.chkDefinePriorities.addActionListener(this);
            this.chkDefinePriorities.setName("CHK_DEFINE_PRIORITIES");
        }
        return this.chkDefinePriorities;
    }

    private JButton getBtnDelClass() {
        if (this.btnDelClass == null) {
            this.btnDelClass = new JButton(Messages.getText((String)"delete"));
            this.btnDelClass.setName("BTNDELCLASS");
            this.btnDelClass.addActionListener(this);
        }
        return this.btnDelClass;
    }

    private JButton getBtnAddClass() {
        if (this.btnAddClass == null) {
            this.btnAddClass = new JButton(Messages.getText((String)"add"));
            this.btnAddClass.setName("BTNADDCLASS");
            this.btnAddClass.addActionListener(this);
        }
        return this.btnAddClass;
    }

    private JButton getBtnMoveUpClass() {
        if (this.btnMoveUpClass == null) {
            this.btnMoveUpClass = new JButton(Messages.getText((String)"move_up"));
            this.btnMoveUpClass.setName("BTNMOVEUPCLASS");
            this.btnMoveUpClass.addActionListener(this);
        }
        return this.btnMoveUpClass;
    }

    private JButton getBtnMoveDownClass() {
        if (this.btnMoveDownClass == null) {
            this.btnMoveDownClass = new JButton(Messages.getText((String)"move_down"));
            this.btnMoveDownClass.setName("BTNMOVEDOWNCLASS");
            this.btnMoveDownClass.addActionListener(this);
        }
        return this.btnMoveDownClass;
    }

    private JScrollPane getCenterScrl() {
        this.scrlPan = new JScrollPane(this.getTblClasses());
        this.scrlPan.setPreferredSize(new Dimension(180, 300));
        return this.scrlPan;
    }

    private JTable getTblClasses() {
        this.tblClasses = new JTable(new LabelClassTableModel());
        this.tblClasses.setRowHeight(50);
        this.tblClasses.setSelectionMode(0);
        this.tblClasses.addMouseListener(new MouseAdapter(){
            int prevRow = -1;

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!FeatureDependent.this.tblClasses.isEnabled()) {
                    return;
                }
                int col = FeatureDependent.this.tblClasses.getColumnModel().getColumnIndexAtX(e.getX());
                int row = (int)(((double)e.getY() - FeatureDependent.this.tblClasses.getLocation().getY()) / (double)FeatureDependent.this.tblClasses.getRowHeight());
                if (row <= FeatureDependent.this.tblClasses.getRowCount() - 1 && col <= FeatureDependent.this.tblClasses.getColumnCount() - 1) {
                    FeatureDependent.this.openEditor = row == this.prevRow && e.getButton() == 1 && e.getClickCount() == 2;
                    this.prevRow = row;
                    if (FeatureDependent.this.openEditor) {
                        FeatureDependent.this.tblClasses.editCellAt(row, col);
                    }
                }
            }
        });
        this.tblClasses.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (!FeatureDependent.this.tblClasses.isEnabled()) {
                    return;
                }
                if (e.getColumn() == VISIBLE_FIELD_INDEX) {
                    ILabelClass oldLc = (ILabelClass)FeatureDependent.this.tblClasses.getValueAt(e.getFirstRow(), PREVIEW_FIELD_INDEX);
                    oldLc.setVisible(Boolean.valueOf(FeatureDependent.this.tblClasses.getValueAt(e.getFirstRow(), VISIBLE_FIELD_INDEX).toString()).booleanValue());
                }
            }
        });
        TableColumnModel cm = this.tblClasses.getColumnModel();
        this.tblClasses.getColumnModel().getColumn(PREVIEW_FIELD_INDEX).setCellRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                LabelClassPreview lcPr = new LabelClassPreview();
                lcPr.setLabelClass((ILabelClass)value);
                return lcPr;
            }
        });
        this.tblClasses.getColumnModel().getColumn(VISIBLE_FIELD_INDEX).setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer(false));
        this.tblClasses.getColumnModel().getColumn(LABEL_EXPRESSION_FIELD_INDEX).setCellRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                String expr = null;
                if (value != null) {
                    expr = (String)value;
                }
                if (expr == null) {
                    expr = "";
                }
                return new JLabel("<html><p>" + expr + "</p></html>", 0);
            }
        });
        for (int i = 0; i < this.tblClasses.getColumnModel().getColumnCount(); ++i) {
            if (i != VISIBLE_FIELD_INDEX) {
                this.tblClasses.getColumnModel().getColumn(i).setCellEditor(new LabelClassCellEditor(this.layer.getFeatureStore()));
                continue;
            }
            this.tblClasses.getColumnModel().getColumn(VISIBLE_FIELD_INDEX).setCellEditor((TableCellEditor)new BooleanTableCellEditor(this.tblClasses));
        }
        ((DefaultTableModel)this.tblClasses.getModel()).fireTableDataChanged();
        this.repaint();
        return this.tblClasses;
    }

    private boolean checSameLablClassName(LabelClassTableModel mod, String name) {
        for (int i = 0; i < mod.getRowCount(); ++i) {
            if (!name.equals(mod.getLabelAtRow(i).getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void initializePanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPanel(), "Center");
    }

    private JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel(new BorderLayout());
            GridLayout gl = new GridLayout(4, 1);
            this.buttonPanel = new JPanel(gl);
            this.buttonPanel.add(this.getBtnAddClass());
            this.buttonPanel.add(this.getBtnDelClass());
            this.buttonPanel.add(this.getBtnMoveUpClass());
            this.buttonPanel.add(this.getBtnMoveDownClass());
            JPanel auxp = new JPanel();
            auxp.add(this.buttonPanel);
            this.panel.add((Component)auxp, "East");
            this.panel.add((Component)this.getChkDefinePriorities(), "North");
            JPanel centro = new JPanel(new BorderLayout());
            centro.add((Component)this.getLabelClassSelector(), "North");
            centro.add((Component)this.getCenterScrl(), "Center");
            this.panel.add((Component)centro, "Center");
        }
        return this.panel;
    }

    private JPanel getLabelClassSelector() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        SymbologyManager symbologyMamanger = SymbologyLocator.getSymbologyManager();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel(i18nManager.getTranslation("_Label_type_to_use_XcolonX")), "West");
        DefaultComboBoxModel<ILabelClassFactory> model = new DefaultComboBoxModel<ILabelClassFactory>();
        Collection factories = symbologyMamanger.getLabelClassFactories();
        for (ILabelClassFactory factory : factories) {
            model.addElement(factory);
        }
        this.comboLabelClassFactoryToUse = new JComboBox(model);
        panel.add((Component)this.comboLabelClassFactoryToUse, "Center");
        if (model.getSize() > 0) {
            this.comboLabelClassFactoryToUse.setSelectedIndex(0);
        }
        return panel;
    }

    @Override
    public void fillPanel(FeatureType fty) throws ReadException {
        this.chkDefinePriorities.setSelected(this.method.definesPriorities());
        this.repaint();
    }

    private void swapClass(int classIndex, int targetPos, int numOfElements) {
        ILabelClass[] classes = ((LabelClassTableModel)this.tblClasses.getModel()).toLabelClassArray();
        ILabelClass aux = classes[targetPos];
        classes[targetPos] = classes[classIndex];
        classes[classIndex] = aux;
        ((LabelClassTableModel)this.tblClasses.getModel()).setClassArray(classes);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int[] indices;
        int[] sRows;
        if (this.method == null) {
            return;
        }
        JComponent c = (JComponent)e.getSource();
        LabelClassTableModel mod = (LabelClassTableModel)this.tblClasses.getModel();
        if (c.equals(this.btnAddClass)) {
            ILabelClassFactory factory = (ILabelClassFactory)this.comboLabelClassFactoryToUse.getSelectedItem();
            if (factory == null) {
                logger.warn("Can't acces to the defaut selected labelclassfactory.");
                return;
            }
            ILabelClass newClass = factory.create();
            String name = Messages.getText((String)"labeling") + String.valueOf(1);
            int count = 0;
            while (this.checSameLablClassName(mod, name)) {
                name = Messages.getText((String)"labeling") + String.valueOf(++count);
            }
            newClass.setName(name);
            mod.addRow(new Object[]{newClass.getName(), newClass, newClass.getSQLQuery(), newClass.getStringLabelExpression(), newClass.isVisible()});
        } else if (c.equals(this.btnDelClass)) {
            if (mod.getRowCount() >= 1) {
                sRows = this.tblClasses.getSelectedRows();
                for (int i = sRows.length - 1; i >= 0; --i) {
                    mod.removeRow(sRows[i]);
                }
            }
        } else if (c.equals(this.chkDefinePriorities)) {
            this.method.setDefinesPriorities(this.chkDefinePriorities.isSelected());
        } else if (c.equals(this.chkLabel)) {
            sRows = this.tblClasses.getSelectedRows();
            for (int i = sRows.length - 1; i >= 0; --i) {
                ILabelClass lc = mod.getLabelAtRow(i);
                lc.setVisible(this.chkLabel.isSelected());
            }
        } else if (c.equals(this.btnMoveUpClass)) {
            indices = this.tblClasses.getSelectedRows();
            if (indices.length > 0) {
                int classIndex = indices[0];
                int targetPos = Math.max(0, classIndex - 1);
                this.swapClass(classIndex, targetPos, indices.length);
            }
        } else if (c.equals(this.btnMoveDownClass)) {
            indices = this.tblClasses.getSelectedRows();
            if (indices.length > 0) {
                int classIndex = indices[indices.length - 1];
                int targetPos = Math.min(this.tblClasses.getRowCount() - 1, classIndex + 1);
                this.swapClass(classIndex, targetPos, indices.length);
            }
        } else if (c.equals(this.btnDelClass) && (indices = this.tblClasses.getSelectedRows()).length > 0) {
            int classIndex = indices[0];
            int targetPos = Math.min(this.tblClasses.getRowCount(), classIndex);
            this.swapClass(classIndex, targetPos, indices.length);
        }
        mod.fireTableDataChanged();
        this.method.clearAllClasses();
        ILabelClass[] classes = ((LabelClassTableModel)this.tblClasses.getModel()).toLabelClassArray();
        for (int i = 0; i < classes.length; ++i) {
            this.method.addLabelClass(classes[i]);
        }
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getBtnAddClass().setEnabled(enabled);
        this.getBtnDelClass().setEnabled(enabled);
        this.getBtnMoveDownClass().setEnabled(enabled);
        this.getBtnMoveUpClass().setEnabled(enabled);
        this.getChkDefinePriorities().setEnabled(enabled);
        this.scrlPan.setEnabled(enabled);
        this.tblClasses.setEnabled(enabled);
    }

    private class LabelClassTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = -9152998982339430209L;
        Object[][] values;
        private String[] classesTableFieldNames = new String[]{Messages.getText((String)"name"), Messages.getText((String)"preview"), Messages.getText((String)"filter"), Messages.getText((String)"label_expression"), Messages.getText((String)"visible")};

        public LabelClassTableModel() {
            ILabelClass[] labelClasses = FeatureDependent.this.method.getLabelClasses();
            this.values = new Object[labelClasses.length][this.classesTableFieldNames.length];
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i][PREVIEW_FIELD_INDEX] = labelClasses[i];
                this.values[i][NAME_FIELD_INDEX] = labelClasses[i].getName();
                this.values[i][FILTER_FIELD_INDEX] = labelClasses[i].getSQLQuery();
                this.values[i][LABEL_EXPRESSION_FIELD_INDEX] = labelClasses[i].getStringLabelExpression();
                this.values[i][VISIBLE_FIELD_INDEX] = labelClasses[i].isVisible();
            }
            this.setDataVector(this.values, this.classesTableFieldNames);
        }

        @Override
        public String getColumnName(int col) {
            return this.classesTableFieldNames[col];
        }

        @Override
        public int getColumnCount() {
            return this.classesTableFieldNames.length;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }

        public ILabelClass getLabelAtRow(int row) {
            return (ILabelClass)this.getValueAt(row, PREVIEW_FIELD_INDEX);
        }

        public ILabelClass[] toLabelClassArray() {
            ILabelClass[] classes = new ILabelClass[this.getRowCount()];
            for (int i = 0; i < classes.length; ++i) {
                classes[i] = this.getLabelAtRow(i);
                if (!FeatureDependent.this.getChkDefinePriorities().isSelected()) continue;
                classes[i].setPriority(i);
            }
            return classes;
        }

        public void setClassArray(ILabelClass[] classes) {
            for (int i = 0; i < classes.length; ++i) {
                this.setValueAt(classes[i], i, PREVIEW_FIELD_INDEX);
                this.setValueAt(classes[i].getName(), i, NAME_FIELD_INDEX);
                this.setValueAt(classes[i].getSQLQuery(), i, FILTER_FIELD_INDEX);
                this.setValueAt(classes[i].getStringLabelExpression(), i, LABEL_EXPRESSION_FIELD_INDEX);
                this.setValueAt(classes[i].isVisible(), i, VISIBLE_FIELD_INDEX);
            }
        }
    }

    private class LabelClassCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 6399823783851437400L;
        private FeatureStore fsto = null;

        public LabelClassCellEditor(FeatureStore store) {
            this.fsto = store;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (FeatureDependent.this.openEditor) {
                SymbologySwingManager manager = SymbologySwingLocator.getSwingManager();
                ILabelClass oldLc = (ILabelClass)FeatureDependent.this.tblClasses.getValueAt(row, PREVIEW_FIELD_INDEX);
                oldLc.setVisible(Boolean.valueOf(FeatureDependent.this.tblClasses.getValueAt(row, VISIBLE_FIELD_INDEX).toString()).booleanValue());
                LabelClassEditor lcProp = manager.createLabelClassEditor(oldLc, this.fsto);
                oldLc.setTexts(new String[]{oldLc.getName()});
                lcProp.showDialog();
                if (!lcProp.isAccepted()) {
                    return null;
                }
                ILabelClass newLc = lcProp.getLabelClass();
                LabelClassTableModel m = (LabelClassTableModel)FeatureDependent.this.tblClasses.getModel();
                Boolean changeDone = false;
                if (!oldLc.getName().equals(newLc.getName())) {
                    if (!FeatureDependent.this.checSameLablClassName(m, newLc.getName())) {
                        m.setValueAt(newLc.getStringLabelExpression(), row, LABEL_EXPRESSION_FIELD_INDEX);
                        m.setValueAt(newLc.getName(), row, NAME_FIELD_INDEX);
                        m.setValueAt(newLc, row, PREVIEW_FIELD_INDEX);
                        m.setValueAt(newLc.getSQLQuery(), row, FILTER_FIELD_INDEX);
                        m.setValueAt(newLc.isVisible(), row, VISIBLE_FIELD_INDEX);
                        this.fireEditingStopped();
                        changeDone = true;
                    } else {
                        JOptionPane.showMessageDialog(FeatureDependent.this.tblClasses, Messages.getText((String)"cannot_exist_two_label_classes_with_the_same_name") + "\n", Messages.getText((String)"error"), 0);
                        changeDone = true;
                    }
                }
                if (!changeDone.booleanValue()) {
                    m.setValueAt(newLc.getStringLabelExpression(), row, LABEL_EXPRESSION_FIELD_INDEX);
                    m.setValueAt(newLc.getName(), row, NAME_FIELD_INDEX);
                    m.setValueAt(newLc, row, PREVIEW_FIELD_INDEX);
                    m.setValueAt(newLc.getSQLQuery(), row, FILTER_FIELD_INDEX);
                    m.setValueAt(newLc.isVisible(), row, VISIBLE_FIELD_INDEX);
                    this.fireEditingStopped();
                    changeDone = true;
                }
            }
            FeatureDependent.this.method.clearAllClasses();
            ILabelClass[] classes = ((LabelClassTableModel)FeatureDependent.this.tblClasses.getModel()).toLabelClassArray();
            for (int i = 0; i < classes.length; ++i) {
                FeatureDependent.this.method.addLabelClass(classes[i]);
            }
            FeatureDependent.this.openEditor = false;
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }
    }
}

