/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.gui.layerproperties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.gui.labeling.LabelClassEditor;
import org.gvsig.app.gui.styling.SelectorFilter;
import org.gvsig.app.gui.styling.SingleStyleSelectorFilter;
import org.gvsig.app.gui.styling.StylePreviewer;
import org.gvsig.app.gui.styling.StyleSelector;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelClass;
import org.gvsig.fmap.mapcontext.rendering.symbols.ITextSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.styles.ILabelStyle;
import org.gvsig.fmap.mapcontext.rendering.symbols.styles.IStyle;
import org.gvsig.gui.beans.AcceptCancelPanel;
import org.gvsig.gui.beans.swing.GridBagLayoutPanel;
import org.gvsig.gui.beans.swing.JBlank;
import org.gvsig.i18n.Messages;
import org.gvsig.labeling.gui.layerproperties.LabelClassPreview;
import org.gvsig.labeling.gui.layerproperties.LabelTextStylePanel;
import org.gvsig.labeling.lang.LabelClassUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.SupportDisposable;
import org.gvsig.tools.dispose.impl.DisposableHelper;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.InitComponentsListener;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelClassProperties
extends JPanel
implements LabelClassEditor,
IWindow,
ActionListener {
    private static final Logger logger = LoggerFactory.getLogger(LabelClassProperties.class);
    private static final String TEST_SQL = "TEST_SQL";
    private static final String DELETE_FIELD = "DELETE_FIELD";
    private static final long serialVersionUID = 6528513396536811057L;
    private static final String ADD_FIELD = "ADD_FIELD";
    private static final String SELECT_STYLE = "SELECT_STYLE";
    private static final String CLEAR_STYLE = "CLEAR_STYLE";
    private static final String VERIFY = "VERIFY";
    private JTextField txtName;
    private ILabelClass lc;
    private ILabelClass clonedClass;
    private JTable tblExpressions;
    private JButton btnRemoveField;
    private JButton btnAddField;
    private JButton btnVerify;
    private JComponent styPreviewer;
    private JButton btnSelStyle;
    private JRadioButton rdBtnFilteredFeatures;
    private JRadioButton rdBtnAllFeatures;
    private JTextField txtSQL;
    private JCheckBox chkLabelFeatures;
    private LabelTextStylePanel textStyle;
    private JPanel sqlPnl;
    private LabelClassPreview labelPreview;
    private FeatureStore featureStore = null;
    private JButton btnDontUseStyle;
    private boolean accepted = true;
    private AcceptCancelPanel acceptCancelPanel;
    private JButton btnSQLBuilder;
    private ExpressionPickerController pickerSQL;
    private static final Object[] TABLE_HEADERS = new String[]{Messages.getText((String)"field_number"), Messages.getText((String)"label_expression")};

    public LabelClassProperties(FeatureStore fsto) {
        this.featureStore = fsto;
        ToolsSwingUtils.addInitComponentsListener((JComponent)this, (InitComponentsListener)new InitComponentsListener(){

            public void doDisposeComponents() {
                if (LabelClassProperties.this.tblExpressions != null) {
                    DisposeUtils.disposeQuietly((Object)LabelClassProperties.this.tblExpressions.getDefaultEditor(Object.class));
                }
            }

            public void doInitComponents() {
            }
        });
        this.initialize();
    }

    private void initialize() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.setPreferredSize(new Dimension(850, 580));
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new FlowLayout(0, 5, 5));
        JLabel lbl_name = new JLabel();
        lbl_name.setText(i18nManager.getTranslation("name").concat(":"));
        northPanel.add(lbl_name);
        this.txtName = new JTextField(40);
        northPanel.add(this.txtName);
        this.add((Component)northPanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout());
        this.textStyle = new LabelTextStylePanel();
        this.textStyle.addActionListener(this);
        centerPanel.add((Component)this.textStyle, "North");
        JPanel labelExpressionsPanel = new JPanel(new BorderLayout());
        labelExpressionsPanel.setBorder(new EmptyBorder(5, 7, 5, 5));
        labelExpressionsPanel.add((Component)new JScrollPane(this.getTableFields()), "Center");
        JPanel a = new JPanel(new FlowLayout(0, 7, 0));
        a.add(new JLabel("<html><b>" + Messages.getText((String)"text_fields") + "</b></html>"));
        centerPanel.add((Component)labelExpressionsPanel, "Center");
        GridLayout gbl = new GridLayout(3, 1, 0, 5);
        JPanel auxp = new JPanel(gbl);
        auxp.add(this.getBtnVerify());
        auxp.add(this.getBtnAddField());
        auxp.add(this.getBtnRemoveField());
        auxp.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        JPanel auxpp = new JPanel();
        auxpp.add(auxp);
        centerPanel.add((Component)auxpp, "East");
        GridBagLayoutPanel aux = new GridBagLayoutPanel();
        this.rdBtnAllFeatures = new JRadioButton(Messages.getText((String)"all_features"));
        this.rdBtnFilteredFeatures = new JRadioButton(Messages.getText((String)"filtered_features"));
        ButtonGroup g = new ButtonGroup();
        g.add(this.rdBtnAllFeatures);
        g.add(this.rdBtnFilteredFeatures);
        this.rdBtnAllFeatures.addActionListener(this);
        this.rdBtnFilteredFeatures.addActionListener(this);
        this.chkLabelFeatures = new JCheckBox(Messages.getText((String)"label_features_in_this_class"));
        aux.addComponent((Component)this.chkLabelFeatures);
        aux.addComponent("", (Component)this.rdBtnAllFeatures);
        aux.addComponent("", (Component)this.rdBtnFilteredFeatures);
        this.sqlPnl = new JPanel(new FlowLayout(0));
        this.txtSQL = new JTextField(30);
        this.btnSQLBuilder = new JButton("...");
        this.sqlPnl.add(this.txtSQL);
        this.sqlPnl.add(this.btnSQLBuilder);
        this.pickerSQL = DALSwingLocator.getManager().createExpressionPickerController(this.featureStore, (JTextComponent)this.txtSQL, this.btnSQLBuilder);
        aux.addComponent("", (Component)this.sqlPnl);
        JPanel auxPanel = new JPanel(new BorderLayout());
        JPanel aux2 = new JPanel();
        auxPanel.setBorder(BorderFactory.createTitledBorder(Messages.getText((String)"background_style")));
        aux2.add(this.getStylePreviewer());
        gbl = new GridLayout(2, 1, 0, 5);
        JPanel aux3 = new JPanel(gbl);
        aux3.add(this.getBtnSelectStyle());
        aux3.add(this.getBtnDontUseStyle());
        aux3.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        auxpp = new JPanel();
        auxpp.add(aux3);
        auxPanel.add((Component)aux2, "West");
        auxPanel.add((Component)auxpp, "East");
        JPanel aux4 = new JPanel(new GridLayout(1, 2));
        aux4.add(auxPanel);
        aux2 = new JPanel(new BorderLayout());
        aux2.setBorder(BorderFactory.createTitledBorder(Messages.getText((String)"preview")));
        aux2.add((Component)new JBlank(5, 5), "North");
        this.labelPreview = new LabelClassPreview();
        aux2.add((Component)this.labelPreview, "Center");
        aux2.add((Component)new JBlank(5, 5), "West");
        aux2.add((Component)new JBlank(5, 5), "East");
        aux2.add((Component)new JBlank(5, 5), "South");
        aux4.add(aux2);
        GridBagLayoutPanel aux5 = new GridBagLayoutPanel();
        aux5.addComponent("", (Component)aux);
        aux5.addComponent("", (Component)aux4);
        centerPanel.add((Component)aux5, "South");
        this.add((Component)centerPanel, "Center");
        this.acceptCancelPanel = new AcceptCancelPanel((ActionListener)this, (ActionListener)this);
        this.add((Component)this.acceptCancelPanel, "South");
        this.chkLabelFeatures.addActionListener(this);
        this.txtName.addActionListener(this);
    }

    public void setAcceptCancelVisible(boolean visible) {
        this.acceptCancelPanel.setVisible(visible);
    }

    private JComponent getStylePreviewer() {
        if (this.styPreviewer == null) {
            this.styPreviewer = new StylePreviewer();
            this.styPreviewer.setPreferredSize(new Dimension(90, 90));
            this.styPreviewer.setBorder(BorderFactory.createBevelBorder(1));
            ((StylePreviewer)this.styPreviewer).setShowOutline(true);
        }
        return this.styPreviewer;
    }

    private JButton getBtnSelectStyle() {
        if (this.btnSelStyle == null) {
            this.btnSelStyle = new JButton(Messages.getText((String)"select"));
            this.btnSelStyle.setActionCommand(SELECT_STYLE);
            this.btnSelStyle.addActionListener(this);
        }
        return this.btnSelStyle;
    }

    private JButton getBtnRemoveField() {
        if (this.btnRemoveField == null) {
            this.btnRemoveField = new JButton(Messages.getText((String)"remove"));
            this.btnRemoveField.setActionCommand(DELETE_FIELD);
            this.btnRemoveField.addActionListener(this);
        }
        return this.btnRemoveField;
    }

    private JButton getBtnAddField() {
        if (this.btnAddField == null) {
            this.btnAddField = new JButton(Messages.getText((String)"add"));
            this.btnAddField.setActionCommand(ADD_FIELD);
            this.btnAddField.addActionListener(this);
        }
        return this.btnAddField;
    }

    private JButton getBtnVerify() {
        if (this.btnVerify == null) {
            this.btnVerify = new JButton(Messages.getText((String)"verify"));
            this.btnVerify.setActionCommand(VERIFY);
            this.btnVerify.addActionListener(this);
        }
        return this.btnVerify;
    }

    private JButton getBtnDontUseStyle() {
        if (this.btnDontUseStyle == null) {
            this.btnDontUseStyle = new JButton(Messages.getText((String)"no_style"));
            this.btnDontUseStyle.setActionCommand(CLEAR_STYLE);
            this.btnDontUseStyle.addActionListener(this);
        }
        return this.btnDontUseStyle;
    }

    private JTable getTableFields() {
        if (this.tblExpressions == null) {
            this.tblExpressions = new JTable();
            this.tblExpressions.setAutoResizeMode(0);
        }
        return this.tblExpressions;
    }

    private void setComponentEnabled(Component c, boolean b) {
        if (c instanceof JComponent) {
            JComponent c1 = (JComponent)c;
            for (int i = 0; i < c1.getComponentCount(); ++i) {
                this.setComponentEnabled(c1.getComponent(i), b);
            }
        }
        c.setEnabled(b);
    }

    public void setLabelClass(ILabelClass labelClass) {
        if (labelClass == null) {
            return;
        }
        this.lc = labelClass;
        try {
            this.clonedClass = (ILabelClass)this.lc.clone();
        }
        catch (CloneNotSupportedException ex) {
            this.clonedClass = this.lc;
        }
        this.labelPreview.setLabelClass(this.clonedClass);
        boolean clo_use_sql = LabelClassUtils.isUseSqlQuery(this.clonedClass);
        if (!clo_use_sql) {
            this.rdBtnAllFeatures.setSelected(true);
            this.txtSQL.setText("");
        } else {
            this.rdBtnFilteredFeatures.setSelected(true);
            this.txtSQL.setText(this.clonedClass.getSQLQuery());
        }
        this.chkLabelFeatures.setSelected(this.clonedClass.isVisible());
        this.rdBtnFilteredFeatures.setSelected(clo_use_sql);
        this.rdBtnAllFeatures.setSelected(!clo_use_sql);
        ((StylePreviewer)this.styPreviewer).setStyle((IStyle)this.clonedClass.getLabelStyle());
        this.txtName.setText(this.clonedClass.getName());
        ITextSymbol lcTextSymbol = this.lc.getTextSymbol();
        ITextSymbol clonedSymbol = null;
        try {
            clonedSymbol = (ITextSymbol)lcTextSymbol.clone();
        }
        catch (CloneNotSupportedException e) {
            logger.error("While clonin.", (Throwable)e);
        }
        this.textStyle.setModel(clonedSymbol, this.lc.getUnit(), this.lc.getReferenceSystem());
        this.getTableFields().setRowHeight(22);
        this.getTableFields().setModel(new FieldTableExpressions(this.lc.getLabelExpressions()));
        TableColumnModel colMod = this.getTableFields().getColumnModel();
        colMod.getColumn(0).setPreferredWidth(100);
        colMod.getColumn(0).setWidth(100);
        colMod.getColumn(1).setResizable(true);
        colMod.getColumn(1).setPreferredWidth(513);
        FeatureAttributeDescriptor[] atts = null;
        try {
            atts = this.featureStore.getDefaultFeatureType().getAttributeDescriptors();
        }
        catch (DataException e) {
            logger.error("While getting attributes.", (Throwable)e);
        }
        TableCellEditor previousEditor = this.getTableFields().getDefaultEditor(Object.class);
        DisposeUtils.disposeQuietly((Object)previousEditor);
        this.getTableFields().setDefaultEditor(Object.class, new DefaultEditor(atts));
        this.repaint();
        this.actionPerformed(new ActionEvent(this, 0, null));
    }

    public JComponent asJComponent() {
        return this;
    }

    public void showDialog() {
        ApplicationLocator.getManager().getUIManager().addWindow((IWindow)this);
    }

    public WindowInfo getWindowInfo() {
        WindowInfo wi = new WindowInfo(9);
        wi.setTitle(Messages.getText((String)"label_class_properties"));
        wi.setWidth(this.getPreferredSize().width + 8);
        wi.setHeight(this.getPreferredSize().height);
        return wi;
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }

    private boolean verifyExpressions() {
        String[] expressions = ((FieldTableExpressions)this.getTableFields().getModel()).getExpression();
        if (expressions.length == 1 && expressions[0].equals("")) {
            return true;
        }
        boolean result = true;
        String message = "";
        for (int i = 0; i < expressions.length; ++i) {
            String expresion = expressions[i];
            if (LabelClassUtils.validExpression(expresion, this.featureStore, false)) continue;
            result = false;
            message = message.compareTo("") != 0 ? message + " , " + (i + 1) : " " + Messages.getText((String)"at_fields") + " " + (i + 1);
        }
        message = message + ".";
        if (!result) {
            JOptionPane.showMessageDialog(ApplicationLocator.getManager().getRootComponent(), Messages.getText((String)"malformed_or_empty_expression") + message, Messages.getText((String)"verify"), 0);
        } else {
            JOptionPane.showMessageDialog(ApplicationLocator.getManager().getRootComponent(), Messages.getText((String)"_Expressions_are_correct"), Messages.getText((String)"verify"), 1);
        }
        return result;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public void doCancel() {
        this.accepted = false;
        this.setLabelClass(this.lc);
    }

    public void doAccept() {
        String sqlstr;
        if (this.rdBtnFilteredFeatures.isSelected() && !this.validVisibleSQL(sqlstr = this.txtSQL.getText(), this.featureStore)) {
            JOptionPane.showMessageDialog(ApplicationLocator.getManager().getRootComponent(), Messages.getText((String)"error_validating_filter_query") + ":\n\n'" + sqlstr + "'", Messages.getText((String)"filtered_features"), 0);
            return;
        }
        this.clonedClass.setUnit(this.textStyle.getUnit());
        this.clonedClass.setReferenceSystem(this.textStyle.getReferenceSystem());
        this.clonedClass.setTextSymbol(this.textStyle.getTextSymbol());
        this.lc = this.clonedClass;
        this.accepted = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setComponentEnabled(this.sqlPnl, this.rdBtnFilteredFeatures.isSelected());
        this.applySettings();
        if ("OK".equals(e.getActionCommand())) {
            this.doAccept();
            try {
                ApplicationLocator.getManager().getUIManager().closeWindow((IWindow)this);
            }
            catch (Exception ex) {
                logger.warn("While closing window.", (Throwable)ex);
            }
        } else if ("CANCEL".equals(e.getActionCommand())) {
            this.doCancel();
            try {
                ApplicationLocator.getManager().getUIManager().closeWindow((IWindow)this);
            }
            catch (Exception ex) {
                logger.warn("While closing window.", (Throwable)ex);
            }
        } else if (CLEAR_STYLE.equals(e.getActionCommand())) {
            this.clonedClass.setLabelStyle(null);
            ((StylePreviewer)this.styPreviewer).setStyle(null);
        } else if (TEST_SQL.equals(e.getActionCommand())) {
            logger.info("TEST_SQL = TEST_SQL");
        } else if (DELETE_FIELD.equals(e.getActionCommand())) {
            int[] rowInd = this.getTableFields().getSelectedRows();
            for (int i = rowInd.length - 1; i >= 0; --i) {
                this.delField(rowInd[i]);
            }
            this.clonedClass.setLabelExpressions(((FieldTableExpressions)this.getTableFields().getModel()).getExpression());
            this.setLabelClass(this.clonedClass);
        } else if (VERIFY.equals(e.getActionCommand())) {
            this.verifyExpressions();
        } else if (ADD_FIELD.equals(e.getActionCommand())) {
            this.addField();
        } else if (SELECT_STYLE.equals(e.getActionCommand())) {
            IStyle myStyle = ((StylePreviewer)this.styPreviewer).getStyle();
            FeatureType fty = null;
            try {
                fty = this.featureStore.getDefaultFeatureType();
            }
            catch (DataException e1) {
                logger.error("While getting feat type.", (Throwable)e1);
            }
            int geotype = fty.getDefaultGeometryAttribute().getGeomType().getType();
            SingleStyleSelectorFilter filter = new SingleStyleSelectorFilter(ILabelStyle.class);
            StyleSelector stySel = null;
            try {
                stySel = new StyleSelector(myStyle, geotype, (SelectorFilter)filter);
            }
            catch (IllegalArgumentException iae) {
                JOptionPane.showMessageDialog(this, Messages.getText((String)"_Option_not_available_for_this_geometry_type"), this.getWindowInfo().getTitle(), 2);
                return;
            }
            ApplicationLocator.getManager().getUIManager().addWindow((IWindow)stySel);
            ILabelStyle sty = (ILabelStyle)stySel.getSelectedObject();
            if (sty != null) {
                this.clonedClass.setLabelStyle(sty);
                this.clonedClass.setUnit(stySel.getUnit());
                this.clonedClass.setReferenceSystem(stySel.getReferenceSystem());
                this.setLabelClass(this.clonedClass);
            }
            ((StylePreviewer)this.styPreviewer).setStyle((IStyle)sty);
        } else if (e.getSource().equals(this.rdBtnAllFeatures) || e.getSource().equals(this.rdBtnFilteredFeatures)) {
            this.clonedClass.setUseSqlQuery(this.rdBtnFilteredFeatures.isSelected());
        }
        this.repaint();
    }

    private boolean validVisibleSQL(String sqlstr, FeatureStore fsto) {
        return LabelClassUtils.validExpression(sqlstr, fsto, true);
    }

    private void applySettings() {
        this.clonedClass.setVisible(this.chkLabelFeatures.isSelected());
        this.clonedClass.setName(this.txtName.getText());
        if (this.rdBtnFilteredFeatures.isSelected()) {
            this.clonedClass.setSQLQuery(this.txtSQL.getText());
        } else {
            this.clonedClass.setSQLQuery("");
        }
        JTable tableFields = this.getTableFields();
        TableCellEditor cellEditor = tableFields.getCellEditor();
        if (cellEditor != null) {
            int row = tableFields.getEditingRow();
            int column = tableFields.getEditingColumn();
            cellEditor.stopCellEditing();
            Object value = cellEditor.getCellEditorValue();
            if (value != null) {
                ((FieldTableExpressions)tableFields.getModel()).setValueAt(value, row, column);
            }
        }
        this.clonedClass.setLabelExpressions(((FieldTableExpressions)tableFields.getModel()).getExpression());
        this.clonedClass.setTextSymbol(this.textStyle.getTextSymbol());
    }

    private void addField() {
        this.addField("");
    }

    private void addField(String fieldExpr) {
        FieldTableExpressions m = (FieldTableExpressions)this.getTableFields().getModel();
        m.addRow(new Object[]{m.getRowCount() + 1, fieldExpr});
    }

    private void delField(int fieldIndex) {
        try {
            ((FieldTableExpressions)this.getTableFields().getModel()).removeRow(fieldIndex);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public ILabelClass getLabelClass() {
        return this.lc;
    }

    private class FieldTableExpressions
    extends DefaultTableModel {
        private static final long serialVersionUID = 2002427714889477770L;

        public FieldTableExpressions(String[] expressions) {
            if (expressions != null && expressions.length > 0) {
                Integer[] aux = new Integer[expressions.length];
                for (int i = 0; i < aux.length; ++i) {
                    aux[i] = i + 1;
                }
                Object[][] values = new Object[aux.length][2];
                for (int i = 0; i < values.length; ++i) {
                    values[i][0] = aux[i];
                    values[i][1] = expressions[i];
                }
                this.setDataVector(values, TABLE_HEADERS);
            } else {
                Object[][] values = new Object[1][2];
                values[0][0] = 1;
                values[0][1] = "";
                this.setDataVector(values, TABLE_HEADERS);
            }
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 1;
        }

        public String[] getExpression() {
            String[] expressions = new String[this.getRowCount()];
            for (int i = 0; i < this.getRowCount(); ++i) {
                expressions[i] = "" + (String)this.getValueAt(i, 1);
            }
            return expressions;
        }
    }

    private class DefaultEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    SupportDisposable {
        private final JPanel editor;
        private final JTextField text;
        private final JButton button;
        private final ExpressionPickerController pickerExpression;
        private final DisposableHelper disposableHelper = new DisposableHelper((Disposable)this);

        public DefaultEditor(FeatureAttributeDescriptor[] atts) {
            this.editor = new JPanel();
            this.editor.setLayout(new GridBagLayout());
            GridBagConstraints cons = new GridBagConstraints();
            cons.fill = 1;
            cons.weightx = 1.0;
            cons.weighty = 1.0;
            this.text = new JTextField();
            this.editor.add((Component)this.text, cons);
            GridBagConstraints cons1 = new GridBagConstraints();
            cons1.fill = 3;
            cons1.weighty = 1.0;
            this.button = new JButton("...");
            this.editor.add((Component)this.button, cons1);
            this.pickerExpression = DALSwingLocator.getManager().createExpressionPickerController(LabelClassProperties.this.featureStore, (JTextComponent)this.text, this.button);
            this.editor.updateUI();
        }

        @Override
        public Object getCellEditorValue() {
            return this.text.getText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.text.setText((String)value);
            return this.editor;
        }

        public void dispose() {
            this.disposableHelper.dispose((SupportDisposable)this);
        }

        public void doDispose() throws BaseException {
            DisposeUtils.disposeQuietly((Object)this.pickerExpression);
        }
    }
}

