/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.placements;

import java.util.ArrayList;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelClass;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.IPlacementConstraints;
import org.gvsig.labeling.placements.AbstractPlacementConstraints;
import org.gvsig.labeling.placements.CannotPlaceLabel;
import org.gvsig.labeling.placements.CompoundLabelPlacement;
import org.gvsig.labeling.placements.ILabelPlacement;
import org.gvsig.labeling.placements.LinePlacementAtExtremities;
import org.gvsig.labeling.placements.LinePlacementInTheMiddle;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.styling.LabelLocationMetrics;
import org.gvsig.tools.task.Cancellable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinePlacementAtBest
extends CompoundLabelPlacement {
    private static Logger logger = LoggerFactory.getLogger(LinePlacementAtBest.class);
    private static ILabelPlacement[] pl = new ILabelPlacement[]{new LinePlacementInTheMiddle(), new LinePlacementAtExtremities()};

    public LinePlacementAtBest() {
        super(pl);
    }

    @Override
    public ArrayList<LabelLocationMetrics> guess(ILabelClass lc, Geometry geom, IPlacementConstraints constraints, double cartographicSymbolSize, Cancellable cancel, ViewPort vp) {
        if (cancel.isCanceled()) {
            return CannotPlaceLabel.NO_PLACES;
        }
        ArrayList<LabelLocationMetrics> llc = super.guess(lc, geom, constraints, cartographicSymbolSize, cancel, vp);
        if (constraints instanceof AbstractPlacementConstraints) {
            try {
                AbstractPlacementConstraints clone = (AbstractPlacementConstraints)((AbstractPlacementConstraints)constraints).clone();
                clone.setLocationAlongTheLine(13);
                llc.addAll(pl[1].guess(lc, geom, clone, cartographicSymbolSize, cancel, vp));
            }
            catch (CloneNotSupportedException e) {
                logger.info("Couldn't clone " + constraints.getClass().getName(), (Throwable)e);
            }
        }
        return llc;
    }

    @Override
    public boolean isSuitableFor(IPlacementConstraints placementConstraints, int shapeType) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        if (geomManager.isSubtype(2, shapeType) || geomManager.isSubtype(8, shapeType)) {
            return placementConstraints != null && placementConstraints.isAtBestOfLine();
        }
        return false;
    }
}

