/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.placements;

import java.util.ArrayList;
import java.util.Iterator;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.IPlacementConstraints;
import org.gvsig.labeling.placements.CannotPlaceLabel;
import org.gvsig.labeling.placements.CompoundLabelPlacement;
import org.gvsig.labeling.placements.ILabelPlacement;
import org.gvsig.labeling.placements.LinePlacementConstraints;
import org.gvsig.labeling.placements.MultiShapePlacement;
import org.gvsig.labeling.placements.MultiShapePlacementConstraints;
import org.gvsig.labeling.placements.PointPlacementConstraints;
import org.gvsig.labeling.placements.PolygonPlacementConstraints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlacementManager {
    private static Logger logger = LoggerFactory.getLogger(PlacementManager.class);
    private static ArrayList<Class<?>> installedLabelPlacements = new ArrayList();
    private static ArrayList<ILabelPlacement> availableLabelPlacements;
    private static final CannotPlaceLabel cantPlaceLabel;

    private PlacementManager() {
    }

    public static ILabelPlacement getPlacement(IPlacementConstraints placementConstraints, int shapeType) {
        ArrayList<ILabelPlacement> suitablePlacements = new ArrayList<ILabelPlacement>();
        if (placementConstraints.getClass().equals(MultiShapePlacementConstraints.class)) {
            MultiShapePlacementConstraints msp = (MultiShapePlacementConstraints)placementConstraints;
            return new MultiShapePlacement(PlacementManager.getPlacement(msp.getPointConstraints(), 1), PlacementManager.getPlacement(msp.getLineConstraints(), 2), PlacementManager.getPlacement(msp.getPolygonConstraints(), 3));
        }
        for (ILabelPlacement placement : PlacementManager.getAvailablePlacements()) {
            if (!placement.isSuitableFor(placementConstraints, shapeType)) continue;
            suitablePlacements.add(placement);
        }
        if (suitablePlacements.size() == 0) {
            return cantPlaceLabel;
        }
        if (suitablePlacements.size() == 1) {
            return (ILabelPlacement)suitablePlacements.get(0);
        }
        return new CompoundLabelPlacement(suitablePlacements.toArray(new ILabelPlacement[suitablePlacements.size()]));
    }

    public static void addLabelPlacement(Class<?> labelPlacementClass) {
        installedLabelPlacements.add(labelPlacementClass);
        if (availableLabelPlacements != null) {
            availableLabelPlacements.clear();
        }
        availableLabelPlacements = null;
    }

    private static ArrayList<ILabelPlacement> getAvailablePlacements() {
        if (availableLabelPlacements == null) {
            availableLabelPlacements = new ArrayList(installedLabelPlacements.size());
            Iterator<Class<?>> iterator = installedLabelPlacements.iterator();
            while (iterator.hasNext()) {
                Class<?> clazz = null;
                try {
                    clazz = iterator.next();
                    availableLabelPlacements.add((ILabelPlacement)clazz.newInstance());
                }
                catch (Exception e) {
                    logger.error("Couldn't install label placement: " + clazz.getName(), (Throwable)e);
                }
            }
        }
        return availableLabelPlacements;
    }

    public static IPlacementConstraints createPlacementConstraints(int geotype) throws Exception {
        GeometryType geom_gt = GeometryLocator.getGeometryManager().getGeometryType(geotype, 0);
        if (geom_gt.isTypeOf(1) || geom_gt.isTypeOf(7)) {
            return new PointPlacementConstraints();
        }
        if (geom_gt.isTypeOf(2) || geom_gt.isTypeOf(8)) {
            return new LinePlacementConstraints();
        }
        if (geom_gt.isTypeOf(3) || geom_gt.isTypeOf(9)) {
            return new PolygonPlacementConstraints();
        }
        if (geom_gt.getType() == 0 || geom_gt.getType() == 6) {
            return new MultiShapePlacementConstraints((PointPlacementConstraints)PlacementManager.createPlacementConstraints(1), (LinePlacementConstraints)PlacementManager.createPlacementConstraints(2), (PolygonPlacementConstraints)PlacementManager.createPlacementConstraints(3));
        }
        logger.error("Unknown geo type in createPlacementConstraints: " + geotype);
        return null;
    }

    static {
        cantPlaceLabel = new CannotPlaceLabel();
    }
}

