/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.placements;

import java.awt.Rectangle;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Vector;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelClass;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.IPlacementConstraints;
import org.gvsig.labeling.placements.CannotPlaceLabel;
import org.gvsig.labeling.placements.ILabelPlacement;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.styling.LabelLocationMetrics;
import org.gvsig.tools.task.Cancellable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolygonPlacementParallel
implements ILabelPlacement {
    private static final Logger logger = LoggerFactory.getLogger(PolygonPlacementParallel.class);

    @Override
    public ArrayList<LabelLocationMetrics> guess(ILabelClass lc, Geometry geom, IPlacementConstraints placementConstraints, double cartographicSymbolSize, Cancellable cancel, ViewPort vp) {
        if (cancel.isCanceled()) {
            return CannotPlaceLabel.NO_PLACES;
        }
        double theta = 0.0;
        Point start_po = null;
        try {
            start_po = placementConstraints.isFitInsidePolygon() ? geom.getInteriorPoint() : geom.centroid();
        }
        catch (Exception exc) {
            logger.warn("While getting centroid/interior point.", (Throwable)exc);
        }
        Point2D.Double startingPoint = new Point2D.Double(start_po.getX(), start_po.getY());
        PathIterator pi = geom.getPathIterator(null);
        Rectangle geomBounds = geom.getBounds();
        double sumx = 0.0;
        double sumy = 0.0;
        double sumxx = 0.0;
        double sumyy = 0.0;
        double sumxy = 0.0;
        double[] coords = new double[6];
        int count = 0;
        Vector<Point2D.Double> v = new Vector<Point2D.Double>();
        while (!pi.isDone()) {
            pi.currentSegment(coords);
            Point2D.Double p = geomBounds.width > geomBounds.height ? new Point2D.Double(coords[0], coords[1]) : new Point2D.Double(coords[1], coords[0]);
            v.addElement(p);
            ++count;
            sumx += ((Point2D)p).getX();
            sumy += ((Point2D)p).getY();
            sumxx += ((Point2D)p).getX() * ((Point2D)p).getX();
            sumyy += ((Point2D)p).getY() * ((Point2D)p).getY();
            sumxy += ((Point2D)p).getX() * ((Point2D)p).getY();
            pi.next();
        }
        double n = count;
        double Sxx = sumxx - sumx * sumx / n;
        double Sxy = sumxy - sumx * sumy / n;
        double b = Sxy / Sxx;
        double a = (sumy - b * sumx) / n;
        boolean isVertical = false;
        if (geomBounds.width < geomBounds.height) {
            if (b == 0.0) {
                isVertical = true;
            } else {
                double bAux = 1.0 / b;
                a = -a / b;
                b = bAux;
            }
        }
        if (isVertical) {
            theta = 1.5707963267948966;
        } else {
            double p1x = 0.0;
            double p1y = (double)geomBounds.height - a;
            double p2x = geomBounds.width;
            double p2y = (double)geomBounds.height - (a + (double)geomBounds.width * b);
            theta = -Math.atan((p2y - p1y) / (p2x - p1x));
        }
        ArrayList<LabelLocationMetrics> guessed = new ArrayList<LabelLocationMetrics>();
        Rectangle labelBounds = lc.getBounds();
        double cosTheta = Math.cos(theta);
        double sinTheta = Math.sin(theta);
        double halfHeight = labelBounds.getHeight() * 0.5;
        double halfWidth = labelBounds.getWidth() * 0.5;
        double offsetX = halfHeight * sinTheta + halfWidth * cosTheta;
        double offsetY = -halfHeight * cosTheta + halfWidth * sinTheta;
        double offsetRX = vp.toMapDistance((int)offsetX);
        double offsetRY = vp.toMapDistance((int)offsetY);
        ((Point2D)startingPoint).setLocation(((Point2D)startingPoint).getX() - offsetRX, ((Point2D)startingPoint).getY() - offsetRY);
        Point auxp = null;
        try {
            auxp = GeometryLocator.getGeometryManager().createPoint(((Point2D)startingPoint).getX(), ((Point2D)startingPoint).getY(), 0);
        }
        catch (Exception e) {
            logger.warn("While creating point.", (Throwable)e);
        }
        auxp.transform(vp.getAffineTransform());
        guessed.add(new LabelLocationMetrics((Point2D)new Point2D.Double(auxp.getX(), auxp.getY()), -theta, true));
        return guessed;
    }

    @Override
    public boolean isSuitableFor(IPlacementConstraints placementConstraints, int shapeType) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        if (geomManager.isSubtype(3, shapeType) || geomManager.isSubtype(9, shapeType)) {
            return placementConstraints != null && placementConstraints.isParallel();
        }
        return false;
    }
}

