/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.symbol;

import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;

public class SymbolUtils {
    public static double getCartographicLength(CartographicSupport cartographicElement, double length, ViewPort viewPort, double dpi) {
        int unit = cartographicElement.getUnit();
        double lengthInPixel = length;
        if (unit != -1) {
            double[] trans2Meter = MapContext.getDistanceTrans2Meter();
            if (cartographicElement.getReferenceSystem() == 0) {
                double dist1PixelInMeters = viewPort.getDist1pixel() * trans2Meter[viewPort.getMapUnits()];
                double realWidthMeter = length * trans2Meter[unit];
                lengthInPixel = realWidthMeter / dist1PixelInMeters;
            } else if (cartographicElement.getReferenceSystem() == 1) {
                double lengthInInches = 1.0 / trans2Meter[7] * trans2Meter[unit] * length;
                lengthInPixel = lengthInInches * dpi;
            }
        } else {
            double scale = dpi / 72.0;
            lengthInPixel *= scale;
        }
        return lengthInPixel;
    }
}

