/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.downloader.swing.impl.config;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.downloader.DownloaderAuthenticationConfig;
import org.gvsig.downloader.DownloaderAuthenticationFactory;
import org.gvsig.downloader.DownloaderAuthenticationRequester;
import org.gvsig.downloader.DownloaderLocator;
import org.gvsig.downloader.DownloaderManager;
import org.gvsig.downloader.swing.DownloaderConfigServicePanel;
import org.gvsig.downloader.swing.impl.config.DownloaderConfigServicePanelView;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.lang.CloneableUtils;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.ChangeListenerSupport;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.icontheme.IconTheme;

public class DownloaderConfigServicePanelImpl
extends DownloaderConfigServicePanelView
implements ChangeListenerSupport,
DownloaderConfigServicePanel {
    private DownloaderAuthenticationConfig config;
    private final ChangeListenerHelper changeListenerHelper = ToolsSwingLocator.getToolsSwingManager().createChangeListenerHelper();
    private boolean dirty;

    public DownloaderConfigServicePanelImpl() {
        this((String)null);
    }

    public DownloaderConfigServicePanelImpl(String theServiceUrl) {
        this.initComponents();
        this.txtServiceURL.setText(theServiceUrl);
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
        toolsSwingManager.translate(this.lblAuthenmticationType);
        toolsSwingManager.translate(this.lblServiceURL);
        toolsSwingManager.translate((AbstractButton)this.btnAuthenticationConfig);
        toolsSwingManager.translate((AbstractButton)this.btnAuthenticationTest);
        toolsSwingManager.addClearButton((JTextComponent)this.txtServiceURL);
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtServiceURL);
        DefaultComboBoxModel<DownloaderAuthenticationFactory> authenticationTypeModel = new DefaultComboBoxModel<DownloaderAuthenticationFactory>();
        for (DownloaderAuthenticationFactory authenticationType : downloader.getAuthenticationTypes()) {
            authenticationTypeModel.addElement(authenticationType);
        }
        this.cboAuthenticationType.setModel(authenticationTypeModel);
        this.cboAuthenticationType.setSelectedIndex(0);
        this.cboAuthenticationType.addActionListener(e -> SwingUtilities.invokeLater(() -> {
            this.doAuthenticationOrUrlChange();
            this.changeListenerHelper.fireEvent();
        }));
        this.btnAuthenticationConfig.addActionListener(e -> this.doAuthenticationConfig());
        this.btnAuthenticationTest.addActionListener(e -> this.doAuthenticationTest());
        this.txtServiceURL.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    DownloaderConfigServicePanelImpl.this.doAuthenticationOrUrlChange();
                    DownloaderConfigServicePanelImpl.this.changeListenerHelper.fireEvent();
                }
            }
        });
        this.txtServiceURL.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DownloaderConfigServicePanelImpl.this.setDirty(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DownloaderConfigServicePanelImpl.this.setDirty(true);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DownloaderConfigServicePanelImpl.this.setDirty(true);
            }
        });
        this.cboAuthenticationType.setSelectedIndex(-1);
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)4, (int)100, (int)6, (int)200);
    }

    private void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.changeListenerHelper.fireEvent();
    }

    private boolean isDirty() {
        return this.dirty;
    }

    private void doUpdateComponents() {
        if (this.config == null) {
            this.btnAuthenticationConfig.setEnabled(false);
            this.btnAuthenticationTest.setEnabled(false);
            return;
        }
        this.btnAuthenticationConfig.setEnabled(true);
        this.btnAuthenticationTest.setEnabled(true);
    }

    public void clear() {
        this.config = null;
        this.txtServiceURL.setText("");
        this.cboAuthenticationType.setSelectedIndex(0);
        this.changeListenerHelper.fireEvent();
    }

    public void put(DownloaderAuthenticationConfig config) {
        this.config = (DownloaderAuthenticationConfig)CloneableUtils.cloneQuietly((Cloneable)config);
        this.txtServiceURL.setText(this.config.getServiceUrl());
        ListElement.setSelected((JComboBox)this.cboAuthenticationType, (Object)this.config.getFactory());
        this.doUpdateComponents();
        this.changeListenerHelper.fireEvent();
    }

    public DownloaderAuthenticationConfig fetch() {
        if (this.config == null) {
            return null;
        }
        return (DownloaderAuthenticationConfig)CloneableUtils.cloneQuietly((Cloneable)this.config);
    }

    private void doAuthenticationOrUrlChange() {
        DownloaderAuthenticationFactory authenticationType = (DownloaderAuthenticationFactory)this.cboAuthenticationType.getSelectedItem();
        if (authenticationType == null) {
            return;
        }
        String url = (String)StringUtils.defaultIfBlank((CharSequence)this.txtServiceURL.getText(), null);
        if (StringUtils.isBlank((CharSequence)url)) {
            return;
        }
        url = url.trim();
        if (this.config == null || !StringUtils.equalsIgnoreCase((CharSequence)authenticationType.getProviderName(), (CharSequence)this.config.getProviderName())) {
            this.config = authenticationType.create(new Object[]{url});
        }
        if (!StringUtils.equals((CharSequence)this.config.getServiceUrl(), (CharSequence)url)) {
            this.config = authenticationType.create(new Object[]{url});
        }
        this.setDirty(false);
        this.doUpdateComponents();
    }

    private void doAuthenticationConfig() {
        if (this.config == null) {
            return;
        }
        if (!this.config.isConfigurable()) {
            return;
        }
        this.config.requestAuthenticationConfig();
        this.changeListenerHelper.fireEvent();
    }

    private void doAuthenticationTest() {
        if (this.config == null) {
            return;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        DownloaderManager manager = DownloaderLocator.getDownloaderManager();
        manager.removeCredentials(this.config.getServiceUrl());
        DownloaderAuthenticationRequester requester = this.config.create();
        if (!requester.requestAuthorization(command -> command.run())) {
            dialogs.messageDialog(i18n.getTranslation("_Authentication_test_failed"), i18n.getTranslation("_Authentication_test"), 2);
            return;
        }
        dialogs.messageDialog(i18n.getTranslation("_Authentication_test_passed"), i18n.getTranslation("_Authentication_test"), 1);
    }

    public boolean isTheConfigurationValid() {
        return !this.isDirty() && this.config != null && this.config.isFilled();
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        String name = FilenameUtils.getBaseName((String)imageName);
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getDefault();
        if (theme.exists(name)) {
            return theme.get(name);
        }
        return new ImageIcon();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListenerHelper.addChangeListener(listener);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeListenerHelper.getChangeListeners();
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListenerHelper.removeChangeListener(listener);
    }

    public void removeAllChangeListener() {
        this.changeListenerHelper.removeAllChangeListener();
    }

    public boolean hasChangeListeners() {
        return this.changeListenerHelper.hasChangeListeners();
    }

    public static void selfRegister() {
        ToolsSwingUtils.registerIcons(DownloaderConfigServicePanel.class, (String)"/org/gvsig/downloader/swing/impl/images", (String)"downloader", (String[][])new String[][]{{"downloader", "downloader-auth-config"}, {"downloader", "downloader-auth-test"}});
    }

    public JComponent asJComponent() {
        return this;
    }
}

