/*
 * Decompiled with CFR 0.152.
 */
package org.japura.controller;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.japura.controller.Controller;
import org.japura.controller.ControllerModel;
import org.japura.debug.DebugComponent;
import org.japura.debug.DebugParameter;
import org.japura.debug.DebugResult;

class DebugControllers
extends DebugComponent {
    private static final long serialVersionUID = 1966234031063183108L;
    private JList list;
    private JTree tree;
    private JScrollPane sp;
    private JRadioButton treeButton;
    private JRadioButton listButton;
    private JCheckBox fullNameButton;
    private List<TreePath> pathsToExpand = new ArrayList<TreePath>();
    private List<String> expandedNodes = new ArrayList<String>();

    public DebugControllers() {
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.getListButton());
        bg.add(this.getTreeButton());
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        buttonsPanel.add((Component)this.getTreeButton(), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        buttonsPanel.add((Component)this.getListButton(), gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        buttonsPanel.add((Component)this.getFullNameButton(), gbc);
        this.setLayout(new BorderLayout());
        this.add((Component)buttonsPanel, "North");
        this.sp = new JScrollPane(this.getTree());
        this.add((Component)this.sp, "Center");
    }

    private void controllerRemoved(ControllerModel controller) {
        String id = controller.getControllerId();
        this.expandedNodes.remove(id);
    }

    public JCheckBox getFullNameButton() {
        if (this.fullNameButton == null) {
            this.fullNameButton = new JCheckBox("Full name");
            this.fullNameButton.setSelected(true);
            this.fullNameButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DebugControllers.this.tree.updateUI();
                    DebugControllers.this.list.updateUI();
                }
            });
        }
        return this.fullNameButton;
    }

    public JRadioButton getListButton() {
        if (this.listButton == null) {
            this.listButton = new JRadioButton("List");
            this.listButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DebugControllers.this.sp.setViewportView(DebugControllers.this.getList());
                }
            });
        }
        return this.listButton;
    }

    public JRadioButton getTreeButton() {
        if (this.treeButton == null) {
            this.treeButton = new JRadioButton("Tree");
            this.treeButton.setSelected(true);
            this.treeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DebugControllers.this.sp.setViewportView(DebugControllers.this.getTree());
                }
            });
        }
        return this.treeButton;
    }

    public JTree getTree() {
        if (this.tree == null) {
            this.tree = new JTree();
            this.tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
            this.tree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.tree.setCellRenderer(new TRenderer());
            this.tree.setRootVisible(false);
            this.tree.setShowsRootHandles(true);
            this.tree.addTreeExpansionListener(new TreeExpansionListener(){

                @Override
                public void treeExpanded(TreeExpansionEvent event) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
                    ControllerModel controller = (ControllerModel)node.getUserObject();
                    String id = controller.getControllerId();
                    DebugControllers.this.expandedNodes.add(id);
                }

                @Override
                public void treeCollapsed(TreeExpansionEvent event) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
                    ControllerModel controller = (ControllerModel)node.getUserObject();
                    String id = controller.getControllerId();
                    DebugControllers.this.expandedNodes.remove(id);
                }
            });
        }
        return this.tree;
    }

    public JList getList() {
        if (this.list == null) {
            this.list = new JList();
            this.list.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.list.setCellRenderer(new LRenderer());
        }
        return this.list;
    }

    private void addToPathList(DefaultMutableTreeNode node) {
        ControllerModel controller = (ControllerModel)node.getUserObject();
        String id = controller.getControllerId();
        if (this.expandedNodes.contains(id)) {
            this.pathsToExpand.add(new TreePath(node.getPath()));
        }
    }

    private void addChild(ControllerModel parent, DefaultMutableTreeNode parentNode) {
        List<ControllerModel> list = parent.getChildren();
        if (list.size() > 0) {
            Iterator<ControllerModel> i$ = list.iterator();
            while (i$.hasNext()) {
                ControllerModel child;
                ControllerModel c = child = i$.next();
                DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
                parentNode.add(childNode);
                this.addToPathList(childNode);
                this.addChild(c, childNode);
            }
        }
    }

    private void addChild(ControllerModel parent, DefaultListModel listModel) {
        List<ControllerModel> list = parent.getChildren();
        if (list.size() > 0) {
            Iterator<ControllerModel> i$ = list.iterator();
            while (i$.hasNext()) {
                ControllerModel child;
                ControllerModel c = child = i$.next();
                listModel.addElement(child);
                this.addChild(c, listModel);
            }
        }
    }

    @Override
    protected String getTitle() {
        List<ControllerModel> list = Controller.getAll();
        return "Controllers - Pool (" + list.size() + ")";
    }

    @Override
    protected DebugResult update(DebugParameter parameter) {
        if (parameter instanceof Parameter) {
            Parameter p = (Parameter)parameter;
            if (p.getControllerToRemove() != null) {
                this.controllerRemoved(p.getControllerToRemove());
                return null;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DebugControllers.this.pathsToExpand.clear();
                    List<ControllerModel> list = Controller.getAll();
                    DefaultMutableTreeNode root = new DefaultMutableTreeNode();
                    DefaultTreeModel treeModel = new DefaultTreeModel(root);
                    DefaultListModel<ControllerModel> listModel = new DefaultListModel<ControllerModel>();
                    for (ControllerModel c : list) {
                        if (c.getParentId() != null) continue;
                        DefaultMutableTreeNode node = new DefaultMutableTreeNode(c);
                        root.add(node);
                        DebugControllers.this.addToPathList(node);
                        listModel.addElement(c);
                        DebugControllers.this.addChild(c, listModel);
                        DebugControllers.this.addChild(c, node);
                    }
                    DebugControllers.this.getTree().setModel(treeModel);
                    DebugControllers.this.getList().setModel(listModel);
                    for (TreePath tp : DebugControllers.this.pathsToExpand) {
                        DebugControllers.this.tree.expandPath(tp);
                    }
                    DebugControllers.this.pathsToExpand.clear();
                }
            });
        }
        return null;
    }

    private static String controllerToString(ControllerModel controller, boolean fullName) {
        String name = null;
        name = fullName ? controller.getClass().getName() : controller.getClass().getSimpleName();
        return name + " [ " + controller.stringToDebugComponent() + " ]";
    }

    public static class Parameter
    extends DebugParameter {
        private ControllerModel controllerToRemove;

        public Parameter(ControllerModel controllerToRemove) {
            this.controllerToRemove = controllerToRemove;
        }

        public Parameter() {
        }

        public ControllerModel getControllerToRemove() {
            return this.controllerToRemove;
        }
    }

    private class TRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 8655744295863210194L;

        private TRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel comp = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            ControllerModel controller = (ControllerModel)node.getUserObject();
            if (controller != null) {
                boolean fullName = DebugControllers.this.getFullNameButton().isSelected();
                comp.setText(DebugControllers.controllerToString(controller, fullName));
            }
            return comp;
        }

        @Override
        public void setIcon(Icon icon) {
        }
    }

    private class LRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 197732829250426432L;

        private LRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel comp = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            ControllerModel controller = (ControllerModel)value;
            boolean fullName = DebugControllers.this.getFullNameButton().isSelected();
            comp.setText(DebugControllers.controllerToString(controller, fullName));
            return comp;
        }
    }
}

