/*
 * Decompiled with CFR 0.152.
 */
package org.japura.controller;

import java.util.List;
import org.japura.controller.Controller;
import org.japura.controller.ControllerModel;

public final class Group {
    private final String id;

    Group(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public <E> List<E> getAll(Class<E> cls) {
        return Controller.getAllFromGroup(this.getId(), cls);
    }

    public List<ControllerModel> getAll() {
        return Controller.getAllFromGroup(this.getId());
    }

    public <E> E get(Class<E> cls) {
        return Controller.getFromGroup(this.getId(), cls);
    }

    public <E> E get(String id, Class<E> cls) {
        return Controller.getFromGroup(this.getId(), id, cls);
    }

    public ControllerModel get(String id) {
        return Controller.getFromGroup(this.getId(), id);
    }

    public void freeAll(Class<?> clss) {
        Controller.freeAllFromGroup(this.getId(), clss);
    }

    public void free() {
        Controller.freeGroup(this.getId());
    }

    public boolean isInstancied(Class<?> cls) {
        return Controller.isInstanciedInGroup(this.getId(), cls);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getId() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Group other = (Group)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

