/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import org.japura.gui.PopupMenuBuilder;
import org.japura.gui.dnd.CheckListTransferHandler;
import org.japura.gui.dnd.CheckListTransferable;
import org.japura.gui.event.ListCheckListener;
import org.japura.gui.event.ListEvent;
import org.japura.gui.event.ListLockListener;
import org.japura.gui.event.ListModelListener;
import org.japura.gui.model.DefaultListCheckModel;
import org.japura.gui.model.ListCheckModel;
import org.japura.gui.renderer.CheckListRenderer;

public class CheckList
extends JList {
    private static final long serialVersionUID = 7562297704191604289L;
    private ListCheckModel model;
    private PopupMenuBuilder<CheckList> popupMenuBuilder;

    public CheckList() {
        MouseListener[] listeners;
        MouseMotionListener[] mmls;
        InputMap im = this.getInputMap(0);
        AbstractAction copyAction = new AbstractAction(){
            private static final long serialVersionUID = -7299012786614721676L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String str = CheckListTransferable.toString(CheckList.this.getModel(), ", ");
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                cb.setContents(new StringSelection(str), null);
            }
        };
        im.put(KeyStroke.getKeyStroke(67, 2), "Copy");
        ActionMap am = this.getActionMap();
        am.put("Copy", copyAction);
        this.setModel(new DefaultListCheckModel());
        this.setCellRenderer(new CheckListRenderer());
        super.setSelectionMode(0);
        for (MouseMotionListener mml : mmls = this.getMouseMotionListeners()) {
        }
        for (MouseListener ml : listeners = this.getMouseListeners()) {
        }
        this.setTransferHandler(new CheckListTransferHandler());
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                CheckList.this.updateSelection(e.getPoint());
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                CheckList.this.updateSelection(null);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                JPopupMenu pm;
                if (SwingUtilities.isLeftMouseButton(e)) {
                    int index = CheckList.this.locationToIndex(e.getPoint());
                    if (index > -1) {
                        Object obj = CheckList.this.getModel().getElementAt(index);
                        if (!CheckList.this.getModel().isLocked(obj)) {
                            boolean checked = CheckList.this.getModel().isChecked(obj);
                            if (checked) {
                                CheckList.this.getModel().removeCheck(obj);
                            } else {
                                CheckList.this.getModel().addCheck(obj);
                            }
                        }
                    }
                } else if (SwingUtilities.isRightMouseButton(e) && CheckList.this.getPopupMenuBuilder() != null && (pm = CheckList.this.getPopupMenuBuilder().buildPopupMenu(CheckList.this)) != null) {
                    pm.show(CheckList.this, e.getX(), e.getY());
                }
            }
        });
    }

    @Override
    public final void setSelectionModel(ListSelectionModel selectionModel) {
        super.setSelectionModel(new DefaultListSelectionModel());
    }

    @Override
    public final void setSelectionMode(int selectionMode) {
        super.setSelectionMode(0);
    }

    private void updateSelection(Point point) {
        if (point != null) {
            int index = this.locationToIndex(point);
            this.setSelectedIndex(index);
        } else {
            this.clearSelection();
        }
        this.repaint();
    }

    public ListCheckModel getModel() {
        if (this.model == null) {
            this.setModel(new DefaultListCheckModel());
        }
        return this.model;
    }

    public void setCellRenderer(ListCellRenderer cellRenderer) {
        if (cellRenderer instanceof CheckListRenderer) {
            super.setCellRenderer(cellRenderer);
        }
    }

    public void setCellRenderer(CheckListRenderer cellRenderer) {
        super.setCellRenderer(cellRenderer);
    }

    public CheckListRenderer getCellRenderer() {
        return (CheckListRenderer)super.getCellRenderer();
    }

    public void setPopupMenuBuilder(PopupMenuBuilder<CheckList> popupMenuBuilder) {
        this.popupMenuBuilder = popupMenuBuilder;
    }

    public PopupMenuBuilder<CheckList> getPopupMenuBuilder() {
        return this.popupMenuBuilder;
    }

    public void setModel(ListModel model) {
        if (!(model instanceof ListCheckModel)) {
            throw new IllegalArgumentException("model must be ListCheckModel");
        }
        this.setModel((ListCheckModel)model);
    }

    public void setModel(ListCheckModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model must be non null");
        }
        ListCheckModel oldValue = this.model;
        this.model = model;
        if (oldValue != null) {
            this.firePropertyChange("model", oldValue, model);
        }
        model.addListModelListener(new ListModelListener(){

            @Override
            public void valueAdded(ListEvent e) {
                CheckList.this.repaint();
            }

            @Override
            public void valueRemoved(ListEvent e) {
                CheckList.this.repaint();
            }
        });
        model.addListCheckListener(new ListCheckListener(){

            @Override
            public void addCheck(ListEvent event) {
                CheckList.this.repaint();
            }

            @Override
            public void removeCheck(ListEvent event) {
                CheckList.this.repaint();
            }
        });
        model.addListLockListener(new ListLockListener(){

            @Override
            public void addLock(ListEvent event) {
                CheckList.this.repaint();
            }

            @Override
            public void removeLock(ListEvent event) {
                CheckList.this.repaint();
            }
        });
        this.repaint();
    }
}

