/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.japura.gui.ButtonTextField;
import org.japura.gui.renderer.HighlightCellRenderer;

public class DynamicList<T> {
    private JPopupMenu optionsPopup;
    private JComponent invoker;
    private JTextField field;
    private JPanel root;
    private JList list;
    private DefaultListModel model;
    private List<T> options;
    private boolean caseSensitive;

    public DynamicList(ButtonTextField buttonField, List<T> options) {
        this(buttonField, options, false);
    }

    public DynamicList(ButtonTextField buttonField, List<T> options, boolean caseSensitive) {
        this.invoker = buttonField;
        this.init(buttonField.getField(), options, caseSensitive);
    }

    public DynamicList(JTextField field, List<T> options) {
        this(field, options, false);
    }

    public DynamicList(JTextField field, List<T> options, boolean caseSensitive) {
        this.invoker = field;
        this.init(field, options, caseSensitive);
    }

    private void init(JTextField field, List<T> options, boolean caseSensitive) {
        this.field = field;
        this.caseSensitive = caseSensitive;
        this.options = options;
        this.setCellRenderer(new HighlightCellRenderer(caseSensitive));
        this.model = new DefaultListModel();
        for (T item : options) {
            String text = item.toString();
            this.model.addElement(text);
        }
        this.getList().setModel(this.model);
        this.getOptionsPopup().setPreferredSize(this.getOptionsPopup().getPreferredSize());
        field.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() != 27) {
                    DynamicList.this.rebuildModel(true);
                }
                if (e.getKeyCode() == 40) {
                    DynamicList.this.getList().requestFocus();
                    if (DynamicList.this.getList().getSelectedIndex() == -1 && DynamicList.this.model.size() > 0) {
                        DynamicList.this.getList().setSelectedIndex(0);
                    }
                } else {
                    DynamicList.this.getField().requestFocus();
                }
            }
        });
    }

    public ListCellRenderer getCellRenderer() {
        return this.getList().getCellRenderer();
    }

    public void setCellRenderer(ListCellRenderer cellRenderer) {
        this.getList().setCellRenderer(cellRenderer);
    }

    private void chooseSelectedListItem() {
        if (this.getList().getSelectedIndex() > -1) {
            Object item = this.getList().getSelectedValue();
            this.getField().setText(item.toString());
            this.rebuildModel(false);
        }
    }

    private JTextField getField() {
        return this.field;
    }

    private JPopupMenu getOptionsPopup() {
        if (this.optionsPopup == null) {
            this.optionsPopup = new JPopupMenu();
            this.optionsPopup.add(this.getRoot());
        }
        return this.optionsPopup;
    }

    private JPanel getRoot() {
        if (this.root == null) {
            this.root = new JPanel();
            this.root.setLayout(new GridLayout(1, 1));
            JScrollPane sp = new JScrollPane(this.getList());
            sp.setBorder(null);
            this.root.add(sp);
        }
        return this.root;
    }

    private void rebuildModel(boolean show) {
        String typedText = this.getField().getText();
        if (!this.caseSensitive) {
            typedText = typedText.toLowerCase();
        }
        if (this.getCellRenderer() instanceof HighlightCellRenderer) {
            HighlightCellRenderer renderer = (HighlightCellRenderer)this.getCellRenderer();
            renderer.setHighlightText(typedText);
        }
        this.model = new DefaultListModel();
        for (T item : this.options) {
            String text = item.toString();
            if (!this.caseSensitive) {
                text = text.toLowerCase();
            }
            if (text.length() != 0 && text.indexOf(typedText) <= -1) continue;
            this.model.addElement(item);
        }
        this.getList().setModel(this.model);
        if (show && this.model.getSize() > 0) {
            this.getOptionsPopup().show(this.invoker, 0, this.invoker.getHeight());
        } else {
            this.getOptionsPopup().setVisible(false);
        }
    }

    public T getItem() {
        String typedText = this.getField().getText();
        if (!this.caseSensitive) {
            typedText = typedText.toLowerCase();
        }
        for (T item : this.options) {
            String text = item.toString();
            if (!this.caseSensitive) {
                text = text.toLowerCase();
            }
            if (!text.equals(typedText)) continue;
            return item;
        }
        return null;
    }

    public void setItem(T item) {
        if (item == null) {
            this.getField().setText("");
        } else if (this.options.contains(item)) {
            this.getField().setText(item.toString());
        }
    }

    public int getAvailableItemsCount() {
        return this.model.getSize();
    }

    public void showDynamicList() {
        this.rebuildModel(true);
    }

    private JList getList() {
        if (this.list == null) {
            this.list = new JList();
            this.list.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
            this.list.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        DynamicList.this.chooseSelectedListItem();
                    }
                }
            });
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        DynamicList.this.chooseSelectedListItem();
                    }
                }
            });
        }
        return this.list;
    }
}

