/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.calendar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.japura.gui.Images;
import org.japura.gui.calendar.Calendar;
import org.japura.gui.calendar.PropertiesProvider;
import org.japura.gui.model.DateDocument;
import org.japura.i18n.I18nManager;
import org.japura.i18n.I18nStringKeys;

public class CalendarField
extends JComponent {
    private static final long serialVersionUID = -3037260699569201200L;
    private DateDocument dateDocument;
    private JTextField textField;
    private JLabel calendarButton;
    private String calendarWindowTitle;
    private PropertiesProvider propertiesProvider;

    public CalendarField() {
        this(new DateDocument());
    }

    public CalendarField(DateDocument dateDocument) {
        if (dateDocument == null) {
            dateDocument = new DateDocument();
        }
        this.setDateDocument(dateDocument);
        this.setLayout(new BorderLayout(3, 0));
        this.add((Component)this.getTextField(), "Center");
        this.add((Component)this.getCalendarButton(), "East");
    }

    public PropertiesProvider getPropertiesProvider() {
        return this.propertiesProvider;
    }

    public void setPropertiesProvider(PropertiesProvider propertiesProvider) {
        this.propertiesProvider = propertiesProvider;
    }

    public void setCalendarButtonIcon(URL urlImage) {
        ImageIcon ii = new ImageIcon(urlImage);
        this.getCalendarButton().setIcon(ii);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public void setDateDocument(DateDocument dateDocument) {
        if (dateDocument != null) {
            this.dateDocument = dateDocument;
            this.setLocale(dateDocument.getLocale());
        }
    }

    public DateDocument getDateDocument() {
        return this.dateDocument;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getTextField().setEnabled(enabled);
        this.getCalendarButton().setEnabled(false);
    }

    protected JTextField getTextField() {
        if (this.textField == null) {
            this.textField = new JTextField(8);
            this.textField.setDocument(this.getDateDocument());
        }
        return this.textField;
    }

    public void setCalendarWindowTitle(String calendarWindowTitle) {
        this.calendarWindowTitle = calendarWindowTitle;
    }

    public String getCalendarWindowTitle() {
        return this.calendarWindowTitle;
    }

    private JLabel getCalendarButton() {
        if (this.calendarButton == null) {
            this.calendarButton = new JLabel();
            URL url = Images.CALENDAR;
            ImageIcon ii = new ImageIcon(url);
            this.calendarButton.setIcon(ii);
            this.calendarButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Long newDate;
                    String title;
                    if (!CalendarField.this.isEnabled()) {
                        return;
                    }
                    Date date = CalendarField.this.getDateDocument().getDate();
                    if (date == null) {
                        date = new Date(System.currentTimeMillis());
                    }
                    if ((title = CalendarField.this.getCalendarWindowTitle()) == null) {
                        title = I18nManager.getString(I18nStringKeys.CALENDAR_WINDOW_TITLE.getKey());
                    }
                    if ((newDate = Calendar.showAsDialog(CalendarField.this.getDateDocument().getLocale(), date.getTime(), title, CalendarField.this, CalendarField.this.getPropertiesProvider())) != null) {
                        CalendarField.this.getDateDocument().setDate(newDate);
                    }
                }
            });
        }
        return this.calendarButton;
    }
}

