/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.japura.gui.CheckList;
import org.japura.gui.model.ListCheckModel;

public class CheckListRenderer
extends JCheckBox
implements ListCellRenderer {
    private Highlight highlight = Highlight.MOUSE_OVER;
    protected Color foreground = UIManager.getColor("List.foreground");
    protected Color background = UIManager.getColor("List.background");
    protected Color selectionForeground = UIManager.getColor("List.selectionForeground");
    protected Color selectionBackground = UIManager.getColor("List.selectionBackground");

    public String getText(Object value) {
        return value.toString();
    }

    public void setHighlight(Highlight highlight) {
        this.highlight = highlight != null ? highlight : Highlight.MOUSE_OVER;
    }

    public Highlight getHighlight() {
        return this.highlight;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (list instanceof CheckList) {
            CheckList cbl = (CheckList)list;
            ListCheckModel model = cbl.getModel();
            boolean checked = model.isChecked(value);
            boolean locked = model.isLocked(value);
            this.setSelected(checked);
            if (locked || !cbl.isEnabled()) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
            if (this.getHighlight().equals((Object)Highlight.MOUSE_OVER_AND_CHECKED_ITEMS) && (checked || isSelected)) {
                this.setBackground(this.selectionBackground);
                this.setForeground(this.selectionForeground);
            } else if (this.getHighlight().equals((Object)Highlight.MOUSE_OVER) && isSelected) {
                this.setBackground(this.selectionBackground);
                this.setForeground(this.selectionForeground);
            } else if (this.getHighlight().equals((Object)Highlight.CHECKED_ITEMS) && checked) {
                this.setBackground(this.selectionBackground);
                this.setForeground(this.selectionForeground);
            } else {
                this.setBackground(this.background);
                this.setForeground(this.foreground);
            }
        }
        this.setText(this.getText(value));
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    public static enum Highlight {
        OFF,
        MOUSE_OVER,
        CHECKED_ITEMS,
        MOUSE_OVER_AND_CHECKED_ITEMS;

    }
}

