/*
 * Decompiled with CFR 0.152.
 */
package org.japura.util.date;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

final class MasksGenerator {
    MasksGenerator() {
    }

    public static void main(String[] dasda) {
        Locale[] ss;
        HashMap<String, ArrayList<Item>> map = new HashMap<String, ArrayList<Item>>();
        for (Locale l : ss = Locale.getAvailableLocales()) {
            DateFormat df = DateFormat.getDateInstance(2, l);
            GregorianCalendar gc = new GregorianCalendar();
            gc.clear();
            gc.set(2001, 1, 15);
            Date date = gc.getTime();
            Item item = new Item();
            item.nameInPortuguese = l.getDisplayName(new Locale("pt", "BR"));
            item.nameInEnglish = l.getDisplayName(Locale.ENGLISH);
            item.country = l.getCountry();
            item.formatedDate = df.format(date);
            String lang = l.getLanguage();
            ArrayList<Item> list = (ArrayList<Item>)map.get(lang);
            if (list == null) {
                list = new ArrayList<Item>();
                map.put(lang, list);
            }
            list.add(item);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("public static DateMask getMask(Locale locale) {");
        sb.append("\n");
        sb.append("if (locale == null) {");
        sb.append("\n");
        sb.append("locale = Locale.getDefault();");
        sb.append("\n");
        sb.append("}");
        sb.append("\n");
        sb.append("String lang = locale.getLanguage();");
        sb.append("\n");
        sb.append("String country = locale.getCountry();");
        sb.append("\n");
        boolean first = true;
        for (Map.Entry entry : map.entrySet()) {
            if (!first) {
                sb.append(" else \n");
            }
            first = false;
            sb.append("if (lang.equals(\"" + (String)entry.getKey() + "\")) {");
            sb.append("\n");
            for (Item item : (List)entry.getValue()) {
                sb.append("if(country.equals(\"" + item.country + "\")) {");
                sb.append("\n");
                sb.append("//");
                sb.append(item.nameInEnglish + " - ");
                sb.append(item.nameInPortuguese + " - ");
                sb.append(item.formatedDate);
                sb.append("\n");
                sb.append("return DateMask.NULL;");
                sb.append("\n");
                sb.append("}");
                sb.append("\n");
            }
            sb.append("}");
            sb.append("\n");
        }
        sb.append("return null;");
        sb.append("\n");
        sb.append("}");
        System.out.println(sb.toString());
    }

    public static class Item {
        public String nameInPortuguese;
        public String nameInEnglish;
        public String country;
        public String formatedDate;

        public String toString() {
            return "Country[" + this.country + "] Data[" + this.formatedDate + "] [" + this.nameInEnglish + "/" + this.nameInPortuguese + "]";
        }
    }
}

