/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.agentproxy;

import com.jcraft.jsch.Identity;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.agentproxy.AgentProxy;
import com.jcraft.jsch.agentproxy.Buffer;
import com.jcraft.jsch.agentproxy.Connector;
import java.util.Vector;

public class RemoteIdentityRepository
implements IdentityRepository {
    private AgentProxy agent;

    public RemoteIdentityRepository(Connector connector) {
        this.agent = new AgentProxy(connector);
    }

    @Override
    public Vector<Identity> getIdentities() {
        Vector<Identity> vector = new Vector<Identity>();
        com.jcraft.jsch.agentproxy.Identity[] identityArray = this.agent.getIdentities();
        for (int i = 0; i < identityArray.length; ++i) {
            final com.jcraft.jsch.agentproxy.Identity identity = identityArray[i];
            Identity identity2 = new Identity(){
                byte[] blob;
                String algname;
                {
                    this.blob = identity.getBlob();
                    this.algname = new String(new Buffer(this.blob).getString());
                }

                @Override
                public boolean setPassphrase(byte[] byArray) throws JSchException {
                    return true;
                }

                @Override
                public byte[] getPublicKeyBlob() {
                    return this.blob;
                }

                @Override
                public byte[] getSignature(byte[] byArray) {
                    return RemoteIdentityRepository.this.agent.sign(this.blob, byArray);
                }

                @Override
                public boolean decrypt() {
                    return true;
                }

                @Override
                public String getAlgName() {
                    return this.algname;
                }

                @Override
                public String getName() {
                    return new String(identity.getComment());
                }

                @Override
                public boolean isEncrypted() {
                    return false;
                }

                @Override
                public void clear() {
                }
            };
            vector.addElement(identity2);
        }
        return vector;
    }

    @Override
    public boolean add(byte[] byArray) {
        return this.agent.addIdentity(byArray);
    }

    @Override
    public boolean remove(byte[] byArray) {
        return this.agent.removeIdentity(byArray);
    }

    @Override
    public void removeAll() {
        this.agent.removeAllIdentities();
    }

    @Override
    public String getName() {
        return this.agent.getConnector().getName();
    }

    @Override
    public int getStatus() {
        if (this.agent.getConnector().isAvailable()) {
            return 2;
        }
        return 1;
    }
}

