/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import jline.Completor;

public class SimpleCompletor
implements Completor,
Cloneable {
    SortedSet candidates;
    String delimiter;
    final SimpleCompletorFilter filter;

    public SimpleCompletor(String string) {
        this(new String[]{string});
    }

    public SimpleCompletor(String[] stringArray) {
        this(stringArray, null);
    }

    public SimpleCompletor(String[] stringArray, SimpleCompletorFilter simpleCompletorFilter) {
        this.filter = simpleCompletorFilter;
        this.setCandidateStrings(stringArray);
    }

    public SimpleCompletor(Reader reader) throws IOException {
        this(SimpleCompletor.getStrings(reader));
    }

    public SimpleCompletor(InputStream inputStream) throws IOException {
        this(SimpleCompletor.getStrings(new InputStreamReader(inputStream)));
    }

    private static String[] getStrings(Reader reader) throws IOException {
        String string;
        Reader reader2 = reader instanceof BufferedReader ? reader : new BufferedReader(reader);
        LinkedList<String> linkedList = new LinkedList<String>();
        while ((string = ((BufferedReader)reader2).readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                linkedList.add(stringTokenizer.nextToken());
            }
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    @Override
    public int complete(String string, int n, List list) {
        String string2;
        String string3 = string == null ? "" : string;
        SortedSet<String> sortedSet = this.candidates.tailSet(string3);
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext() && (string2 = (String)iterator.next()).startsWith(string3)) {
            int n2;
            if (this.delimiter != null && (n2 = string2.indexOf(this.delimiter, n)) != -1) {
                string2 = string2.substring(0, n2 + 1);
            }
            list.add(string2);
        }
        if (list.size() == 1) {
            list.set(0, (String)list.get(0) + " ");
        }
        return list.size() == 0 ? -1 : 0;
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setCandidates(SortedSet sortedSet) {
        if (this.filter != null) {
            TreeSet<String> treeSet = new TreeSet<String>();
            for (String string : sortedSet) {
                if ((string = this.filter.filter(string)) == null) continue;
                treeSet.add(string);
            }
            this.candidates = treeSet;
        } else {
            this.candidates = sortedSet;
        }
    }

    public SortedSet getCandidates() {
        return Collections.unmodifiableSortedSet(this.candidates);
    }

    public void setCandidateStrings(String[] stringArray) {
        this.setCandidates(new TreeSet<String>(Arrays.asList(stringArray)));
    }

    public void addCandidateString(String string) {
        String string2;
        String string3 = string2 = this.filter == null ? string : this.filter.filter(string);
        if (string2 != null) {
            this.candidates.add(string2);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static class NoOpFilter
    implements SimpleCompletorFilter {
        @Override
        public String filter(String string) {
            return string;
        }
    }

    public static interface SimpleCompletorFilter {
        public String filter(String var1);
    }
}

