/*
 * Decompiled with CFR 0.152.
 */
package workbench;

import java.io.BufferedReader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.EncodingUtil;
import workbench.util.FileUtil;
import workbench.util.StringUtil;

public class AppArguments
extends ArgumentParser {
    public static final String ARG_SCRIPT = "script";
    public static final String ARG_COMMAND = "command";
    public static final String ARG_SCRIPT_ENCODING = "encoding";
    public static final String ARG_ABORT = "abortOnError";
    public static final String ARG_SHOWPROGRESS = "showProgress";
    public static final String ARG_PROFILE = "profile";
    public static final String ARG_PROFILE_GROUP = "profilegroup";
    public static final String ARG_CONN_URL = "url";
    public static final String ARG_CONN_DRIVER = "driver";
    public static final String ARG_CONN_DRIVER_NAME = "driverName";
    public static final String ARG_CONN_DRIVER_CLASS = "driverclass";
    public static final String ARG_CONN_JAR = "driverjar";
    public static final String ARG_CONN_USER = "username";
    public static final String ARG_CONN_PWD = "password";
    public static final String ARG_CONN_PROPS = "connectionProperties";
    public static final String ARG_CONN_DESCRIPTOR = "connection";
    public static final String ARG_CONN_AUTOCOMMIT = "autocommit";
    public static final String ARG_CONN_SSH_HOST = "sshHost";
    public static final String ARG_CONN_SSH_USER = "sshUser";
    public static final String ARG_CONN_SSH_KEYFILE = "sshPrivateKey";
    public static final String ARG_CONN_SSH_PWD = "sshPassword";
    public static final String ARG_CONN_SSH_LOCAL_PORT = "sshLocalPort";
    public static final String ARG_CONN_SSH_DB_PORT = "sshDBPort";
    public static final String ARG_CONN_SSH_DB_HOST = "sshDBHost";
    public static final String ARG_CONN_SSH_PORT = "sshPort";
    public static final String ARG_CONN_SEPARATE = "separateConnection";
    public static final String ARG_CONN_EMPTYNULL = "emptyStringIsNull";
    public static final String ARG_CONN_ROLLBACK = "rollbackOnDisconnect";
    public static final String ARG_CONN_CHECK_OPEN_TRANS = "checkUncommitted";
    public static final String ARG_CONN_TRIM_CHAR = "trimCharData";
    public static final String ARG_CONN_FETCHSIZE = "fetchSize";
    public static final String ARG_IGNORE_DROP = "ignoreDropErrors";
    public static final String ARG_READ_ONLY = "readOnly";
    public static final String ARG_CONN_REMOVE_COMMENTS = "removeComments";
    public static final String ARG_HIDE_WARNINGS = "hideWarnings";
    public static final String ARG_INTERACTIVE = "interactive";
    public static final String ARG_PROPFILE = "arguments";
    public static final String ARG_LB_CONN = "lbDefaults";
    public static final String ARG_CONN_NAME = "connectionName";
    public static final String ARG_DISPLAY_RESULT = "displayResult";
    public static final String ARG_SUCCESS_SCRIPT = "cleanupSuccess";
    public static final String ARG_ERROR_SCRIPT = "cleanupError";
    public static final String ARG_SHOW_TIMING = "showTiming";
    public static final String ARG_FEEDBACK = "feedback";
    public static final String ARG_WORKSPACE = "workspace";
    public static final String ARG_ALT_DELIMITER = "altDelimiter";
    public static final String ARG_DELIMITER = "delimiter";
    public static final String ARG_CONSOLIDATE_LOG = "consolidateMessages";
    public static final String ARG_SHOW_PUMPER = "dataPumper";
    public static final String ARG_SHOW_DBEXP = "dbExplorer";
    public static final String ARG_SHOW_SEARCHER = "objectSearcher";
    public static final String ARG_PROFILE_STORAGE = "profileStorage";
    public static final String ARG_MACRO_STORAGE = "macroStorage";
    public static final String ARG_CONFIGDIR = "configDir";
    public static final String ARG_LIBDIR = "libdir";
    public static final String ARG_LOGLEVEL = "logLevel";
    public static final String ARG_LOGFILE = "logfile";
    public static final String ARG_VARDEF = "varDef";
    public static final String ARG_VARIABLE = "variable";
    public static final String ARG_VAR_FILE = "varFile";
    public static final String ARG_LANG = "language";
    public static final String ARG_NOSETTNGS = "noSettings";
    public static final String ARG_NOTEMPLATES = "noTemplates";
    public static final String ARG_CONSOLE_OPT_COLS = "optimizeColWidth";
    public static final String ARG_CONSOLE_BUFFER_RESULTS = "bufferResults";
    public static final String ARG_PROP = "prop";
    public static final String ARG_LOG_ALL_STMT = "logAllStatements";
    public static final String ARG_EXTENSION = "extension";

    public AppArguments() {
        this.addArgument(ARG_PROPFILE);
        this.addArgument(ARG_LB_CONN);
        this.addArgument(ARG_PROFILE, ArgumentType.ProfileArgument);
        this.addArgument(ARG_FEEDBACK, ArgumentType.BoolArgument);
        this.addArgument(ARG_PROFILE_GROUP);
        this.addArgument(ARG_PROFILE_STORAGE, ArgumentType.Repeatable);
        this.addArgument(ARG_MACRO_STORAGE);
        this.addArgument(ARG_CONFIGDIR);
        this.addArgument(ARG_LIBDIR);
        this.addArgument(ARG_SCRIPT);
        this.addArgument(ARG_COMMAND);
        this.addArgument(ARG_SCRIPT_ENCODING);
        this.addArgument(ARG_LOGLEVEL);
        this.addArgument(ARG_LOGFILE);
        this.addArgument(ARG_ABORT, ArgumentType.BoolArgument);
        this.addArgument(ARG_SUCCESS_SCRIPT);
        this.addArgument(ARG_ERROR_SCRIPT);
        this.addArgument(ARG_VARDEF, ArgumentType.RepeatableValue);
        this.addArgument(ARG_VARIABLE, ArgumentType.RepeatableValue);
        this.addArgument(ARG_VAR_FILE, ArgumentType.RepeatableValue);
        this.addArgument(ARG_CONN_URL);
        this.addArgument(ARG_CONN_PROPS, ArgumentType.RepeatableValue);
        this.addArgument(ARG_CONN_DRIVER);
        this.addArgument(ARG_CONN_DRIVER_CLASS);
        this.addArgument(ARG_CONN_JAR);
        this.addArgument(ARG_CONN_FETCHSIZE);
        this.addArgument(ARG_CONN_USER);
        this.addArgument(ARG_CONN_NAME);
        this.addArgument(ARG_CONN_PWD);
        this.addArgument(ARG_CONN_SEPARATE, ArgumentType.BoolArgument);
        this.addArgument(ARG_CONN_EMPTYNULL, ArgumentType.BoolArgument);
        this.addArgument(ARG_CONN_AUTOCOMMIT, ArgumentType.BoolArgument);
        this.addArgument(ARG_CONN_REMOVE_COMMENTS, ArgumentType.BoolArgument);
        this.addArgument(ARG_CONN_CHECK_OPEN_TRANS, ArgumentType.BoolArgument);
        this.addArgument(ARG_CONN_ROLLBACK, ArgumentType.BoolArgument);
        this.addArgument(ARG_CONN_SSH_HOST);
        this.addArgument(ARG_CONN_SSH_KEYFILE, ArgumentType.Filename);
        this.addArgument(ARG_CONN_SSH_PWD);
        this.addArgument(ARG_CONN_SSH_USER);
        this.addArgument(ARG_CONN_SSH_LOCAL_PORT);
        this.addArgument(ARG_CONN_SSH_DB_PORT);
        this.addArgument(ARG_CONN_SSH_DB_HOST);
        this.addArgument(ARG_CONN_SSH_PORT);
        this.addArgument(ARG_SHOW_PUMPER, ArgumentType.BoolArgument);
        this.addArgument(ARG_IGNORE_DROP, ArgumentType.BoolArgument);
        this.addArgument(ARG_DISPLAY_RESULT, ArgumentType.BoolArgument);
        this.addArgument(ARG_SHOW_DBEXP, ArgumentType.BoolSwitch);
        this.addArgument(ARG_SHOW_SEARCHER, ArgumentType.BoolSwitch);
        this.addArgument(ARG_SHOW_TIMING, ArgumentType.BoolSwitch);
        this.addArgument(ARG_SHOWPROGRESS, ArgumentType.BoolArgument);
        this.addArgument(ARG_CONSOLE_OPT_COLS, ArgumentType.BoolArgument);
        this.addArgument(ARG_CONSOLE_BUFFER_RESULTS, ArgumentType.BoolArgument);
        this.addArgument(ARG_WORKSPACE);
        this.addArgument(ARG_NOSETTNGS, ArgumentType.BoolArgument);
        this.addArgument(ARG_NOTEMPLATES, ArgumentType.BoolSwitch);
        this.addArgument(ARG_HIDE_WARNINGS, ArgumentType.BoolArgument);
        this.addArgument(ARG_ALT_DELIMITER);
        this.addArgument(ARG_DELIMITER);
        this.addArgument(ARG_READ_ONLY, ArgumentType.BoolArgument);
        this.addArgument(ARG_CONN_TRIM_CHAR, ArgumentType.BoolArgument);
        this.addArgument(ARG_LANG);
        this.addArgument(ARG_CONSOLIDATE_LOG, ArgumentType.BoolArgument);
        this.addArgument(ARG_INTERACTIVE, ArgumentType.BoolArgument);
        this.addArgument("help");
        this.addArgument("version");
        this.addArgument(ARG_PROP, ArgumentType.Repeatable);
        this.addArgument(ARG_LOG_ALL_STMT, ArgumentType.BoolSwitch);
        this.addArgument(ARG_CONN_DESCRIPTOR);
        this.addArgument(ARG_EXTENSION);
        this.addArgument("sourceConnection");
        this.addArgument("targetConnection");
        this.addArgument("sourceProfile");
        this.addArgument("sourceGroup");
        this.addArgument("targetProfile");
        this.addArgument("targetGroup");
        this.addArgument("continueOnError", ArgumentType.BoolSwitch);
        this.addArgument("referenceConnection");
        this.addArgument("referenceProfile");
        this.addArgument("referenceGroup");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void parse(String[] stringArray) {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string2 : stringArray) {
            void var6_12;
            if (StringUtil.isBlank(string2)) continue;
            if (string2.startsWith("-")) {
                String string3 = string2.substring(1);
            }
            arrayList.add((String)var6_12);
        }
        super.parse(arrayList);
        String string4 = this.getValue(ARG_PROPFILE);
        if (string4 != null) {
            try {
                File exception = new File(string4);
                this.parseProperties(exception);
            }
            catch (Exception string5) {
                System.err.println("Could not read properties file: " + string4);
                string5.printStackTrace();
            }
        }
        if ((string = this.getValue(ARG_LB_CONN)) != null) {
            try {
                File exception = new File(string);
                BufferedReader bufferedReader = EncodingUtil.createBufferedReader(exception, null);
                List<String> list = FileUtil.getLines(bufferedReader, true, true);
                ArrayList<String> arrayList2 = new ArrayList<String>(list.size());
                for (String string6 : list) {
                    if (string6.startsWith("classpath:") && this.isArgNotPresent(ARG_CONN_JAR)) {
                        String string7 = string6.substring("classpath:".length()).trim();
                        File file = new File(string7);
                        if (file.getParent() == null) {
                            string7 = "./" + file.getName();
                        }
                        string6 = "driverjar=" + string7;
                        arrayList2.add(string6);
                        continue;
                    }
                    this.processParameter(string6, "driver:", ARG_CONN_DRIVER, arrayList2);
                    this.processParameter(string6, "url:", ARG_CONN_URL, arrayList2);
                    this.processParameter(string6, "username:", ARG_CONN_USER, arrayList2);
                    this.processParameter(string6, "password:", ARG_CONN_PWD, arrayList2);
                }
                this.parse(arrayList2);
            }
            catch (Exception exception) {
                System.err.println("Could not read liquibase properties!");
                exception.printStackTrace();
            }
        }
    }

    private void processParameter(String string, String string2, String string3, List<String> list) {
        if (string.startsWith(string2) && this.isArgNotPresent(string3)) {
            String string4 = string.replace(string2, string3 + "=");
            list.add(string4);
        }
    }

    public void setCommandString(String string) {
        this.arguments.put(ARG_COMMAND, string);
    }

    public String getHelp() {
        StringBuilder stringBuilder = new StringBuilder(100);
        List<String> list = this.getRegisteredArguments();
        stringBuilder.append("Available parameters:\n");
        for (String string : list) {
            ArgumentType argumentType = this.getArgumentType(string);
            stringBuilder.append('-');
            stringBuilder.append(string);
            if (argumentType == ArgumentType.BoolArgument) {
                stringBuilder.append(" (true/false)");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

