/*
 * Decompiled with CFR 0.152.
 */
package workbench.console;

import workbench.db.WbConnection;
import workbench.sql.ScriptCommandDefinition;
import workbench.sql.parser.ParserType;
import workbench.sql.parser.ScriptParser;

public class InputBuffer {
    private StringBuilder script;
    private ScriptParser parser;
    private ParserType parserType = ParserType.Standard;

    public InputBuffer() {
        this.script = new StringBuilder(1000);
        this.parser = new ScriptParser(this.parserType);
    }

    public void setConnection(WbConnection wbConnection) {
        if (wbConnection == null) {
            return;
        }
        this.setDbId(wbConnection.getDbId());
        this.parser.setAlternateDelimiter(wbConnection.getAlternateDelimiter());
    }

    public void setDbId(String string) {
        ParserType parserType = ParserType.getTypeFromDBID(string);
        if (parserType != this.parserType) {
            this.parser = new ScriptParser(parserType);
            this.parserType = parserType;
        }
    }

    public String getScript() {
        return this.script.toString();
    }

    public int getLength() {
        return this.script.length();
    }

    public void clear() {
        this.script.setLength(0);
    }

    public boolean addLine(String string) {
        this.script.append('\n');
        this.script.append(string);
        return this.isComplete();
    }

    public boolean isComplete() {
        String string = this.script.toString();
        this.parser.setScript(string);
        this.parser.startIterator();
        ScriptCommandDefinition scriptCommandDefinition = this.parser.getNextCommandDefinition();
        if (scriptCommandDefinition == null) {
            return false;
        }
        if (scriptCommandDefinition.getDelimiterNeeded()) {
            return scriptCommandDefinition.getDelimiterUsed() != null;
        }
        return true;
    }
}

