/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.SQLException;
import java.util.Objects;
import workbench.db.DbObject;
import workbench.db.WbConnection;
import workbench.util.StringUtil;

public class CatalogIdentifier
implements DbObject {
    private String catalogName;
    private String typeName = "CATALOG";

    public CatalogIdentifier(String string) {
        this.catalogName = string;
    }

    public void setCatalog(String string) {
        this.catalogName = string;
    }

    public void setTypeName(String string) {
        if (StringUtil.isNonBlank(string)) {
            this.typeName = string.trim().toUpperCase();
        }
    }

    @Override
    public String getCatalog() {
        return this.catalogName;
    }

    @Override
    public String getSchema() {
        return null;
    }

    @Override
    public String getObjectType() {
        return this.typeName;
    }

    @Override
    public String getObjectName() {
        return this.catalogName;
    }

    @Override
    public void setName(String string) {
        this.catalogName = string;
    }

    @Override
    public String getObjectName(WbConnection wbConnection) {
        return wbConnection.getMetadata().quoteObjectname(this.catalogName);
    }

    @Override
    public String getObjectExpression(WbConnection wbConnection) {
        return this.getObjectName(wbConnection);
    }

    @Override
    public String getFullyQualifiedName(WbConnection wbConnection) {
        return this.getObjectName(wbConnection);
    }

    @Override
    public CharSequence getSource(WbConnection wbConnection) throws SQLException {
        return null;
    }

    @Override
    public String getObjectNameForDrop(WbConnection wbConnection) {
        return this.getObjectName(wbConnection);
    }

    @Override
    public String getComment() {
        return null;
    }

    @Override
    public void setComment(String string) {
    }

    @Override
    public String getDropStatement(WbConnection wbConnection, boolean bl) {
        if (wbConnection == null) {
            return null;
        }
        if (wbConnection.getMetadata().isSqlServer() && this.catalogName != null) {
            return "use master;\ndrop schema " + wbConnection.getMetadata().quoteObjectname(this.catalogName) + ";";
        }
        return null;
    }

    public int hashCode() {
        int n = 3;
        n = 53 * n + Objects.hashCode(this.catalogName);
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CatalogIdentifier catalogIdentifier = (CatalogIdentifier)object;
        return Objects.equals(this.catalogName, catalogIdentifier.catalogName);
    }

    public String toString() {
        return this.catalogName;
    }

    @Override
    public boolean supportsGetSource() {
        return false;
    }
}

