/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DbObject;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.sqltemplates.TemplateHandler;
import workbench.interfaces.ObjectDropper;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.RowActionMonitor;
import workbench.util.StringUtil;

public class ColumnDropper
implements ObjectDropper {
    private WbConnection conn;
    private List<ColumnIdentifier> columns;
    private TableIdentifier table;
    private boolean cancelDrop = false;
    private Statement currentStatement;

    public ColumnDropper() {
    }

    public ColumnDropper(WbConnection wbConnection, TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        this.conn = wbConnection;
        this.columns = list;
        this.table = tableIdentifier;
    }

    @Override
    public void setRowActionMonitor(RowActionMonitor rowActionMonitor) {
    }

    @Override
    public boolean supportsCascade() {
        return false;
    }

    @Override
    public void setCascade(boolean bl) {
    }

    @Override
    public boolean supportsFKSorting() {
        return false;
    }

    @Override
    public void cancel() throws SQLException {
        this.cancelDrop = true;
        if (this.currentStatement != null) {
            this.currentStatement.cancel();
        }
    }

    @Override
    public WbConnection getConnection() {
        return this.conn;
    }

    @Override
    public void setConnection(WbConnection wbConnection) {
        this.conn = wbConnection;
    }

    @Override
    public void setObjectTable(TableIdentifier tableIdentifier) {
        this.table = tableIdentifier;
    }

    @Override
    public List<? extends DbObject> getObjects() {
        return this.columns;
    }

    @Override
    public void setObjects(List<? extends DbObject> list) {
        this.columns = new ArrayList<ColumnIdentifier>();
        if (list == null) {
            return;
        }
        for (DbObject dbObject : list) {
            if (!(dbObject instanceof ColumnIdentifier)) continue;
            this.columns.add((ColumnIdentifier)dbObject);
        }
    }

    @Override
    public CharSequence getScript() {
        List<String> list = ColumnDropper.getSql(this.table, this.columns, this.conn);
        StringBuffer stringBuffer = new StringBuffer(list.size() * 40);
        boolean bl = this.conn != null ? this.conn.shouldCommitDDL() : false;
        for (String string : list) {
            stringBuffer.append(string);
            stringBuffer.append(";\n");
        }
        if (bl) {
            stringBuffer.append("COMMIT;\n");
        }
        return stringBuffer;
    }

    @Override
    public void dropObjects() throws SQLException {
        if (this.conn == null) {
            return;
        }
        if (this.table == null) {
            return;
        }
        if (this.columns == null || this.columns.isEmpty()) {
            LogMgr.logWarning(new CallerInfo(){}, "No columns to drop!");
            return;
        }
        List<String> list = ColumnDropper.getSql(this.table, this.columns, this.conn);
        if (list.isEmpty()) {
            LogMgr.logWarning(new CallerInfo(){}, "No statements generated!");
            return;
        }
        try {
            this.currentStatement = this.conn.createStatement();
            for (String string : list) {
                if (this.cancelDrop) break;
                LogMgr.logDebug(new CallerInfo(){}, "Statement to drop column(s): " + string);
                this.currentStatement.executeUpdate(string);
            }
            if (this.conn.shouldCommitDDL()) {
                if (this.cancelDrop) {
                    this.conn.rollback();
                } else {
                    this.conn.commit();
                }
            }
        }
        catch (SQLException sQLException) {
            if (this.conn.shouldCommitDDL()) {
                this.conn.rollback();
            }
            throw sQLException;
        }
        finally {
            JdbcUtils.closeStatement(this.currentStatement);
            this.currentStatement = null;
        }
    }

    @Override
    public CharSequence getDropForObject(DbObject dbObject, boolean bl) {
        return null;
    }

    @Override
    public CharSequence getDropForObject(DbObject dbObject) {
        return null;
    }

    public static List<String> getSql(TableIdentifier tableIdentifier, List<ColumnIdentifier> list, WbConnection wbConnection) {
        String string = wbConnection.getDbSettings().getDropMultipleColumnSql();
        String string2 = wbConnection.getDbSettings().getDropSingleColumnSql();
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        if (list.size() == 1 || StringUtil.isEmptyString(string)) {
            string2 = TemplateHandler.replaceTablePlaceholder(string2, tableIdentifier, wbConnection);
            for (ColumnIdentifier columnIdentifier : list) {
                arrayList.add(StringUtil.replace(string2, "%column_name%", columnIdentifier.getColumnName(wbConnection)));
            }
        } else {
            string = TemplateHandler.replaceTablePlaceholder(string, tableIdentifier, wbConnection);
            StringBuilder stringBuilder = new StringBuilder(list.size());
            int n = 0;
            for (ColumnIdentifier columnIdentifier : list) {
                if (n > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(columnIdentifier.getColumnName(wbConnection));
                ++n;
            }
            arrayList.add(StringUtil.replace(string, "%columnlist%", stringBuilder.toString()));
        }
        return arrayList;
    }

    @Override
    public boolean supportsObject(DbObject dbObject) {
        return dbObject instanceof ColumnIdentifier;
    }
}

