/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import workbench.db.WbConnection;

public enum DBID {
    Oracle("oracle"),
    Postgres("postgresql"),
    SQL_Server("microsoft_sql_server"),
    Vertica("vertica_database"),
    MySQL("mysql"),
    MariaDB("mariadb"),
    Firebird("firebird"),
    DB2_LUW("db2"),
    DB2_ISERIES("db2i"),
    DB2_ZOS("db2h"),
    SQLite("sqlite"),
    SQL_Anywhere("sql_anywhere"),
    Teradata("teradata"),
    H2("h2"),
    HSQLDB("hsql_database_engine"),
    Derby("apache_derby"),
    OPENEDGE("openedge"),
    Greenplum("greenplum"),
    HANA("hdb"),
    Cubrid("cubrid"),
    Informix("informix_dynamic_server"),
    Exasol("exasolution"),
    SAP_DB("sap_db"),
    Clickhouse("clickhouse"),
    MonetDB("monetdb"),
    Ingres("ingres"),
    Redshift("redshift"),
    CockroachDB("cockroachdb"),
    UCanAccess("ucanaccess"),
    Unknown("_$unknown$_");

    private String dbid;

    private DBID(String string2) {
        this.dbid = string2;
    }

    public String getId() {
        return this.dbid;
    }

    public boolean isDB(String string) {
        return this.dbid.equalsIgnoreCase(string);
    }

    public boolean isDB(WbConnection wbConnection) {
        if (wbConnection == null) {
            return false;
        }
        return this.dbid.equalsIgnoreCase(wbConnection.getDbId());
    }

    public static DBID fromConnection(WbConnection wbConnection) {
        if (wbConnection == null) {
            return Unknown;
        }
        return DBID.fromID(wbConnection.getDbId());
    }

    public static DBID fromID(String string) {
        for (DBID dBID : DBID.values()) {
            if (!dBID.isDB(string)) continue;
            return dBID;
        }
        return Unknown;
    }

    public static String generateId(String string) {
        String string2 = string.replaceAll("[ \\(\\)\\[\\]/$,.'=\"]", "_").toLowerCase();
        if (string.startsWith("DB2")) {
            string2 = string.contains("AS/400") || string.contains("iSeries") ? DB2_ISERIES.getId() : (string.equals("DB2") ? DB2_ZOS.getId() : DB2_LUW.getId());
        } else if (string.startsWith("HSQL")) {
            string2 = "hsql_database_engine";
        } else if (string.toLowerCase().contains("ucanaccess")) {
            string2 = "ucanaccess";
        }
        return string2;
    }
}

