/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import workbench.db.CatalogInformationReader;
import workbench.db.ColumnIdentifier;
import workbench.db.DBID;
import workbench.db.DataTypeResolver;
import workbench.db.DbObject;
import workbench.db.DbObjectFinder;
import workbench.db.DbSettings;
import workbench.db.DefaultDataTypeResolver;
import workbench.db.GenericCatalogInformationReader;
import workbench.db.GenericSchemaInfoReader;
import workbench.db.IdentifierCase;
import workbench.db.IndexReader;
import workbench.db.JdbcTableDefinitionReader;
import workbench.db.JdbcUtils;
import workbench.db.MetaDataSqlManager;
import workbench.db.ObjectListAppender;
import workbench.db.ObjectListCleaner;
import workbench.db.ObjectListEnhancer;
import workbench.db.ObjectListExtender;
import workbench.db.ObjectListFilter;
import workbench.db.ObjectNameFilter;
import workbench.db.ProcedureReader;
import workbench.db.QuoteHandler;
import workbench.db.ReaderFactory;
import workbench.db.SchemaInformationReader;
import workbench.db.SelectIntoVerifier;
import workbench.db.SequenceDefinition;
import workbench.db.SequenceReader;
import workbench.db.SynonymReader;
import workbench.db.TableColumnsDatastore;
import workbench.db.TableDefinition;
import workbench.db.TableDefinitionReader;
import workbench.db.TableIdentifier;
import workbench.db.TableListSorter;
import workbench.db.ViewReader;
import workbench.db.WbConnection;
import workbench.db.derby.DerbyTypeReader;
import workbench.db.firebird.FirebirdDomainReader;
import workbench.db.greenplum.GreenplumObjectListCleaner;
import workbench.db.greenplum.GreenplumObjectListEnhancer;
import workbench.db.greenplum.GreenplumUtil;
import workbench.db.h2database.H2ConstantReader;
import workbench.db.h2database.H2DomainReader;
import workbench.db.hana.HanaTableDefinitionReader;
import workbench.db.hsqldb.HsqlDataTypeResolver;
import workbench.db.hsqldb.HsqlTypeReader;
import workbench.db.ibm.DB2TempTableReader;
import workbench.db.ibm.DB2TypeReader;
import workbench.db.ibm.Db2iObjectListEnhancer;
import workbench.db.ibm.Db2iVariableReader;
import workbench.db.ibm.InformixDataTypeResolver;
import workbench.db.mssql.SqlServerDataTypeResolver;
import workbench.db.mssql.SqlServerObjectListEnhancer;
import workbench.db.mssql.SqlServerRuleReader;
import workbench.db.mssql.SqlServerSchemaInfoReader;
import workbench.db.mssql.SqlServerTableDefinitionReader;
import workbench.db.mssql.SqlServerTypeReader;
import workbench.db.mssql.SqlServerUtil;
import workbench.db.mysql.MySQLTableCommentReader;
import workbench.db.nuodb.NuoDBDomainReader;
import workbench.db.objectcache.Namespace;
import workbench.db.oracle.DbmsOutput;
import workbench.db.oracle.OracleDataTypeResolver;
import workbench.db.oracle.OracleObjectListEnhancer;
import workbench.db.oracle.OracleTableDefinitionReader;
import workbench.db.oracle.OracleTypeReader;
import workbench.db.oracle.OracleUtils;
import workbench.db.postgres.PostgresCollationReader;
import workbench.db.postgres.PostgresDataTypeResolver;
import workbench.db.postgres.PostgresDomainReader;
import workbench.db.postgres.PostgresEnumReader;
import workbench.db.postgres.PostgresEventTriggerReader;
import workbench.db.postgres.PostgresExtensionReader;
import workbench.db.postgres.PostgresForeignServerReader;
import workbench.db.postgres.PostgresObjectListCleaner;
import workbench.db.postgres.PostgresPublicationReader;
import workbench.db.postgres.PostgresRangeTypeReader;
import workbench.db.postgres.PostgresRuleReader;
import workbench.db.postgres.PostgresSubscriptionReader;
import workbench.db.postgres.PostgresTypeReader;
import workbench.db.postgres.PostgresUtil;
import workbench.db.progress.OpenEdgeObjectListEnhancer;
import workbench.db.progress.OpenEdgeSchemaInformationReader;
import workbench.db.sqlite.SQLiteDataTypeResolver;
import workbench.db.vertica.VerticaTableDefinitionReader;
import workbench.db.vertica.VerticaTableReader;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.syntax.SqlKeywordHelper;
import workbench.storage.DataStore;
import workbench.storage.DatastoreTransposer;
import workbench.storage.RowDataListSorter;
import workbench.storage.SortDefinition;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.VersionNumber;

public class DbMetadata
implements QuoteHandler {
    public static final String MVIEW_NAME = "MATERIALIZED VIEW";
    public static final String RESULT_COL_REMARKS = "REMARKS";
    public static final String RESULT_COL_OBJECT_NAME = "NAME";
    public static final String RESULT_COL_TYPE = "TYPE";
    public static final String RESULT_COL_CATALOG = "CATALOG";
    public static final String RESULT_COL_SCHEMA = "SCHEMA";
    public static final int COLUMN_IDX_TABLE_LIST_NAME = 0;
    public static final int COLUMN_IDX_TABLE_LIST_TYPE = 1;
    public static final int COLUMN_IDX_TABLE_LIST_CATALOG = 2;
    public static final int COLUMN_IDX_TABLE_LIST_SCHEMA = 3;
    public static final int COLUMN_IDX_TABLE_LIST_REMARKS = 4;
    private final String[] EMPTY_STRING_ARRAY = new String[0];
    private final Object readerLock = new Object();
    private String schemaTerm;
    private String catalogTerm;
    private String productName;
    private String dbId;
    private MetaDataSqlManager metaSqlMgr;
    private DatabaseMetaData metaData;
    private WbConnection dbConnection;
    private ObjectListEnhancer objectListEnhancer;
    private TableDefinitionReader definitionReader;
    private DataTypeResolver dataTypeResolver;
    private SchemaInformationReader schemaInfoReader;
    private CatalogInformationReader catalogInfoReader;
    private IndexReader indexReader;
    private List<ObjectListExtender> extenders = new ArrayList<ObjectListExtender>();
    private List<ObjectListAppender> appenders = new ArrayList<ObjectListAppender>();
    private List<ObjectListCleaner> cleaners = new ArrayList<ObjectListCleaner>(1);
    private DbmsOutput oraOutput;
    private boolean isOracle;
    private boolean isPostgres;
    private boolean isHsql;
    private boolean isFirebird;
    private boolean isSqlServer;
    private boolean isMySql;
    private boolean isMariaDB;
    private boolean isApacheDerby;
    private boolean isExcel;
    private boolean isAccess;
    private boolean isH2;
    private String quoteCharacter;
    private final Set<String> keywords = CollectionUtil.caseInsensitiveSet();
    private final Set<String> reservedWords = CollectionUtil.caseInsensitiveSet();
    private String baseTableTypeName;
    private String mviewTypeName;
    private Set<String> tableTypesList;
    private String[] tableTypesArray;
    private String[] selectableTypes;
    private Set<String> schemasToIgnore;
    private Set<String> catalogsToIgnore;
    private DbSettings dbSettings;
    private final char catalogSeparator;
    private SelectIntoVerifier selectIntoVerifier;
    private Set<String> objectTypesFromDriver;
    private int maxTableNameLength;
    private boolean supportsGetSchema = true;
    private Pattern identifierPattern;

    public DbMetadata(WbConnection wbConnection) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.dbConnection = wbConnection;
        this.metaData = wbConnection.getSqlConnection().getMetaData();
        String string = this.dbConnection.getId();
        CallerInfo callerInfo = new CallerInfo(){};
        try {
            this.schemaTerm = this.metaData.getSchemaTerm();
            LogMgr.logDebug(callerInfo, string + ": Schema term: " + this.schemaTerm);
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(callerInfo, string + ": Could not retrieve Schema term: " + throwable.getMessage());
            this.schemaTerm = "Schema";
        }
        try {
            this.catalogTerm = this.metaData.getCatalogTerm();
            LogMgr.logDebug(callerInfo, string + ": Catalog term: " + this.catalogTerm);
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(callerInfo, string + ": Could not retrieve Catalog term: " + throwable.getMessage());
            this.catalogTerm = "Catalog";
        }
        if (StringUtil.isBlank(this.schemaTerm)) {
            this.schemaTerm = "Schema";
        }
        if (StringUtil.isBlank(this.catalogTerm)) {
            this.catalogTerm = "Catalog";
        }
        try {
            this.productName = this.metaData.getDatabaseProductName();
        }
        catch (Throwable throwable) {
            this.productName = JdbcUtils.getDBMSName(wbConnection.getProfile().getUrl());
            LogMgr.logWarning(callerInfo, string + ": Could not retrieve database product name. Using name from JDBC URL: " + this.productName, throwable);
        }
        String string2 = this.productName.toLowerCase();
        VersionNumber versionNumber = null;
        if (string2.contains("greenplum") || string2.contains("postgres") && PostgresUtil.isGreenplum(this.dbConnection.getSqlConnection())) {
            this.dbId = DBID.Greenplum.getId();
            this.dataTypeResolver = new PostgresDataTypeResolver();
            this.extenders.add(new PostgresRuleReader());
            this.extenders.add(new PostgresDomainReader());
            this.extenders.add(new PostgresTypeReader());
            this.objectListEnhancer = new GreenplumObjectListEnhancer();
            versionNumber = GreenplumUtil.getDatabaseVersion(this.dbConnection);
            if (JdbcUtils.hasMinimumServerVersion(versionNumber, "5.0")) {
                this.extenders.add(new PostgresEnumReader());
                this.extenders.add(new PostgresExtensionReader());
            }
            this.cleaners.add(new GreenplumObjectListCleaner());
        } else if (string2.contains("redshift") || string2.contains("postgres") && PostgresUtil.isRedshift(this.dbConnection)) {
            this.isPostgres = true;
            object4 = new PostgresDataTypeResolver();
            ((PostgresDataTypeResolver)object4).setFixTimestampTZ(JdbcUtils.hasMiniumDriverVersion(this.dbConnection, "1.0"));
            this.dataTypeResolver = object4;
            this.mviewTypeName = MVIEW_NAME;
            this.extenders.add(new PostgresDomainReader());
            this.extenders.add(new PostgresRuleReader());
            object3 = new PostgresTypeReader();
            this.objectListEnhancer = object3;
            this.extenders.add((ObjectListExtender)object3);
            this.dbId = DBID.Redshift.getId();
            LogMgr.logInfo(callerInfo, string + ": Using DBID=" + this.dbId);
        } else if (string2.contains("postgres") && Settings.getInstance().checkCockroachDBConnection() && PostgresUtil.isCockroachDB(this.dbConnection.getSqlConnection())) {
            this.dbId = DBID.CockroachDB.getId();
            this.isPostgres = false;
        } else if (string2.contains("postgres")) {
            this.isPostgres = true;
            this.dbId = DBID.Postgres.getId();
            object4 = new PostgresDataTypeResolver();
            ((PostgresDataTypeResolver)object4).setFixTimestampTZ(JdbcUtils.hasMiniumDriverVersion(this.dbConnection, "42.0"));
            this.dataTypeResolver = object4;
            this.mviewTypeName = MVIEW_NAME;
            this.extenders.add(new PostgresDomainReader());
            if (JdbcUtils.hasMinimumServerVersion(this.dbConnection, "8.3")) {
                this.extenders.add(new PostgresEnumReader());
            }
            if (JdbcUtils.hasMinimumServerVersion(this.dbConnection, "8.4")) {
                this.extenders.add(new PostgresForeignServerReader());
            }
            if (JdbcUtils.hasMinimumServerVersion(this.dbConnection, "9.1")) {
                this.extenders.add(new PostgresExtensionReader());
                this.extenders.add(new PostgresEventTriggerReader());
                this.extenders.add(new PostgresCollationReader());
            }
            if (JdbcUtils.hasMinimumServerVersion(this.dbConnection, "10")) {
                this.extenders.add(new PostgresPublicationReader());
                this.extenders.add(new PostgresSubscriptionReader());
            }
            this.extenders.add(new PostgresRuleReader());
            object3 = new PostgresTypeReader();
            this.objectListEnhancer = object3;
            this.extenders.add((ObjectListExtender)object3);
            if (JdbcUtils.hasMinimumServerVersion(this.dbConnection, "9.2") && PostgresRangeTypeReader.retrieveRangeTypes()) {
                this.extenders.add(new PostgresRangeTypeReader());
            }
            if (JdbcUtils.hasMinimumServerVersion(this.dbConnection, "10.0")) {
                this.cleaners.add(new PostgresObjectListCleaner());
            }
        } else if (string2.contains("oracle") && !string2.contains("lite ordbms")) {
            this.isOracle = true;
            this.dbId = DBID.Oracle.getId();
            this.mviewTypeName = MVIEW_NAME;
            this.dataTypeResolver = new OracleDataTypeResolver(wbConnection);
            this.definitionReader = new OracleTableDefinitionReader(wbConnection, (OracleDataTypeResolver)this.dataTypeResolver);
            this.extenders.add(new OracleTypeReader());
            this.objectListEnhancer = new OracleObjectListEnhancer();
        } else if (string2.contains("hsql") && !string2.startsWith("ucanaccess")) {
            this.isHsql = true;
            this.dbId = DBID.HSQLDB.getId();
            this.dataTypeResolver = new HsqlDataTypeResolver();
            if (JdbcUtils.hasMinimumServerVersion(this.dbConnection, "2.2")) {
                this.extenders.add(new HsqlTypeReader());
            }
        } else if (string2.contains("firebird")) {
            this.isFirebird = true;
            this.dbId = DBID.Firebird.getId();
            this.extenders.add(new FirebirdDomainReader());
        } else if (string2.contains("microsoft") && string2.contains("sql server")) {
            this.isSqlServer = true;
            this.dbId = DBID.SQL_Server.getId();
            if (SqlServerTypeReader.versionSupportsTypes(this.dbConnection)) {
                this.extenders.add(new SqlServerTypeReader());
            }
            if (SqlServerUtil.isSqlServer2000(this.dbConnection)) {
                this.extenders.add(new SqlServerRuleReader());
            }
            this.definitionReader = new SqlServerTableDefinitionReader(this.dbConnection);
            this.objectListEnhancer = new SqlServerObjectListEnhancer();
            this.dataTypeResolver = new SqlServerDataTypeResolver();
            if (Settings.getInstance().getBoolProperty("workbench.db.microsoft_sql_server.use.schemareader", true) && SqlServerUtil.isSqlServer2005(this.dbConnection)) {
                this.schemaInfoReader = new SqlServerSchemaInfoReader(this.dbConnection);
            }
        } else if (string2.contains("db2")) {
            this.dbId = DBID.generateId(this.productName);
            if (this.dbId.equals(DBID.DB2_LUW.getId())) {
                this.extenders.add(new DB2TypeReader());
                this.appenders.add(new DB2TempTableReader());
            }
            if (this.dbId.equals(DBID.DB2_ISERIES.getId())) {
                this.objectListEnhancer = new Db2iObjectListEnhancer();
                this.extenders.add(new Db2iVariableReader());
            }
        } else if (string2.contains("mysql")) {
            this.objectListEnhancer = new MySQLTableCommentReader();
            this.isMySql = true;
            this.dbId = DBID.MySQL.getId();
            object4 = this.dbConnection.getDatabaseProductVersion();
            if (((String)object4).toLowerCase().contains("mariadb")) {
                this.dbId = DBID.MariaDB.getId();
                this.isMariaDB = true;
            }
        } else if (string2.contains("derby")) {
            this.isApacheDerby = true;
            this.dbId = DBID.Derby.getId();
            if (JdbcUtils.hasMinimumServerVersion(this.dbConnection, "10.6")) {
                this.extenders.add(new DerbyTypeReader());
            }
        } else if (string2.equals("nuodb")) {
            this.extenders.add(new NuoDBDomainReader());
        } else if (string2.contains("sqlite")) {
            this.dbId = DBID.SQLite.getId();
            this.dataTypeResolver = new SQLiteDataTypeResolver();
        } else if (string2.contains("excel")) {
            this.isExcel = true;
        } else if (string2.contains("access")) {
            this.isAccess = true;
        } else if (string2.equals("h2")) {
            this.isH2 = true;
            this.dbId = DBID.H2.getId();
            this.extenders.add(new H2DomainReader());
            this.extenders.add(new H2ConstantReader());
        } else if (string2.contains("informix") || Settings.getInstance().getInformixProductNames().contains(this.productName)) {
            this.dbId = DBID.Informix.getId();
            this.dataTypeResolver = new InformixDataTypeResolver();
        } else if (string2.equals("vertica database")) {
            this.dbId = DBID.Vertica.getId();
            this.definitionReader = new VerticaTableDefinitionReader(wbConnection);
            this.extenders.add(new VerticaTableReader());
        } else if (string2.contains("openedge")) {
            this.dbId = DBID.OPENEDGE.getId();
            this.objectListEnhancer = new OpenEdgeObjectListEnhancer();
            if (Settings.getInstance().getBoolProperty("workbench.db.openedge.check.defaultschema", true)) {
                this.schemaInfoReader = new OpenEdgeSchemaInformationReader(this.dbConnection);
            }
        } else if (string2.equals("hdb")) {
            this.dbId = DBID.HANA.getId();
            this.definitionReader = new HanaTableDefinitionReader(wbConnection);
        }
        if (this.dataTypeResolver == null) {
            this.dataTypeResolver = new DefaultDataTypeResolver();
        }
        if (this.definitionReader == null) {
            this.definitionReader = new JdbcTableDefinitionReader(this.dbConnection);
        }
        try {
            this.quoteCharacter = this.metaData.getIdentifierQuoteString();
            LogMgr.logDebug(callerInfo, string + ": Identifier quote character obtained from driver: " + this.quoteCharacter);
        }
        catch (Throwable throwable) {
            this.quoteCharacter = null;
            LogMgr.logError(callerInfo, string + ": Error when retrieving identifier quote character", throwable);
        }
        if (this.dbId == null) {
            this.dbId = DBID.generateId(this.productName);
        }
        LogMgr.logInfo(callerInfo, string + ": Using DBID=" + this.dbId);
        if (versionNumber == null) {
            versionNumber = wbConnection.getDatabaseVersion(this.dbId);
        }
        this.dbSettings = new DbSettings(this.dbId, versionNumber.getMajorVersion(), versionNumber.getMinorVersion());
        object4 = this.dbSettings.getIdentifierQuoteString();
        if (object4 != null) {
            this.quoteCharacter = "<none>".equals(object4) ? "" : object4;
            LogMgr.logDebug(callerInfo, string + ": Using configured identifier quote character: >" + this.quoteCharacter + "<");
        }
        if (StringUtil.isBlank(this.quoteCharacter)) {
            this.quoteCharacter = "\"";
        }
        LogMgr.logInfo(callerInfo, string + ": Using identifier quote character: " + this.quoteCharacter);
        LogMgr.logInfo(callerInfo, string + ": Using search string escape character: " + this.getSearchStringEscape());
        this.baseTableTypeName = this.dbSettings.getProperty("basetype.table", "TABLE");
        object3 = new ArrayList<String>(this.retrieveTableTypes());
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            object2 = ((String)iterator.next()).toLowerCase();
            if (!((String)object2).contains("view") || ((String)object2).equalsIgnoreCase("materialized view")) continue;
            iterator.remove();
        }
        this.tableTypesList = CollectionUtil.caseInsensitiveSet((Collection<String>)object3);
        this.tableTypesList.remove("SYNONYM");
        this.tableTypesArray = StringUtil.toArray(this.tableTypesList, true);
        object2 = this.getObjectsWithData();
        if (!this.dbSettings.includeSystemTablesInSelectable()) {
            object = object2.iterator();
            while (object.hasNext()) {
                String string3 = (String)object.next();
                if (!string3.toUpperCase().contains("SYSTEM")) continue;
                object.remove();
            }
        }
        this.selectableTypes = StringUtil.toArray((Collection<String>)object2, true);
        this.selectIntoVerifier = new SelectIntoVerifier(this.dbId);
        object = this.getDbSettings().getCatalogSeparator();
        if (object == null) {
            try {
                object = this.metaData.getCatalogSeparator();
            }
            catch (Exception exception) {
                LogMgr.logError(callerInfo, string + ": Could not retrieve catalog separator", exception);
            }
        }
        this.catalogSeparator = StringUtil.isBlank((CharSequence)object) ? (char)46 : ((String)object).charAt(0);
        LogMgr.logInfo(callerInfo, string + ": Using catalog separator: " + this.catalogSeparator);
        try {
            this.maxTableNameLength = this.metaData.getMaxTableNameLength();
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(callerInfo, string + ": Driver does not support getMaxTableNameLength()", throwable);
            this.maxTableNameLength = 0;
        }
        this.initIdentifierPattern();
        if (this.schemaInfoReader == null) {
            this.schemaInfoReader = new GenericSchemaInfoReader(this.dbConnection, this.dbSettings);
        }
        this.catalogInfoReader = new GenericCatalogInformationReader(this.dbConnection, this.dbSettings);
        this.logConfiguredTableTypes();
    }

    private void logConfiguredTableTypes() {
        List<String> list = this.dbSettings.getListProperty("tabletypes");
        if (list.size() > 0) {
            LogMgr.logDebug(new CallerInfo(){}, this.getConnId() + ": Using configured table types: " + list);
        }
    }

    private void initIdentifierPattern() {
        String string = this.getDbSettings().getProperty("identifier.pattern", null);
        if (string != null) {
            try {
                this.identifierPattern = Pattern.compile(string);
                LogMgr.logInfo(new CallerInfo(){}, this.getConnId() + ": Using regular expression for valid identifiers: " + string);
            }
            catch (Exception exception) {
                LogMgr.logWarning(new CallerInfo(){}, this.getConnId() + ": Could not compile pattern: " + string, exception);
            }
        }
    }

    public int getMaxTableNameLength() {
        return this.maxTableNameLength;
    }

    public final String getSearchStringEscape() {
        String string = this.getDbSettings().getSearchStringEscape();
        if (string != null) {
            return string;
        }
        try {
            return this.metaData.getSearchStringEscape();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public char getCatalogSeparator() {
        return this.catalogSeparator;
    }

    public char getSchemaSeparator() {
        if (this.dbSettings.useCatalogSeparatorForSchema()) {
            return this.getCatalogSeparator();
        }
        String string = this.dbSettings.getSchemaSeparator();
        if (string == null) {
            return '.';
        }
        return string.charAt(0);
    }

    public MetaDataSqlManager getMetaDataSQLMgr() {
        if (this.metaSqlMgr == null) {
            this.metaSqlMgr = new MetaDataSqlManager(this.productName, this.dbId, this.dbConnection.getDatabaseVersion());
        }
        return this.metaSqlMgr;
    }

    public ProcedureReader getProcedureReader() {
        return ReaderFactory.getProcedureReader(this);
    }

    public ViewReader getViewReader() {
        return ReaderFactory.createViewReader(this.dbConnection);
    }

    @Override
    public String getIdentifierQuoteCharacter() {
        return this.quoteCharacter;
    }

    public char getIdentifierQuoteChar() {
        if (StringUtil.isBlank(this.quoteCharacter)) {
            return '\"';
        }
        return this.quoteCharacter.charAt(0);
    }

    public String getBaseTableTypeName() {
        return this.baseTableTypeName;
    }

    public String[] getTableTypesArray() {
        return Arrays.copyOf(this.tableTypesArray, this.tableTypesArray.length);
    }

    public String[] getTablesAndViewTypes() {
        ArrayList<String> arrayList = new ArrayList<String>(this.tableTypesList);
        arrayList.addAll(this.getDbSettings().getViewTypes());
        return arrayList.toArray(this.EMPTY_STRING_ARRAY);
    }

    public String[] getSelectableTypes() {
        return Arrays.copyOf(this.selectableTypes, this.selectableTypes.length);
    }

    public List<String> getTableTypes() {
        return new ArrayList<String>(this.tableTypesList);
    }

    public boolean supportsMaterializedViews() {
        return this.mviewTypeName != null;
    }

    public String getMViewTypeName() {
        if (this.mviewTypeName == null) {
            return "";
        }
        return this.mviewTypeName;
    }

    public String getViewTypeName() {
        return "VIEW";
    }

    public DataTypeResolver getDataTypeResolver() {
        return this.dataTypeResolver;
    }

    public DatabaseMetaData getJdbcMetaData() {
        return this.metaData;
    }

    public WbConnection getWbConnection() {
        return this.dbConnection;
    }

    public Connection getSqlConnection() {
        return this.dbConnection.getSqlConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexReader getIndexReader() {
        Object object = this.readerLock;
        synchronized (object) {
            if (this.indexReader == null) {
                this.indexReader = ReaderFactory.getIndexReader(this);
            }
            return this.indexReader;
        }
    }

    public TableDefinitionReader getTableDefinitionReader() {
        return this.definitionReader;
    }

    public boolean objectTypeCanContainData(String string) {
        if (string == null) {
            return false;
        }
        return this.getObjectsWithData().contains(string);
    }

    public final Set<String> getObjectsWithData() {
        List<String> list;
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        set.addAll(this.retrieveTableTypes());
        set.addAll(this.getTableTypes());
        set.addAll(this.getDbSettings().getViewTypes());
        String string = "workbench.db.objecttype.selectable.";
        String string2 = Settings.getInstance().getProperty(string + "default", null);
        String string3 = Settings.getInstance().getProperty(string + this.dbId, string2);
        if (string3 != null) {
            list = StringUtil.stringToList(string3.toLowerCase(), ",", true, true);
            set.addAll(list);
        }
        if (set.isEmpty()) {
            set.add("table");
            set.add("view");
            set.add("system view");
            set.add("system table");
        }
        list = Settings.getInstance().getListProperty("workbench.db.objecttype.not.selectable." + this.dbId, false);
        set.removeAll(list);
        return set;
    }

    public final String getProductName() {
        return this.productName;
    }

    String getConnId() {
        if (this.dbConnection == null) {
            return "";
        }
        return this.dbConnection.getId();
    }

    public final String getDbId() {
        return this.dbId;
    }

    public final DbSettings getDbSettings() {
        return this.dbSettings;
    }

    public boolean isSelectIntoNewTable(String string) {
        return this.selectIntoVerifier.isSelectIntoNewTable(string);
    }

    public boolean supportsSelectIntoNewTable() {
        return this.selectIntoVerifier != null && this.selectIntoVerifier.supportsSelectIntoNewTable();
    }

    public boolean isMySql() {
        return this.isMySql;
    }

    public boolean isMariaDB() {
        return this.isMariaDB;
    }

    public boolean isPostgres() {
        return this.isPostgres;
    }

    public boolean isVertica() {
        return this.dbId.equals(DBID.Vertica.getId());
    }

    public boolean isOracle() {
        return this.isOracle;
    }

    public boolean isHsql() {
        return this.isHsql;
    }

    public boolean isFirebird() {
        return this.isFirebird;
    }

    public boolean isSqlServer() {
        return this.isSqlServer;
    }

    public boolean isApacheDerby() {
        return this.isApacheDerby;
    }

    public boolean isH2() {
        return this.isH2;
    }

    public boolean isDB2LuW() {
        return this.dbId.equals(DBID.DB2_LUW.getId());
    }

    public void clearIgnoredCatalogs() {
        this.catalogsToIgnore = null;
    }

    public void clearIgnoredSchemas() {
        this.schemasToIgnore = null;
    }

    public boolean ignoreSchema(String string) {
        return this.ignoreSchema(string, null);
    }

    public boolean ignoreSchema(String string, String string2) {
        if (StringUtil.isEmptyString(string)) {
            return true;
        }
        if (this.dbSettings.alwaysUseSchema()) {
            return false;
        }
        if (this.schemasToIgnore == null) {
            this.schemasToIgnore = this.readIgnored("schema", null);
        }
        if (this.schemasToIgnore.contains("$current")) {
            String string3;
            String string4 = string3 = string2 == null ? this.getCurrentSchema() : string2;
            if (string3 != null) {
                return SqlUtil.objectNamesAreEqual(string, string3);
            }
        }
        return this.schemasToIgnore.contains("*") || this.schemasToIgnore.contains(string);
    }

    private Set<String> readIgnored(String string, String string2) {
        String string3 = Settings.getInstance().getProperty("workbench.sql.ignore" + string + "." + this.dbId, string2);
        Set<String> set = string3 != null ? new TreeSet<String>(StringUtil.stringToList(string3, ",")) : Collections.emptySet();
        return set;
    }

    public void resetSchemasToIgnores() {
        this.schemasToIgnore = null;
    }

    public boolean needSchemaInDML(TableIdentifier tableIdentifier) {
        try {
            String string = tableIdentifier.getSchema();
            if (this.isOracle && "PUBLIC".equalsIgnoreCase(string)) {
                return false;
            }
            if (!this.dbSettings.supportsSchemas()) {
                return false;
            }
            if (this.dbSettings.alwaysUseSchema()) {
                return true;
            }
            String string2 = this.getCurrentSchema();
            if (string2 != null && !string2.equalsIgnoreCase(string)) {
                return true;
            }
            return !this.ignoreSchema(string, string2);
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    public boolean needCatalogInDML(TableIdentifier tableIdentifier) {
        String string;
        if (this.isAccess) {
            return true;
        }
        String string2 = tableIdentifier.getCatalog();
        if (StringUtil.isEmptyString(string2)) {
            return false;
        }
        if (this.isExcel) {
            String string3 = this.getCurrentCatalog();
            if (StringUtil.isEmptyString(string3)) {
                return true;
            }
            File file = new File(string2);
            File file2 = new File(string3);
            return !file.equals(file2);
        }
        if (!this.dbSettings.supportsCatalogs()) {
            return false;
        }
        if (!this.dbSettings.useCatalogInDML()) {
            return false;
        }
        if (this.dbSettings.alwaysUseCatalog()) {
            return true;
        }
        if (this.dbSettings.needsCatalogIfNoCurrent() && StringUtil.isEmptyString(string = this.getCurrentCatalog())) {
            return true;
        }
        return !this.ignoreCatalog(string2);
    }

    public boolean ignoreCatalog(String string) {
        return this.ignoreCatalog(string, null);
    }

    public boolean ignoreCatalog(String string, String string2) {
        if (string == null) {
            return true;
        }
        if (this.dbSettings.alwaysUseCatalog()) {
            return false;
        }
        if (!this.dbSettings.supportsCatalogs()) {
            return true;
        }
        if (this.catalogsToIgnore == null) {
            this.catalogsToIgnore = this.readIgnored("catalog", "$current");
        }
        if (this.catalogsToIgnore.contains("$current")) {
            String string3;
            String string4 = string3 = string2 == null ? this.getCurrentCatalog() : string2;
            if (string3 != null) {
                return SqlUtil.objectNamesAreEqual(string3, string);
            }
        }
        return this.catalogsToIgnore.contains("*") || this.catalogsToIgnore.contains(string);
    }

    public boolean supportsBatchUpdates() {
        try {
            return this.metaData.supportsBatchUpdates();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public String getObjectType(TableIdentifier tableIdentifier) {
        String string = null;
        try {
            DbObjectFinder dbObjectFinder = new DbObjectFinder(this);
            TableIdentifier tableIdentifier2 = tableIdentifier.createCopy();
            tableIdentifier2.adjustCase(this.dbConnection);
            tableIdentifier2.checkIsQuoted(this);
            TableIdentifier tableIdentifier3 = dbObjectFinder.findObject(tableIdentifier2);
            if (tableIdentifier3 != null) {
                string = tableIdentifier3.getType();
            }
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReservedWord(String string) {
        assert (this.dbId != null);
        Set<String> set = this.reservedWords;
        synchronized (set) {
            if (this.reservedWords.isEmpty()) {
                SqlKeywordHelper sqlKeywordHelper = new SqlKeywordHelper(this.dbId);
                this.reservedWords.addAll(sqlKeywordHelper.getReservedWords());
                this.reservedWords.addAll(sqlKeywordHelper.getOperators());
                if (this.dbSettings.getAliasId() != null) {
                    SqlKeywordHelper sqlKeywordHelper2 = new SqlKeywordHelper(this.dbSettings.getAliasId());
                    this.reservedWords.addAll(sqlKeywordHelper2.getReservedWords());
                    this.reservedWords.addAll(sqlKeywordHelper2.getOperators());
                }
            }
            return this.reservedWords.contains(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isKeyword(String string) {
        assert (this.dbId != null);
        Set<String> set = this.keywords;
        synchronized (set) {
            if (this.keywords.isEmpty()) {
                Object object;
                SqlKeywordHelper sqlKeywordHelper = new SqlKeywordHelper(this.dbId);
                this.keywords.addAll(sqlKeywordHelper.getKeywords());
                this.keywords.addAll(sqlKeywordHelper.getOperators());
                if (this.dbSettings.getAliasId() != null) {
                    object = new SqlKeywordHelper(this.dbSettings.getAliasId());
                    this.keywords.addAll(((SqlKeywordHelper)object).getKeywords());
                    this.keywords.addAll(((SqlKeywordHelper)object).getOperators());
                }
                try {
                    object = this.metaData.getSQLKeywords();
                    if (StringUtil.isNonBlank((CharSequence)object)) {
                        List<String> list = StringUtil.stringToList((String)object, ",");
                        this.keywords.addAll(list);
                    }
                }
                catch (Throwable throwable) {
                    LogMgr.logDebug(new CallerInfo(){}, this.getConnId() + ": Could not read SQL keywords from driver", throwable);
                }
            }
            return this.keywords.contains(string);
        }
    }

    @Override
    public boolean isQuoted(String string) {
        if (string == null) {
            return false;
        }
        if ((string = string.trim()).length() < 2) {
            return false;
        }
        if (string.startsWith(this.quoteCharacter)) {
            return true;
        }
        return this.isSqlServer && string.charAt(0) == '[' && string.charAt(string.length() - 1) == ']';
    }

    @Override
    public String removeQuotes(String string) {
        if (StringUtil.isEmptyString(string)) {
            return string;
        }
        string = string.trim();
        if (this.isSqlServer && string.startsWith("[") && string.endsWith("]")) {
            return string.substring(1, string.length() - 1);
        }
        return StringUtil.removeQuotes(string, this.quoteCharacter);
    }

    @Override
    public String quoteObjectname(String string) {
        return this.quoteObjectname(string, false);
    }

    @Override
    public String quoteObjectname(String string, boolean bl) {
        boolean bl2;
        if (StringUtil.isEmptyString(string)) {
            return null;
        }
        if (this.isQuoted(string)) {
            return string;
        }
        if (this.dbSettings.neverQuoteObjects()) {
            return this.removeQuotes(string);
        }
        boolean bl3 = bl2 = bl || this.needsQuotes(string);
        if (bl2) {
            StringBuilder stringBuilder = new StringBuilder(string.length() + this.quoteCharacter.length() * 2);
            stringBuilder.append(this.quoteCharacter);
            stringBuilder.append(string.trim());
            stringBuilder.append(this.quoteCharacter);
            return stringBuilder.toString();
        }
        return string;
    }

    @Override
    public boolean isLegalIdentifier(String string) {
        Matcher matcher = null;
        matcher = this.identifierPattern == null ? SqlUtil.SQL_IDENTIFIER.matcher(string) : this.identifierPattern.matcher(string);
        return matcher.matches();
    }

    @Override
    public boolean needsQuotes(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        if (this.isQuoted(string)) {
            return false;
        }
        if (string.indexOf(32) > -1) {
            return true;
        }
        if (!this.isLegalIdentifier(string)) {
            return true;
        }
        if (!this.storesMixedCaseIdentifiers()) {
            if (this.storesUpperCaseIdentifiers() && !StringUtil.isUpperCase(string)) {
                return true;
            }
            if (this.storesLowerCaseIdentifiers() && !StringUtil.isLowerCase(string)) {
                return true;
            }
        }
        return this.isReservedWord(string);
    }

    public String adjustSchemaNameCase(String string) {
        if (StringUtil.isBlank(string)) {
            return null;
        }
        if (this.isQuoted(string)) {
            return string.trim();
        }
        string = SqlUtil.removeObjectQuotes(string).trim();
        if (this.storesUpperCaseSchemas()) {
            return string.toUpperCase();
        }
        if (this.storesLowerCaseSchemas()) {
            return string.toLowerCase();
        }
        return string;
    }

    public boolean isDefaultCase(String string) {
        if (string == null) {
            return true;
        }
        if (this.storesMixedCaseIdentifiers()) {
            return true;
        }
        boolean bl = StringUtil.isUpperCase(string);
        boolean bl2 = StringUtil.isLowerCase(string);
        if (bl && this.storesUpperCaseIdentifiers()) {
            return true;
        }
        return bl2 && this.storesLowerCaseIdentifiers();
    }

    public String adjustObjectnameCase(String string) {
        if (string == null) {
            return null;
        }
        if (this.isQuoted(string)) {
            return string.trim();
        }
        try {
            if (this.storesMixedCaseIdentifiers()) {
                return string;
            }
            if (this.storesUpperCaseIdentifiers()) {
                return string.toUpperCase();
            }
            if (this.storesLowerCaseIdentifiers()) {
                return string.toLowerCase();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string.trim();
    }

    public String getCurrentSchema() {
        if (this.dbSettings.supportsSchemas() && this.schemaInfoReader.isSupported()) {
            return this.schemaInfoReader.getCurrentSchema();
        }
        String string = null;
        if (this.supportsGetSchema) {
            try {
                string = this.dbConnection.getSqlConnection().getSchema();
            }
            catch (Throwable throwable) {
                this.supportsGetSchema = false;
            }
        }
        return string;
    }

    public void clearCachedSchemaInformation() {
        this.schemaInfoReader.clearCache();
        this.catalogInfoReader.clearCache();
    }

    public String getSchemaToUse() {
        String string = this.getCurrentSchema();
        if (string == null) {
            return null;
        }
        if (this.ignoreSchema(string, string)) {
            return null;
        }
        return string;
    }

    public DataStore getObjects(String string, String string2, String[] stringArray) throws SQLException {
        return this.getObjects(string, string2, null, stringArray);
    }

    public String[] getTableListColumns() {
        return new String[]{RESULT_COL_OBJECT_NAME, RESULT_COL_TYPE, this.catalogTerm.toUpperCase(), this.schemaTerm.toUpperCase(), RESULT_COL_REMARKS};
    }

    public static String cleanupWildcards(String string) {
        if (StringUtil.isEmptyString(string)) {
            return null;
        }
        if ("*".equals(string) || "%".equals(string)) {
            return null;
        }
        return SqlUtil.removeObjectQuotes(StringUtil.replace(string, "*", "%"));
    }

    private Set<String> getExtenderTypes() {
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        for (ObjectListExtender objectListExtender : this.extenders) {
            set.addAll(objectListExtender.supportedTypes());
        }
        return set;
    }

    private String[] cleanupTypes(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        Set<String> set = this.getExtenderTypes();
        Collection<String> collection = this.retrieveTableTypes();
        for (String string : stringArray) {
            if (StringUtil.isBlank(string) || set.contains(string) || !collection.contains(string)) continue;
            arrayList.add(string);
        }
        String[] stringArray2 = new String[arrayList.size()];
        stringArray2 = arrayList.toArray(stringArray2);
        return stringArray2;
    }

    public DataStore createTableListDataStore() {
        final String[] stringArray = this.getTableListColumns();
        int[] nArray = new int[]{12, 12, 12, 12, 12};
        int[] nArray2 = new int[]{30, 12, 10, 10, 20};
        final boolean bl = this.isOracle && Settings.getInstance().getBoolProperty("workbench.db.oracle.sortmviewsastable", true);
        DataStore dataStore = new DataStore(stringArray, nArray, nArray2){

            @Override
            protected RowDataListSorter createSorter(SortDefinition sortDefinition) {
                TableListSorter tableListSorter = new TableListSorter(sortDefinition);
                tableListSorter.setSortMViewAsTable(bl);
                tableListSorter.setUseNaturalSort(this.useNaturalSort);
                int n = this.getResultInfo().findColumn(stringArray[1]);
                tableListSorter.setTypeColumnIndex(n);
                return tableListSorter;
            }
        };
        return dataStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataStore getObjects(String string, String string2, String string3, String[] stringArray) throws SQLException {
        DbObject dbObject;
        Object object;
        SequenceReader sequenceReader;
        string = DbMetadata.cleanupWildcards(string);
        string2 = DbMetadata.cleanupWildcards(string2);
        string3 = DbMetadata.cleanupWildcards(string3);
        DataStore dataStore = this.createTableListDataStore();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = DbMetadata.typeIncluded("SYNONYM", stringArray);
        ObjectListFilter objectListFilter = new ObjectListFilter(this.dbId);
        if (this.isOracle) {
            stringArray = OracleUtils.adjustTableTypes(this.dbConnection, stringArray);
        }
        String string4 = this.dbConnection.getSearchStringEscape();
        String string5 = string3;
        String string6 = string2;
        String string7 = SqlUtil.removeObjectQuotes(string);
        if (this.getDbSettings().supportsMetaDataWildcards()) {
            string5 = SqlUtil.escapeUnderscore(string3, string4);
        }
        if (this.getDbSettings().supportsMetaDataSchemaWildcards()) {
            string6 = SqlUtil.escapeUnderscore(string2, string4);
        }
        if (this.getDbSettings().supportsMetaDataCatalogWildcards()) {
            string7 = SqlUtil.escapeUnderscore(string, string4);
        }
        String string8 = (sequenceReader = this.getSequenceReader()) != null ? sequenceReader.getSequenceTypeName() : null;
        SynonymReader synonymReader = this.getSynonymReader();
        String string9 = "SYNONYM";
        if (synonymReader != null) {
            string9 = synonymReader.getSynonymTypeName();
        }
        if (!this.getDbSettings().supportsMetaDataNullPattern() && string5 == null) {
            string5 = "%";
        }
        ResultSet resultSet = null;
        try {
            object = StringUtil.toUpperCase(stringArray);
            if (this.getDbSettings().cleanupTypeList()) {
                object = this.cleanupTypes(stringArray);
            }
            if (Settings.getInstance().getDebugMetadataSql()) {
                LogMgr.logDebug(new CallerInfo(){}, this.getConnId() + ": Calling getTables() using: catalog=" + string7 + ", schema=" + string6 + ", name=" + string5 + ", types=" + (object == null ? "null" : Arrays.asList(object).toString()));
            }
            long l = System.currentTimeMillis();
            if ((object == null || ((String[])object).length > 0) && (resultSet = this.metaData.getTables(string7, string6, string5, (String[])object)) == null) {
                LogMgr.logError(new CallerInfo(){}, this.getConnId() + ": Driver returned a NULL ResultSet from getTables()", null);
            }
            long l2 = System.currentTimeMillis() - l;
            LogMgr.logDebug(new CallerInfo(){}, this.getConnId() + ": Retrieving table list took: " + l2 + "ms");
            if (resultSet != null && Settings.getInstance().getDebugMetadataSql()) {
                SqlUtil.dumpResultSetInfo("DatabaseMetaData.getTables()", resultSet.getMetaData());
            }
            boolean bl4 = this.dbSettings.useColumnNameForMetadata();
            Set<String> set = this.getDbSettings().getTableTypeSynonyms();
            l = System.currentTimeMillis();
            while (resultSet != null && resultSet.next()) {
                boolean bl5;
                String string10;
                String string11 = bl4 ? resultSet.getString("TABLE_CAT") : resultSet.getString(1);
                String string12 = bl4 ? resultSet.getString("TABLE_SCHEM") : resultSet.getString(2);
                String string13 = bl4 ? resultSet.getString("TABLE_NAME") : resultSet.getString(3);
                String string14 = string10 = bl4 ? resultSet.getString("TABLE_TYPE") : resultSet.getString(4);
                if (string13 == null) continue;
                if (set.contains(string10)) {
                    string10 = "TABLE";
                }
                if (objectListFilter.isExcluded(string10, string13)) continue;
                String string15 = bl4 ? resultSet.getString(RESULT_COL_REMARKS) : resultSet.getString(5);
                boolean bl6 = bl5 = bl2 || string9.equals(string10);
                if (bl5) {
                    bl2 = true;
                }
                if (this.isIndexType(string10)) continue;
                int n = dataStore.addRow();
                dataStore.setValue(n, 0, (Object)string13);
                dataStore.setValue(n, 1, (Object)string10);
                dataStore.setValue(n, 2, (Object)string11);
                dataStore.setValue(n, 3, (Object)string12);
                dataStore.setValue(n, 4, (Object)string15);
                if (bl || !StringUtil.equalString(string8, string10)) continue;
                bl = true;
            }
            l2 = System.currentTimeMillis() - l;
            LogMgr.logDebug(new CallerInfo(){}, this.getConnId() + ": Processing " + dataStore.getRowCount() + " tables took: " + l2 + "ms");
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResult(resultSet);
            throw throwable;
        }
        JdbcUtils.closeResult(resultSet);
        if (sequenceReader != null && DbMetadata.typeIncluded(sequenceReader.getSequenceTypeName(), stringArray) && this.dbSettings.getBoolProperty("retrieve_sequences", true) && !bl) {
            object = sequenceReader.getSequences(string, string2, string3);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                dbObject = (SequenceDefinition)iterator.next();
                int n = dataStore.addRow();
                dataStore.setValue(n, 0, (Object)((SequenceDefinition)dbObject).getSequenceName());
                dataStore.setValue(n, 1, (Object)((SequenceDefinition)dbObject).getObjectType());
                dataStore.setValue(n, 2, (Object)((SequenceDefinition)dbObject).getCatalog());
                dataStore.setValue(n, 3, (Object)((SequenceDefinition)dbObject).getSchema());
                dataStore.setValue(n, 4, (Object)((SequenceDefinition)dbObject).getComment());
                dataStore.getRow(n).setUserObject(dbObject);
            }
        }
        if (synonymReader != null && bl3 && this.dbSettings.getBoolProperty("retrieve_synonyms", false) && !bl2) {
            object = synonymReader.getSynonymList(this.dbConnection, string, string2, string3);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                dbObject = (TableIdentifier)iterator.next();
                int n = dataStore.addRow();
                dataStore.setValue(n, 0, (Object)((TableIdentifier)dbObject).getTableName());
                dataStore.setValue(n, 1, (Object)((TableIdentifier)dbObject).getType());
                dataStore.setValue(n, 2, (Object)((TableIdentifier)dbObject).getCatalog());
                dataStore.setValue(n, 3, (Object)((TableIdentifier)dbObject).getSchema());
                dataStore.setValue(n, 4, (Object)((TableIdentifier)dbObject).getComment());
                dataStore.getRow(n).setUserObject(dbObject);
            }
        }
        for (ObjectListAppender objectListAppender : this.appenders) {
            objectListAppender.extendObjectList(this.dbConnection, dataStore, string, string2, string3, stringArray);
        }
        for (ObjectListExtender objectListExtender : this.extenders) {
            if (!objectListExtender.handlesType(stringArray)) continue;
            objectListExtender.extendObjectList(this.dbConnection, dataStore, string, string2, string3, stringArray);
        }
        if (this.objectListEnhancer != null) {
            this.objectListEnhancer.updateObjectList(this.dbConnection, dataStore, string, string2, string3, stringArray);
        }
        for (ObjectListCleaner objectListCleaner : this.cleaners) {
            objectListCleaner.cleanupObjectList(this.dbConnection, dataStore, string, string2, string3, stringArray);
        }
        dataStore.resetStatus();
        return dataStore;
    }

    public static boolean typeIncluded(String string, String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        if (string == null) {
            return false;
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (stringArray[i] == null) continue;
            if (stringArray[i].equals("*")) {
                return true;
            }
            if (stringArray[i].equals("%")) {
                return true;
            }
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public boolean storesMixedCaseIdentifiers() {
        IdentifierCase identifierCase = this.dbSettings.getObjectNameCase();
        if (identifierCase != IdentifierCase.unknown) {
            return identifierCase == IdentifierCase.mixed;
        }
        try {
            boolean bl = this.metaData.storesUpperCaseIdentifiers();
            boolean bl2 = this.metaData.storesLowerCaseIdentifiers();
            boolean bl3 = this.metaData.storesMixedCaseIdentifiers();
            return bl3 || bl && bl2;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public boolean storesUpperCaseSchemas() {
        IdentifierCase identifierCase = this.dbSettings.getSchemaNameCase();
        if (identifierCase == IdentifierCase.unknown) {
            return this.storesUpperCaseIdentifiers();
        }
        return identifierCase == IdentifierCase.upper;
    }

    public boolean storesLowerCaseSchemas() {
        IdentifierCase identifierCase = this.dbSettings.getSchemaNameCase();
        if (identifierCase == IdentifierCase.unknown) {
            return this.storesLowerCaseIdentifiers();
        }
        return identifierCase == IdentifierCase.lower;
    }

    public boolean storesLowerCaseIdentifiers() {
        IdentifierCase identifierCase = this.dbSettings.getObjectNameCase();
        if (identifierCase != IdentifierCase.unknown) {
            return identifierCase == IdentifierCase.lower;
        }
        try {
            boolean bl = this.metaData.storesLowerCaseIdentifiers();
            return bl;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public boolean storesUpperCaseIdentifiers() {
        IdentifierCase identifierCase = this.dbSettings.getObjectNameCase();
        if (identifierCase != IdentifierCase.unknown) {
            return identifierCase == IdentifierCase.upper;
        }
        try {
            boolean bl = this.metaData.storesUpperCaseIdentifiers();
            return bl;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public void enableOutput() {
        this.enableOutput(-1L);
    }

    public void enableOutput(long l) {
        if (!this.isOracle) {
            return;
        }
        if (this.oraOutput == null) {
            try {
                this.oraOutput = new DbmsOutput(this.dbConnection.getSqlConnection());
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, this.getConnId() + ": Could not create DbmsOutput", exception);
                this.oraOutput = null;
            }
        }
        if (this.oraOutput != null) {
            try {
                this.oraOutput.enable(l);
            }
            catch (Throwable throwable) {
                LogMgr.logError(new CallerInfo(){}, this.getConnId() + ": Error when enabling DbmsOutput", throwable);
            }
        }
    }

    public boolean isDbmsOutputEnabled() {
        if (!this.isOracle) {
            return false;
        }
        if (this.oraOutput == null) {
            return false;
        }
        return this.oraOutput.isEnabled();
    }

    public void disableOutput() {
        if (!this.isOracle) {
            return;
        }
        if (this.oraOutput != null) {
            try {
                this.oraOutput.disable();
                this.oraOutput = null;
            }
            catch (Throwable throwable) {
                LogMgr.logError(new CallerInfo(){}, this.getConnId() + ": Error when disabling DbmsOutput", throwable);
            }
        }
    }

    public String getOutputMessages() {
        String string = "";
        if (this.oraOutput != null) {
            try {
                string = this.oraOutput.getResult();
            }
            catch (Throwable throwable) {
                LogMgr.logError(new CallerInfo(){}, this.getConnId() + ": Error when retrieving Output Messages", throwable);
                string = "";
            }
        }
        return string;
    }

    public void close() {
        if (this.dbConnection != null && !this.dbConnection.isBusy()) {
            if (this.oraOutput != null) {
                this.oraOutput.close();
            }
            if (this.schemaInfoReader != null) {
                this.schemaInfoReader.dispose();
            }
        }
    }

    public boolean isExtendedObject(DbObject dbObject) {
        for (ObjectListExtender objectListExtender : this.extenders) {
            if (!objectListExtender.handlesType(dbObject.getObjectType())) continue;
            return true;
        }
        return false;
    }

    public String getObjectSource(DbObject dbObject) {
        if (dbObject == null) {
            return null;
        }
        for (ObjectListExtender objectListExtender : this.extenders) {
            if (!objectListExtender.handlesType(dbObject.getObjectType())) continue;
            return objectListExtender.getObjectSource(this.dbConnection, dbObject);
        }
        return null;
    }

    public List<ColumnIdentifier> getTableColumns(TableIdentifier tableIdentifier) throws SQLException {
        return this.getTableColumns(tableIdentifier, true);
    }

    public List<ColumnIdentifier> getTableColumns(TableIdentifier tableIdentifier, boolean bl) throws SQLException {
        TableDefinition tableDefinition = this.definitionReader.getTableDefinition(tableIdentifier, bl);
        if (tableDefinition == null) {
            return Collections.emptyList();
        }
        if (!tableIdentifier.isPkInitialized() && bl) {
            tableIdentifier.setPrimaryKey(tableDefinition.getTable().getPrimaryKey());
        }
        return tableDefinition.getColumns();
    }

    public DbObject getObjectDefinition(TableIdentifier tableIdentifier) {
        for (ObjectListExtender objectListExtender : this.extenders) {
            if (!objectListExtender.handlesType(tableIdentifier.getObjectType())) continue;
            return objectListExtender.getObjectDefinition(this.dbConnection, tableIdentifier);
        }
        return null;
    }

    public DataStore getExtendedObjectDetails(DbObject dbObject) {
        if (dbObject == null) {
            return null;
        }
        DataStore dataStore = null;
        for (ObjectListExtender objectListExtender : this.extenders) {
            if (!objectListExtender.handlesType(dbObject.getObjectType())) continue;
            dataStore = objectListExtender.getObjectDetails(this.dbConnection, dbObject);
            break;
        }
        return dataStore;
    }

    public boolean isSynonym(TableIdentifier tableIdentifier) {
        if (tableIdentifier == null) {
            return false;
        }
        SynonymReader synonymReader = this.getSynonymReader();
        if (synonymReader == null) {
            return false;
        }
        return synonymReader.getSynonymTypeName().equalsIgnoreCase(tableIdentifier.getType());
    }

    public boolean isSequenceType(String string) {
        if (string == null) {
            return false;
        }
        SequenceReader sequenceReader = this.getSequenceReader();
        if (sequenceReader == null) {
            return false;
        }
        return StringUtil.equalStringIgnoreCase(string, sequenceReader.getSequenceTypeName());
    }

    public List<ColumnIdentifier> getObjectColumns(DbObject dbObject) throws SQLException {
        if (dbObject == null) {
            return null;
        }
        if (this.isViewOrTable(dbObject.getObjectType()) && dbObject instanceof TableIdentifier) {
            return this.getTableColumns((TableIdentifier)dbObject);
        }
        for (ObjectListExtender objectListExtender : this.extenders) {
            if (!objectListExtender.handlesType(dbObject.getObjectType())) continue;
            return objectListExtender.getColumns(this.dbConnection, dbObject);
        }
        return null;
    }

    public boolean hasColumns(DbObject dbObject) {
        if (dbObject == null) {
            return false;
        }
        return this.hasColumns(dbObject.getObjectType());
    }

    public boolean hasColumns(String string) {
        if (string == null) {
            return false;
        }
        if (this.isExtendedTableType(string)) {
            return true;
        }
        if (this.isViewType(string)) {
            return true;
        }
        if (string.equals(MVIEW_NAME)) {
            return true;
        }
        for (ObjectListExtender objectListExtender : this.extenders) {
            if (!objectListExtender.handlesType(string)) continue;
            return objectListExtender.hasColumns();
        }
        return false;
    }

    public DataStore getObjectDetails(TableIdentifier tableIdentifier) throws SQLException {
        Object object;
        DataStore dataStore = null;
        for (ObjectListExtender object2 : this.extenders) {
            if (!object2.handlesType(tableIdentifier.getObjectType())) continue;
            dataStore = object2.getObjectDetails(this.dbConnection, tableIdentifier);
            break;
        }
        if (dataStore == null && this.isSequenceType(tableIdentifier.getObjectType())) {
            object = tableIdentifier.createCopy();
            ((TableIdentifier)object).adjustCase(this.dbConnection);
            String string = SqlUtil.removeObjectQuotes(tableIdentifier.getSchema());
            String string2 = SqlUtil.removeObjectQuotes(tableIdentifier.getObjectName());
            String string3 = SqlUtil.removeObjectQuotes(tableIdentifier.getCatalog());
            DataStore dataStore2 = this.getSequenceReader().getRawSequenceDefinition(string3, string, string2);
            if (GuiSettings.getTransformSequenceDisplay() && dataStore2 != null && dataStore2.getRowCount() == 1) {
                DatastoreTransposer datastoreTransposer = new DatastoreTransposer(dataStore2);
                datastoreTransposer.setColumnsToExclude(CollectionUtil.caseInsensitiveSet(RESULT_COL_REMARKS));
                dataStore = datastoreTransposer.transposeRows(new int[]{0});
                dataStore.getColumns()[0].setColumnName(ResourceMgr.getString("TxtAttribute"));
                dataStore.getColumns()[1].setColumnName(ResourceMgr.getString("TxtValue"));
            } else {
                dataStore = dataStore2;
            }
        } else if (dataStore == null) {
            object = this.definitionReader.getTableDefinition(tableIdentifier, true);
            dataStore = new TableColumnsDatastore((TableDefinition)object);
        }
        if (dataStore != null) {
            dataStore.resetStatus();
        }
        return dataStore;
    }

    public TableDefinition getTableDefinition(TableIdentifier tableIdentifier) throws SQLException {
        return this.getTableDefinition(tableIdentifier, true);
    }

    public TableDefinition getTableDefinition(TableIdentifier tableIdentifier, boolean bl) throws SQLException {
        if (tableIdentifier == null) {
            return null;
        }
        return this.definitionReader.getTableDefinition(tableIdentifier, bl);
    }

    public TableIdentifier resolveSynonym(TableIdentifier tableIdentifier) {
        if (tableIdentifier == null) {
            return null;
        }
        if (!this.supportsSynonyms()) {
            return tableIdentifier;
        }
        String string = tableIdentifier.getType();
        if (string != null && !this.dbSettings.isSynonymType(string)) {
            return tableIdentifier;
        }
        TableIdentifier tableIdentifier2 = this.getSynonymTable(tableIdentifier);
        if (tableIdentifier2 == null) {
            return tableIdentifier;
        }
        return tableIdentifier2;
    }

    public List<TableIdentifier> getTableList() throws SQLException {
        return this.getObjectList(null, this.getCurrentSchema(), this.tableTypesArray);
    }

    public List<TableIdentifier> getObjectList(String string, String[] stringArray) throws SQLException {
        if (string == null) {
            string = this.getCurrentSchema();
        }
        return this.getObjectList(null, string, stringArray);
    }

    public List<TableIdentifier> getTableList(String string, String string2) throws SQLException {
        return this.getObjectList(string, string2, this.tableTypesArray);
    }

    public List<TableIdentifier> getSelectableObjectsList(String string, String string2) throws SQLException {
        return this.getSelectableObjectsList(string, string2, this.selectableTypes);
    }

    public List<TableIdentifier> getSelectableObjectsList(String string, String string2, String[] stringArray) throws SQLException {
        if (this.getDbSettings().supportsSchemas()) {
            return this.getObjectList(string, null, string2, stringArray);
        }
        if (this.getDbSettings().supportsCatalogs()) {
            return this.getObjectList(string, string2, null, stringArray);
        }
        return this.getObjectList(string, null, null, stringArray);
    }

    public List<TableIdentifier> getObjectList(String string, String string2, String[] stringArray) throws SQLException {
        if (this.getDbSettings().supportsSchemas()) {
            return this.getObjectList(string, null, string2, stringArray);
        }
        if (this.getDbSettings().supportsCatalogs()) {
            return this.getObjectList(string, string2, null, stringArray);
        }
        return this.getObjectList(string, null, null, stringArray);
    }

    public List<TableIdentifier> getObjectList(String string, Namespace namespace, String[] stringArray) throws SQLException {
        if (namespace == null) {
            namespace = Namespace.NULL_NSP;
        }
        return this.getObjectList(string, namespace.getCatalog(), namespace.getSchema(), stringArray);
    }

    public List<TableIdentifier> getObjectList(String string, String string2, String string3, String[] stringArray) throws SQLException {
        DataStore dataStore = this.getObjects(string2, string3, string, stringArray);
        int n = dataStore.getRowCount();
        ArrayList<TableIdentifier> arrayList = new ArrayList<TableIdentifier>(n);
        for (int i = 0; i < n; ++i) {
            TableIdentifier tableIdentifier = this.buildTableIdentifierFromDs(dataStore, i);
            arrayList.add(tableIdentifier);
        }
        return arrayList;
    }

    public TableIdentifier buildTableIdentifierFromDs(DataStore dataStore, int n) {
        Object object = dataStore.getRow(n).getUserObject();
        if (object instanceof TableIdentifier) {
            return (TableIdentifier)object;
        }
        String string = dataStore.getValueAsString(n, 0);
        String string2 = dataStore.getValueAsString(n, 3);
        String string3 = dataStore.getValueAsString(n, 2);
        TableIdentifier tableIdentifier = new TableIdentifier(string3, string2, string, false);
        tableIdentifier.setNeverAdjustCase(true);
        tableIdentifier.setType(dataStore.getValueAsString(n, 1));
        tableIdentifier.setComment(dataStore.getValueAsString(n, 4));
        return tableIdentifier;
    }

    public String getSchemaToUse(TableIdentifier tableIdentifier) {
        if (!this.getDbSettings().supportsSchemas()) {
            return null;
        }
        String string = tableIdentifier.getRawSchema();
        String string2 = null;
        if (string == null) {
            string = string2 = this.getCurrentSchema();
        }
        if (this.ignoreSchema(string, string2)) {
            return null;
        }
        return StringUtil.trim(string);
    }

    public String getCatalogToUse(TableIdentifier tableIdentifier) {
        if (!this.getDbSettings().supportsCatalogs()) {
            return null;
        }
        String string = tableIdentifier.getRawCatalog();
        if (string == null) {
            string = this.definitionReader.getCatalogToUse(tableIdentifier);
        }
        if (this.ignoreCatalog(string)) {
            return null;
        }
        return StringUtil.trim(string);
    }

    public String getCurrentCatalog() {
        return this.catalogInfoReader.getCurrentCatalog();
    }

    public void clearCachedCatalog() {
        this.catalogInfoReader.clearCache();
    }

    public List<String> getCatalogs() {
        return this.getCatalogInformation(null);
    }

    public List<String> getAllCatalogs() {
        if (this.isPostgres) {
            return PostgresUtil.getAllDatabases(this.dbConnection);
        }
        return this.getCatalogInformation(null);
    }

    public boolean supportsCatalogLevelObjects() {
        return this.isSqlServer && SqlServerUtil.supportsPartitioning(this.dbConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCatalogInformation(ObjectNameFilter objectNameFilter) {
        List<String> list = CollectionUtil.arrayList();
        boolean bl = this.dbSettings.useColumnNameForMetadata();
        ResultSet resultSet = null;
        try {
            long l = System.currentTimeMillis();
            resultSet = this.metaData.getCatalogs();
            while (resultSet.next()) {
                String string = bl ? resultSet.getString("TABLE_CAT") : resultSet.getString(1);
                if (!StringUtil.isNonEmpty(string)) continue;
                list.add(string);
            }
            long l2 = System.currentTimeMillis() - l;
            LogMgr.logDebug(new CallerInfo(){}, this.getConnId() + ": Retrieving " + list.size() + " catalogs using getCatalogs() took: " + l2 + "ms");
        }
        catch (Exception exception) {
            try {
                LogMgr.logError(new CallerInfo(){}, this.getConnId() + ": Error retrieving catalog information", exception);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResult(resultSet);
                throw throwable;
            }
            JdbcUtils.closeResult(resultSet);
        }
        JdbcUtils.closeResult(resultSet);
        if (objectNameFilter != null) {
            objectNameFilter.applyFilter(list);
        }
        Collections.sort(list);
        return list;
    }

    public List<String> getSchemas() {
        return this.getSchemas(null);
    }

    public boolean supportsCatalogForGetSchemas() {
        if (this.isSqlServer) {
            return SqlServerUtil.isMicrosoftDriver(this.dbConnection);
        }
        return this.getDbSettings().supportsCatalogForGetSchemas();
    }

    public List<String> getSchemas(ObjectNameFilter objectNameFilter) {
        return this.getSchemas(objectNameFilter, null);
    }

    public List<String> getSchemas(ObjectNameFilter objectNameFilter, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = objectNameFilter != null;
        long l = System.currentTimeMillis();
        try {
            Object object;
            if (objectNameFilter != null && objectNameFilter.isRetrievalFilter()) {
                for (String string2 : objectNameFilter.getFilterExpressions()) {
                    long l2 = System.currentTimeMillis();
                    string2 = this.adjustSchemaNameCase(DbMetadata.cleanupWildcards(string2));
                    ResultSet resultSet = this.metaData.getSchemas(string, string2);
                    int n = this.addSchemaResult(arrayList, resultSet);
                    long l3 = System.currentTimeMillis() - l2;
                    LogMgr.logDebug(new CallerInfo(){}, this.getConnId() + ": Using schema filter expression " + string2 + " as a retrieval parameter returned " + n + " schemas (" + l3 + "ms)");
                }
                bl = false;
            } else if (StringUtil.isNonEmpty(string) && this.supportsCatalogForGetSchemas()) {
                object = this.metaData.getSchemas(string, null);
                this.addSchemaResult(arrayList, (ResultSet)object);
            } else {
                if (StringUtil.isNonEmpty(string)) {
                    object = null;
                    if (LogMgr.isDebugEnabled()) {
                        object = new Exception("Backtrace");
                    }
                    LogMgr.logWarning(new CallerInfo(){}, this.getConnId() + ": getSchemas() called with catalog parameter, but current connection is not configured to support that", (Throwable)object);
                }
                object = this.metaData.getSchemas();
                this.addSchemaResult(arrayList, (ResultSet)object);
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, this.getConnId() + ": Error retrieving schemas: " + exception.getMessage(), exception);
        }
        long l4 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, this.getConnId() + ": Retrieving " + arrayList.size() + " schemas using getSchemas() took " + l4 + "ms");
        List<String> list = this.dbSettings.getSchemasToAdd();
        if (list != null) {
            arrayList.addAll(list);
        }
        if (objectNameFilter != null && bl) {
            objectNameFilter.applyFilter(arrayList);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addSchemaResult(List<String> list, ResultSet resultSet) throws SQLException {
        boolean bl = this.dbSettings.useColumnNameForMetadata();
        int n = 0;
        try {
            while (resultSet.next()) {
                ++n;
                String string = bl ? resultSet.getString("TABLE_SCHEM") : resultSet.getString(1);
                if (!StringUtil.isNonEmpty(string)) continue;
                list.add(string);
            }
        }
        finally {
            JdbcUtils.closeResult(resultSet);
        }
        return n;
    }

    private boolean isIndexType(String string) {
        if (string == null) {
            return false;
        }
        return string.contains("INDEX");
    }

    private synchronized Collection<String> retrieveTableTypes() {
        List<String> list = this.dbSettings.getListProperty("tabletypes");
        if (list.size() > 0) {
            return list;
        }
        return this.retrieveObjectTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Collection<String> retrieveObjectTypes() {
        if (this.objectTypesFromDriver != null) {
            return this.objectTypesFromDriver;
        }
        boolean bl = this.getDbSettings().getBoolProperty("metadata.tabletypes.ignore.index", true);
        boolean bl2 = this.getDbSettings().getBoolProperty("metadata.tabletypes.use.defaults", true);
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        ResultSet resultSet = null;
        String string = "";
        try {
            resultSet = this.metaData.getTableTypes();
            while (resultSet != null && resultSet.next()) {
                String string2 = resultSet.getString(1);
                if (string2 == null) continue;
                string2 = string2.trim();
                if (bl && this.isIndexType(string2)) {
                    if (!string.isEmpty()) {
                        string = string + ",";
                    }
                    string = string + string2;
                    continue;
                }
                set.add(string2.toUpperCase());
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, this.getConnId() + ": Error retrieving table types.", exception);
        }
        finally {
            JdbcUtils.closeResult(resultSet);
        }
        if (!string.isEmpty()) {
            LogMgr.logDebug(new CallerInfo(){}, this.getConnId() + ": Ignoring \"table\" types: " + string);
        }
        if (set.isEmpty() && bl2) {
            set = CollectionUtil.caseInsensitiveSet("TABLE", "VIEW");
            LogMgr.logWarning(new CallerInfo(){}, this.getConnId() + ": The driver did not return any table types using getTableTypes(). Using default values: " + set);
        } else {
            LogMgr.logInfo(new CallerInfo(){}, this.getConnId() + ": Table types returned by the JDBC driver: " + set);
        }
        this.objectTypesFromDriver = Collections.unmodifiableSet(set);
        return this.objectTypesFromDriver;
    }

    public Collection<String> getObjectTypes() {
        SequenceReader sequenceReader;
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        set.addAll(this.retrieveObjectTypes());
        List<String> list = this.dbSettings.getListProperty("additional.objecttypes");
        set.addAll(list);
        if (this.supportsSynonyms()) {
            set.add(this.getSynonymReader().getSynonymTypeName());
        }
        if ((sequenceReader = this.getSequenceReader()) != null) {
            set.add(sequenceReader.getSequenceTypeName());
        }
        for (ObjectListExtender objectListExtender : this.extenders) {
            if (objectListExtender.isDerivedType()) continue;
            set.addAll(objectListExtender.supportedTypes());
        }
        return set;
    }

    public String getSchemaTerm() {
        return this.schemaTerm;
    }

    public String getCatalogTerm() {
        return this.catalogTerm;
    }

    public SequenceReader getSequenceReader() {
        return ReaderFactory.getSequenceReader(this.dbConnection);
    }

    public boolean isExtendedTableType(String string) {
        if (this.isTableType(string)) {
            return true;
        }
        List<String> list = this.dbSettings.getListProperty("additional.tabletypes");
        return list.contains(string);
    }

    public boolean isViewOrTable(String string) {
        return this.isTableType(string) || this.isExtendedTableType(string) || this.isViewType(string);
    }

    public boolean isViewType(String string) {
        return this.getDbSettings().isViewType(string);
    }

    public boolean isTableType(String string) {
        if (string == null) {
            return false;
        }
        return this.tableTypesList.contains(string.trim());
    }

    public boolean supportsSynonyms() {
        return this.getSynonymReader() != null;
    }

    public TableIdentifier getSynonymTable(TableIdentifier tableIdentifier) {
        TableIdentifier tableIdentifier2 = tableIdentifier.createCopy();
        tableIdentifier2.adjustCase(this.dbConnection);
        return this.getSynonymTable(tableIdentifier2.getCatalog(), tableIdentifier2.getSchema(), tableIdentifier2.getTableName());
    }

    public TableIdentifier getSynonymTable(String string, String string2, String string3) {
        SynonymReader synonymReader = this.getSynonymReader();
        if (synonymReader == null) {
            return null;
        }
        TableIdentifier tableIdentifier = null;
        try {
            tableIdentifier = synonymReader.getSynonymTable(this.dbConnection, string, string2, string3);
            if (tableIdentifier != null && tableIdentifier.getType() == null) {
                String string4 = this.getObjectType(tableIdentifier);
                tableIdentifier.setType(string4);
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not retrieve table for synonym", exception);
        }
        return tableIdentifier;
    }

    public SynonymReader getSynonymReader() {
        return ReaderFactory.getSynonymReader(this.dbConnection);
    }
}

