/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import workbench.db.BlobAccessType;
import workbench.db.ClobAccessType;
import workbench.db.CreateTableTypeDefinition;
import workbench.db.DBID;
import workbench.db.DmlExpressionType;
import workbench.db.GenerateDDLCommit;
import workbench.db.IdentifierCase;
import workbench.db.importer.SetObjectStrategy;
import workbench.db.oracle.OracleUtils;
import workbench.db.sqltemplates.TemplateHandler;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.DbExplorerSettings;
import workbench.resource.Settings;
import workbench.sql.EndReadOnlyTrans;
import workbench.util.CollectionUtil;
import workbench.util.NumberStringCache;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class DbSettings {
    public static final String IDX_TYPE_NORMAL = "NORMAL";
    public static final String DEFAULT_CREATE_TABLE_TYPE = "default";
    public static final String DBID_PLACEHOLDER = "[dbid]";
    private static final String NOT_THERE = "$wb$_not_there_$wb$";
    private final String dbId;
    private final Set<String> updatingCommands = CollectionUtil.caseInsensitiveSet();
    private final Set<String> noUpdateCountVerbs = CollectionUtil.caseInsensitiveSet();
    private final Set<String> useMaxRowsVerbs = CollectionUtil.caseInsensitiveSet();
    private boolean alwaysUseMaxRows;
    private final DbSettings aliasSettings;
    private final String prefix;
    private final String prefixMajorVersion;
    private final String prefixFullVersion;
    public static final String DEFAULT_CREATE_TABLE_TEMPLATE = "CREATE TABLE %fq_table_name%\n(\n%columnlist%\n)";

    public DbSettings(String string) {
        this(string, -1, -1);
    }

    public DbSettings(String string, int n, int n2) {
        Object object;
        this.dbId = string;
        this.prefix = "workbench.db." + string + ".";
        this.prefixMajorVersion = "workbench.db." + string + "_" + NumberStringCache.getNumberString(n) + ".";
        this.prefixFullVersion = "workbench.db." + string + "_" + NumberStringCache.getNumberString(n) + "_" + NumberStringCache.getNumberString(n2) + ".";
        Settings settings = Settings.getInstance();
        CallerInfo callerInfo = new CallerInfo(){};
        List<String> list = StringUtil.stringToList(settings.getProperty("workbench.db.neverquote", ""));
        if (CollectionUtil.isNonEmpty(list)) {
            LogMgr.logInfo(callerInfo, "Migrating deprecated property \"workbench.db.neverquote\" to dbid based properties");
            object = list.iterator();
            while (object.hasNext()) {
                String string2 = object.next();
                settings.setProperty("workbench.db." + string2 + ".neverquote", "true");
            }
            settings.removeProperty("workbench.db.neverquote");
        }
        if ((object = settings.getProperty(this.prefix + "aliasid", null)) != null) {
            LogMgr.logInfo(callerInfo, "Using alias DBID: " + (String)object + " for: " + this.dbId);
            this.aliasSettings = new DbSettings((String)object, n, n2);
        } else {
            this.aliasSettings = null;
        }
        this.readNoUpdateCountVerbs();
        this.readUpdatingCommands();
        this.readMaxRowVerbs();
    }

    public String getAliasId() {
        if (this.aliasSettings != null) {
            return this.aliasSettings.getDbId();
        }
        return null;
    }

    public final String getDbId() {
        return this.dbId;
    }

    public List<String> getListProperty(String string) {
        return this.getListProperty(string, null, false);
    }

    public List<String> getListProperty(String string, String string2) {
        return this.getListProperty(string, string2, false);
    }

    public List<String> getListProperty(String string, String string2, boolean bl) {
        String string3 = this.getProperty(string, string2);
        if (bl && string3 != null) {
            string3 = string3.toLowerCase();
        }
        return StringUtil.stringToList(string3, ",", true, true, false);
    }

    public String getProperty(String string, String string2) {
        return this.getVersionedString(string, string2);
    }

    private String getVersionedString(String string, String string2) {
        Settings settings = Settings.getInstance();
        String string3 = settings.getProperty(this.prefixFullVersion + string, NOT_THERE);
        if (string3 != NOT_THERE) {
            return string3;
        }
        string3 = settings.getProperty(this.prefixMajorVersion + string, NOT_THERE);
        if (string3 != NOT_THERE) {
            return string3;
        }
        if (this.aliasSettings == null) {
            return settings.getProperty(this.prefix + string, string2);
        }
        string3 = settings.getProperty(this.prefix + string, NOT_THERE);
        if (string3 == NOT_THERE) {
            return this.aliasSettings.getVersionedString(string, string2);
        }
        return string3;
    }

    public void setPropertyTemporary(String string, boolean bl) {
        Settings.getInstance().setTemporaryProperty(this.prefix + string, Boolean.toString(bl));
    }

    public void setPropertyTemporary(String string, String string2) {
        Settings.getInstance().setTemporaryProperty(this.prefix + string, string2);
    }

    public void setProperty(String string, boolean bl) {
        Settings.getInstance().setProperty(this.prefix + string, bl);
    }

    public void setProperty(String string, String string2) {
        Settings.getInstance().setProperty(this.prefix + string, string2);
    }

    public boolean isUpdatingCommand(String string) {
        if (StringUtil.isEmptyString(string)) {
            return false;
        }
        return this.updatingCommands.contains(string);
    }

    public static Map<String, String> getDBMSNames() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("h2", "H2");
        hashMap.put("oracle", "Oracle");
        hashMap.put("hsql_database_engine", "HSQLDB");
        hashMap.put("postgresql", "PostgreSQL");
        hashMap.put("db2", "DB2 (LUW)");
        hashMap.put("db2h", "DB2 Host");
        hashMap.put("db2i", "DB2 iSeries");
        hashMap.put("mysql", "MySQL");
        hashMap.put("firebird", "Firebird SQL");
        hashMap.put("informix_dynamic_server", "Informix");
        hashMap.put("sql_anywhere", "SQL Anywhere");
        hashMap.put("microsoft_sql_server", "Microsoft SQL Server");
        hashMap.put("apache_derby", "Apache Derby");
        return hashMap;
    }

    public boolean supportsCreateArray() {
        return this.getBoolProperty("createarray.supported", true);
    }

    public boolean handleArrayDisplay() {
        return this.getBoolProperty("array.adjust.display", true);
    }

    public boolean showArrayType() {
        return this.getBoolProperty("array.show.type", false);
    }

    public boolean useGetStringForBit() {
        return this.getBoolProperty("bit.use.getstring", false);
    }

    public boolean useGetObjectForDates() {
        return this.getBoolProperty("date.use.getobject", false);
    }

    public boolean useLocalTimeForTime() {
        return this.getBoolProperty("time.use.localtime", false);
    }

    public boolean useGetObjectForTimestamps() {
        return this.getBoolProperty("timestamp.use.getobject", false);
    }

    public boolean useGetObjectForTimestampTZ() {
        return this.getBoolProperty("timestamptz.use.getobject", false);
    }

    public boolean useGetXML() {
        return this.getBoolProperty("xml.use.getsqlxml", false);
    }

    public ClobAccessType getClobReadMethod() {
        String string = this.getProperty("clob.use.getstring", null);
        if ("true".equals(string)) {
            return ClobAccessType.string;
        }
        String string2 = this.getProperty("clob.read.method", ClobAccessType.string.name());
        return Settings.getInstance().getEnumValue(string2, ClobAccessType.string);
    }

    public boolean useSetStringForClobs() {
        return this.getBoolProperty("clob.use.setstring", false);
    }

    public BlobAccessType getBlobReadMethod() {
        String string = this.getProperty("blob.use.getbytes", null);
        if (string == null) {
            String string2 = this.getProperty("blob.read.method", BlobAccessType.binaryStream.name());
            return Settings.getInstance().getEnumValue(string2, BlobAccessType.binaryStream);
        }
        if (StringUtil.stringToBool(string)) {
            return BlobAccessType.byteArray;
        }
        return BlobAccessType.binaryStream;
    }

    public boolean useSetBytesForBlobs() {
        return this.getBoolProperty("blob.use.setbytes", false);
    }

    public boolean padCharColumns() {
        return this.getBoolProperty("dml.char.pad", false);
    }

    public boolean longVarcharIsClob() {
        return this.getBoolProperty("clob.longvarchar", true);
    }

    public boolean supportsResultSetsWithDML() {
        return this.getBoolProperty("dml.supports.results", true);
    }

    public boolean truncateReturnsRowCount() {
        return this.getBoolProperty("dml.truncate.returns.rows", true);
    }

    public boolean supportsBatchedStatements() {
        return this.getBoolProperty("batchedstatements", false);
    }

    public boolean allowsExtendedCreateStatement() {
        return this.getBoolProperty("extended.createstmt", true);
    }

    public void setUseExtendedCreateStatement(boolean bl) {
        this.setProperty("extended.createstmt", bl);
    }

    public boolean allowsMultipleGetUpdateCounts() {
        return this.getBoolProperty("multipleupdatecounts", true);
    }

    public boolean reportsRealSizeAsDisplaySize() {
        return this.getBoolProperty("charsize.usedisplaysize", false);
    }

    public int getMaxWarnings() {
        int n = 5000;
        int n2 = this.getIntProperty("maxwarnings", n);
        if (n2 <= 0) {
            n2 = n;
        }
        return n2;
    }

    public int getMaxResults() {
        int n = 50000;
        int n2 = this.getIntProperty("maxresults", n);
        if (n2 <= 0) {
            n2 = n;
        }
        return n2;
    }

    public boolean ddlNeedsCommit() {
        return this.getBoolProperty("ddlneedscommit", false);
    }

    public GenerateDDLCommit getDDLScriptCommitType() {
        String string = this.getProperty("ddl.commit.type", GenerateDDLCommit.whenNeeded.name());
        try {
            return GenerateDDLCommit.valueOf(string);
        }
        catch (Exception exception) {
            return GenerateDDLCommit.whenNeeded;
        }
    }

    public boolean ignoreCommitInAutocommitMode() {
        return this.getBoolProperty("transaction.control.ignore.autocommit", false);
    }

    public boolean showFeedbackForIgnoredCommit() {
        return this.getBoolProperty("transaction.control.ignore.feedback", false);
    }

    public boolean neverQuoteObjects() {
        return this.getBoolProperty("neverquote", false);
    }

    public boolean trimDefaults() {
        return this.getBoolProperty("trimdefaults", true);
    }

    public boolean useSetNull() {
        return this.getBoolProperty("import.use.setnull", false);
    }

    public boolean sendClobsAsStrings() {
        return this.getBoolProperty("import.clob.as.string", false);
    }

    public boolean sendClobAsClob() {
        return this.getBoolProperty("import.clob.as.clob", false);
    }

    public boolean sendBlobAsBlob() {
        return this.getBoolProperty("import.blob.as.blob", false);
    }

    public boolean sendBlobAsBytes() {
        return this.getBoolProperty("import.blob.as.bytes", false);
    }

    public boolean useJdbcCommit() {
        return this.getBoolProperty("usejdbccommit", false);
    }

    public boolean isStringComparisonCaseSensitive() {
        return this.getBoolProperty("casesensitive", false);
    }

    public boolean getDefaultBeforeNull() {
        return this.getBoolProperty("defaultbeforenull", false);
    }

    public String getCascadeConstraintsVerb(String string) {
        if (string == null) {
            return null;
        }
        String string2 = this.getProperty("drop." + DbSettings.getKeyValue(string) + ".cascade", null);
        return string2;
    }

    public boolean useFQConstraintName() {
        return this.getBoolProperty("constraints.use_fqname", false);
    }

    public boolean useCatalogInDML() {
        return this.getBoolProperty("catalog.dml", true);
    }

    public boolean alwaysUseSchema() {
        return this.getBoolProperty("schema.always", false);
    }

    public boolean alwaysUseCatalog() {
        return this.getBoolProperty("catalog.always", false);
    }

    public boolean needsCatalogIfNoCurrent() {
        return this.getBoolProperty("catalog.neededwhenempty", false);
    }

    public String getInsertForImport() {
        return this.getProperty("import.insert", null);
    }

    public Collection<String> getRefCursorTypeNames() {
        return CollectionUtil.caseInsensitiveSet(this.getListProperty("refcursor.typename", null));
    }

    public int getRefCursorDataType() {
        return this.getIntProperty("refcursor.typevalue", Integer.MIN_VALUE);
    }

    public boolean useWbProcedureCall() {
        return this.getBoolProperty("procs.use.wbcall", false);
    }

    public String getCreateIndexSQL() {
        String string = Settings.getInstance().getProperty("workbench.db.sql.create.index", null);
        return this.getProperty("create.index", string);
    }

    public String getCreateUniqeConstraintSQL() {
        String string = Settings.getInstance().getProperty("workbench.db.sql.create.uniqueconstraint", null);
        return this.getProperty("create.uniqueconstraint", string);
    }

    public String getSelectForFunctionSQL() {
        return this.getProperty("function.select", null);
    }

    public static String getKeyValue(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase().trim().replaceAll("\\s+", "_");
    }

    public String getDropDDL(String string, boolean bl) {
        if (StringUtil.isBlank(string)) {
            return null;
        }
        String string2 = this.getCascadeConstraintsVerb(string);
        String string3 = this.getProperty("drop." + DbSettings.getKeyValue(string), null);
        if (string3 == null) {
            string3 = "DROP " + string.toUpperCase() + " " + "%name%";
            if (string2 != null && bl) {
                string3 = string3 + " " + string2;
            }
        } else {
            string3 = bl ? string3.replace("%cascade%", string2 == null ? "" : string2) : TemplateHandler.removePlaceholder(string3, "%cascade%", true);
        }
        return string3.trim();
    }

    public boolean useSpecificNameForDropFunction() {
        return this.getBoolProperty("drop.procedure.use.specificname", false);
    }

    public boolean useSpecificNameForProcedureColumns() {
        return this.getBoolProperty("procedures.use.specificname", true);
    }

    public String getSpecificNameColumn() {
        return this.getProperty("procedures.specificname.colname", "SPECIFIC_NAME");
    }

    public boolean needParametersToDropFunction() {
        return this.getBoolProperty("drop.function.includeparameters", false);
    }

    public boolean includeOutParameterForDropFunction() {
        return this.getBoolProperty("drop.function.include.out.parameters", true);
    }

    public boolean useSavepointForImport() {
        return this.getBoolProperty("import.usesavepoint", false);
    }

    public boolean useSavepointForTableStatements() {
        return this.getBoolProperty("import.tablestmt.usesavepoint", false);
    }

    public boolean useSavePointForDML() {
        return this.getBoolProperty("sql.usesavepoint", false);
    }

    public boolean useSavePointForDDL() {
        return this.getBoolProperty("ddl.usesavepoint", false);
    }

    public String getBlobLiteralType() {
        return this.getProperty("blob.literal.type", "hex");
    }

    public String getBlobLiteralPrefix() {
        return this.getProperty("blob.literal.prefix", null);
    }

    public String getBlobLiteralSuffix() {
        return this.getProperty("blob.literal.suffix", null);
    }

    public boolean getBlobLiteralUpperCase() {
        return this.getBoolProperty("blob.literal.upcase", false);
    }

    public boolean getUseIdioticQuotes() {
        return this.getBoolProperty("bracket.quoting", false);
    }

    public boolean selectStartsTransaction() {
        return this.getBoolProperty("select.startstransaction", false);
    }

    public boolean getUseMySQLShowCreate(String string) {
        if (string == null) {
            return false;
        }
        return Settings.getInstance().getBoolProperty("workbench.db.mysql.use.showcreate." + string.trim().toLowerCase(), false);
    }

    public String getLineComment() {
        return this.getProperty("linecomment", null);
    }

    public boolean supportsQueryTimeout() {
        return this.getBoolProperty("supportquerytimeout", true);
    }

    public boolean supportsIndexedViews() {
        return this.getBoolProperty("indexedviews", false);
    }

    public boolean supportsGetPrimaryKeys() {
        return this.getBoolProperty("supportgetpk", true);
    }

    public boolean supportsTransactions() {
        return this.getBoolProperty("supports.transactions", true);
    }

    public boolean getStripProcGroupNumber() {
        return this.getBoolProperty("strip.procgroup", false);
    }

    public String getProcGroupDelimiter() {
        return this.getProperty("procversiondelimiter", null);
    }

    public boolean supportsCascadedTruncate() {
        String string = this.getProperty("sql.truncate.cascade", null);
        return string != null;
    }

    public String getTruncateCommand(boolean bl) {
        String string = this.getProperty("sql.truncate", null);
        if (bl) {
            string = this.getProperty("sql.truncate.cascade", string);
        }
        return string;
    }

    public boolean truncateNeedsCommit() {
        return this.getBoolProperty("truncate.commit", false);
    }

    public boolean supportsTruncate() {
        return this.getTruncateCommand(false) != null;
    }

    public boolean isViewType(String string) {
        if (string == null) {
            return false;
        }
        return this.getViewTypes().contains(string);
    }

    public boolean isSynonymType(String string) {
        if (string == null) {
            return false;
        }
        Set<String> set = CollectionUtil.caseInsensitiveSet(this.getListProperty("synonymtypes", "synonym"));
        return set.contains(string.toLowerCase());
    }

    public boolean isMview(String string) {
        if (string == null) {
            return false;
        }
        String string2 = this.getProperty("mviewname", "materialized view").toLowerCase();
        return string.equalsIgnoreCase(string2);
    }

    String mapIndexType(int n) {
        switch (n) {
            case 2: {
                return "HASH";
            }
            case 1: {
                return "CLUSTERED";
            }
        }
        return IDX_TYPE_NORMAL;
    }

    public IdentifierCase getSchemaNameCase() {
        String string = this.getProperty("schemaname.case", null);
        return Settings.getInstance().getEnumValue(string, IdentifierCase.unknown);
    }

    public void setObjectNameCase(String string) {
        Settings.getInstance().setProperty(this.prefix + "objectname.case", string);
    }

    public IdentifierCase getObjectNameCase() {
        String string = this.getProperty("objectname.case", null);
        return Settings.getInstance().getEnumValue(string, IdentifierCase.unknown);
    }

    public String getRuleDisplay(int n) {
        StringBuilder stringBuilder = new StringBuilder(40);
        switch (n) {
            case 3: {
                stringBuilder.append("workbench.sql.fkrule.noaction");
                break;
            }
            case 1: {
                stringBuilder.append("workbench.sql.fkrule.restrict");
                break;
            }
            case 2: {
                stringBuilder.append("workbench.sql.fkrule.setnull");
                break;
            }
            case 0: {
                stringBuilder.append("workbench.sql.fkrule.cascade");
                break;
            }
            case 4: {
                stringBuilder.append("workbench.sql.fkrule.setdefault");
                break;
            }
            case 5: {
                stringBuilder.append("workbench.sql.fkrule.initiallydeferred");
                break;
            }
            case 6: {
                stringBuilder.append("workbench.sql.fkrule.initiallyimmediate");
                break;
            }
            case 7: {
                stringBuilder.append("workbench.sql.fkrule.notdeferrable");
                break;
            }
            default: {
                stringBuilder = null;
            }
        }
        if (stringBuilder != null) {
            stringBuilder.append('.');
            stringBuilder.append(this.getDbId());
            String string = Settings.getInstance().getProperty(stringBuilder.toString(), null);
            if (string != null) {
                return string;
            }
        }
        switch (n) {
            case 3: {
                return "NO ACTION";
            }
            case 1: {
                return "RESTRICT";
            }
            case 2: {
                return "SET NULL";
            }
            case 0: {
                return "CASCADE";
            }
            case 4: {
                return "SET DEFAULT";
            }
            case 5: {
                return "INITIALLY DEFERRED";
            }
            case 6: {
                return "INITIALLY IMMEDIATE";
            }
            case 7: {
                return "NOT DEFERRABLE";
            }
        }
        return "";
    }

    public boolean useSetCatalog() {
        return this.getBoolProperty("usesetcatalog", true);
    }

    public boolean isNotDeferrable(String string) {
        if (StringUtil.isEmptyString(string)) {
            return true;
        }
        return string.equals(this.getRuleDisplay(7));
    }

    public List<String> getDataTypesToIgnore() {
        String string = Settings.getInstance().getProperty("workbench.ignoretypes." + this.getDbId(), null);
        List<String> list = StringUtil.stringToList(string, ",", true, true);
        return list;
    }

    public String getQueryForCurrentCatalog() {
        return this.getProperty("currentcatalog.query", null);
    }

    public boolean getConvertDateInExport() {
        return this.getBoolProperty("export.convert.date2ts", false);
    }

    public boolean useColumnListInExport() {
        return this.getBoolProperty("export.select.use.columns", true);
    }

    public boolean exportXMLAsClob() {
        return this.getBoolProperty("export.xml.clob", true);
    }

    public boolean getUseStreamsForBlobExport() {
        return this.getBoolProperty("export.blob.use.streams", true);
    }

    public boolean getUseStreamsForClobExport() {
        return this.getBoolProperty("export.clob.use.streams", false);
    }

    public boolean needsExactClobLength() {
        return this.getBoolProperty("exactcloblength", false);
    }

    public boolean getFormatViewSource() {
        return this.getBoolProperty("source.view.doformat", false);
    }

    public String getDropSingleColumnSql() {
        return this.getProperty("drop.column", null);
    }

    public String getDropMultipleColumnSql() {
        return this.getProperty("drop.column.multi", null);
    }

    public String getAddColumnSql() {
        return this.getProperty("add.column", null);
    }

    public boolean useQuotedColumnsForComments() {
        return this.getBoolProperty("comments.column.quote", true);
    }

    public boolean supportsMultiRowInsert() {
        return this.getBoolProperty("dml.insert.multirow.supported", true);
    }

    public boolean supportsSortedIndex() {
        return this.getBoolProperty("index.sorted", true);
    }

    public boolean ignoreIndexColumnWithOrdinalZero() {
        return this.getBoolProperty("index.ignore.ordinal_zero", true);
    }

    public final boolean includeSystemTablesInSelectable() {
        return this.getBoolProperty("systemtables.selectable", false);
    }

    public boolean removeNewLinesInSQL() {
        return this.getBoolProperty("removenewlines", false);
    }

    public boolean canDropInTransaction(String string) {
        if (this.ddlNeedsCommit()) {
            return this.getBoolProperty("drop." + string + ".in.transaction", true);
        }
        return true;
    }

    public boolean canDropType(String string) {
        if (StringUtil.isEmptyString(string)) {
            return false;
        }
        if (string.equalsIgnoreCase("column")) {
            return this.getDropSingleColumnSql() != null;
        }
        return true;
    }

    public void setDataTypeExpression(String string, String string2) {
        Settings.getInstance().setProperty(this.prefix + "selectexpression." + string, string2);
    }

    public String getDataTypeSelectExpression(String string) {
        if (string == null) {
            return null;
        }
        return this.getProperty("selectexpression." + string.toLowerCase(), null);
    }

    public String getDmlExpressionValue(String string, DmlExpressionType dmlExpressionType) {
        if (string == null) {
            return null;
        }
        String string2 = SqlUtil.getBaseTypeName(string);
        String string3 = this.getProperty("dmlexpression." + string2.toLowerCase(), null);
        if (dmlExpressionType != DmlExpressionType.Any) {
            string3 = this.getProperty("dmlexpression." + string2.toLowerCase() + "." + dmlExpressionType.toString().toLowerCase(), string3);
        }
        return string3;
    }

    public boolean isDmlExpressionDefined(String string, DmlExpressionType dmlExpressionType) {
        return this.getDmlExpressionValue(string, dmlExpressionType) != null;
    }

    public String getJDBCTypeMapping() {
        return this.getProperty("typemap", null);
    }

    public boolean cleanupTypeMappingNames() {
        return this.getBoolProperty("typemap.cleanup", false);
    }

    public SetObjectStrategy getUseTypeWithSetObject() {
        String string = this.getProperty("import.setobject.usetype", "false");
        if ("true".equals(string)) {
            return SetObjectStrategy.Always;
        }
        if ("fasle".equals(string)) {
            return SetObjectStrategy.Never;
        }
        try {
            return SetObjectStrategy.valueOf(string);
        }
        catch (Throwable throwable) {
            return SetObjectStrategy.Never;
        }
    }

    public boolean getRetrieveProcParmsForAutoCompletion() {
        return this.getBoolProperty("completion.procs.showparms", true);
    }

    public Map<Integer, Integer> getTypeMappingForPreparedStatement() {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        try {
            Field[] fieldArray;
            for (Field field : fieldArray = SqlUtil.getSqlTypeFields()) {
                int n = field.getInt(null);
                int n2 = this.getIntProperty("types.pstmt.send." + n, n);
                hashMap.put(n, n2);
            }
        }
        catch (Exception exception) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not retrieve type mapping", exception);
        }
        return hashMap;
    }

    public boolean getGenerateTableIndexSource() {
        if (this.isTableSourceRetrievalCustomized()) {
            boolean bl = this.getBoolProperty("retrieve.create.table.index_included", false);
            return !bl;
        }
        return this.getBoolProperty("generate.tablesource.include.indexes", true);
    }

    public boolean getGenerateTableFKSource() {
        if (this.isTableSourceRetrievalCustomized()) {
            boolean bl = this.getBoolProperty("retrieve.create.table.fk_included", false);
            return !bl;
        }
        return this.getBoolProperty("generate.tablesource.include.fk", true);
    }

    public GenerateOwnerType getGenerateTableOwner() {
        String string = this.getProperty("generate.tablesource.include.owner", null);
        return Settings.getInstance().getEnumValue(string, GenerateOwnerType.whenNeeded);
    }

    public boolean getGenerateTableComments() {
        if (this.isTableSourceRetrievalCustomized()) {
            boolean bl = this.getBoolProperty("retrieve.create.table.comments_included", false);
            return !bl;
        }
        boolean bl = Settings.getInstance().getBoolProperty("workbench.db.generate.tablesource.generate.comments", true);
        return this.getBoolProperty("generate.tablesource.include.comments", bl);
    }

    public boolean getUseInlineColumnComments() {
        return this.getBoolProperty("column.comment.inline", false);
    }

    public String getInlineCommentKeyword() {
        return this.getProperty("column.comment.inline.keyword", "COMMENT");
    }

    public boolean getUseInlineTableComments() {
        return this.getBoolProperty("table.comment.inline", false);
    }

    public String getInlineTableCommentKeyword() {
        return this.getProperty("table.comment.inline.keyword", null);
    }

    public boolean getGenerateTableGrants() {
        if (this.isTableSourceRetrievalCustomized()) {
            boolean bl = this.getBoolProperty("retrieve.create.table.grants_included", false);
            return !bl;
        }
        boolean bl = DbExplorerSettings.getGenerateTableGrants();
        return this.getBoolProperty("generate.tablesource.include.grants", bl);
    }

    public boolean needsPKIndexForPKDefinition() {
        return this.getBoolProperty("pksource.needs.pkindex", false);
    }

    public boolean needTableDefinitionForTableSource() {
        boolean bl = this.isTableSourceRetrievalCustomized();
        return this.getBoolProperty("retrieve.create.table.needs_definition", !bl);
    }

    public boolean isTableSourceRetrievalCustomized() {
        return this.isObjectSourceRetrievalCustomized("table");
    }

    public boolean isObjectSourceRetrievalCustomized(String string) {
        if (DBID.Oracle.isDB(this.getDbId()) && OracleUtils.getUseOracleDBMSMeta(OracleUtils.DbmsMetadataTypes.table)) {
            return true;
        }
        return this.getUseCustomizedCreateObjectRetrieval(string) && StringUtil.isNonEmpty(this.getRetrieveObjectSourceSql(string));
    }

    protected boolean getUseCustomizedCreateObjectRetrieval(String string) {
        return this.getBoolProperty("retrieve.create." + string + ".enabled", true);
    }

    public String getRetrieveObjectSourceSql(String string) {
        if (!this.getUseCustomizedCreateObjectRetrieval(string)) {
            return null;
        }
        string = StringUtil.coalesce(this.cleanUpObjectType(string), "table");
        return this.getProperty("retrieve.create." + string + ".query", null);
    }

    public int getRetrieveTableSourceCol(String string) {
        string = StringUtil.coalesce(this.cleanUpObjectType(string), "table");
        return this.getIntProperty("retrieve.create." + string + ".sourcecol", 1);
    }

    public int getRetrieveIndexSourceCol() {
        return this.getIntProperty("retrieve.create.index.sourcecol", 1);
    }

    protected boolean getUseCustomizedCreateIndexRetrieval() {
        return this.getBoolProperty("retrieve.create.index.enabled", true);
    }

    public String getRetrieveIndexSourceSql() {
        if (!this.getUseCustomizedCreateIndexRetrieval()) {
            return null;
        }
        return this.getProperty("retrieve.create.index.query", null);
    }

    public boolean getRetrieveIndexSourceNeedsQuotes() {
        return this.getBoolProperty("retrieve.create.index.checkquotes", true);
    }

    public static List<CreateTableTypeDefinition> getCreateTableTypes() {
        return DbSettings.getCreateTableTypes(null);
    }

    public static List<CreateTableTypeDefinition> getCreateTableTypes(String string) {
        List<String> list = Settings.getInstance().getKeysWithPrefix(".create.table.");
        ArrayList<CreateTableTypeDefinition> arrayList = new ArrayList<CreateTableTypeDefinition>(list.size());
        for (String string2 : list) {
            if (string2.contains(".create.table.sql.") || string2.contains(".retrieve.create.table.") || string2.endsWith(".commit")) continue;
            CreateTableTypeDefinition createTableTypeDefinition = new CreateTableTypeDefinition(string2);
            if (string != null && !string.equals(createTableTypeDefinition.getDbId())) continue;
            arrayList.add(createTableTypeDefinition);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public boolean commitCreateTable(String string) {
        if (string == null) {
            return true;
        }
        String string2 = this.prefix + ".create.table." + string.toLowerCase() + ".commit";
        return Settings.getInstance().getBoolProperty(string2, true);
    }

    public String getCreateTableTemplate(String string) {
        if (StringUtil.isBlank(string)) {
            string = DEFAULT_CREATE_TABLE_TYPE;
        }
        return this.getProperty("create.table." + DbSettings.getKeyValue(string), DEFAULT_CREATE_TABLE_TEMPLATE);
    }

    public Set<String> getViewTypes() {
        List<String> list = Settings.getInstance().getListProperty("workbench.db.viewtypes", false, "VIEW");
        List<String> list2 = this.getListProperty("additional.viewtypes", null);
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        set.addAll(list);
        set.addAll(list2);
        return set;
    }

    public void setCreateTableTemplate(String string, String string2) {
        Settings.getInstance().setProperty(this.prefix + "create.table." + string.toLowerCase(), string2);
    }

    public boolean getRetrieveObjectSourceNeedsQuotes(String string) {
        string = StringUtil.coalesce(this.cleanUpObjectType(string), "TABLE");
        return this.getBoolProperty("retrieve.create." + string + ".checkquotes", true);
    }

    public boolean applyFormatForNativeTableSource() {
        return this.applyFormatForNativeSource("table");
    }

    public boolean applyFormatForNativeSource(String string) {
        return this.getBoolProperty("retrieve.create." + string + ".reformat", false);
    }

    public boolean isSearchable(String string) {
        if (StringUtil.isBlank(string)) {
            return false;
        }
        List<String> list = this.getListProperty("datatypes.searchable", null, true);
        return list.contains(string.toLowerCase());
    }

    public String getAlterColumnDataTypeSql() {
        return this.getProperty("alter.column.type", null);
    }

    public String getRenameColumnSql() {
        return this.getProperty("alter.column.rename", null);
    }

    public String getAlterColumnSetNotNull() {
        return this.getProperty("alter.column.notnull.set", null);
    }

    public String getAlterColumnDropNotNull() {
        return this.getProperty("alter.column.notnull.drop", null);
    }

    public String getAlterColumnDefaultSql() {
        return this.getProperty("alter.column.default", null);
    }

    public String getSetColumnDefaultSql() {
        return this.getProperty("alter.column.default.set", null);
    }

    public String getDropColumnDefaultSql() {
        return this.getProperty("alter.column.default.drop", null);
    }

    public String getRenameObjectSql(String string) {
        if (StringUtil.isBlank(string)) {
            return null;
        }
        return this.getProperty("alter." + DbSettings.getKeyValue(string) + ".rename", null);
    }

    public Collection<String> getExportTypesNeedingQuotes() {
        return this.getListProperty("export.quoting.needed");
    }

    public String getChangeSchemaSql(String string) {
        if (StringUtil.isBlank(string)) {
            return null;
        }
        return this.getProperty("alter." + DbSettings.getKeyValue(string) + ".change.schema", null);
    }

    public String getChangeCatalogSql(String string) {
        if (StringUtil.isBlank(string)) {
            return null;
        }
        return this.getProperty("alter." + DbSettings.getKeyValue(string) + ".change.catalog", null);
    }

    public String getDropPrimaryKeySql(String string) {
        if (StringUtil.isBlank(string)) {
            return null;
        }
        return this.getProperty("alter." + DbSettings.getKeyValue(string) + ".drop.pk", null);
    }

    public String getDropConstraint(String string) {
        if (StringUtil.isBlank(string)) {
            return null;
        }
        return this.getProperty("alter." + DbSettings.getKeyValue(string) + ".drop.constraint", null);
    }

    public String getDropFKConstraint(String string) {
        if (StringUtil.isBlank(string)) {
            return null;
        }
        String string2 = this.getDropConstraint(string);
        return this.getProperty("alter." + DbSettings.getKeyValue(string) + ".drop.fk_constraint", string2);
    }

    public String getAddPK(String string) {
        return this.getAddPK(string, false);
    }

    public String getAddPK(String string, boolean bl) {
        if (StringUtil.isBlank(string)) {
            return null;
        }
        String string2 = this.getProperty("alter." + DbSettings.getKeyValue(string) + ".add.pk", null);
        if (StringUtil.isEmptyString(string2) && bl) {
            string2 = Settings.getInstance().getProperty("workbench.db.sql.alter." + DbSettings.getKeyValue(string) + ".add.pk", null);
        }
        return string2;
    }

    public String cleanUpObjectType(String string) {
        if (string == null) {
            return "";
        }
        return string.toLowerCase().trim().replace(' ', '_');
    }

    public boolean columnCommentAllowed(String string) {
        if (StringUtil.isBlank(string)) {
            return false;
        }
        String string2 = this.cleanUpObjectType(string);
        List<String> list = this.getListProperty("columncomment.types", "table");
        return list.contains(string2);
    }

    public static boolean getExcludePostgresDefaultRules() {
        return Settings.getInstance().getBoolProperty("workbench.db.postgresql.exclude.defaultselectrule", true);
    }

    public boolean useXmlAPI() {
        return this.getBoolProperty("use.xmlapi", false);
    }

    public boolean isClobType(String string) {
        if (string == null) {
            return false;
        }
        return this.getBoolProperty("isclob." + string, false);
    }

    public boolean pkIndexHasTableName() {
        return this.getBoolProperty("pkconstraint.is_table_name", false);
    }

    public boolean createTriggerNeedsAlternateDelimiter() {
        return this.getBoolProperty("alternate.delim.create.trigger", true);
    }

    public boolean getSearchAllSchemas() {
        return this.getBoolProperty("search.all.schemas", true);
    }

    public String getInlinePKKeyword() {
        return this.getProperty("sql.pk.inline", "PRIMARY KEY");
    }

    public boolean returnsValidDefaultExpressions() {
        return this.getBoolProperty("defaultvalue.isexpression", true);
    }

    public boolean usePreparedStatementForQueryInfo() {
        return this.getBoolProperty("queryinfo.preparedstatement", false);
    }

    public void setUsePreparedStatementForQueryInfo(boolean bl) {
        Settings.getInstance().setProperty(this.prefix + "queryinfo.preparedstatement", bl);
    }

    public boolean alwaysUseSchemaForCompletion() {
        return this.getBoolProperty("completion.always_use.schema", false);
    }

    public boolean alwaysUseCatalogForCompletion() {
        return this.getBoolProperty("completion.always_use.catalog", false);
    }

    public String getUniqueKeyViolationErrorState() {
        return this.getProperty("errorstate.unique", null);
    }

    public int getUniqueKeyViolationErrorCode() {
        return this.getIntProperty("errorcode.unique", -1);
    }

    public boolean supportsResultMetaGetTable() {
        return this.getBoolProperty("resultmetadata.gettablename.supported", false);
    }

    public void setSupportsResultMetaGetTable(boolean bl) {
        this.setPropertyTemporary("resultmetadata.gettablename.supported", false);
    }

    public boolean supportsTriggersOnViews() {
        return this.getBoolProperty("view.trigger.supported", false);
    }

    public boolean supportsTriggers() {
        return this.getBoolProperty("trigger.supported", true);
    }

    public boolean changeCatalogToRetrieveSchemas() {
        return this.getBoolProperty("schema.retrieve.change.catalog", false);
    }

    public boolean supportsCatalogForGetSchemas() {
        return this.getBoolProperty("getschemas.per.catalog.supported", false);
    }

    public boolean supportsCatalogs() {
        return this.getBoolProperty("catalogs.supported", true);
    }

    public boolean supportsSchemas() {
        return this.getBoolProperty("schemas.supported", true);
    }

    public boolean schemaIsCatalog() {
        return this.getBoolProperty("schema.is.catalog", false);
    }

    public boolean supportsParameterMetaData() {
        return this.getBoolProperty("parameter.metadata.supported", true);
    }

    public boolean supportsParameterMetaDataForCallableStatement() {
        return this.getBoolProperty("parameter.metadata.callablestatement.supported", true);
    }

    public boolean doEscapeSearchString() {
        return this.getBoolProperty("escape.searchstrings", true);
    }

    public String getSearchStringEscape() {
        return this.getProperty("searchstringescape", null);
    }

    public boolean fixFKRetrieval() {
        return this.getBoolProperty("fixfkretrieval", true);
    }

    public Set<String> getTableTypeSynonyms() {
        return CollectionUtil.caseInsensitiveSet(this.getListProperty("table.type.alternate.names"));
    }

    public String getIdentifierQuoteString() {
        String string = "identifier.quote";
        String string2 = this.getProperty("quote.escape", null);
        if (string2 != null) {
            LogMgr.logWarning(new CallerInfo(){}, "Deprecated property \"" + this.prefix + ".quote.escape\" used. Renaming to: " + this.prefix + string);
            Settings.getInstance().removeProperty(this.prefix + "quote.escape");
            Settings.getInstance().setProperty(this.prefix + string, string2);
        } else {
            string2 = this.getProperty(string, null);
        }
        return string2;
    }

    public boolean clearCacheOnReconnect() {
        boolean bl = Settings.getInstance().getBoolProperty("workbench.db.objectcache.disconnect.clear", false);
        return this.getBoolProperty("objectcache.disconnect.clear", bl);
    }

    public boolean populateCacheInBackground() {
        boolean bl = Settings.getInstance().getBoolProperty("workbench.db.objectcache.retrieve.background", true);
        return this.getBoolProperty("objectcache.retrieve.background", bl);
    }

    public boolean useCacheForObjectInfo() {
        boolean bl = Settings.getInstance().getBoolProperty("workbench.db.objectinfo.usecache", false);
        return this.getBoolProperty("objectinfo.usecache", bl);
    }

    public boolean objectInfoWithFK() {
        boolean bl = Settings.getInstance().getBoolProperty("workbench.db.objectinfo.includefk", false);
        return this.getBoolProperty("objectinfo.includefk", bl);
    }

    public boolean objectInfoWithDependencies() {
        boolean bl = Settings.getInstance().getBoolProperty("workbench.db.objectinfo.includedeps", false);
        return this.getBoolProperty("objectinfo.includedeps", bl);
    }

    public boolean useSavePointForTransactionCheck() {
        return this.getBoolProperty("opentransaction.usesavepoint", false);
    }

    public String checkOpenTransactionsQuery() {
        return this.getProperty("opentransaction.query", null);
    }

    public String getCatalogSeparator() {
        return this.getProperty("separator.catalog", null);
    }

    public boolean useCatalogSeparatorForSchema() {
        return this.getBoolProperty("separator.catalog.forschema", false);
    }

    public String getSchemaSeparator() {
        return this.getProperty("separator.schema", ".");
    }

    public boolean createInlinePKConstraints() {
        return this.getBoolProperty("pk.inline", false);
    }

    public boolean createInlineFKConstraints() {
        return this.getBoolProperty("fk.inline", false);
    }

    public boolean supportsFkOption(String string, String string2) {
        String string3 = string2.toLowerCase().replace(' ', '_');
        return this.getBoolProperty("fk." + string.toLowerCase() + "." + string3 + ".supported", true);
    }

    public boolean supportsMetaDataWildcards() {
        return this.getBoolProperty("metadata.retrieval.wildcards", true);
    }

    public boolean supportsMetaDataSchemaWildcards() {
        return this.supportsMetaDataWildcards("schema");
    }

    public boolean supportsMetaDataCatalogWildcards() {
        return this.supportsMetaDataWildcards("catalog");
    }

    public boolean supportsMetaDataNullPattern() {
        return this.getBoolProperty("metadata.pattern.tablename.null.supported", true);
    }

    private boolean supportsMetaDataWildcards(String string) {
        return this.getBoolProperty("metadata.retrieval.wildcards." + string, this.supportsMetaDataWildcards());
    }

    public int getLockTimoutForSqlServer() {
        return this.getIntProperty("dbexplorer.locktimeout", 2500);
    }

    public boolean endTransactionAfterConnect() {
        return this.getBoolProperty("afterconnect.finishtrans", false);
    }

    public String getTableSelectTemplate(String string) {
        String string2 = Settings.getInstance().getProperty("workbench.db.sql." + string + ".select", null);
        return this.getProperty(string + ".select", string2);
    }

    public String getSwitchCatalogStatement() {
        return this.getProperty("switchcatalog.sql", "USE %catalog%");
    }

    public boolean getSwitchCatalogInExplorer() {
        return this.getBoolProperty("dbexplorer.switchcatalog", DbExplorerSettings.getSwitchCatalogInExplorer());
    }

    public boolean fixSqlServerAutoincrement() {
        return Settings.getInstance().getBoolProperty("workbench.db.microsoft_sql_server.autoincrement.fix", true);
    }

    public String getLowerFunctionTemplate() {
        return this.getProperty("sql.function.lower", null);
    }

    public String getDisabledConstraintKeyword() {
        return this.getProperty("sql.constraint.disabled", null);
    }

    public String getNoValidateConstraintKeyword() {
        return this.getProperty("sql.constraint.notvalid", null);
    }

    public boolean getUseGenericExecuteForSelect() {
        boolean bl = Settings.getInstance().getUseGenericExecuteForSelect();
        return this.getBoolProperty("select.executegeneric", bl);
    }

    public boolean useCleanSQLForPreparedStatements() {
        return this.getBoolProperty("preparedstaments.cleansql", false);
    }

    public boolean supportsAutomaticFkIndexes() {
        return this.getBoolProperty("fk.index.automatic", false);
    }

    public boolean useReadUncommittedForDbExplorer() {
        return this.getBoolProperty("dbexplorer.use.read_uncommitted", false);
    }

    public boolean useFullSearchPathForCompletion() {
        return this.getBoolProperty("completion.full.searchpath", false);
    }

    public boolean useCurrentNamespaceForCompletion() {
        return this.getBoolProperty("completion.current.namespace", Settings.getInstance().getAutoCompletionUseCurrentNameSpace());
    }

    public boolean cleanupTypeList() {
        return this.getBoolProperty("metadata.cleanup.types", false);
    }

    public boolean useMaxRows(String string) {
        if (this.alwaysUseMaxRows) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return this.useMaxRowsVerbs.contains(string);
    }

    public Set<String> verbsWithoutUpdateCount() {
        return Collections.unmodifiableSet(this.noUpdateCountVerbs);
    }

    private void readUpdatingCommands() {
        String string = Settings.getInstance().getProperty("workbench.db.updatingcommands", null);
        this.updatingCommands.addAll(StringUtil.stringToList(string, ",", true, true));
        String string2 = this.getProperty("updatingcommands", null);
        this.updatingCommands.addAll(StringUtil.stringToList(string2, ",", true, true));
    }

    private void readMaxRowVerbs() {
        String string = Settings.getInstance().getProperty("workbench.db.maxrows.verbs", null);
        this.useMaxRowsVerbs.addAll(StringUtil.stringToList(string, ",", true, true));
        String string2 = this.getProperty("maxrows.verbs", null);
        List<String> list = StringUtil.stringToList(string2, ",", true, true);
        for (String string3 : list) {
            if (StringUtil.isEmptyString(string3)) continue;
            if (string3.startsWith("-")) {
                this.useMaxRowsVerbs.remove(string3.substring(1));
                continue;
            }
            this.useMaxRowsVerbs.add(string3);
        }
        this.alwaysUseMaxRows = this.useMaxRowsVerbs.contains("*");
    }

    private void readNoUpdateCountVerbs() {
        List<String> list = this.getListProperty("no.updatecount.default");
        this.noUpdateCountVerbs.addAll(list);
        List<String> list2 = this.getListProperty("no.updatecount");
        for (String string : list2) {
            if (StringUtil.isEmptyString(string)) continue;
            if (string.charAt(0) == '-') {
                this.noUpdateCountVerbs.remove(string.substring(1));
                continue;
            }
            this.noUpdateCountVerbs.add(string);
        }
    }

    public boolean disableEscapesForDDL() {
        return this.getBoolProperty("ddl.disable.escapeprocessing", true);
    }

    public boolean hideOracleIdentitySequences() {
        return this.getBoolProperty("sequence.identity.hide", false);
    }

    public boolean useColumnNameForMetadata() {
        return this.getBoolProperty("metadata.retrieval.columnnames", true);
    }

    public boolean returnAccessibleProceduresOnly() {
        return this.getBoolProperty("procedurelist.only.accessible", true);
    }

    public boolean returnAccessibleTablesOnly() {
        return this.getBoolProperty("tablelist.only.accessible", false);
    }

    public boolean checkIndexTable() {
        return this.getBoolProperty("metadata.index.check.table", false);
    }

    public String getDDLIfNoExistsOption(String string) {
        if (this.getUseConditionalDDL()) {
            return this.getProperty("ddl.create." + this.cleanUpObjectType(string) + ".ifnotexists", null);
        }
        return null;
    }

    public boolean getUseConditionalDDL() {
        return this.getBoolProperty("ddl.use.conditional", true);
    }

    public boolean getBoolProperty(String string, boolean bl) {
        String string2 = this.getProperty(string, null);
        if (string2 == null) {
            return bl;
        }
        return Boolean.valueOf(string2);
    }

    public int getIntProperty(String string, int n) {
        String string2 = this.getProperty(string, null);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (Throwable throwable) {
            return n;
        }
    }

    public boolean generateColumnListInViews() {
        boolean bl = DbExplorerSettings.getGenerateColumnListInViews();
        return this.getBoolProperty("create.view.columnlist", bl);
    }

    public String getErrorColumnInfoRegex() {
        return this.getProperty("errorinfo.regex.column", null);
    }

    public String getErrorLineInfoRegex() {
        return this.getProperty("errorinfo.regex.line", null);
    }

    public String getErrorPosInfoRegex() {
        return this.getProperty("errorinfo.regex.position", null);
    }

    public boolean getErrorPosIsZeroBased() {
        return this.getBoolProperty("errorinfo.zerobased", true);
    }

    public boolean getErrorPosIncludesLeadingComments() {
        return this.getBoolProperty("errorinfo.leading.comment.included", false);
    }

    public boolean getCheckResultSetReadOnlyCols() {
        return this.getBoolProperty("resultset.columns.check.readonly", true);
    }

    public boolean getRetrieveGeneratedKeys() {
        return this.getBoolProperty("insert.retrieve.keys", true);
    }

    public Collection<String> getIgnoreCompletionSchemas() {
        return this.getListProperty("completion.ignore.schema", null);
    }

    public Collection<String> getIgnoreCompletionCatalogs() {
        return this.getListProperty("completion.ignore.catalog", null);
    }

    public Set<String> getGrantorsToIgnore() {
        List<String> list = this.getListProperty("ignore.grantor");
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        set.addAll(list);
        return set;
    }

    public Set<String> getGranteesToIgnore() {
        List<String> list = this.getListProperty("ignore.grantee");
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        set.addAll(list);
        return set;
    }

    public boolean supportsSetSchema() {
        return this.getBoolProperty("supports.schema_change", false);
    }

    public EndReadOnlyTrans getAutoCloseReadOnlyTransactions() {
        String string = Settings.getInstance().getProperty("workbench.sql.transaction.readonly.end", EndReadOnlyTrans.never.name());
        String string2 = this.getProperty("transaction.readonly.end", string);
        return Settings.getInstance().getEnumValue(string2, EndReadOnlyTrans.never);
    }

    public Set<Integer> getInformationalWarningCodes() {
        List<String> list = this.getListProperty("warning.ignore.codes");
        if (list.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Integer> hashSet = new HashSet<Integer>(list.size());
        for (String string : list) {
            hashSet.add(StringUtil.getIntValue(string, Integer.MIN_VALUE));
        }
        return hashSet;
    }

    public Set<String> getInformationalWarningStates() {
        List<String> list = this.getListProperty("warning.ignore.sqlstate");
        if (list.isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<String>(list);
    }

    public List<String> getSchemasToAdd() {
        return this.getListProperty("schemas.additional", null);
    }

    public boolean checkUniqueIndexesForPK() {
        boolean bl = Settings.getInstance().getBoolProperty("workbench.db.pk.retrieval.checkunique", true);
        return this.getBoolProperty("pk.retrieval.checkunique", bl);
    }

    public boolean getUpdateTableCheckPkOnly() {
        String string = "updatetable.check.pkonly";
        boolean bl = Settings.getInstance().getBoolProperty("workbench.db." + string, false);
        return this.getBoolProperty(string, bl);
    }

    public boolean useCompletionCacheForUpdateTableCheck() {
        String string = "updatetable.check.use.cache";
        boolean bl = Settings.getInstance().getBoolProperty("workbench.db." + string, false);
        return this.getBoolProperty(string, bl);
    }

    public String getLimitClause() {
        return this.getVersionedString("select.limit", null);
    }

    public boolean fixStupidMySQLZeroDate() {
        return this.getBoolProperty("timestamp.ignore.read.errors", false);
    }

    public boolean addWarningsOnError() {
        return this.getBoolProperty("error.include.warning", true);
    }

    public boolean supportsFunctionOverloading() {
        return this.getBoolProperty("function.overloading.supported", false);
    }

    public boolean showProcedureParameters() {
        return this.getBoolProperty("procedurelist.showparameters", false);
    }

    public boolean retrieveWarningsForEachResult() {
        return this.getBoolProperty("warning.retrieve.eachresult", false);
    }

    public boolean supportsReplace(String string) {
        return this.getBoolProperty("ddl" + DbSettings.getKeyValue(string) + ".replace.supported", false);
    }

    public boolean useGetFunctions() {
        return this.getBoolProperty("procedurereader.use.getfunctions", false);
    }

    public boolean syncConnectionReadOnlyState() {
        return this.getBoolProperty("change.connection.readonly.state", true);
    }

    public String getSetReadOnlySQL() {
        return this.getProperty("change.connection.readonly.sql", null);
    }

    public String getSetReadWriteSQL() {
        return this.getProperty("change.connection.readwrite.sql", null);
    }

    public Set<String> getTypesRequiringAlternateDelimiter() {
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        String string = this.getProperty("types.alternatedelimiter", "procedure,function,trigger");
        set.addAll(StringUtil.stringToList(string, ",", true, true));
        return set;
    }

    public boolean trimObjectNames(String string) {
        boolean bl = this.getBoolProperty("trim.names", true);
        return this.getBoolProperty(string + ".trim.names", bl);
    }

    public String getUnboundedVarcharType() {
        return this.getProperty("varchar.type.unlimited", null);
    }

    public int getMaxVarcharLength() {
        return this.getIntProperty("varchar.max.length", 32762);
    }

    public boolean quoteIndexColumnNames() {
        return this.getBoolProperty("index.columns.quote", true);
    }

    public boolean databaseProductVersionReturnsRealVersion() {
        return this.getBoolProperty("databaseproductversion.realversion", false);
    }

    public boolean supportsEmbeddedResults() {
        return this.getBoolProperty("supports.embedded.results", false);
    }

    public boolean refcursorIsEmbeddedResult() {
        return this.getBoolProperty("embedded.results.refcursor", false);
    }

    public boolean supportsUseDBStatement() {
        return this.getBoolProperty("sql.supports.usedb", false);
    }

    public boolean ignoreSQLErrorsForGetMoreResults() {
        return this.getBoolProperty("getmoreresults.ignore.sqlerrors", false);
    }

    public Set<String> getScriptOnlyObjects() {
        List<String> list = this.getListProperty("scriptonly.objects", "");
        return CollectionUtil.caseInsensitiveSet(list);
    }

    public Set<String> getGlobalObjectTypes() {
        List<String> list = this.getListProperty("objects.global", "");
        return CollectionUtil.caseInsensitiveSet(list);
    }

    public Set<String> getCatalogLevelTypes() {
        List<String> list = this.getListProperty("objects.catalog.global", "");
        return CollectionUtil.caseInsensitiveSet(list);
    }

    public boolean enableDatabaseSwitcher() {
        return this.getBoolProperty("gui.enable.dbswitcher", false);
    }

    public boolean autoDisableDriverBuffering() {
        return this.getBoolProperty("export.driver.buffering.disable", false);
    }

    public boolean treatSchemaChangeErrorAsWarning() {
        return this.getBoolProperty("setschema.exception.is.warning", false);
    }

    public boolean useSQLiteDataReader() {
        return this.getBoolProperty("use.specific.rowdatareader", true);
    }

    public boolean showSuccessMessageForVerb(String string) {
        if (string == null) {
            return false;
        }
        String string2 = "show.success." + string.toLowerCase();
        boolean bl = Settings.getInstance().getBoolProperty("workbench.db." + string2, true);
        return this.getBoolProperty(string2, bl);
    }

    public static enum GenerateOwnerType {
        always,
        whenNeeded,
        never;

    }
}

