/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DropType;
import workbench.db.GetMetaDataSql;
import workbench.db.IndexDefinition;
import workbench.db.JdbcUtils;
import workbench.db.NoConfigException;
import workbench.db.SourceStatementsHelp;
import workbench.db.TableCommentReader;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.TableSourceBuilder;
import workbench.db.TableSourceBuilderFactory;
import workbench.db.ViewGrantReader;
import workbench.db.ViewReader;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.sql.formatter.WbSqlFormatter;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.StringUtil;

public class DefaultViewReader
implements ViewReader {
    protected WbConnection connection;

    public DefaultViewReader(WbConnection wbConnection) {
        this.connection = wbConnection;
    }

    @Override
    public CharSequence getExtendedViewSource(TableIdentifier tableIdentifier) throws SQLException {
        return this.getExtendedViewSource(new TableDefinition(tableIdentifier), DropType.none, false);
    }

    @Override
    public CharSequence getExtendedViewSource(TableIdentifier tableIdentifier, DropType dropType) throws SQLException {
        return this.getExtendedViewSource(new TableDefinition(tableIdentifier), dropType, false);
    }

    @Override
    public CharSequence getFullViewSource(TableDefinition tableDefinition) throws SQLException, NoConfigException {
        return this.createFullViewSource(tableDefinition, DropType.none, false);
    }

    protected CharSequence createFullViewSource(TableDefinition tableDefinition, DropType dropType, boolean bl) throws SQLException, NoConfigException {
        boolean bl2;
        TableIdentifier tableIdentifier = tableDefinition.getTable();
        CharSequence charSequence = this.getViewSource(tableIdentifier);
        List<ColumnIdentifier> list = tableDefinition.getColumns();
        if (CollectionUtil.isEmpty(list)) {
            tableDefinition = this.connection.getMetadata().getTableDefinition(tableDefinition.getTable());
            list = tableDefinition.getColumns();
        }
        if (StringUtil.isEmptyString(charSequence)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(charSequence.length() + 100);
        String string = Settings.getInstance().getInternalEditorLineEnding();
        String string2 = this.connection.getParsingUtil().getSqlVerb(charSequence.toString());
        TableSourceBuilder tableSourceBuilder = TableSourceBuilderFactory.getBuilder(this.connection);
        boolean bl3 = bl2 = dropType != DropType.none;
        if (dropType == DropType.regular && !string2.equals("CREATE OR REPLACE") && !string2.equalsIgnoreCase("REPLACE")) {
            bl2 = true;
        }
        if (string2.startsWith("CREATE") || string2.equals("REPLACE")) {
            if (bl2) {
                stringBuilder.append(tableSourceBuilder.generateDrop(tableIdentifier, dropType));
                stringBuilder.append(string);
                stringBuilder.append(string);
            }
            stringBuilder.append(charSequence);
            if (this.connection.getDbSettings().ddlNeedsCommit() && bl) {
                stringBuilder.append(string);
                stringBuilder.append("COMMIT;");
                stringBuilder.append(string);
            }
        } else {
            stringBuilder.append((CharSequence)tableSourceBuilder.generateCreateObject(dropType, tableIdentifier, null));
            if (this.connection.getDbSettings().generateColumnListInViews()) {
                stringBuilder.append(string);
                stringBuilder.append('(');
                stringBuilder.append(string);
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    String string3 = list.get(i).getColumnName();
                    stringBuilder.append("  ");
                    stringBuilder.append(this.connection.getMetadata().quoteObjectname(string3));
                    if (i >= n - 1) continue;
                    stringBuilder.append(',');
                    stringBuilder.append(string);
                }
                stringBuilder.append(string);
                stringBuilder.append(')');
            }
            stringBuilder.append(string);
            stringBuilder.append("AS ");
            stringBuilder.append(string);
            stringBuilder.append(charSequence);
            stringBuilder.append(string);
        }
        return stringBuilder;
    }

    @Override
    public CharSequence getExtendedViewSource(TableDefinition tableDefinition, DropType dropType, boolean bl) throws SQLException {
        StringBuilder stringBuilder;
        List<IndexDefinition> list;
        StringBuilder stringBuilder2;
        String string;
        Object object;
        TableIdentifier tableIdentifier = tableDefinition.getTable();
        CharSequence charSequence = null;
        try {
            charSequence = this.createFullViewSource(tableDefinition, dropType, bl);
        }
        catch (NoConfigException noConfigException) {
            SourceStatementsHelp sourceStatementsHelp = new SourceStatementsHelp(this.connection.getMetadata().getMetaDataSQLMgr());
            return sourceStatementsHelp.explainMissingViewSourceSql();
        }
        if (StringUtil.isEmptyString(charSequence)) {
            return "";
        }
        StringBuilder stringBuilder3 = new StringBuilder(charSequence.length() + 100);
        stringBuilder3.append(charSequence);
        String string2 = Settings.getInstance().getInternalEditorLineEnding();
        ViewGrantReader viewGrantReader = ViewGrantReader.createViewGrantReader(this.connection);
        if (viewGrantReader != null && (object = viewGrantReader.getViewGrantSource(this.connection, tableDefinition.getTable())) != null && object.length() > 0) {
            stringBuilder3.append(Settings.getInstance().getInternalEditorLineEnding());
            stringBuilder3.append(Settings.getInstance().getInternalEditorLineEnding());
            stringBuilder3.append((CharSequence)object);
            stringBuilder3.append(Settings.getInstance().getInternalEditorLineEnding());
        }
        if (StringUtil.isNonBlank(string = ((TableCommentReader)(object = new TableCommentReader())).getTableCommentSql(this.connection, tableDefinition.getTable()))) {
            stringBuilder3.append(string);
            if (!string.endsWith(";")) {
                stringBuilder3.append(';');
            }
        }
        if (StringUtil.isNonBlank(stringBuilder2 = ((TableCommentReader)object).getTableColumnCommentsSql(this.connection, tableDefinition.getTable(), tableDefinition.getColumns()))) {
            stringBuilder3.append(string2);
            stringBuilder3.append((CharSequence)stringBuilder2);
            stringBuilder3.append(string2);
        }
        if ((list = this.connection.getMetadata().getIndexReader().getTableIndexList(tableIdentifier, true)).size() > 0 && (stringBuilder = this.connection.getMetadata().getIndexReader().getIndexSource(tableIdentifier, list)) != null && stringBuilder.length() > 0) {
            stringBuilder3.append(string2);
            stringBuilder3.append(string2);
            stringBuilder3.append((CharSequence)stringBuilder);
            stringBuilder3.append(string2);
        }
        if (this.connection.getDbSettings().ddlNeedsCommit() && bl) {
            stringBuilder3.append("COMMIT;");
        }
        return stringBuilder3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence getViewSource(TableIdentifier tableIdentifier) throws NoConfigException {
        if (tableIdentifier == null) {
            return null;
        }
        if (this.connection.getDbSettings().isObjectSourceRetrievalCustomized(tableIdentifier.getType())) {
            TableSourceBuilder tableSourceBuilder = TableSourceBuilderFactory.getBuilder(this.connection);
            return tableSourceBuilder.getNativeTableSource(tableIdentifier, DropType.none);
        }
        GetMetaDataSql getMetaDataSql = this.connection.getMetadata().getMetaDataSQLMgr().getViewSourceSql();
        if (getMetaDataSql == null) {
            throw new NoConfigException("No SQL to retrieve the VIEW source");
        }
        StringBuilder stringBuilder = new StringBuilder(500);
        Statement statement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        String string = null;
        try {
            Object object;
            if (this.connection.getDbSettings().useSavePointForDML()) {
                savepoint = this.connection.setSavepoint();
            }
            TableIdentifier tableIdentifier2 = tableIdentifier.createCopy();
            tableIdentifier2.adjustCase(this.connection);
            getMetaDataSql.setSchema(tableIdentifier2.getRawSchema());
            getMetaDataSql.setObjectName(tableIdentifier2.getRawTableName());
            getMetaDataSql.setCatalog(tableIdentifier2.getRawCatalog());
            if (getMetaDataSql.isPreparedStatement()) {
                string = getMetaDataSql.getBaseSql();
                LogMgr.logMetadataSql(new CallerInfo(){}, "view source", string, tableIdentifier2.getRawCatalog(), tableIdentifier2.getRawSchema(), tableIdentifier2.getRawTableName());
                object = getMetaDataSql.prepareStatement(this.connection, tableIdentifier2.getRawCatalog(), tableIdentifier2.getRawSchema(), tableIdentifier2.getRawTableName());
                resultSet = object.executeQuery();
            } else {
                statement = this.connection.createStatementForQuery();
                string = getMetaDataSql.getSql();
                LogMgr.logMetadataSql(new CallerInfo(){}, "view source", string, new Object[0]);
                resultSet = statement.executeQuery(string);
            }
            while (resultSet.next()) {
                object = resultSet.getString(1);
                if (object == null) continue;
                stringBuilder.append((String)object);
            }
            if (stringBuilder.length() > 0) {
                StringUtil.trimTrailingWhitespace(stringBuilder);
                if (this.connection.getDbSettings().getFormatViewSource()) {
                    object = new WbSqlFormatter((CharSequence)stringBuilder, this.connection.getDbId());
                    stringBuilder = new StringBuilder(((WbSqlFormatter)object).getFormattedSql());
                }
                if (!StringUtil.endsWith((CharSequence)stringBuilder, ';')) {
                    stringBuilder.append(';');
                    stringBuilder.append(Settings.getInstance().getInternalEditorLineEnding());
                }
            }
            this.connection.releaseSavepoint(savepoint);
            JdbcUtils.closeAll(resultSet, statement);
        }
        catch (Exception exception) {
            LogMgr.logMetadataError(new CallerInfo(){}, exception, "view source", string, new Object[0]);
            stringBuilder = new StringBuilder(ExceptionUtil.getDisplay(exception));
            this.connection.rollback(savepoint);
        }
        finally {
            JdbcUtils.closeAll(resultSet, statement);
        }
        return stringBuilder;
    }
}

