/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.SqlUtil;

public class DriverInfo {
    private Map<String, String> infoMap = new HashMap<String, String>(30);
    private final Set<String> methods = new TreeSet<String>();

    public DriverInfo(Connection connection) {
        this.methods.add("getSearchStringEscape");
        this.methods.add("getCatalogSeparator");
        this.methods.add("getExtraNameCharacters");
        this.methods.add("getIdentifierQuoteString");
        this.methods.add("getProcedureTerm");
        this.methods.add("getSchemaTerm");
        this.methods.add("getCatalogTerm");
        this.methods.add("allProceduresAreCallable");
        this.methods.add("allTablesAreSelectable");
        this.methods.add("dataDefinitionCausesTransactionCommit");
        this.methods.add("dataDefinitionIgnoredInTransactions");
        this.methods.add("nullPlusNonNullIsNull");
        this.methods.add("nullsAreSortedAtEnd");
        this.methods.add("nullsAreSortedAtStart");
        this.methods.add("nullsAreSortedAtEnd");
        this.methods.add("getMaxCharLiteralLength");
        this.methods.add("getMaxColumnNameLength");
        this.methods.add("getMaxColumnsInIndex");
        this.methods.add("getMaxTableNameLength");
        this.methods.add("getMaxTablesInSelect");
        this.methods.add("getMaxStatementLength");
        this.methods.add("storesLowerCaseIdentifiers");
        this.methods.add("storesUpperCaseIdentifiers");
        this.methods.add("storesMixedCaseIdentifiers");
        this.methods.add("storesMixedCaseQuotedIdentifiers");
        this.methods.add("storesLowerCaseQuotedIdentifiers");
        this.methods.add("storesUpperCaseQuotedIdentifiers");
        this.methods.add("supportsAlterTableWithAddColumn");
        this.methods.add("supportsAlterTableWithDropColumn");
        this.methods.add("supportsANSI92EntryLevelSQL");
        this.methods.add("supportsANSI92FullSQL");
        this.methods.add("supportsANSI92IntermediateSQL");
        this.methods.add("supportsBatchUpdates");
        this.methods.add("supportsColumnAliasing");
        this.methods.add("supportsCorrelatedSubqueries");
        this.methods.add("supportsCoreSQLGrammar");
        this.methods.add("supportsDataDefinitionAndDataManipulationTransactions");
        this.methods.add("supportsDataManipulationTransactionsOnly");
        this.methods.add("supportsFullOuterJoins");
        this.methods.add("supportsGetGeneratedKeys");
        this.methods.add("supportsLikeEscapeClause");
        this.methods.add("supportsMultipleResultSets");
        this.methods.add("supportsMultipleTransactions");
        this.methods.add("supportsMixedCaseIdentifiers");
        this.methods.add("supportsMixedCaseQuotedIdentifiers");
        this.methods.add("supportsSavepoints");
        this.methods.add("supportsSchemasInTableDefinitions");
        this.methods.add("supportsSchemasInDataManipulation");
        this.methods.add("supportsSchemasInIndexDefinitions");
        this.methods.add("supportsSchemasInProcedureCalls");
        this.methods.add("supportsCatalogsInTableDefinitions");
        this.methods.add("supportsCatalogsInDataManipulation");
        this.methods.add("supportsCatalogsInIndexDefinitions");
        this.methods.add("supportsCatalogsInProcedureCalls");
        this.methods.add("supportsStoredProcedures");
        this.methods.add("supportsSubqueriesInComparisons");
        this.methods.add("supportsSubqueriesInExists");
        this.methods.add("supportsSubqueriesInIns");
        this.methods.add("supportsTableCorrelationNames");
        this.methods.add("supportsTransactions");
        this.methods.add("supportsUnion");
        this.methods.add("supportsUnionAll");
        this.fillMap(connection);
    }

    private void fillMap(Connection connection) {
        DatabaseMetaData databaseMetaData = null;
        try {
            databaseMetaData = connection.getMetaData();
            int n = databaseMetaData.getDefaultTransactionIsolation();
            this.infoMap.put("defaultIsolationLevel", SqlUtil.getIsolationLevelName(n));
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Could not obtain MetaData", sQLException);
        }
        if (databaseMetaData == null) {
            return;
        }
        for (String string : this.methods) {
            String string2 = this.getValue(databaseMetaData, string);
            if (string.startsWith("get")) {
                this.infoMap.put(Character.toLowerCase(string.charAt(3)) + string.substring(4), string2);
                continue;
            }
            this.infoMap.put(string, string2);
        }
    }

    public Map<String, String> getInfoMap() {
        return Collections.unmodifiableMap(this.infoMap);
    }

    public DataStore getInfo() {
        DataStore dataStore = new DataStore(new String[]{"FEATURE", "VALUE"}, new int[]{12, 12});
        for (Map.Entry<String, String> entry : this.infoMap.entrySet()) {
            int n = dataStore.addRow();
            dataStore.setValue(n, 0, (Object)entry.getKey());
            dataStore.setValue(n, 1, (Object)entry.getValue());
        }
        dataStore.sortByColumn(0, true);
        return dataStore;
    }

    private String getValue(DatabaseMetaData databaseMetaData, String string) {
        if (databaseMetaData == null) {
            return "n/a";
        }
        try {
            Method method = databaseMetaData.getClass().getMethod(string, new Class[0]);
            Object object = method.invoke((Object)databaseMetaData, new Object[0]);
            if (object == null) {
                return "";
            }
            return object.toString();
        }
        catch (Throwable throwable) {
            LogMgr.logDebug(new CallerInfo(){}, "Could not retrieve property: " + string, throwable);
            return "n/a";
        }
    }
}

