/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.SQLException;
import workbench.db.ColumnIdentifier;
import workbench.db.DefaultFKHandler;
import workbench.db.FKMatchType;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.mssql.SqlServerFKHandler;
import workbench.db.mssql.SqlServerUtil;
import workbench.db.oracle.OracleFKHandler;
import workbench.db.postgres.PostgresFKHandler;
import workbench.storage.DataStore;

public interface FKHandler {
    public static final int COLUMN_IDX_FK_DEF_FK_NAME = 0;
    public static final int COLUMN_IDX_FK_DEF_COLUMN_NAME = 1;
    public static final int COLUMN_IDX_FK_DEF_REFERENCE_COLUMN_NAME = 2;
    public static final int COLUMN_IDX_FK_DEF_UPDATE_RULE = 3;
    public static final int COLUMN_IDX_FK_DEF_DELETE_RULE = 4;
    public static final int COLUMN_IDX_FK_DEF_DEFERRABLE = 5;
    public static final int COLUMN_IDX_FK_DEF_ENABLED = 6;
    public static final int COLUMN_IDX_FK_DEF_VALIDATED = 7;
    public static final int COLUMN_IDX_FK_DEF_UPDATE_RULE_VALUE = 8;
    public static final int COLUMN_IDX_FK_DEF_DELETE_RULE_VALUE = 9;
    public static final int COLUMN_IDX_FK_DEF_DEFERRABLE_RULE_VALUE = 10;
    public static final int COLUMN_IDX_DEFERRABILITY = 13;
    public static final String COLUMN_NAME_REMARKS = "REMARKS";
    public static final ColumnIdentifier REMARKS_COLUMN = new ColumnIdentifier("REMARKS", 12, 20);
    public static final String COLUMN_NAME_MATCH_TYPE = "MATCH_TYPE";
    public static final ColumnIdentifier MATCH_TYPE_COLUMN = new ColumnIdentifier("MATCH_TYPE", 12, 10);

    public boolean supportsStatus();

    public boolean containsStatusColumn();

    public FkStatusInfo getFkEnabledFlag(TableIdentifier var1, String var2);

    public DataStore getExportedKeys(TableIdentifier var1) throws SQLException;

    public DataStore getForeignKeys(TableIdentifier var1, boolean var2);

    public DataStore getImportedKeys(TableIdentifier var1) throws SQLException;

    public DataStore getReferencedBy(TableIdentifier var1);

    public DataStore createDisplayDataStore(String var1, boolean var2);

    public void cancel();

    default public boolean supportsRemarks() {
        return false;
    }

    default public boolean shouldGenerate(FKMatchType fKMatchType) {
        return this.supportsMatchType() && fKMatchType != null;
    }

    default public boolean supportsMatchType() {
        return false;
    }

    default public void initializeSharedCache() {
    }

    default public void clearSharedCache() {
    }

    public static FKHandler createInstance(WbConnection wbConnection) {
        if (wbConnection.getMetadata().isPostgres()) {
            return new PostgresFKHandler(wbConnection);
        }
        if (wbConnection.getMetadata().isOracle() && wbConnection.getDbSettings().fixFKRetrieval()) {
            return new OracleFKHandler(wbConnection);
        }
        if (wbConnection.getMetadata().isSqlServer() && SqlServerUtil.isSqlServer2005(wbConnection)) {
            return new SqlServerFKHandler(wbConnection);
        }
        return new DefaultFKHandler(wbConnection);
    }

    public static class FkStatusInfo {
        public final boolean validated;
        public final boolean enabled;

        public FkStatusInfo(boolean bl, boolean bl2) {
            this.validated = bl2;
            this.enabled = bl;
        }
    }
}

