/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.SqlParsingUtil;
import workbench.util.StringUtil;

public class GetMetaDataSql {
    private String baseSql;
    private String schema;
    private String schemaField;
    private String catalog;
    private String catalogField;
    private String objectName;
    private String objectNameField;
    private String orderBy;
    private boolean useUpperCase;
    private boolean useLowerCase;
    private boolean isProcedureCall;
    private int schemaArgumentPos;
    private int catalogArgumentPos;
    private int objectNameArgumentPos;
    private String baseObjectName;
    private String baseObjectCatalog;
    private String baseObjectSchema;
    private String baseObjectNameField;
    private String baseObjectCatalogField;
    private String baseObjectSchemaField;
    private String specificNameColumn;
    private String specificName;
    private String internalIdColumn;
    private Object internalId;
    private String metaDataType;
    private boolean isPreparedStatement;

    public void setMetaDataType(String string) {
        this.metaDataType = string;
    }

    public String getSql() {
        if (this.isProcedureCall) {
            return this.getProcedureCallSql();
        }
        return this.getSelectSql();
    }

    private String getSelectSql() {
        boolean bl;
        boolean bl2 = bl = this.containsWhere(this.baseSql);
        boolean bl3 = !bl;
        StringBuilder stringBuilder = new StringBuilder(this.baseSql);
        if (this.schema != null && this.schemaField != null) {
            if (bl3) {
                stringBuilder.append(" WHERE ");
                bl3 = false;
            }
            if (bl2) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append(this.schemaField + this.getOperator(this.schema) + "'" + this.getNameValue(this.schema) + "'");
            bl2 = true;
        }
        if (this.catalog != null && this.catalogField != null) {
            if (bl3) {
                stringBuilder.append(" WHERE ");
                bl3 = false;
            }
            if (bl2) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append(this.catalogField + this.getOperator(this.catalog) + "'" + this.getNameValue(this.catalog) + "'");
            bl2 = true;
        }
        if (this.objectName != null && this.objectNameField != null) {
            if (bl3) {
                stringBuilder.append(" WHERE ");
                bl3 = false;
            }
            if (bl2) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append(this.objectNameField + this.getOperator(this.objectName) + "'" + this.getNameValue(this.objectName) + "'");
            bl2 = true;
        }
        if (this.specificName != null && this.specificNameColumn != null) {
            if (bl3) {
                stringBuilder.append(" WHERE ");
                bl3 = false;
            }
            if (bl2) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append(this.specificNameColumn + this.getOperator(this.specificName) + "'" + this.getNameValue(this.specificName) + "'");
            bl2 = true;
        }
        if (this.internalId != null && this.internalIdColumn != null) {
            if (bl3) {
                stringBuilder.append(" WHERE ");
                bl3 = false;
            }
            if (bl2) {
                stringBuilder.append(" AND ");
            }
            String string = null;
            string = this.internalId instanceof String ? "'" + this.internalId + "'" : this.internalId.toString();
            stringBuilder.append(this.internalIdColumn + " = " + string);
            bl2 = true;
        }
        if (this.baseObjectName != null && this.baseObjectNameField != null) {
            stringBuilder.append(" AND ");
            stringBuilder.append(this.baseObjectNameField + this.getOperator(this.baseObjectName) + "'" + this.getNameValue(this.baseObjectName) + "'");
        }
        if (this.baseObjectCatalog != null && this.baseObjectCatalogField != null) {
            stringBuilder.append(" AND ");
            stringBuilder.append(this.baseObjectCatalogField + this.getOperator(this.baseObjectCatalog) + "'" + this.getNameValue(this.baseObjectCatalog) + "'");
        }
        if (this.baseObjectSchema != null && this.baseObjectSchemaField != null) {
            stringBuilder.append(" AND ");
            stringBuilder.append(this.baseObjectSchemaField + this.getOperator(this.baseObjectSchema) + "'" + this.getNameValue(this.baseObjectSchema) + "'");
        }
        if (this.orderBy != null) {
            stringBuilder.append(" " + this.orderBy);
        }
        return stringBuilder.toString();
    }

    private String getOperator(String string) {
        if (string == null) {
            return "";
        }
        if (string.indexOf(37) > -1) {
            return " LIKE ";
        }
        return " = ";
    }

    private String getNameValue(String string) {
        if (string == null) {
            return null;
        }
        if (this.useLowerCase) {
            return string.toLowerCase();
        }
        if (this.useUpperCase) {
            return string.toUpperCase();
        }
        return string;
    }

    private String getProcedureCallSql() {
        StringBuilder stringBuilder = new StringBuilder(this.baseSql);
        stringBuilder.append(' ');
        for (int i = 1; i < 4; ++i) {
            if (this.schemaArgumentPos == i && this.schema != null) {
                if (i > 1) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(this.schema);
                continue;
            }
            if (this.catalogArgumentPos == i && this.catalog != null) {
                if (i > 1) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(this.catalog);
                continue;
            }
            if (this.objectNameArgumentPos != i || this.objectName == null) continue;
            if (i > 1) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.objectName);
        }
        return stringBuilder.toString();
    }

    public String getInternalIdColumn() {
        return this.internalIdColumn;
    }

    public void setInternalIdColumn(String string) {
        this.internalIdColumn = string;
    }

    public Object getInternalId() {
        return this.internalId;
    }

    public void setInternalId(Object object) {
        this.internalId = object;
    }

    public String getBaseSql() {
        return this.baseSql;
    }

    public void setBaseSql(String string) {
        this.baseSql = string == null ? null : string.trim();
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String string) {
        this.schema = string;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String string) {
        this.catalog = string;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String string) {
        this.objectName = string;
    }

    public String toString() {
        return this.getSql();
    }

    public String getSchemaField() {
        return this.schemaField;
    }

    public void setSchemaField(String string) {
        this.schemaField = string;
    }

    public String getCatalogField() {
        return this.catalogField;
    }

    public void setCatalogField(String string) {
        this.catalogField = string;
    }

    public String getObjectNameField() {
        return this.objectNameField;
    }

    public void setObjectNameField(String string) {
        this.objectNameField = string;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String string) {
        this.orderBy = string;
    }

    public boolean getUseUpperCase() {
        return this.useUpperCase;
    }

    public void setUseUpperCase(boolean bl) {
        this.useUpperCase = bl;
    }

    public boolean getUseLowerCase() {
        return this.useLowerCase;
    }

    public void setUseLowerCase(boolean bl) {
        this.useLowerCase = bl;
    }

    public boolean isIsProcedureCall() {
        return this.isProcedureCall;
    }

    public void setIsProcedureCall(boolean bl) {
        this.isProcedureCall = bl;
    }

    public int getSchemaArgumentPos() {
        return this.schemaArgumentPos;
    }

    public void setSchemaArgumentPos(int n) {
        this.schemaArgumentPos = n;
    }

    public int getCatalogArgumentPos() {
        return this.catalogArgumentPos;
    }

    public void setCatalogArgumentPos(int n) {
        this.catalogArgumentPos = n;
    }

    public int getObjectNameArgumentPos() {
        return this.objectNameArgumentPos;
    }

    public void setObjectNameArgumentPos(int n) {
        this.objectNameArgumentPos = n;
    }

    public int getBaseObjectNameArgumentPos() {
        return this.objectNameArgumentPos;
    }

    public void setBaseObjectNameArgumentPos(int n) {
        this.objectNameArgumentPos = n;
    }

    public String getBaseObjectCatalog() {
        return this.baseObjectCatalog;
    }

    public void setBaseObjectCatalog(String string) {
        this.baseObjectCatalog = string;
    }

    public String getBaseObjectCatalogField() {
        return this.baseObjectCatalogField;
    }

    public void setBaseObjectCatalogField(String string) {
        this.baseObjectCatalogField = string;
    }

    public String getBaseObjectName() {
        return this.baseObjectName;
    }

    public void setBaseObjectName(String string) {
        this.baseObjectName = string;
    }

    public String getBaseObjectNameField() {
        return this.baseObjectNameField;
    }

    public void setBaseObjectNameField(String string) {
        this.baseObjectNameField = string;
    }

    public String getBaseObjectSchema() {
        return this.baseObjectSchema;
    }

    public void setBaseObjectSchema(String string) {
        this.baseObjectSchema = string;
    }

    public String getBaseObjectSchemaField() {
        return this.baseObjectSchemaField;
    }

    public void setBaseObjectSchemaField(String string) {
        this.baseObjectSchemaField = string;
    }

    public String getSpecificNameColumn() {
        return this.specificNameColumn;
    }

    public void setSpecificNameColumn(String string) {
        this.specificNameColumn = string;
    }

    public String getSpecificName() {
        return this.specificName;
    }

    public void setSpecificName(String string) {
        this.specificName = string;
    }

    public boolean isPreparedStatement() {
        return this.isPreparedStatement;
    }

    public void setIsPreparedStatement(boolean bl) {
        this.isPreparedStatement = bl;
    }

    public PreparedStatement prepareStatement(WbConnection wbConnection, String string, String string2, String string3) throws SQLException {
        if (!this.isPreparedStatement) {
            return null;
        }
        PreparedStatement preparedStatement = wbConnection.getSqlConnection().prepareStatement(this.baseSql);
        int n = this.getSchemaArgumentPos();
        int n2 = this.getCatalogArgumentPos();
        int n3 = this.getObjectNameArgumentPos();
        String string4 = "";
        if (n3 > 0) {
            preparedStatement.setString(n3, string3);
            string4 = "Parameter " + n3 + ": '" + string3 + "'";
        }
        if (n > 0 && StringUtil.isNonEmpty(string2)) {
            preparedStatement.setString(n, string2);
            string4 = string4 + ", Parameter " + n + ": '" + string2 + "'";
        }
        if (n2 > 0 && StringUtil.isNonEmpty(string)) {
            preparedStatement.setString(n2, string);
            string4 = string4 + ", Parameter " + n2 + ": '" + string + "'";
        }
        if (Settings.getInstance().getDebugMetadataSql()) {
            LogMgr.logInfo(new CallerInfo(){}, "Retrieving " + this.metaDataType + " using query=\n" + this.baseSql + "\n(" + string4 + ")");
        }
        return preparedStatement;
    }

    boolean containsWhere(String string) {
        if (string == null) {
            return false;
        }
        if (!(string = string.toLowerCase()).contains("where")) {
            return false;
        }
        SqlParsingUtil sqlParsingUtil = SqlParsingUtil.getInstance(null);
        int n = sqlParsingUtil.getFromPosition(string);
        if (n == -1) {
            return false;
        }
        int n2 = sqlParsingUtil.getKeywordPosition(Collections.singleton("WHERE"), string, n);
        return n2 > -1;
    }
}

