/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import workbench.db.ConnectionMgr;
import workbench.db.ConnectionProfile;
import workbench.db.DbDriver;
import workbench.db.ObjectNameFilter;
import workbench.db.ProfileStorage;
import workbench.interfaces.PropertyStorage;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.sql.wbcommands.ConnectionDescriptor;
import workbench.ssh.SshConfig;
import workbench.ssh.SshHostConfig;
import workbench.util.FileUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;
import workbench.util.WbProperties;

public class IniProfileStorage
implements ProfileStorage {
    public static final String EXTENSION = "properties";
    public static final String DEFAULT_FILE_NAME = "wb-profiles.properties";
    private static final String PROP_PREFIX = "profile";
    private static final String PROP_NAME = ".name";
    private static final String PROP_URL = ".url";
    private static final String PROP_PWD = ".password";
    private static final String PROP_USERNAME = ".username";
    private static final String PROP_DRIVERNAME = ".drivername";
    private static final String PROP_DRIVERCLASS = ".driverclass";
    private static final String PROP_DRIVERJAR = ".driverjar";
    private static final String PROP_AUTOCOMMMIT = ".autocommmit";
    private static final String PROP_FETCHSIZE = ".fetchsize";
    private static final String PROP_ALT_DELIMITER = ".alternate.delimiter";
    private static final String PROP_STORE_PWD = ".store.pwd";
    private static final String PROP_ROLLBACK_DISCONNECT = ".rollback.disconnect";
    private static final String PROP_GROUP = ".group";
    private static final String PROP_TAGS = ".tags";
    private static final String PROP_WORKSPACE = ".workspace";
    private static final String PROP_DEFAULT_DIR = ".default.dir";
    private static final String PROP_ICON = ".icon";
    private static final String PROP_CONNECTION_TIMEOUT = ".connection.timeout";
    private static final String PROP_HIDE_WARNINGS = ".hide.warnings";
    private static final String PROP_REMEMEMBER_SCHEMA = ".rememember.schema";
    private static final String PROP_REMOVE_COMMENTS = ".remove.comments";
    private static final String PROP_INCLUDE_NULL_ON_INSERT = ".include.null.insert";
    private static final String PROP_EMPTY_STRING_IS_NULL = ".empty.string.is.null";
    private static final String PROP_PROMPTUSERNAME = ".prompt.username";
    private static final String PROP_CONFIRM_UPDATES = ".confirm.updates";
    private static final String PROP_PREVENT_NO_WHERE = ".prevent.no.where.clause";
    private static final String PROP_READONLY = ".readonly";
    private static final String PROP_DETECTOPENTRANSACTION = ".detect.open.transaction";
    private static final String PROP_ORACLESYSDBA = ".oracle.sysdba";
    private static final String PROP_TRIMCHARDATA = ".trim.char.data";
    private static final String PROP_IGNOREDROPERRORS = ".ignore.drop.errors";
    private static final String PROP_SEPARATECONNECTION = ".separate.connection";
    private static final String PROP_STORECACHE = ".store.cache";
    private static final String PROP_IDLE_TIME = ".idle.time";
    private static final String PROP_SCRIPT_IDLE = ".script.idle";
    private static final String PROP_SCRIPT_DISCONNECT = ".script.disconnect";
    private static final String PROP_SCRIPT_CONNECT = ".script.connect";
    private static final String PROP_MACROFILE = ".macro.file";
    private static final String PROP_COPY_PROPS = ".copy.props";
    private static final String PROP_CONN_PROPS = ".connection.properties";
    private static final String PROP_CONN_VARS = ".connection.variables";
    private static final String PROP_INFO_COLOR = ".info.color";
    private static final String PROP_SCHEMA_FILTER = ".schema.filter";
    private static final String PROP_CATALOG_FILTER = ".catalog.filter";
    public static final String PROP_SSH_HOST = ".ssh.host";
    public static final String PROP_SSH_USER = ".ssh.user";
    public static final String PROP_SSH_PWD = ".ssh.pwd";
    public static final String PROP_SSH_KEYFILE = ".ssh.keyfile";
    public static final String PROP_SSH_TRY_AGENT = ".ssh.try.agent";
    public static final String PROP_SSH_GLOBAL_CONFIG = ".ssh.global.hostconfig";
    public static final String PROP_SSH_PORT = ".ssh.port";
    private static final String PROP_SSH_LOCAL_PORT = ".ssh.localport";
    private static final String PROP_SSH_DB_PORT = ".ssh.db.port";
    private static final String PROP_SSH_DB_HOST = ".ssh.db.host";
    private static final String XML_PREFIX = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"no\"?><!DOCTYPE properties SYSTEM \"http://java.sun.com/dtd/properties.dtd\">";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ConnectionProfile> readProfiles(WbFile wbFile) {
        LogMgr.logDebug(new CallerInfo(){}, "Loading connection profiles from " + wbFile.getFullPath());
        WbProperties wbProperties = new WbProperties(1);
        BufferedReader bufferedReader = null;
        ArrayList<ConnectionProfile> arrayList = new ArrayList<ConnectionProfile>(25);
        try {
            File file = wbFile.getCanonicalFile().getParentFile();
            bufferedReader = new BufferedReader(new FileReader(wbFile));
            wbProperties.loadFromReader(bufferedReader);
            Set<String> set = this.getProfileKeys(wbProperties);
            for (String string : set) {
                ConnectionProfile connectionProfile = this.readProfile(file, string, wbProperties);
                if (connectionProfile == null) continue;
                arrayList.add(connectionProfile);
            }
        }
        catch (Exception exception) {
            try {
                LogMgr.logError(new CallerInfo(){}, "Could not read profiles from: " + wbFile, exception);
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietely(bufferedReader);
                throw throwable;
            }
            FileUtil.closeQuietely(bufferedReader);
        }
        FileUtil.closeQuietely(bufferedReader);
        LogMgr.logInfo(new CallerInfo(){}, "Loaded " + arrayList.size() + " connection profiles from " + wbFile.getFullPath());
        return arrayList;
    }

    private ConnectionProfile readProfile(File file, String string, WbProperties wbProperties) {
        Object object;
        Serializable serializable;
        string = "." + string;
        String string2 = wbProperties.getProperty(PROP_PREFIX + string + PROP_URL, null);
        String string3 = wbProperties.getProperty(PROP_PREFIX + string + PROP_TAGS, null);
        String string4 = wbProperties.getProperty(PROP_PREFIX + string + PROP_NAME, null);
        String string5 = wbProperties.getProperty(PROP_PREFIX + string + PROP_DRIVERCLASS, null);
        String string6 = wbProperties.getProperty(PROP_PREFIX + string + PROP_DRIVERJAR, null);
        String string7 = wbProperties.getProperty(PROP_PREFIX + string + PROP_DRIVERNAME, null);
        String string8 = wbProperties.getProperty(PROP_PREFIX + string + PROP_GROUP, null);
        String string9 = wbProperties.getProperty(PROP_PREFIX + string + PROP_USERNAME, null);
        String string10 = wbProperties.getProperty(PROP_PREFIX + string + PROP_PWD, null);
        String string11 = wbProperties.getProperty(PROP_PREFIX + string + PROP_ICON, null);
        String string12 = wbProperties.getProperty(PROP_PREFIX + string + PROP_WORKSPACE, null);
        String string13 = wbProperties.getProperty(PROP_PREFIX + string + PROP_ALT_DELIMITER, null);
        String string14 = wbProperties.getProperty(PROP_PREFIX + string + PROP_MACROFILE, null);
        String string15 = wbProperties.getProperty(PROP_PREFIX + string + PROP_SCRIPT_CONNECT, null);
        String string16 = wbProperties.getProperty(PROP_PREFIX + string + PROP_SCRIPT_DISCONNECT, null);
        String string17 = wbProperties.getProperty(PROP_PREFIX + string + PROP_SCRIPT_IDLE, null);
        String string18 = wbProperties.getProperty(PROP_PREFIX + string + PROP_DEFAULT_DIR, null);
        String string19 = wbProperties.getProperty(PROP_PREFIX + string + PROP_CONN_PROPS, null);
        String string20 = wbProperties.getProperty(PROP_PREFIX + string + PROP_CONN_VARS, null);
        String string21 = wbProperties.getProperty(PROP_PREFIX + string + PROP_INFO_COLOR, null);
        Properties properties = this.toProperties(string19);
        Properties properties2 = this.toProperties(string20);
        Color color = Settings.stringToColor(string21);
        boolean bl = wbProperties.getBoolProperty(PROP_PREFIX + string + PROP_AUTOCOMMMIT, false);
        boolean bl2 = wbProperties.getBoolProperty(PROP_PREFIX + string + PROP_STORECACHE, false);
        boolean bl3 = wbProperties.getBoolProperty(PROP_PREFIX + string + PROP_STORE_PWD, true);
        boolean bl4 = wbProperties.getBoolProperty(PROP_PREFIX + string + PROP_ROLLBACK_DISCONNECT, false);
        boolean bl5 = wbProperties.getBoolProperty(PROP_PREFIX + string + PROP_SEPARATECONNECTION, false);
        boolean bl6 = wbProperties.getBoolProperty(PROP_PREFIX + string + PROP_IGNOREDROPERRORS, false);
        boolean bl7 = wbProperties.getBoolProperty(PROP_PREFIX + string + PROP_TRIMCHARDATA, false);
        boolean bl8 = wbProperties.getBoolProperty(PROP_PREFIX + string + PROP_ORACLESYSDBA, false);
        boolean bl9 = wbProperties.getBoolProperty(PROP_PREFIX + string + PROP_DETECTOPENTRANSACTION, false);
        boolean bl10 = wbProperties.getBoolProperty(PROP_PREFIX + string + PROP_READONLY, false);
        boolean bl11 = wbProperties.getBoolProperty(PROP_PREFIX + string + PROP_PREVENT_NO_WHERE, false);
        boolean bl12 = wbProperties.getBoolProperty(PROP_PREFIX + string + PROP_CONFIRM_UPDATES, false);
        boolean bl13 = wbProperties.getBoolProperty(PROP_PREFIX + string + PROP_PROMPTUSERNAME, false);
        boolean bl14 = wbProperties.getBoolProperty(PROP_PREFIX + string + PROP_EMPTY_STRING_IS_NULL, false);
        boolean bl15 = wbProperties.getBoolProperty(PROP_PREFIX + string + PROP_INCLUDE_NULL_ON_INSERT, true);
        boolean bl16 = wbProperties.getBoolProperty(PROP_PREFIX + string + PROP_REMOVE_COMMENTS, false);
        boolean bl17 = wbProperties.getBoolProperty(PROP_PREFIX + string + PROP_REMEMEMBER_SCHEMA, false);
        boolean bl18 = wbProperties.getBoolProperty(PROP_PREFIX + string + PROP_HIDE_WARNINGS, false);
        boolean bl19 = wbProperties.getBoolProperty(PROP_PREFIX + string + PROP_COPY_PROPS, false);
        int n = wbProperties.getIntProperty(PROP_PREFIX + string + PROP_IDLE_TIME, -1);
        int n2 = wbProperties.getIntProperty(PROP_PREFIX + string + PROP_FETCHSIZE, -1);
        int n3 = wbProperties.getIntProperty(PROP_PREFIX + string + PROP_CONNECTION_TIMEOUT, -1);
        SshConfig sshConfig = this.readSshConfig(wbProperties, PROP_PREFIX, string);
        Integer n4 = null;
        if (n2 >= 0) {
            n4 = n2;
        }
        Integer n5 = null;
        if (n3 > 0) {
            n5 = n3;
        }
        if (StringUtil.isBlank(string5) && (string5 = ConnectionDescriptor.findDriverClassFromUrl(string2)) != null) {
            LogMgr.logInfo(new CallerInfo(){}, "Profile " + string4 + " does not contain a driver class definition. Using " + string5 + " based on the URL: " + string2);
        }
        if (StringUtil.isNonEmpty(string6)) {
            if (StringUtil.isBlank(string5)) {
                LogMgr.logError(new CallerInfo(){}, "Profile " + string4 + " defines a JDBC driver but no driver class was specified. Ignoring the profile", null);
                return null;
            }
            serializable = new WbFile(string6);
            if (!((File)serializable).isAbsolute()) {
                serializable = new WbFile(file, string6);
                LogMgr.logDebug(new CallerInfo(){}, "Using full path: " + ((WbFile)serializable).getFullPath() + " for driver jar " + string6 + " from profile " + string4);
                string6 = ((WbFile)serializable).getFullPath();
            } else {
                string6 = ((WbFile)serializable).getFullPath();
            }
            if (!((File)serializable).exists()) {
                LogMgr.logError(new CallerInfo(){}, "Driver jar: \"" + ((WbFile)serializable).getFullPath() + "\" for profile: " + string4 + " does not exist.", null);
            }
            object = ConnectionMgr.getInstance().registerDriver(string5, string6);
            string7 = ((DbDriver)object).getName();
        }
        serializable = this.getSchemaFilter(wbProperties, string);
        object = this.getCatalogFilter(wbProperties, string);
        ConnectionProfile connectionProfile = new ConnectionProfile();
        connectionProfile.setName(string4);
        connectionProfile.setUsername(string9);
        connectionProfile.setUrl(string2);
        connectionProfile.setInputPassword(string10);
        connectionProfile.setDriverclass(string5);
        connectionProfile.setDriverName(string7);
        connectionProfile.setGroup(string8);
        connectionProfile.setTagList(string3);
        connectionProfile.setDefaultFetchSize(n4);
        connectionProfile.setOracleSysDBA(bl8);
        connectionProfile.setReadOnly(bl10);
        connectionProfile.setWorkspaceFile(string12);
        connectionProfile.setIcon(string11);
        connectionProfile.setConnectionTimeout(n5);
        connectionProfile.setRollbackBeforeDisconnect(bl4);
        connectionProfile.setUseSeparateConnectionPerTab(bl5);
        connectionProfile.setAlternateDelimiterString(string13);
        connectionProfile.setMacroFilename(string14);
        connectionProfile.setIgnoreDropErrors(bl6);
        connectionProfile.setTrimCharData(bl7);
        connectionProfile.setDetectOpenTransaction(bl9);
        connectionProfile.setPreventDMLWithoutWhere(bl11);
        connectionProfile.setConfirmUpdates(bl12);
        connectionProfile.setPromptForUsername(bl13);
        connectionProfile.setEmptyStringIsNull(bl14);
        connectionProfile.setIncludeNullInInsert(bl15);
        connectionProfile.setRemoveComments(bl16);
        connectionProfile.setStoreExplorerSchema(bl17);
        connectionProfile.setHideWarnings(bl18);
        connectionProfile.setStoreCacheLocally(bl2);
        connectionProfile.setAutocommit(bl);
        connectionProfile.setPreDisconnectScript(string16);
        connectionProfile.setPostConnectScript(string15);
        connectionProfile.setIdleScript(string17);
        connectionProfile.setIdleTime(n);
        connectionProfile.setStorePassword(bl3);
        connectionProfile.setCopyExtendedPropsToSystem(bl19);
        connectionProfile.setConnectionProperties(properties);
        connectionProfile.setConnectionVariables(properties2);
        connectionProfile.setInfoDisplayColor(color);
        connectionProfile.setSchemaFilter((ObjectNameFilter)serializable);
        connectionProfile.setCatalogFilter((ObjectNameFilter)object);
        connectionProfile.setSshConfig(sshConfig);
        connectionProfile.setDefaultDirectory(string18);
        return connectionProfile;
    }

    @Override
    public void saveProfiles(List<ConnectionProfile> list, WbFile wbFile) {
        LogMgr.logDebug(new CallerInfo(){}, "Saving profiles to: " + wbFile);
        WbProperties wbProperties = new WbProperties(2);
        long l = System.currentTimeMillis();
        Comparator comparator = (string, string2) -> {
            String string3;
            int n = string.indexOf(46, string.indexOf(46) + 1);
            int n2 = string2.indexOf(46, string2.indexOf(46) + 1);
            String string4 = string.substring(0, n);
            if (string4.equals(string3 = string2.substring(0, n2))) {
                if (string.endsWith(PROP_NAME) && !string2.endsWith(PROP_NAME)) {
                    return -1;
                }
                if (!string.endsWith(PROP_NAME) && string2.endsWith(PROP_NAME)) {
                    return 1;
                }
            }
            return string.compareTo((String)string2);
        };
        wbProperties.setSortComparator(comparator);
        for (int i = 0; i < list.size(); ++i) {
            String string3 = StringUtil.formatInt(i + 1, 4).toString();
            this.storeProfile(string3, list.get(i), wbProperties);
        }
        try {
            wbProperties.saveToFile(wbFile);
        }
        catch (IOException iOException) {
            LogMgr.logError(new CallerInfo(){}, "Error saving profiles to: " + wbFile, iOException);
        }
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Saved " + list.size() + " profiles to " + wbFile + " in " + l2 + "ms");
    }

    private void storeProfile(String string, ConnectionProfile connectionProfile, WbProperties wbProperties) {
        ObjectNameFilter objectNameFilter;
        String string2;
        Integer n;
        ConnectionProfile connectionProfile2 = new ConnectionProfile();
        string = "." + string;
        wbProperties.setProperty(PROP_PREFIX + string + PROP_URL, connectionProfile.getUrl());
        wbProperties.setProperty(PROP_PREFIX + string + PROP_NAME, connectionProfile.getName());
        wbProperties.setProperty(PROP_PREFIX + string + PROP_DRIVERNAME, connectionProfile.getDriverName());
        wbProperties.setProperty(PROP_PREFIX + string + PROP_DRIVERCLASS, connectionProfile.getDriverclass());
        wbProperties.setProperty(PROP_PREFIX + string + PROP_USERNAME, connectionProfile.getUsername());
        wbProperties.setProperty(PROP_PREFIX + string + PROP_AUTOCOMMMIT, connectionProfile.getAutocommit());
        wbProperties.setProperty(PROP_PREFIX + string + PROP_TAGS, connectionProfile.getTagList());
        wbProperties.setProperty(PROP_PREFIX + string + PROP_STORE_PWD, connectionProfile.getStorePassword());
        if (connectionProfile.getStorePassword()) {
            wbProperties.setProperty(PROP_PREFIX + string + PROP_PWD, connectionProfile.getPassword());
        }
        wbProperties.setProperty(PROP_PREFIX + string + PROP_ICON, connectionProfile.getIcon());
        wbProperties.setProperty(PROP_PREFIX + string + PROP_WORKSPACE, connectionProfile.getWorkspaceFile());
        wbProperties.setProperty(PROP_PREFIX + string + PROP_ALT_DELIMITER, connectionProfile.getAlternateDelimiterString());
        wbProperties.setProperty(PROP_PREFIX + string + PROP_MACROFILE, connectionProfile.getMacroFilename());
        wbProperties.setProperty(PROP_PREFIX + string + PROP_SCRIPT_CONNECT, connectionProfile.getPostConnectScript());
        wbProperties.setProperty(PROP_PREFIX + string + PROP_SCRIPT_DISCONNECT, connectionProfile.getPreDisconnectScript());
        wbProperties.setProperty(PROP_PREFIX + string + PROP_DEFAULT_DIR, connectionProfile.getDefaultDirectory());
        this.writeSshConfig(wbProperties, PROP_PREFIX, string, connectionProfile.getSshConfig());
        this.setNonDefaultProperty(wbProperties, PROP_PREFIX + string + PROP_STORECACHE, connectionProfile.getStoreCacheLocally(), connectionProfile2.getStoreCacheLocally());
        this.setNonDefaultProperty(wbProperties, PROP_PREFIX + string + PROP_ROLLBACK_DISCONNECT, connectionProfile.getRollbackBeforeDisconnect(), connectionProfile2.getRollbackBeforeDisconnect());
        this.setNonDefaultProperty(wbProperties, PROP_PREFIX + string + PROP_SEPARATECONNECTION, connectionProfile.getUseSeparateConnectionPerTab(), connectionProfile2.getUseSeparateConnectionPerTab());
        this.setNonDefaultProperty(wbProperties, PROP_PREFIX + string + PROP_IGNOREDROPERRORS, connectionProfile.getIgnoreDropErrors(), connectionProfile2.getIgnoreDropErrors());
        this.setNonDefaultProperty(wbProperties, PROP_PREFIX + string + PROP_TRIMCHARDATA, connectionProfile.getTrimCharData(), connectionProfile2.getTrimCharData());
        this.setNonDefaultProperty(wbProperties, PROP_PREFIX + string + PROP_ORACLESYSDBA, connectionProfile.getOracleSysDBA(), connectionProfile2.getOracleSysDBA());
        this.setNonDefaultProperty(wbProperties, PROP_PREFIX + string + PROP_DETECTOPENTRANSACTION, connectionProfile.getDetectOpenTransaction(), connectionProfile2.getDetectOpenTransaction());
        this.setNonDefaultProperty(wbProperties, PROP_PREFIX + string + PROP_READONLY, connectionProfile.isReadOnly(), connectionProfile2.isReadOnly());
        this.setNonDefaultProperty(wbProperties, PROP_PREFIX + string + PROP_PREVENT_NO_WHERE, connectionProfile.getPreventDMLWithoutWhere(), connectionProfile2.getPreventDMLWithoutWhere());
        this.setNonDefaultProperty(wbProperties, PROP_PREFIX + string + PROP_CONFIRM_UPDATES, connectionProfile.getConfirmUpdates(), connectionProfile2.getConfirmUpdates());
        this.setNonDefaultProperty(wbProperties, PROP_PREFIX + string + PROP_PROMPTUSERNAME, connectionProfile.getPromptForUsername(), connectionProfile2.getPromptForUsername());
        this.setNonDefaultProperty(wbProperties, PROP_PREFIX + string + PROP_EMPTY_STRING_IS_NULL, connectionProfile.getEmptyStringIsNull(), connectionProfile2.getEmptyStringIsNull());
        this.setNonDefaultProperty(wbProperties, PROP_PREFIX + string + PROP_INCLUDE_NULL_ON_INSERT, connectionProfile.getIncludeNullInInsert(), connectionProfile2.getIncludeNullInInsert());
        this.setNonDefaultProperty(wbProperties, PROP_PREFIX + string + PROP_REMOVE_COMMENTS, connectionProfile.getRemoveComments(), connectionProfile2.getRemoveComments());
        this.setNonDefaultProperty(wbProperties, PROP_PREFIX + string + PROP_REMEMEMBER_SCHEMA, connectionProfile.getStoreExplorerSchema(), connectionProfile2.getStoreExplorerSchema());
        this.setNonDefaultProperty(wbProperties, PROP_PREFIX + string + PROP_HIDE_WARNINGS, connectionProfile.isHideWarnings(), connectionProfile2.isHideWarnings());
        if (StringUtil.stringsAreNotEqual(connectionProfile.getGroup(), connectionProfile2.getGroup())) {
            wbProperties.setProperty(PROP_PREFIX + string + PROP_GROUP, connectionProfile.getGroup());
        }
        wbProperties.setProperty(PROP_PREFIX + string + PROP_SCRIPT_IDLE, connectionProfile.getIdleScript());
        if (connectionProfile.getIdleTime() != connectionProfile2.getIdleTime()) {
            wbProperties.setProperty(PROP_PREFIX + string + PROP_IDLE_TIME, Long.toString(connectionProfile.getIdleTime()));
        }
        wbProperties.setProperty(PROP_PREFIX + string + PROP_INFO_COLOR, Settings.colorToString(connectionProfile.getInfoDisplayColor()));
        Integer n2 = connectionProfile.getDefaultFetchSize();
        if (n2 != null) {
            wbProperties.setProperty(PROP_PREFIX + string + PROP_FETCHSIZE, n2);
        }
        if ((n = connectionProfile.getConnectionTimeout()) != null) {
            wbProperties.setProperty(PROP_PREFIX + string + PROP_CONNECTION_TIMEOUT, n);
        }
        String string3 = string2 = (objectNameFilter = connectionProfile.getSchemaFilter()) != null ? objectNameFilter.getFilterString() : null;
        if (string2 != null && objectNameFilter != null) {
            wbProperties.setProperty(PROP_PREFIX + string + PROP_SCHEMA_FILTER, string2);
            wbProperties.setProperty(PROP_PREFIX + string + PROP_SCHEMA_FILTER + ".include", objectNameFilter.isInclusionFilter());
            wbProperties.setProperty(PROP_PREFIX + string + PROP_SCHEMA_FILTER + ".retrieval_filter", objectNameFilter.isRetrievalFilter());
        }
        String string4 = string2 = (objectNameFilter = connectionProfile.getCatalogFilter()) != null ? objectNameFilter.getFilterString() : null;
        if (string2 != null && objectNameFilter != null) {
            wbProperties.setProperty(PROP_PREFIX + string + PROP_CATALOG_FILTER, string2);
            wbProperties.setProperty(PROP_PREFIX + string + PROP_CATALOG_FILTER + ".include", objectNameFilter.isInclusionFilter());
        }
        String string5 = this.toXML(connectionProfile.getConnectionProperties());
        wbProperties.setProperty(PROP_PREFIX + string + PROP_CONN_PROPS, string5);
        wbProperties.setProperty(PROP_PREFIX + string + PROP_CONN_VARS, this.toXML(connectionProfile.getConnectionVariables()));
    }

    private void setNonDefaultProperty(WbProperties wbProperties, String string, boolean bl, boolean bl2) {
        if (bl != bl2) {
            wbProperties.setProperty(string, bl);
        }
    }

    private String toXML(Properties properties) {
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(properties.size() * 20);
            properties.storeToXML((OutputStream)byteArrayOutputStream, null, "ISO-8859-1");
            String string = byteArrayOutputStream.toString("ISO-8859-1");
            string = string.replaceAll("((\r\n)|(\n\r)|\r|\n)", "");
            int n = string.indexOf("<properties>");
            if (n > -1) {
                string = string.substring(n);
            }
            return string;
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not convert properties to XML", throwable);
            return null;
        }
    }

    private Properties toProperties(String string) {
        if (StringUtil.isBlank(string)) {
            return null;
        }
        if (!string.startsWith("<?xml")) {
            string = XML_PREFIX + string;
        }
        try {
            Properties properties = new Properties();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("ISO-8859-1"));
            properties.loadFromXML(byteArrayInputStream);
            return properties;
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not convert XML properties", throwable);
            return null;
        }
    }

    private Set<String> getProfileKeys(WbProperties wbProperties) {
        TreeSet<String> treeSet = new TreeSet<String>();
        List<String> list = wbProperties.getKeysWithPrefix(PROP_PREFIX);
        for (String string : list) {
            String[] stringArray = string.split("\\.");
            if (stringArray.length <= 2) continue;
            treeSet.add(stringArray[1]);
        }
        return treeSet;
    }

    private ObjectNameFilter getSchemaFilter(WbProperties wbProperties, String string) {
        ObjectNameFilter objectNameFilter = this.getFilter(wbProperties, string, PROP_SCHEMA_FILTER);
        if (objectNameFilter != null) {
            boolean bl = wbProperties.getBoolProperty(PROP_PREFIX + string + PROP_SCHEMA_FILTER + ".retrieval_filter", false);
            objectNameFilter.setIsRetrievalFilter(bl);
        }
        return objectNameFilter;
    }

    private ObjectNameFilter getCatalogFilter(WbProperties wbProperties, String string) {
        return this.getFilter(wbProperties, string, PROP_CATALOG_FILTER);
    }

    private ObjectNameFilter getFilter(WbProperties wbProperties, String string, String string2) {
        String string3 = wbProperties.getProperty(PROP_PREFIX + string + string2);
        if (StringUtil.isBlank(string3)) {
            return null;
        }
        boolean bl = wbProperties.getBoolProperty(PROP_PREFIX + string + string2 + ".include", false);
        ObjectNameFilter objectNameFilter = new ObjectNameFilter();
        objectNameFilter.setExpressionList(string3);
        objectNameFilter.setInclusionFilter(bl);
        return objectNameFilter;
    }

    private void writeSshHost(PropertyStorage propertyStorage, String string, String string2, SshHostConfig sshHostConfig) {
        propertyStorage.setProperty(string + string2 + PROP_SSH_HOST, sshHostConfig.getHostname());
        propertyStorage.setProperty(string + string2 + PROP_SSH_USER, sshHostConfig.getUsername());
        propertyStorage.setProperty(string + string2 + PROP_SSH_PWD, sshHostConfig.getPassword());
        propertyStorage.setProperty(string + string2 + PROP_SSH_PORT, sshHostConfig.getSshPort());
        propertyStorage.setProperty(string + string2 + PROP_SSH_KEYFILE, sshHostConfig.getPrivateKeyFile());
        propertyStorage.setProperty(string + string2 + PROP_SSH_TRY_AGENT, sshHostConfig.getTryAgent());
    }

    private void writeSshConfig(PropertyStorage propertyStorage, String string, String string2, SshConfig sshConfig) {
        if (sshConfig == null) {
            return;
        }
        if (sshConfig.getSshHostConfigName() == null) {
            this.writeSshHost(propertyStorage, string, string2, sshConfig.getSshHostConfig());
        } else {
            propertyStorage.setProperty(string + string2 + PROP_SSH_GLOBAL_CONFIG, sshConfig.getSshHostConfigName());
        }
        propertyStorage.setProperty(string + string2 + PROP_SSH_LOCAL_PORT, sshConfig.getLocalPort());
        propertyStorage.setProperty(string + string2 + PROP_SSH_DB_HOST, sshConfig.getDbHostname());
        propertyStorage.setProperty(string + string2 + PROP_SSH_DB_PORT, sshConfig.getDbPort());
    }

    private SshHostConfig readHostConfig(PropertyStorage propertyStorage, String string, String string2) {
        String string3 = propertyStorage.getProperty(string + string2 + PROP_SSH_HOST, null);
        String string4 = propertyStorage.getProperty(string + string2 + PROP_SSH_USER, null);
        String string5 = propertyStorage.getProperty(string + string2 + PROP_SSH_PWD, null);
        String string6 = propertyStorage.getProperty(string + string2 + PROP_SSH_KEYFILE, null);
        int n = propertyStorage.getIntProperty(string + string2 + PROP_SSH_PORT, Integer.MIN_VALUE);
        boolean bl = propertyStorage.getBoolProperty(string + string2 + PROP_SSH_TRY_AGENT, false);
        SshHostConfig sshHostConfig = new SshHostConfig();
        if (string3 != null && string4 != null) {
            sshHostConfig.setHostname(string3);
            sshHostConfig.setUsername(string4);
            sshHostConfig.setPassword(string5);
            sshHostConfig.setPrivateKeyFile(string6);
            sshHostConfig.setTryAgent(bl);
            if (n != Integer.MIN_VALUE) {
                sshHostConfig.setSshPort(n);
            }
        }
        return sshHostConfig;
    }

    private SshConfig readSshConfig(PropertyStorage propertyStorage, String string, String string2) {
        String string3 = propertyStorage.getProperty(string + string2 + PROP_SSH_DB_HOST, null);
        int n = propertyStorage.getIntProperty(string + string2 + PROP_SSH_LOCAL_PORT, Integer.MIN_VALUE);
        int n2 = propertyStorage.getIntProperty(string + string2 + PROP_SSH_DB_PORT, Integer.MIN_VALUE);
        SshConfig sshConfig = null;
        if (string3 != null || n != Integer.MIN_VALUE || n2 != Integer.MIN_VALUE) {
            sshConfig = new SshConfig();
            sshConfig.setLocalPort(n);
            sshConfig.setDbHostname(string3);
            sshConfig.setDbPort(n2);
            String string4 = propertyStorage.getProperty(string + string2 + PROP_SSH_GLOBAL_CONFIG, null);
            if (StringUtil.isBlank(string4)) {
                sshConfig.setHostConfig(this.readHostConfig(propertyStorage, string, string2));
            } else {
                sshConfig.setSshHostConfigName(string4);
            }
        }
        return sshConfig;
    }
}

