/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.SQLException;
import java.sql.Statement;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class ResultBufferingController {
    private final WbConnection dbConn;
    private boolean autocommitChanged;
    private boolean setFetchSize;
    private final int fetchSize = 100;

    public ResultBufferingController(WbConnection wbConnection) {
        this.dbConn = wbConnection;
    }

    public void restoreDriverBuffering() {
        if (this.autocommitChanged) {
            try {
                LogMgr.logDebug(new CallerInfo(){}, "Re-enabling on autocommit");
                this.dbConn.setAutoCommit(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void initializeStatement(Statement statement) throws SQLException {
        if (statement != null && this.setFetchSize) {
            statement.setFetchSize(100);
        }
    }

    public void disableDriverBuffering() {
        if (this.dbConn.getDbSettings().autoDisableDriverBuffering() && JdbcUtils.checkPostgresBuffering(this.dbConn)) {
            LogMgr.logInfo(new CallerInfo(){}, "Disabling auto commit and setting fetch size to avoid excessive buffering by the driver");
            try {
                this.dbConn.setAutoCommit(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.autocommitChanged = true;
            this.setFetchSize = true;
        } else {
            this.autocommitChanged = false;
            this.setFetchSize = false;
        }
    }
}

