/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.CommentSqlManager;
import workbench.db.DbObjectFinder;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.sqltemplates.ColumnChanger;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class TableCommentReader {
    public String getTableCommentSql(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        return this.getTableCommentSql(wbConnection.getDbSettings().getDbId(), wbConnection, tableIdentifier);
    }

    String getTableCommentSql(String string, WbConnection wbConnection, TableIdentifier tableIdentifier) {
        CommentSqlManager commentSqlManager = new CommentSqlManager(wbConnection.getMetadata().getDbId());
        String string2 = commentSqlManager.getCommentSqlTemplate(tableIdentifier.getType(), "set");
        if (StringUtil.isBlank(string2)) {
            return null;
        }
        String string3 = null;
        string3 = tableIdentifier.commentIsDefined() ? tableIdentifier.getComment() : this.getTableComment(wbConnection, tableIdentifier);
        String string4 = null;
        if (Settings.getInstance().getIncludeEmptyComments() || StringUtil.isNonBlank(string3)) {
            String string5 = tableIdentifier.getFullyQualifiedName(wbConnection);
            string4 = StringUtil.replace(string2, "%fq_object_name%", string5);
            if ((string4 = StringUtil.replace(string4, "%fq_table_name%", string5)).contains("%object_name%")) {
                string4 = StringUtil.replace(string4, "%object_name%", tableIdentifier.getObjectExpression(wbConnection));
            }
            string4 = this.replaceObjectNamePlaceholder(string4, "%table_name%", wbConnection.getMetadata().quoteObjectname(tableIdentifier.getTableName()));
            string4 = this.replaceObjectNamePlaceholder(string4, "%schema%", wbConnection.getMetadata().quoteObjectname(tableIdentifier.getSchema()));
            string4 = this.replaceObjectNamePlaceholder(string4, "%catalog%", wbConnection.getMetadata().quoteObjectname(tableIdentifier.getCatalog()));
            string4 = StringUtil.replace(string4, "%comment%", string3 == null ? "" : string3.replace("'", "''"));
            string4 = string4 + ";";
        }
        return string4;
    }

    public String getTableComment(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        TableIdentifier tableIdentifier2 = new DbObjectFinder(wbConnection).findObject(tableIdentifier);
        if (tableIdentifier2 == null) {
            return null;
        }
        return tableIdentifier2.getComment();
    }

    public StringBuilder getTableColumnCommentsSql(WbConnection wbConnection, TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        return this.getTableColumnCommentsSql(wbConnection.getMetadata().getDbId(), wbConnection, tableIdentifier, list);
    }

    StringBuilder getTableColumnCommentsSql(String string, WbConnection wbConnection, TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        CommentSqlManager commentSqlManager = new CommentSqlManager(string);
        String string2 = commentSqlManager.getCommentSqlTemplate("column", "set");
        if (StringUtil.isBlank(string2)) {
            return null;
        }
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(list.size() * 25);
        ColumnChanger columnChanger = new ColumnChanger(wbConnection);
        for (ColumnIdentifier columnIdentifier : list) {
            String string3 = columnIdentifier.getComment();
            if (!Settings.getInstance().getIncludeEmptyComments() && !StringUtil.isNonBlank(string3)) continue;
            try {
                String string4 = columnChanger.getColumnCommentSql(tableIdentifier, columnIdentifier);
                stringBuilder.append(string4);
                stringBuilder.append(";\n");
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error creating comments SQL for remark=" + string3, exception);
            }
        }
        return stringBuilder;
    }

    private String replaceObjectNamePlaceholder(String string, String string2, String string3) {
        if (StringUtil.isBlank(string3)) {
            return string.replace(string2 + ".", "");
        }
        return string.replace(string2, string3);
    }
}

