/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import workbench.db.CommitType;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.importer.TableDependencySorter;
import workbench.db.sqltemplates.TemplateHandler;
import workbench.interfaces.JobErrorHandler;
import workbench.interfaces.ScriptGenerationMonitor;
import workbench.interfaces.StatusBar;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.sql.formatter.FormatterUtil;
import workbench.util.ExceptionUtil;

public class TableDeleter {
    private WbConnection connection;
    private boolean cancelExecution;
    private Statement currentStatement;
    private JobErrorHandler errorHandler;
    private StatusBar statusDisplay;
    private TableDependencySorter sorter;
    private ScriptGenerationMonitor scriptMonitor;

    public TableDeleter(WbConnection wbConnection) {
        this.connection = wbConnection;
    }

    public void cancel() {
        this.cancelExecution = true;
        if (this.sorter != null) {
            this.sorter.cancel();
        }
    }

    public boolean isCanelled() {
        return this.cancelExecution;
    }

    public void setScriptMonitor(ScriptGenerationMonitor scriptGenerationMonitor) {
        this.scriptMonitor = scriptGenerationMonitor;
    }

    public void setStatusBar(StatusBar statusBar) {
        this.statusDisplay = statusBar;
    }

    public void setErrorHandler(JobErrorHandler jobErrorHandler) {
        this.errorHandler = jobErrorHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TableIdentifier> deleteTableData(List<TableIdentifier> list, boolean bl, boolean bl2, boolean bl3) throws SQLException {
        this.cancelExecution = false;
        boolean bl4 = false;
        if (bl2 && !this.connection.getDbSettings().supportsTruncate()) {
            bl2 = false;
            LogMgr.logWarning(new CallerInfo(){}, "Use of TRUNCATE requested, but DBMS does not support truncate. Using DELETE instead.");
        }
        boolean bl5 = false;
        ArrayList<TableIdentifier> arrayList = new ArrayList<TableIdentifier>();
        try {
            this.currentStatement = this.connection.createStatement();
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Error creating statement", sQLException);
            throw sQLException;
        }
        boolean bl6 = false;
        boolean bl7 = this.connection.getAutoCommit();
        if (bl7 && !this.connection.getProfile().getAutocommit()) {
            this.connection.setAutoCommit(false);
            bl6 = true;
        }
        try {
            boolean bl8;
            String string;
            String string2;
            this.connection.setBusy(true);
            for (TableIdentifier tableIdentifier : list) {
                if (this.cancelExecution) break;
                if (this.statusDisplay != null) {
                    this.statusDisplay.setStatusMessage(ResourceMgr.getFormattedString("TxtDeletingTable", tableIdentifier.getTableName()));
                }
                try {
                    this.deleteTable(tableIdentifier, bl2, bl, bl3);
                    arrayList.add(tableIdentifier);
                }
                catch (SQLException sQLException) {
                    string2 = ExceptionUtil.getDisplay(sQLException);
                    LogMgr.logError(new CallerInfo(){}, "Error deleting table " + tableIdentifier, sQLException);
                    if (this.errorHandler == null) {
                        this.connection.rollback();
                        throw sQLException;
                    }
                    if (bl4) continue;
                    string = ResourceMgr.getString("ErrDeleteTableData");
                    string = string.replace("%table%", tableIdentifier.toString());
                    string = string.replace("%error%", string2);
                    int n = this.errorHandler.getActionOnError(-1, null, null, string = string + "\n" + ResourceMgr.getString("MsgContinueQ"));
                    if (n == 3) {
                        bl5 = true;
                        break;
                    }
                    if (n == 1) {
                        bl5 = false;
                        continue;
                    }
                    if (n != 2) continue;
                    bl5 = false;
                    bl4 = true;
                }
            }
            boolean bl9 = bl8 = !this.connection.getAutoCommit();
            if (bl8 && bl2) {
                bl8 = this.connection.getDbSettings().truncateNeedsCommit();
            }
            boolean bl10 = false;
            try {
                if (bl8) {
                    if (bl5 || this.cancelExecution) {
                        bl10 = false;
                        this.connection.rollback();
                    } else if (bl8) {
                        bl10 = true;
                        this.connection.commit();
                    }
                }
            }
            catch (SQLException sQLException) {
                LogMgr.logError(new CallerInfo(){}, "Error on commit/rollback", sQLException);
                string2 = ExceptionUtil.getDisplay(sQLException);
                string = null;
                string = bl10 ? ResourceMgr.getFormattedString("ErrCommit", string2) : (bl8 ? ResourceMgr.getFormattedString("ErrRollbackTableData", string2) : string2);
                if (this.errorHandler != null) {
                    this.errorHandler.fatalError(string);
                }
            }
        }
        finally {
            JdbcUtils.closeStatement(this.currentStatement);
            this.connection.setBusy(false);
            if (bl6) {
                this.connection.setAutoCommit(bl7);
            }
        }
        if (this.statusDisplay != null) {
            this.statusDisplay.clearStatusMessage();
        }
        return arrayList;
    }

    private void deleteTable(TableIdentifier tableIdentifier, boolean bl, boolean bl2, boolean bl3) throws SQLException {
        Savepoint savepoint = null;
        try {
            if (this.connection.getDbSettings().useSavePointForDML()) {
                savepoint = this.connection.setSavepoint();
            }
            String string = this.getDeleteStatement(tableIdentifier, bl, bl3);
            LogMgr.logInfo(new CallerInfo(){}, "Executing: [" + string + "] to delete target table...");
            this.currentStatement.executeUpdate(string);
            if (bl2 && !this.connection.getAutoCommit()) {
                this.connection.commit();
            } else {
                this.connection.releaseSavepoint(savepoint);
            }
        }
        catch (SQLException sQLException) {
            this.connection.rollback(savepoint);
            if (bl2 && !this.connection.getAutoCommit()) {
                this.connection.rollback();
            }
            throw sQLException;
        }
    }

    private String getDeleteStatement(TableIdentifier tableIdentifier, boolean bl, boolean bl2) {
        String string;
        String string2 = null;
        String string3 = tableIdentifier.createCopy().getTableExpression(this.connection);
        if (bl && (string = this.connection.getDbSettings().getTruncateCommand(bl2)) != null) {
            string2 = TemplateHandler.replaceTablePlaceholder(string, tableIdentifier, this.connection, false);
        }
        if (string2 == null) {
            string2 = "DELETE FROM " + string3;
        }
        return string2;
    }

    public String generateSortedScript(List<TableIdentifier> list, CommitType commitType, boolean bl, boolean bl2) {
        this.sorter = new TableDependencySorter(this.connection);
        this.sorter.setValidateTables(false);
        this.sorter.setProgressMonitor(this.scriptMonitor);
        List<TableIdentifier> list2 = this.sorter.sortForDelete(list, true);
        if (this.sorter.isCancelled()) {
            return "";
        }
        this.sorter = null;
        CharSequence charSequence = this.generateScript(list2, commitType, false, false);
        return charSequence == null ? "" : charSequence.toString();
    }

    public CharSequence generateScript(List<TableIdentifier> list, CommitType commitType, boolean bl, boolean bl2) {
        boolean bl3 = this.connection.getDbSettings().truncateNeedsCommit();
        if (commitType == CommitType.never || !bl3) {
            // empty if block
        }
        StringBuilder stringBuilder = new StringBuilder(list.size() * 30);
        int n = list.size();
        String string = FormatterUtil.getKeyword("commit") + ";\n";
        for (int i = 0; i < n && !this.cancelExecution; ++i) {
            TableIdentifier tableIdentifier = list.get(i);
            if (this.scriptMonitor != null) {
                this.scriptMonitor.setCurrentObject(tableIdentifier.getTableName(), i + 1, n);
            }
            String string2 = this.getDeleteStatement(tableIdentifier, bl, bl2);
            stringBuilder.append(string2);
            stringBuilder.append(";\n");
            if (commitType != CommitType.each) continue;
            stringBuilder.append(string);
            stringBuilder.append('\n');
        }
        if (commitType == CommitType.once) {
            stringBuilder.append('\n');
            stringBuilder.append(string);
        }
        return stringBuilder;
    }
}

