/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.util.TreeSet;
import workbench.db.DbSettings;
import workbench.db.DefaultTransactionChecker;
import workbench.db.WbConnection;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public interface TransactionChecker {
    public static final TransactionChecker NO_CHECK = wbConnection -> false;

    public boolean hasUncommittedChanges(WbConnection var1);

    public static class Factory {
        public static TransactionChecker createChecker(WbConnection wbConnection) {
            if (wbConnection == null) {
                return NO_CHECK;
            }
            DbSettings dbSettings = wbConnection.getDbSettings();
            if (dbSettings == null) {
                return NO_CHECK;
            }
            String string = dbSettings.checkOpenTransactionsQuery();
            if (string != null) {
                return new DefaultTransactionChecker(string);
            }
            return NO_CHECK;
        }

        public static boolean supportsTransactionCheck(String string) {
            if (StringUtil.isBlank(string)) {
                return false;
            }
            TreeSet<String> treeSet = new TreeSet<String>();
            treeSet.addAll(Settings.getInstance().getListProperty("workbench.db.drivers.opentransaction.check.builtin", false));
            treeSet.addAll(Settings.getInstance().getListProperty("workbench.db.drivers.opentransaction.check", false));
            return treeSet.contains(string);
        }
    }
}

