/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.io.Serializable;
import java.sql.SQLException;
import workbench.db.DbObject;
import workbench.db.TableIdentifier;
import workbench.db.TriggerLevel;
import workbench.db.TriggerReader;
import workbench.db.TriggerReaderFactory;
import workbench.db.WbConnection;
import workbench.util.SqlUtil;

public class TriggerDefinition
implements DbObject,
Serializable {
    public static final String TRIGGER_TYPE_NAME = "TRIGGER";
    public static final String PLACEHOLDER_TRIGGER_NAME = "%trigger_name%";
    public static final String PLACEHOLDER_TRIGGER_SCHEMA = "%trigger_schema%";
    public static final String PLACEHOLDER_TRIGGER_CATALOG = "%trigger_catalog%";
    public static final String PLACEHOLDER_TRIGGER_TABLE = "%trigger_table%";
    private String schema;
    private String catalog;
    private String triggerName;
    private String comment;
    private String type;
    private String event;
    private TableIdentifier table;
    private CharSequence source;
    private String status;
    private TriggerLevel level;

    public TriggerDefinition(String string, String string2, String string3) {
        this.schema = string2;
        this.catalog = string;
        this.triggerName = string3;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String string) {
        this.comment = string;
    }

    public String getStatus() {
        return this.status;
    }

    public TriggerLevel getLevel() {
        return this.level;
    }

    public void setLevel(TriggerLevel triggerLevel) {
        this.level = triggerLevel;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public void setTriggerEvent(String string) {
        this.event = string;
    }

    public String getTriggerEvent() {
        return this.event;
    }

    public void setTriggerType(String string) {
        this.type = string;
    }

    public String getTriggerType() {
        return this.type;
    }

    public void setRelatedTable(TableIdentifier tableIdentifier) {
        this.table = tableIdentifier;
    }

    public TableIdentifier getRelatedTable() {
        return this.table;
    }

    @Override
    public String getDropStatement(WbConnection wbConnection, boolean bl) {
        String string = wbConnection.getDbSettings().getDropDDL(this.getObjectType(), bl);
        if (string == null) {
            return null;
        }
        string = string.replace("%name%", this.getObjectNameForDrop(wbConnection));
        string = string.replace(PLACEHOLDER_TRIGGER_NAME, this.triggerName);
        if (this.schema != null) {
            string = string.replace(PLACEHOLDER_TRIGGER_SCHEMA, this.schema);
        }
        if (this.catalog != null) {
            string = string.replace(PLACEHOLDER_TRIGGER_CATALOG, this.catalog);
        }
        if (this.table != null) {
            string = string.replace(PLACEHOLDER_TRIGGER_TABLE, this.table.getTableExpression(wbConnection));
        }
        return string;
    }

    public void setSource(CharSequence charSequence) {
        this.source = charSequence;
    }

    public CharSequence getSource() {
        return this.source;
    }

    @Override
    public CharSequence getSource(WbConnection wbConnection) throws SQLException {
        return this.getSource(wbConnection, true);
    }

    public CharSequence getSource(WbConnection wbConnection, boolean bl) throws SQLException {
        if (wbConnection == null) {
            return null;
        }
        TriggerReader triggerReader = TriggerReaderFactory.createReader(wbConnection);
        return triggerReader.getTriggerSource(this.catalog, this.schema, this.triggerName, this.table, this.comment, bl);
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public String getObjectNameForDrop(WbConnection wbConnection) {
        return this.getFullyQualifiedName(wbConnection);
    }

    @Override
    public String getObjectName(WbConnection wbConnection) {
        return wbConnection.getMetadata().quoteObjectname(this.triggerName);
    }

    @Override
    public String getFullyQualifiedName(WbConnection wbConnection) {
        return this.getObjectExpression(null);
    }

    @Override
    public String getObjectExpression(WbConnection wbConnection) {
        return SqlUtil.buildExpression(wbConnection, this.catalog, this.schema, this.triggerName);
    }

    @Override
    public String getObjectName() {
        return this.triggerName;
    }

    @Override
    public String getObjectType() {
        return TRIGGER_TYPE_NAME;
    }

    public String toString() {
        return this.triggerName;
    }

    @Override
    public boolean supportsGetSource() {
        return true;
    }
}

