/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class TypeMapper {
    public static final String PLACEHOLDER_DIGITS = "$digits";
    public static final String PLACEHOLDER_SIZE = "$size";
    private WbConnection targetDb;
    private Map<Integer, String> typeInfo;
    private Map<Integer, String> userMapping;

    TypeMapper() {
        this.createAnsiMap();
    }

    public TypeMapper(WbConnection wbConnection) {
        this.targetDb = wbConnection;
        if (this.targetDb == null) {
            this.createAnsiMap();
        } else {
            this.createTypeMap();
        }
    }

    private String findAlternateBlobType(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(4);
        arrayList.add(2004);
        arrayList.add(-4);
        arrayList.add(-3);
        arrayList.add(-2);
        for (Integer n2 : arrayList) {
            String string;
            if (n2 == n || (string = this.typeInfo.get(n2)) == null) continue;
            return string;
        }
        return null;
    }

    private String findAlternateClobType(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(4);
        arrayList.add(2005);
        arrayList.add(-1);
        arrayList.add(2011);
        arrayList.add(-16);
        for (Integer n2 : arrayList) {
            String string;
            if (n2 == n || (string = this.typeInfo.get(n2)) == null) continue;
            return string;
        }
        return null;
    }

    protected String getUserMapping(int n, int n2, int n3) {
        if (this.userMapping == null) {
            return null;
        }
        Integer n4 = n;
        String string = this.userMapping.get(n4);
        if (string == null) {
            return null;
        }
        string = string.replace(PLACEHOLDER_SIZE, Integer.toString(n2));
        string = string.replace(PLACEHOLDER_DIGITS, Integer.toString(n3));
        return string;
    }

    public String getTypeName(int n, int n2, int n3) {
        String string = this.getUserMapping(n, n2, n3);
        if (string != null) {
            return string;
        }
        Integer n4 = n;
        String string2 = this.typeInfo.get(n4);
        if (string2 == null) {
            if (SqlUtil.isBlobType(n)) {
                string2 = this.findAlternateBlobType(n);
            } else if (SqlUtil.isClobType(n)) {
                string2 = this.findAlternateClobType(n);
            }
            if (string2 != null) {
                LogMgr.logInfo(new CallerInfo(){}, "Could not find a direct mapping for java.sql.Types." + SqlUtil.getTypeName(n) + ", using DBMS type: " + string2);
            }
        }
        if (string2 == null) {
            return SqlUtil.getTypeName(n);
        }
        if (this.targetDb == null) {
            return SqlUtil.getSqlTypeDisplay(string2, n, n2, n3);
        }
        return this.targetDb.getMetadata().getDataTypeResolver().getSqlTypeDisplay(string2, n, n2, n3);
    }

    public void parseUserTypeMap(String string) {
        this.userMapping = new HashMap<Integer, String>();
        if (StringUtil.isBlank(string)) {
            return;
        }
        List<String> list = StringUtil.stringToList(string, ";", true, true, false, false);
        for (String string2 : list) {
            String[] stringArray = string2.split(":");
            if (stringArray == null || stringArray.length != 2) continue;
            try {
                Integer n = Integer.parseInt(stringArray[0]);
                this.userMapping.put(n, stringArray[1]);
                LogMgr.logInfo(new CallerInfo(){}, "Mapping java.sql.Types." + SqlUtil.getTypeName(n) + " to usertype: " + stringArray[1]);
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Could not parse entry: " + string2, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTypeMap() {
        ResultSet resultSet = null;
        this.typeInfo = new HashMap<Integer, String>(27);
        boolean bl = this.targetDb.getDbSettings().cleanupTypeMappingNames();
        Pattern pattern = Pattern.compile("[\\(\\)\\[\\]{}'\"`]");
        try {
            LogMgr.logInfo(new CallerInfo(){}, "Reading type map for " + this.targetDb.getDbId());
            resultSet = this.targetDb.getSqlConnection().getMetaData().getTypeInfo();
            while (resultSet.next()) {
                Object object;
                String string;
                String string2 = resultSet.getString(1);
                int n = resultSet.getInt(2);
                if (n == 2003 || n == 1111 || n == 2002) continue;
                if (bl && !(string = ((Matcher)(object = pattern.matcher(string2))).replaceAll("")).equals(string2)) {
                    LogMgr.logInfo(new CallerInfo(){}, "Using type name [" + string + "] instead of [" + string2 + "]");
                    string2 = string;
                }
                if (this.typeInfo.containsKey(object = Integer.valueOf(n))) {
                    LogMgr.logWarning(new CallerInfo(){}, "The mapping from java.sql.Types." + SqlUtil.getTypeName(n) + " to  DBMS type " + string2 + " will be ignored. A mapping is already present.");
                    continue;
                }
                LogMgr.logInfo(new CallerInfo(){}, "Mapping java.sql.Types." + SqlUtil.getTypeName(n) + " to DBMS type " + string2);
                this.typeInfo.put((Integer)object, string2);
            }
            JdbcUtils.closeResult(resultSet);
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Error reading type info for target connection", sQLException);
            this.typeInfo = new HashMap<Integer, String>();
        }
        finally {
            JdbcUtils.closeResult(resultSet);
        }
        this.parseUserTypeMap(this.targetDb.getDbSettings().getJDBCTypeMapping());
    }

    private void createAnsiMap() {
        this.typeInfo = new HashMap<Integer, String>();
        this.typeInfo.put(4, "integer");
        this.typeInfo.put(12, "varchar");
        this.typeInfo.put(-5, "bigint");
        this.typeInfo.put(3, "decimal");
        this.typeInfo.put(16, "boolean");
        this.typeInfo.put(2005, "clob");
        this.typeInfo.put(2004, "blob");
        this.typeInfo.put(-9, "nvarchar");
        this.typeInfo.put(2, "decimal");
        this.typeInfo.put(91, "date");
        this.typeInfo.put(93, "timestamp");
        this.typeInfo.put(92, "time");
        this.typeInfo.put(1, "char");
    }
}

