/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.derby;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.SynonymReader;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.StringUtil;

public class DerbySynonymReader
implements SynonymReader {
    @Override
    public List<TableIdentifier> getSynonymList(WbConnection wbConnection, String string, String string2, String string3) throws SQLException {
        ArrayList<TableIdentifier> arrayList = new ArrayList<TableIdentifier>();
        String string4 = "SELECT s.schemaname, a.alias \nFROM sys.sysaliases a \n  JOIN sys.sysschemas s ON a.schemaid = s.schemaid \nWHERE a.aliastype = 'S'\n  AND s.schemaname = ? \n";
        if (StringUtil.isNonBlank(string3)) {
            string4 = string4 + " AND a.alias LIKE ?";
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "synonyms", string4, new Object[0]);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string4);
            preparedStatement.setString(1, string2);
            if (StringUtil.isNonBlank(string3)) {
                preparedStatement.setString(2, string3);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string5 = resultSet.getString(1);
                String string6 = resultSet.getString(2);
                if (resultSet.wasNull()) continue;
                TableIdentifier tableIdentifier = new TableIdentifier(null, string5, string6, false);
                tableIdentifier.setType("SYNONYM");
                tableIdentifier.setNeverAdjustCase(true);
                arrayList.add(tableIdentifier);
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "synonyms", string4, new Object[0]);
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return arrayList;
    }

    @Override
    public TableIdentifier getSynonymTable(WbConnection wbConnection, String string, String string2, String string3) throws SQLException {
        String string4 = "select a.aliasinfo \nfrom sys.sysaliases a  join sys.sysschemas s on a.schemaid = s.schemaid \nwhere a.alias = ?  and s.schemaname = ?";
        LogMgr.logMetadataSql(new CallerInfo(){}, "synonym table", string4, new Object[0]);
        PreparedStatement preparedStatement = wbConnection.getSqlConnection().prepareStatement(string4);
        preparedStatement.setString(1, string3);
        preparedStatement.setString(2, string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        String string5 = null;
        TableIdentifier tableIdentifier = null;
        try {
            if (resultSet.next() && (string5 = resultSet.getString(1)) != null) {
                tableIdentifier = new TableIdentifier(string5);
            }
        }
        catch (SQLException sQLException) {
            LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "synonym table", string4, new Object[0]);
            throw sQLException;
        }
        finally {
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        if (tableIdentifier != null) {
            String string6 = wbConnection.getMetadata().getObjectType(tableIdentifier);
            tableIdentifier.setType(string6);
        }
        return tableIdentifier;
    }

    @Override
    public boolean supportsReplace(WbConnection wbConnection) {
        return false;
    }
}

