/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.derby;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListExtender;
import workbench.db.WbConnection;
import workbench.db.derby.DerbyTypeDefinition;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;

public class DerbyTypeReader
implements ObjectListExtender {
    @Override
    public boolean isDerivedType() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean extendObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        if (!DbMetadata.typeIncluded("TYPE", stringArray)) {
            return false;
        }
        String string4 = this.getSelect(string2, string3);
        string4 = string4 + " ORDER BY a.alias, s.schemaname ";
        Statement statement = null;
        ResultSet resultSet = null;
        LogMgr.logMetadataSql(new CallerInfo(){}, "aliases", string4, new Object[0]);
        try {
            statement = wbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(string4);
            while (resultSet.next()) {
                String string5 = resultSet.getString("schemaname");
                String string6 = resultSet.getString("type_name");
                String string7 = resultSet.getString("javaclassname");
                String string8 = resultSet.getString("aliasinfo");
                int n = dataStore.addRow();
                dataStore.setValue(n, 2, null);
                dataStore.setValue(n, 3, (Object)string5);
                dataStore.setValue(n, 0, (Object)string6);
                dataStore.setValue(n, 1, (Object)"TYPE");
                dataStore.setValue(n, 4, null);
                DerbyTypeDefinition derbyTypeDefinition = new DerbyTypeDefinition(string5, string6, string7, string8);
                dataStore.getRow(n).setUserObject(derbyTypeDefinition);
            }
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "aliases", string4, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return true;
    }

    private String getSelect(String string, String string2) {
        String string3 = "select s.schemaname, \n       a.alias as type_name,  \n       a.javaclassname, \n       a.aliasinfo \nfrom sys.sysaliases a \n  join sys.sysschemas s on a.schemaid = s.schemaid \nwhere a.aliastype = 'A'   \nand a.systemalias = 'false'";
        if (string != null && !"".equals(string)) {
            string3 = string3 + " AND s.schemaname LIKE '" + string + "' ";
        }
        if (string2 != null) {
            string3 = string3 + " AND a.alias LIKE '" + string2 + "' ";
        }
        return string3;
    }

    @Override
    public List<String> supportedTypes() {
        return CollectionUtil.arrayList("TYPE");
    }

    @Override
    public boolean handlesType(String string) {
        return "TYPE".equalsIgnoreCase(string);
    }

    @Override
    public boolean handlesType(String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (String string : stringArray) {
            if (!this.handlesType(string)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataStore getObjectDetails(WbConnection wbConnection, DbObject dbObject) {
        DataStore dataStore;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            DataStore dataStore2;
            String string = this.getSelect(dbObject.getSchema(), dbObject.getObjectName());
            statement = wbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(string);
            dataStore = dataStore2 = new DataStore(resultSet, true);
        }
        catch (Exception exception) {
            DataStore dataStore3;
            try {
                LogMgr.logError(new CallerInfo(){}, "Error retrieving object types", exception);
                dataStore3 = null;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
            return dataStore3;
        }
        JdbcUtils.closeAll(resultSet, statement);
        return dataStore;
    }

    @Override
    public DerbyTypeDefinition getObjectDefinition(WbConnection wbConnection, DbObject dbObject) {
        DataStore dataStore = this.getObjectDetails(wbConnection, dbObject);
        if (dataStore.getRowCount() < 1) {
            return null;
        }
        String string = dataStore.getValueAsString(0, 0);
        String string2 = dataStore.getValueAsString(0, 1);
        String string3 = dataStore.getValueAsString(0, 2);
        String string4 = dataStore.getValueAsString(0, 3);
        DerbyTypeDefinition derbyTypeDefinition = new DerbyTypeDefinition(string, string2, string3, string4);
        return derbyTypeDefinition;
    }

    @Override
    public String getObjectSource(WbConnection wbConnection, DbObject dbObject) {
        DerbyTypeDefinition derbyTypeDefinition = this.getObjectDefinition(wbConnection, dbObject);
        try {
            return derbyTypeDefinition.getSource(wbConnection).toString();
        }
        catch (SQLException sQLException) {
            return "";
        }
    }

    @Override
    public List<ColumnIdentifier> getColumns(WbConnection wbConnection, DbObject dbObject) {
        return null;
    }

    @Override
    public boolean hasColumns() {
        return false;
    }
}

