/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.diff;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.BaseObjectType;
import workbench.db.ColumnIdentifier;
import workbench.db.ComparableDbObject;
import workbench.db.DbObject;
import workbench.db.WbConnection;
import workbench.db.diff.ColumnDiff;
import workbench.db.diff.TableDiff;
import workbench.db.report.GenericReportObject;
import workbench.db.report.ReportColumn;
import workbench.db.report.ReportObjectType;
import workbench.db.report.ReportTable;
import workbench.db.report.TagWriter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.StringUtil;

public class ObjectDiff {
    public static final String TAG_ADD_OBJECT = "add-object";
    public static final String TAG_DROP_OBJECT = "drop-object";
    public static final String TAG_ALTER_OBJECT = "modify-object";
    public static final String TAG_REF_OBJECT_DEF = "reference-object";
    public static final String TAG_TARG_OBJECT_DEF = "target-object";
    public static final String TAG_ADD_TYPE = "add-type";
    public static final String TAG_DROP_TYPE = "drop-type";
    public static final String TAG_ALTER_TYPE = "modify-type";
    private ComparableDbObject referenceObject;
    private ComparableDbObject targetObject;
    private StringBuilder indent = StringUtil.emptyBuilder();
    private String targetSchema;

    public ObjectDiff(ComparableDbObject comparableDbObject, ComparableDbObject comparableDbObject2, String string) {
        this.referenceObject = comparableDbObject;
        this.targetObject = comparableDbObject2;
        this.targetSchema = string;
    }

    public boolean isDifferent(WbConnection wbConnection, WbConnection wbConnection2) {
        if (this.targetObject == null && this.referenceObject == null) {
            return false;
        }
        if (this.targetObject == null || this.referenceObject == null) {
            return true;
        }
        if (!this.targetObject.isEqualTo(this.referenceObject)) {
            return true;
        }
        try {
            CharSequence charSequence = this.referenceObject.getSource(wbConnection);
            CharSequence charSequence2 = this.targetObject.getSource(wbConnection2);
            if (charSequence == null && charSequence2 == null) {
                return false;
            }
            if (charSequence == null || charSequence2 == null) {
                return false;
            }
            return !charSequence.equals(charSequence2);
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Could not compare source", sQLException);
            return false;
        }
    }

    public StringBuilder getMigrateTargetXml(WbConnection wbConnection, WbConnection wbConnection2) {
        if (this.isObjectType(this.targetObject) && this.isObjectType(this.referenceObject)) {
            return this.getObjectTypeDiff(wbConnection, wbConnection2);
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        StringBuilder stringBuilder2 = new StringBuilder(this.indent);
        stringBuilder2.append("  ");
        TagWriter tagWriter = new TagWriter();
        if (this.targetObject == null && this.referenceObject != null) {
            GenericReportObject genericReportObject = new GenericReportObject(wbConnection, this.referenceObject);
            genericReportObject.setSchemaNameToUse(this.targetSchema);
            StringBuilder stringBuilder3 = genericReportObject.getXml(stringBuilder2);
            tagWriter.appendOpenTag(stringBuilder, this.indent, TAG_ADD_OBJECT);
            stringBuilder.append('\n');
            stringBuilder.append((CharSequence)stringBuilder3);
            stringBuilder.append('\n');
            tagWriter.appendCloseTag(stringBuilder, this.indent, TAG_ADD_OBJECT);
            stringBuilder.append('\n');
        } else if (this.targetObject != null && this.referenceObject == null) {
            GenericReportObject genericReportObject = new GenericReportObject(wbConnection2, this.targetObject);
            StringBuilder stringBuilder4 = genericReportObject.getXml(stringBuilder2);
            tagWriter.appendOpenTag(stringBuilder, this.indent, TAG_DROP_OBJECT);
            stringBuilder.append('\n');
            stringBuilder.append((CharSequence)stringBuilder4);
            stringBuilder.append('\n');
            tagWriter.appendCloseTag(stringBuilder, this.indent, TAG_DROP_OBJECT);
            stringBuilder.append('\n');
        } else if (!this.targetObject.isEqualTo(this.referenceObject)) {
            GenericReportObject genericReportObject = new GenericReportObject(wbConnection, this.referenceObject);
            GenericReportObject genericReportObject2 = new GenericReportObject(wbConnection2, this.targetObject);
            StringBuilder stringBuilder5 = new StringBuilder(stringBuilder2);
            stringBuilder5.append("  ");
            tagWriter.appendOpenTag(stringBuilder, this.indent, TAG_ALTER_OBJECT);
            stringBuilder.append('\n');
            tagWriter.appendOpenTag(stringBuilder, stringBuilder2, TAG_REF_OBJECT_DEF);
            stringBuilder.append('\n');
            stringBuilder.append((CharSequence)genericReportObject.getXml(stringBuilder5));
            tagWriter.appendCloseTag(stringBuilder, stringBuilder2, TAG_REF_OBJECT_DEF);
            tagWriter.appendOpenTag(stringBuilder, stringBuilder2, TAG_TARG_OBJECT_DEF);
            stringBuilder.append('\n');
            stringBuilder.append((CharSequence)genericReportObject2.getXml(stringBuilder5));
            tagWriter.appendCloseTag(stringBuilder, stringBuilder2, TAG_TARG_OBJECT_DEF);
            tagWriter.appendCloseTag(stringBuilder, this.indent, TAG_ALTER_OBJECT);
            stringBuilder.append('\n');
        }
        return stringBuilder;
    }

    private boolean isObjectType(DbObject dbObject) {
        if (dbObject == null) {
            return true;
        }
        return dbObject instanceof BaseObjectType;
    }

    public StringBuilder getObjectTypeDiff(WbConnection wbConnection, WbConnection wbConnection2) {
        String string = null;
        ReportObjectType reportObjectType = null;
        if (this.targetObject == null && this.referenceObject != null) {
            reportObjectType = new ReportObjectType((BaseObjectType)this.referenceObject);
            string = TAG_ADD_TYPE;
            reportObjectType.setSchemaToUse(this.targetSchema);
        } else if (this.targetObject != null && this.referenceObject == null) {
            reportObjectType = new ReportObjectType((BaseObjectType)this.targetObject);
            string = TAG_DROP_TYPE;
        }
        if (string != null) {
            StringBuilder stringBuilder = new StringBuilder(200);
            StringBuilder stringBuilder2 = reportObjectType.getXml(string, this.indent);
            stringBuilder.append((CharSequence)stringBuilder2);
            return stringBuilder;
        }
        return this.getDiff((BaseObjectType)this.referenceObject, (BaseObjectType)this.targetObject);
    }

    private StringBuilder getDiff(BaseObjectType baseObjectType, BaseObjectType baseObjectType2) {
        if (baseObjectType.equals(baseObjectType2)) {
            return StringUtil.emptyBuilder();
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        StringBuilder stringBuilder2 = new StringBuilder(this.indent);
        stringBuilder2.append("  ");
        TagWriter tagWriter = new TagWriter();
        tagWriter.appendOpenTag(stringBuilder, this.indent, TAG_ALTER_TYPE, "name", baseObjectType2.getObjectName());
        stringBuilder.append('\n');
        ReportObjectType reportObjectType = new ReportObjectType(baseObjectType2);
        reportObjectType.appendDefinitionXml(stringBuilder, stringBuilder2);
        ArrayList<ReportColumn> arrayList = new ArrayList<ReportColumn>();
        List<ReportColumn> list = this.getColumns(baseObjectType);
        List<ReportColumn> list2 = this.getColumns(baseObjectType2);
        StringBuilder stringBuilder3 = new StringBuilder(this.indent);
        stringBuilder3.append("  ");
        StringBuilder stringBuilder4 = new StringBuilder(100);
        for (ReportColumn object : list) {
            ReportColumn reportColumn = ReportTable.findColumn(list2, object.getColumn().getColumnName());
            if (reportColumn == null) {
                arrayList.add(object);
                continue;
            }
            ColumnDiff columnDiff = new ColumnDiff(object, reportColumn);
            columnDiff.setCompareForeignKeys(false);
            columnDiff.setCompareJdbcTypes(false);
            columnDiff.setIndent(stringBuilder3);
            StringBuilder stringBuilder5 = columnDiff.getMigrateTargetXml();
            if (stringBuilder5.length() <= 0) continue;
            stringBuilder4.append((CharSequence)stringBuilder5);
        }
        ArrayList arrayList2 = new ArrayList();
        for (ReportColumn reportColumn : list2) {
            if (ReportTable.findColumn(list, reportColumn.getColumn().getColumnName()) != null) continue;
            arrayList2.add(reportColumn);
        }
        if (stringBuilder4.length() > 0) {
            stringBuilder.append((CharSequence)stringBuilder4);
        }
        TableDiff.appendAddColumns(tagWriter, stringBuilder, arrayList, this.indent);
        TableDiff.appendRemoveColumns(tagWriter, stringBuilder, arrayList2, this.indent);
        tagWriter.appendCloseTag(stringBuilder, this.indent, TAG_ALTER_TYPE);
        stringBuilder.append('\n');
        return stringBuilder;
    }

    private List<ReportColumn> getColumns(BaseObjectType baseObjectType) {
        ArrayList<ReportColumn> arrayList = new ArrayList<ReportColumn>();
        ArrayList<ColumnIdentifier> arrayList2 = new ArrayList<ColumnIdentifier>(baseObjectType.getAttributes());
        Collections.sort(arrayList2);
        for (ColumnIdentifier columnIdentifier : arrayList2) {
            arrayList.add(new ReportColumn(columnIdentifier));
        }
        return arrayList;
    }

    public void setIndent(StringBuilder stringBuilder) {
        this.indent = stringBuilder == null ? StringUtil.emptyBuilder() : stringBuilder;
    }
}

