/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.diff;

import java.util.List;
import workbench.db.TriggerDefinition;
import workbench.db.diff.TriggerDiff;
import workbench.db.report.ReportTrigger;
import workbench.db.report.TagWriter;

public class TriggerListDiff {
    public static final String TAG_DROP_TRIGGER = "drop-trigger";
    private List<TriggerDefinition> referenceTriggers;
    private List<TriggerDefinition> targetTriggers;

    public TriggerListDiff(List<TriggerDefinition> list, List<TriggerDefinition> list2) {
        this.referenceTriggers = list;
        this.targetTriggers = list2;
    }

    public boolean hasChanges() {
        TriggerDefinition triggerDefinition;
        for (TriggerDefinition triggerDefinition2 : this.targetTriggers) {
            triggerDefinition = this.findTrigger(triggerDefinition2.getObjectName(), this.referenceTriggers);
            if (triggerDefinition != null) continue;
            return true;
        }
        for (TriggerDefinition triggerDefinition2 : this.referenceTriggers) {
            ReportTrigger reportTrigger;
            ReportTrigger reportTrigger2 = new ReportTrigger(triggerDefinition2);
            TriggerDiff triggerDiff = new TriggerDiff(reportTrigger2, reportTrigger = (triggerDefinition = this.findTrigger(triggerDefinition2.getObjectName(), this.targetTriggers)) == null ? null : new ReportTrigger(triggerDefinition));
            if (!triggerDiff.isDifferent()) continue;
            return true;
        }
        return false;
    }

    private TriggerDefinition findTrigger(String string, List<TriggerDefinition> list) {
        for (TriggerDefinition triggerDefinition : list) {
            if (!triggerDefinition.getObjectName().equals(string)) continue;
            return triggerDefinition;
        }
        return null;
    }

    public void writeXml(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        TriggerDefinition triggerDefinition;
        TagWriter tagWriter = new TagWriter();
        for (TriggerDefinition triggerDefinition2 : this.targetTriggers) {
            triggerDefinition = this.findTrigger(triggerDefinition2.getObjectName(), this.referenceTriggers);
            if (triggerDefinition != null) continue;
            tagWriter.appendEmptyTag(stringBuilder2, stringBuilder, TAG_DROP_TRIGGER, "name", triggerDefinition2.getObjectName());
            stringBuilder2.append("\n");
        }
        for (TriggerDefinition triggerDefinition2 : this.referenceTriggers) {
            triggerDefinition = this.findTrigger(triggerDefinition2.getObjectName(), this.targetTriggers);
            ReportTrigger reportTrigger = new ReportTrigger(triggerDefinition2);
            ReportTrigger reportTrigger2 = triggerDefinition == null ? null : new ReportTrigger(triggerDefinition);
            TriggerDiff triggerDiff = new TriggerDiff(reportTrigger, reportTrigger2);
            stringBuilder2.append((CharSequence)triggerDiff.getMigrateTargetXml(stringBuilder));
        }
    }
}

